/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.ZulipAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class ZulipAnnouncerValidator {
    private static final String DEFAULT_ZULIP_TPL = "src/jreleaser/templates/zulip.tpl";

    private ZulipAnnouncerValidator() {
    }

    public static void validateZulip(JReleaserContext context, ZulipAnnouncer announcer, Errors errors) {
        context.getLogger().debug("announce.zulip");
        Validator.resolveActivatable(context, (Activatable)announcer, "announce.zulip", "NEVER");
        if (!announcer.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        announcer.setAccount(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.zulip.account", "zulip.account"}), "announce.zulip.account", announcer.getAccount(), errors));
        announcer.setApiKey(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.zulip.api.key", "ZULIP_API_KEY"}), "announce.zulip.apiKey", announcer.getApiKey(), errors, context.isDryrun()));
        announcer.setApiHost(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.zulip.api.host", "zulip.api.host"}), "announce.zulip.apiHost", announcer.getApiHost(), errors));
        if (StringUtils.isBlank((String)announcer.getSubject())) {
            announcer.setSubject(RB.$((String)"default.discussion.title", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((String)announcer.getChannel())) {
            announcer.setChannel("announce");
        }
        if (StringUtils.isBlank((String)announcer.getMessage()) && StringUtils.isBlank((String)announcer.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_ZULIP_TPL), new LinkOption[0])) {
                announcer.setMessageTemplate(DEFAULT_ZULIP_TPL);
            } else {
                announcer.setMessage(RB.$((String)"default.release.message", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)announcer.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(announcer.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"zulip.messageTemplate", announcer.getMessageTemplate()}));
        }
        Validator.validateTimeout(announcer);
    }
}

