/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jreleaser.cli.AbstractCommand;
import org.jreleaser.cli.Main;
import org.jreleaser.cli.internal.ColorizedJReleaserLoggerAdapter;
import org.jreleaser.engine.environment.Environment;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.util.IoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="env")
public class Env
extends AbstractCommand<Main> {
    @CommandLine.Option(names={"--settings-file"}, paramLabel="<file>")
    Path settingsFile;

    @Override
    protected void execute() {
        Environment.display((JReleaserLogger)this.initLogger(), (Path)this.resolveBasedir(), (Path)this.resolveSettings());
    }

    private Path resolveSettings() {
        if (null != this.settingsFile) {
            return this.resolveBasedir().resolve(this.settingsFile).normalize();
        }
        return null;
    }

    private Path resolveBasedir() {
        return Paths.get(".", new String[0]).normalize();
    }

    protected JReleaserLogger initLogger() {
        return new ColorizedJReleaserLoggerAdapter(this.createTracer(), ((Main)this.parent()).getOut(), ColorizedJReleaserLoggerAdapter.Level.INFO);
    }

    protected PrintWriter createTracer() {
        return IoUtils.newPrintWriter((OutputStream)new ByteArrayOutputStream());
    }
}

