# This file is generated by SciPy's build process
# It contains system_info results at the time of building this package.
from enum import Enum

__all__ = ["show"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return { k: _cleanup(v) for k, v in d.items() if v != '' and _cleanup(v) != '' }
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "clang",
                "linker": r"ld64",
                "version": "17.0.6",
                "commands": r"/opt/local/bin/clang-mp-17",
                "args": r"-Os, -isysroot/Library/Developer/CommandLineTools/SDKs/MacOSX10.15.sdk",
                "linker args": r"-Os, -isysroot/Library/Developer/CommandLineTools/SDKs/MacOSX10.15.sdk",
            },
            "cython": {
                "name": r"cython",
                "linker": r"cython",
                "version": r"3.1.4",
                "commands": r"cython",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "clang",
                "linker": r"ld64",
                "version": "17.0.6",
                "commands": r"/opt/local/bin/clang++-mp-17",
                "args": r"-I/opt/local/libexec/boost/1.81/include, -Os, -stdlib=libc++, -stdlib=libc++, -isysroot/Library/Developer/CommandLineTools/SDKs/MacOSX10.15.sdk",
                "linker args": r"-I/opt/local/libexec/boost/1.81/include, -Os, -stdlib=libc++, -stdlib=libc++, -isysroot/Library/Developer/CommandLineTools/SDKs/MacOSX10.15.sdk",
            },
            "fortran": {
                "name": "gcc",
                "linker": r"ld64",
                "version": "15.2.0",
                "commands": r"/opt/local/bin/gfortran-mp-15",
                "args": r"",
                "linker args": r"",
            },
            "pythran": {
                "version": r"0.18.0",
                "include directory": r"../../../../../../../Library/Frameworks/Python.framework/Versions/3.13/lib/python3.13/site-packages/pythran"
            },
        },
        "Machine Information": {
            "host": {
                "cpu": r"x86_64",
                "family": r"x86_64",
                "endian": r"little",
                "system": r"darwin",
            },
            "build": {
                "cpu": r"x86_64",
                "family": r"x86_64",
                "endian": r"little",
                "system": r"darwin",
            },
            "cross-compiled": bool("False".lower().replace('false', '')),
        },
        "Build Dependencies": {
            "blas": {
                "name": "openblas",
                "found": bool("True".lower().replace('false', '')),
                "version": "0.3.30",
                "detection method": "pkgconfig",
                "include directory": r"/opt/local/include/openblas",
                "lib directory": r"/opt/local/lib",
                "openblas configuration": r"USE_64BITINT= NO_CBLAS= NO_LAPACK= NO_LAPACKE= DYNAMIC_ARCH=OFF DYNAMIC_OLDER=OFF NO_AFFINITY=1 USE_OPENMP= NEHALEM MAX_THREADS=56",
                "pc file directory": r"/opt/local/lib/pkgconfig",
            },
            "lapack": {
                "name": "openblas",
                "found": bool("True".lower().replace('false', '')),
                "version": "0.3.30",
                "detection method": "pkgconfig",
                "include directory": r"/opt/local/include/openblas",
                "lib directory": r"/opt/local/lib",
                "openblas configuration": r"USE_64BITINT= NO_CBLAS= NO_LAPACK= NO_LAPACKE= DYNAMIC_ARCH=OFF DYNAMIC_OLDER=OFF NO_AFFINITY=1 USE_OPENMP= NEHALEM MAX_THREADS=56",
                "pc file directory": r"/opt/local/lib/pkgconfig",
            },
            "pybind11": {
                "name": "pybind11",
                "version": "3.0.1",
                "detection method": "config-tool",
                "include directory": r"unknown",
            },
        },
        "Python Information": {
            "path": r"/opt/local/Library/Frameworks/Python.framework/Versions/3.13/bin/python3.13",
            "version": "3.13",
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which SciPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )
