/*
 * Copyright 2008 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.gen;

/**
 * Interface to represent the constants contained in resource bundle:
 * 'com/google/gwt/i18n/client/gen/Colors.properties'.
 */
public interface Colors extends com.google.gwt.i18n.client.Constants {

  /**
   * Translated "bļåçķ".
   * 
   * @return translated "bļåçķ"
   */
  @DefaultStringValue("bļåçķ")
  @Key("black")
  String black();

  /**
   * Translated "bļûç".
   * 
   * @return translated "bļûç"
   */
  @DefaultStringValue("bļûç")
  @Key("blue")
  String blue();

  /**
   * Translated "ĝrééñ".
   * 
   * @return translated "ĝrééñ"
   */
  @DefaultStringValue("ĝrééñ")
  @Key("green")
  String green();

  /**
   * Translated "ĝréý".
   * 
   * @return translated "ĝréý"
   */
  @DefaultStringValue("ĝréý")
  @Key("grey")
  String grey();

  /**
   * Translated "réd ".
   * 
   * @return translated "réd "
   */
  @DefaultStringValue("réd ")
  @Key("red")
  String red();

  /**
   * Translated "any primary color".
   * 
   * @return translated "any primary color"
   */
  @DefaultStringValue("any primary color")
  @Key("shapeColor")
  String shapeColor();

  /**
   * Translated "ŵĥîţé".
   * 
   * @return translated "ŵĥîţé"
   */
  @DefaultStringValue("ŵĥîţé")
  @Key("white")
  String white();

  /**
   * Translated "ýéļļöŵ".
   * 
   * @return translated "ýéļļöŵ"
   */
  @DefaultStringValue("ýéļļöŵ")
  @Key("yellow")
  String yellow();
}
