/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class SelectionTableModel
extends AbstractTableModel
implements DataSelectionListener,
MainLayerManager.ActiveLayerChangeListener,
LayerManager.LayerChangeListener {
    private final transient OsmDataLayer layer;
    private final transient List<OsmPrimitive> cache;

    public SelectionTableModel(OsmDataLayer layer) {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        this.layer = layer;
        this.cache = new ArrayList<OsmPrimitive>();
        this.populateSelectedPrimitives(layer);
    }

    public void register() {
        SelectionEventManager.getInstance().addSelectionListener(this);
        MainApplication.getLayerManager().addActiveLayerChangeListener(this);
    }

    public void unregister() {
        SelectionEventManager.getInstance().removeSelectionListener(this);
        MainApplication.getLayerManager().removeActiveLayerChangeListener(this);
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        if (MainApplication.getLayerManager().getEditLayer() != this.layer) {
            return 0;
        }
        return this.cache.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.cache.get(rowIndex);
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        if (e.getPreviousActiveLayer() == this.layer) {
            this.cache.clear();
        }
        this.fireTableDataChanged();
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.getRemovedLayer() == this.layer) {
            this.unregister();
        }
        this.cache.clear();
        this.fireTableDataChanged();
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    @Override
    public void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        this.selectionChanged(event.getSelection());
    }

    private void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        if (this.layer == MainApplication.getLayerManager().getActiveDataLayer()) {
            this.cache.clear();
            this.cache.addAll(newSelection);
        } else {
            this.cache.clear();
        }
        this.fireTableDataChanged();
    }

    public List<OsmPrimitive> getSelection() {
        return this.cache;
    }

    protected void populateSelectedPrimitives(OsmDataLayer layer) {
        this.selectionChanged(layer.data.getAllSelected());
    }

    public OsmPrimitive getPrimitive(int row) {
        return this.cache.get(row);
    }
}

