/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bbox;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.bbox.BBoxChooser;
import org.openstreetmap.josm.gui.bbox.JosmMapViewer;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class TileSelectionBBoxChooser
extends JPanel
implements BBoxChooser {
    private transient Bounds bbox;
    private final TileBoundsMapView mapViewer = new TileBoundsMapView();
    private final TileGridInputPanel pnlTileGrid = new TileGridInputPanel();
    private final TileAddressInputPanel pnlTileAddress = new TileAddressInputPanel();

    protected final void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.weightx = 0.5;
        gc.fill = 2;
        gc.anchor = 18;
        this.add((Component)this.pnlTileGrid, gc);
        gc.gridx = 1;
        this.add((Component)this.pnlTileAddress, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 2;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.mapViewer, gc);
        this.mapViewer.setFocusable(false);
        this.mapViewer.setZoomControlsVisible(false);
        this.mapViewer.setMapMarkerVisible(false);
        this.pnlTileAddress.addPropertyChangeListener(this.pnlTileGrid);
        this.pnlTileGrid.addPropertyChangeListener(new TileBoundsChangeListener());
    }

    public TileSelectionBBoxChooser() {
        this.build();
    }

    @Override
    public Bounds getBoundingBox() {
        return this.bbox;
    }

    @Override
    public void setBoundingBox(Bounds bbox) {
        this.pnlTileGrid.initFromBoundingBox(bbox);
    }

    protected void refreshMapView() {
        if (this.bbox == null) {
            return;
        }
        ArrayList<MapMarker> marker = new ArrayList<MapMarker>(2);
        marker.add(new MapMarkerDot(this.bbox.getMinLat(), this.bbox.getMinLon()));
        marker.add(new MapMarkerDot(this.bbox.getMaxLat(), this.bbox.getMaxLon()));
        this.mapViewer.setBoundingBox(this.bbox);
        this.mapViewer.setMapMarkerList(marker);
        this.mapViewer.setDisplayToFitMapMarkers();
        this.mapViewer.zoomOut();
    }

    protected Bounds convertTileBoundsToBoundingBox(TileBounds tb) {
        LatLon min = this.getNorthWestLatLonOfTile(tb.min, tb.zoomLevel);
        Point p = new Point(tb.max);
        ++p.x;
        ++p.y;
        LatLon max = this.getNorthWestLatLonOfTile(p, tb.zoomLevel);
        return new Bounds(max.lat(), min.lon(), min.lat(), max.lon());
    }

    protected LatLon getNorthWestLatLonOfTile(Point tile, int zoom) {
        double lon = (double)tile.x / Math.pow(2.0, zoom) * 360.0 - 180.0;
        double lat = Utils.toDegrees(Math.atan(Math.sinh(Math.PI - Math.PI * 2 * (double)tile.y / Math.pow(2.0, zoom))));
        return new LatLon(lat, lon);
    }

    private static class TileGridInputPanel
    extends JPanel
    implements PropertyChangeListener {
        public static final String TILE_BOUNDS_PROP = TileGridInputPanel.class.getName() + ".tileBounds";
        private final JosmTextField tfMaxY = new JosmTextField();
        private final JosmTextField tfMinY = new JosmTextField();
        private final JosmTextField tfMaxX = new JosmTextField();
        private final JosmTextField tfMinX = new JosmTextField();
        private transient TileCoordinateValidator valMaxY;
        private transient TileCoordinateValidator valMinY;
        private transient TileCoordinateValidator valMaxX;
        private transient TileCoordinateValidator valMinX;
        private final JSpinner spZoomLevel = new JSpinner(new SpinnerNumberModel(0, 0, 18, 1));
        private final transient TileBoundsBuilder tileBoundsBuilder = new TileBoundsBuilder();
        private boolean doFireTileBoundChanged = true;

        protected JPanel buildTextPanel() {
            JPanel pnl = new JPanel(new BorderLayout());
            HtmlPanel msg = new HtmlPanel();
            msg.setText(I18n.tr("<html>Please select a <strong>range of OSM tiles</strong> at a given zoom level.</html>", new Object[0]));
            pnl.add(msg);
            return pnl;
        }

        protected JPanel buildZoomLevelPanel() {
            JPanel pnl = new JPanel(new FlowLayout(0));
            pnl.add(new JLabel(I18n.tr("Zoom level:", new Object[0])));
            pnl.add(this.spZoomLevel);
            this.spZoomLevel.addChangeListener(new ZomeLevelChangeHandler());
            this.spZoomLevel.addChangeListener(this.tileBoundsBuilder);
            return pnl;
        }

        protected JPanel buildTileGridInputPanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.insets = new Insets(0, 0, 2, 2);
            gc.gridwidth = 2;
            gc.gridx = 1;
            gc.fill = 2;
            pnl.add((Component)this.buildZoomLevelPanel(), gc);
            gc.gridwidth = 1;
            gc.gridy = 1;
            gc.gridx = 1;
            pnl.add((Component)new JLabel(I18n.tr("from tile", new Object[0])), gc);
            gc.gridx = 2;
            pnl.add((Component)new JLabel(I18n.tr("up to tile", new Object[0])), gc);
            gc.gridx = 0;
            gc.gridy = 2;
            gc.weightx = 0.0;
            pnl.add((Component)new JLabel("X:"), gc);
            gc.gridx = 1;
            gc.weightx = 0.5;
            pnl.add((Component)this.tfMinX, gc);
            this.valMinX = new TileCoordinateValidator(this.tfMinX);
            SelectAllOnFocusGainedDecorator.decorate(this.tfMinX);
            this.tfMinX.addActionListener(this.tileBoundsBuilder);
            this.tfMinX.addFocusListener(this.tileBoundsBuilder);
            gc.gridx = 2;
            gc.weightx = 0.5;
            pnl.add((Component)this.tfMaxX, gc);
            this.valMaxX = new TileCoordinateValidator(this.tfMaxX);
            SelectAllOnFocusGainedDecorator.decorate(this.tfMaxX);
            this.tfMaxX.addActionListener(this.tileBoundsBuilder);
            this.tfMaxX.addFocusListener(this.tileBoundsBuilder);
            gc.gridx = 0;
            gc.gridy = 3;
            gc.weightx = 0.0;
            pnl.add((Component)new JLabel("Y:"), gc);
            gc.gridx = 1;
            gc.weightx = 0.5;
            pnl.add((Component)this.tfMinY, gc);
            this.valMinY = new TileCoordinateValidator(this.tfMinY);
            SelectAllOnFocusGainedDecorator.decorate(this.tfMinY);
            this.tfMinY.addActionListener(this.tileBoundsBuilder);
            this.tfMinY.addFocusListener(this.tileBoundsBuilder);
            gc.gridx = 2;
            gc.weightx = 0.5;
            pnl.add((Component)this.tfMaxY, gc);
            this.valMaxY = new TileCoordinateValidator(this.tfMaxY);
            SelectAllOnFocusGainedDecorator.decorate(this.tfMaxY);
            this.tfMaxY.addActionListener(this.tileBoundsBuilder);
            this.tfMaxY.addFocusListener(this.tileBoundsBuilder);
            gc.gridy = 4;
            gc.gridx = 0;
            gc.gridwidth = 3;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            gc.fill = 1;
            pnl.add((Component)new JPanel(), gc);
            return pnl;
        }

        protected void build() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)this.buildTextPanel(), "North");
            this.add((Component)this.buildTileGridInputPanel(), "Center");
            HashSet<AWTKeyStroke> forwardKeys = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(0));
            forwardKeys.add(KeyStroke.getKeyStroke(10, 0));
            this.setFocusTraversalKeys(0, forwardKeys);
        }

        TileGridInputPanel() {
            this.build();
        }

        public void initFromBoundingBox(Bounds bbox) {
            if (bbox == null) {
                return;
            }
            TileBounds tb = new TileBounds();
            tb.zoomLevel = (Integer)this.spZoomLevel.getValue();
            tb.min = new Point(Math.max(0, TileGridInputPanel.lonToTileX(tb.zoomLevel, bbox.getMinLon())), Math.max(0, TileGridInputPanel.latToTileY(tb.zoomLevel, bbox.getMaxLat() - 1.0E-5)));
            tb.max = new Point(Math.max(0, TileGridInputPanel.lonToTileX(tb.zoomLevel, bbox.getMaxLon())), Math.max(0, TileGridInputPanel.latToTileY(tb.zoomLevel, bbox.getMinLat() - 1.0E-5)));
            this.doFireTileBoundChanged = false;
            this.setTileBounds(tb);
            this.doFireTileBoundChanged = true;
        }

        public static int latToTileY(int zoom, double lat) {
            if (zoom < 3 || zoom > 18) {
                return -1;
            }
            double l = lat / 180.0 * Math.PI;
            double pf = Math.log(Math.tan(l) + 1.0 / Math.cos(l));
            return (int)((double)(1 << zoom - 1) * (Math.PI - pf) / Math.PI);
        }

        public static int lonToTileX(int zoom, double lon) {
            if (zoom < 3 || zoom > 18) {
                return -1;
            }
            return (int)((double)(1 << zoom - 3) * (lon + 180.0) / 45.0);
        }

        public void setTileBounds(TileBounds tileBounds) {
            this.tfMinX.setText(Integer.toString(tileBounds.min.x));
            this.tfMinY.setText(Integer.toString(tileBounds.min.y));
            this.tfMaxX.setText(Integer.toString(tileBounds.max.x));
            this.tfMaxY.setText(Integer.toString(tileBounds.max.y));
            this.spZoomLevel.setValue(tileBounds.zoomLevel);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(TileAddressInputPanel.TILE_BOUNDS_PROP)) {
                TileBounds tb = (TileBounds)evt.getNewValue();
                this.setTileBounds(tb);
                this.fireTileBoundsChanged(tb);
            }
        }

        protected void fireTileBoundsChanged(TileBounds tb) {
            if (!this.doFireTileBoundChanged) {
                return;
            }
            this.firePropertyChange(TILE_BOUNDS_PROP, null, tb);
        }

        class ZomeLevelChangeHandler
        implements ChangeListener {
            ZomeLevelChangeHandler() {
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                int zoomLevel = (Integer)TileGridInputPanel.this.spZoomLevel.getValue();
                TileGridInputPanel.this.valMaxX.setZoomLevel(zoomLevel);
                TileGridInputPanel.this.valMaxY.setZoomLevel(zoomLevel);
                TileGridInputPanel.this.valMinX.setZoomLevel(zoomLevel);
                TileGridInputPanel.this.valMinY.setZoomLevel(zoomLevel);
            }
        }

        class TileBoundsBuilder
        implements ActionListener,
        FocusListener,
        ChangeListener {
            TileBoundsBuilder() {
            }

            protected void buildTileBounds() {
                if (!TileGridInputPanel.this.valMaxX.isValid()) {
                    return;
                }
                if (!TileGridInputPanel.this.valMaxY.isValid()) {
                    return;
                }
                if (!TileGridInputPanel.this.valMinX.isValid()) {
                    return;
                }
                if (!TileGridInputPanel.this.valMinY.isValid()) {
                    return;
                }
                Point min = new Point(TileGridInputPanel.this.valMinX.getTileIndex(), TileGridInputPanel.this.valMinY.getTileIndex());
                Point max = new Point(TileGridInputPanel.this.valMaxX.getTileIndex(), TileGridInputPanel.this.valMaxY.getTileIndex());
                int zoomlevel = (Integer)TileGridInputPanel.this.spZoomLevel.getValue();
                TileBounds tb = new TileBounds(min, max, zoomlevel);
                TileGridInputPanel.this.fireTileBoundsChanged(tb);
            }

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.buildTileBounds();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.buildTileBounds();
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.buildTileBounds();
            }
        }
    }

    private static class TileAddressInputPanel
    extends JPanel {
        public static final String TILE_BOUNDS_PROP = TileAddressInputPanel.class.getName() + ".tileBounds";
        private transient TileAddressValidator valTileAddress;

        protected JPanel buildTextPanel() {
            JPanel pnl = new JPanel(new BorderLayout());
            HtmlPanel msg = new HtmlPanel();
            msg.setText(I18n.tr("<html>Alternatively you may enter a <strong>tile address</strong> for a single tile in the format <i>zoomlevel/x/y</i>, e.g. <i>15/256/223</i>. Tile addresses in the format <i>zoom,x,y</i> or <i>zoom;x;y</i> are valid too.</html>", new Object[0]));
            pnl.add(msg);
            return pnl;
        }

        protected JPanel buildTileAddressInputPanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.weightx = 0.0;
            gc.insets = new Insets(0, 0, 2, 2);
            pnl.add((Component)new JLabel(I18n.tr("Tile address:", new Object[0])), gc);
            gc.weightx = 1.0;
            gc.gridx = 1;
            JosmTextField tfTileAddress = new JosmTextField();
            pnl.add((Component)tfTileAddress, gc);
            this.valTileAddress = new TileAddressValidator(tfTileAddress);
            SelectAllOnFocusGainedDecorator.decorate(tfTileAddress);
            gc.weightx = 0.0;
            gc.gridx = 2;
            ApplyTileAddressAction applyTileAddressAction = new ApplyTileAddressAction();
            JButton btn = new JButton(applyTileAddressAction);
            btn.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            pnl.add((Component)btn, gc);
            tfTileAddress.addActionListener(applyTileAddressAction);
            return pnl;
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.insets = new Insets(0, 0, 5, 0);
            this.add((Component)this.buildTextPanel(), gc);
            gc.gridy = 1;
            this.add((Component)this.buildTileAddressInputPanel(), gc);
            gc.gridy = 2;
            gc.fill = 1;
            gc.weighty = 1.0;
            this.add((Component)new JPanel(), gc);
        }

        TileAddressInputPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.build();
        }

        protected void fireTileBoundsChanged(TileBounds tb) {
            this.firePropertyChange(TILE_BOUNDS_PROP, null, tb);
        }

        class ApplyTileAddressAction
        extends AbstractAction {
            ApplyTileAddressAction() {
                new ImageProvider("apply").getResource().attachImageIcon(this, true);
                this.putValue("ShortDescription", I18n.tr("Apply the tile address", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                TileBounds tb = TileAddressInputPanel.this.valTileAddress.getTileBounds();
                if (tb != null) {
                    TileAddressInputPanel.this.fireTileBoundsChanged(tb);
                }
            }
        }
    }

    private static final class TileBoundsMapView
    extends JosmMapViewer {
        private Point min;
        private Point max;

        private TileBoundsMapView() {
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        }

        public void setBoundingBox(Bounds bbox) {
            if (bbox == null) {
                this.min = null;
                this.max = null;
            } else {
                Point p1 = this.tileSource.latLonToXY(bbox.getMinLat(), bbox.getMinLon(), 24);
                Point p2 = this.tileSource.latLonToXY(bbox.getMaxLat(), bbox.getMaxLon(), 24);
                this.min = new Point(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y));
                this.max = new Point(Math.max(p1.x, p2.x), Math.max(p1.y, p2.y));
            }
            this.repaint();
        }

        private Point getTopLeftCoordinates() {
            return new Point(this.center.x - this.getWidth() / 2, this.center.y - this.getHeight() / 2);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.min == null || this.max == null) {
                return;
            }
            int zoomDiff = 24 - this.zoom;
            Point tlc = this.getTopLeftCoordinates();
            int xMin = (this.min.x >> zoomDiff) - tlc.x;
            int yMin = (this.min.y >> zoomDiff) - tlc.y;
            int xMax = (this.max.x >> zoomDiff) - tlc.x;
            int yMax = (this.max.y >> zoomDiff) - tlc.y;
            int w = xMax - xMin;
            int h = yMax - yMin;
            g.setColor(new Color(0.9f, 0.7f, 0.7f, 0.6f));
            g.fillRect(xMin, yMin, w, h);
            g.setColor(Color.BLACK);
            g.drawRect(xMin, yMin, w, h);
        }
    }

    class TileBoundsChangeListener
    implements PropertyChangeListener {
        TileBoundsChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals(TileGridInputPanel.TILE_BOUNDS_PROP)) {
                return;
            }
            TileBounds tb = (TileBounds)evt.getNewValue();
            Bounds oldValue = TileSelectionBBoxChooser.this.bbox;
            TileSelectionBBoxChooser.this.bbox = TileSelectionBBoxChooser.this.convertTileBoundsToBoundingBox(tb);
            TileSelectionBBoxChooser.this.firePropertyChange(BBoxChooser.BBOX_PROP, oldValue, TileSelectionBBoxChooser.this.bbox);
            TileSelectionBBoxChooser.this.refreshMapView();
        }
    }

    private static final class TileBounds {
        private Point min;
        private Point max;
        private int zoomLevel;

        private TileBounds() {
            this.zoomLevel = 0;
            this.min = new Point(0, 0);
            this.max = new Point(0, 0);
        }

        private TileBounds(Point min, Point max, int zoomLevel) {
            this.min = min;
            this.max = max;
            this.zoomLevel = zoomLevel;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(24);
            sb.append("min=").append(this.min.x).append(',').append(this.min.y).append(",max=").append(this.max.x).append(',').append(this.max.y).append(",zoom=").append(this.zoomLevel);
            return sb.toString();
        }
    }

    private static class TileCoordinateValidator
    extends AbstractTextComponentValidator {
        private int zoomLevel;
        private int tileIndex;

        TileCoordinateValidator(JTextComponent tc) {
            super(tc);
        }

        public void setZoomLevel(int zoomLevel) {
            this.zoomLevel = zoomLevel;
            this.validate();
        }

        @Override
        public boolean isValid() {
            String value = this.getComponent().getText().trim();
            try {
                this.tileIndex = value.isEmpty() ? 0 : Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return this.tileIndex >= 0 && (double)this.tileIndex < Math.pow(2.0, this.zoomLevel);
        }

        @Override
        public void validate() {
            if (this.isValid()) {
                this.feedbackValid(I18n.tr("Please enter a tile index", new Object[0]));
            } else {
                this.feedbackInvalid(I18n.tr("The current value isn''t a valid tile index for the given zoom level", this.getComponent().getText()));
            }
        }

        public int getTileIndex() {
            return this.tileIndex;
        }
    }

    private static class TileAddressValidator
    extends AbstractTextComponentValidator {
        private TileBounds tileBounds;

        TileAddressValidator(JTextComponent tc) {
            super(tc);
        }

        @Override
        public boolean isValid() {
            int y;
            int x;
            int zoom;
            String value = this.getComponent().getText().trim();
            Matcher m = Pattern.compile("(\\d+)[^\\d]+(\\d+)[^\\d]+(\\d+)").matcher(value);
            this.tileBounds = null;
            if (!m.matches()) {
                return false;
            }
            try {
                zoom = Integer.parseInt(m.group(1));
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (zoom < 0 || zoom > 18) {
                return false;
            }
            try {
                x = Integer.parseInt(m.group(2));
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (x < 0 || (double)x >= Math.pow(2.0, zoom)) {
                return false;
            }
            try {
                y = Integer.parseInt(m.group(3));
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (y < 0 || (double)y >= Math.pow(2.0, zoom)) {
                return false;
            }
            this.tileBounds = new TileBounds(new Point(x, y), new Point(x, y), zoom);
            return true;
        }

        @Override
        public void validate() {
            if (this.isValid()) {
                this.feedbackValid(I18n.tr("Please enter a tile address", new Object[0]));
            } else {
                this.feedbackInvalid(I18n.tr("The current value isn''t a valid tile address", this.getComponent().getText()));
            }
        }

        public TileBounds getTileBounds() {
            return this.tileBounds;
        }
    }
}

