/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.ArrayList;
import java.util.Iterator;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.expr.path.KindTest;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.Test;
import org.basex.query.func.fn.FnError;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class Catch
extends Single {
    private final ArrayList<Test> tests;
    private final Var[] vars;

    public Catch(InputInfo info, Expr expr, Var[] vars, ArrayList<Test> tests) {
        super(info, expr, SeqType.ITEM_ZM);
        this.tests = tests;
        this.vars = vars;
        this.expr = expr;
    }

    @Override
    public Catch compile(CompileContext cc) throws QueryException {
        this.expr = cc.compileOrError(this.expr, false);
        return this.optimize(cc);
    }

    @Override
    public Catch optimize(CompileContext cc) {
        return (Catch)this.adoptType(this.expr);
    }

    Value value(QueryContext qc, QueryException ex) throws QueryException {
        int v = 0;
        for (Value value : ex.values()) {
            qc.set(this.vars[v++], value);
        }
        return this.expr.value(qc);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        Var[] vrs = QueryException.variables(cc.qc, this.info);
        int vl = vrs.length;
        for (int v = 0; v < vl; ++v) {
            vm.put(this.vars[v].id, cc.vs().add(vrs[v]));
        }
        return this.copyType(new Catch(this.info, this.expr.copy(cc, vm), vrs, new ArrayList<Test>(this.tests)));
    }

    @Override
    public Catch inline(InlineContext ic) {
        try {
            Expr inlined = this.expr.inline(ic);
            if (inlined == null) {
                return null;
            }
            this.expr = inlined;
        }
        catch (QueryException ex) {
            this.expr = FnError.get(ex, this.expr);
        }
        return this;
    }

    Expr inline(QueryException ex, CompileContext cc) throws QueryException {
        if (this.expr instanceof Value) {
            return this.expr;
        }
        Expr inlined = this.expr;
        int v = 0;
        for (Value value : ex.values()) {
            inlined = new InlineContext(this.vars[v++], value, cc).inline(inlined);
        }
        return inlined;
    }

    boolean simplify(ArrayList<Test> list, CompileContext cc) {
        if (list.contains(KindTest.ELEMENT)) {
            cc.info("simplify %: %", this::description, "*");
            return false;
        }
        if (this.tests.contains(KindTest.ELEMENT) && this.tests.size() != 1) {
            this.tests.clear();
            this.tests.add(KindTest.ELEMENT);
            cc.info("simplify %: %", this::description, "*");
        }
        Iterator<Test> iter = this.tests.iterator();
        while (iter.hasNext()) {
            Test test = iter.next();
            if (list.contains(test)) {
                cc.info("remove % from %", test, this::description);
                iter.remove();
                continue;
            }
            list.add(test);
        }
        return !this.tests.isEmpty();
    }

    boolean global() {
        return this.tests.size() == 1 && this.tests.get(0) instanceof KindTest;
    }

    boolean matches(QueryException ex) {
        QNm name = ex.qname();
        for (Test test : this.tests) {
            if (!(test instanceof KindTest) && !((NameTest)test).matches(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        for (Var var : this.vars) {
            if (visitor.declared(var)) continue;
            return false;
        }
        return Catch.visitAll(visitor, this.expr);
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Catch)) return false;
        Catch ctch = (Catch)obj;
        if (!Array.equals(this.vars, ctch.vars)) return false;
        if (!this.tests.equals(ctch.tests)) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("catch");
        int c = 0;
        for (Test test : this.tests) {
            if (c++ > 0) {
                qs.token('|');
            }
            qs.token(test.toString(false));
        }
        qs.brace(this.expr);
    }
}

