/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.io.IOException;
import java.math.BigDecimal;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.fn.FnRound;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Itr
extends ANum {
    public static final Itr MAX;
    public static final Itr ZERO;
    public static final Itr ONE;
    private static final Itr[] INTSS;
    private final long value;

    private Itr(long value) {
        this(value, AtomType.INTEGER);
    }

    public Itr(long value, Type type) {
        super(type);
        this.value = value;
    }

    public static Itr get(long value) {
        return value >= 0L && value < (long)INTSS.length ? INTSS[(int)value] : new Itr(value);
    }

    public static Itr get(long value, Type type) {
        return type == AtomType.INTEGER ? Itr.get(value) : new Itr(value, type);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.value);
    }

    @Override
    public byte[] string() {
        return Token.token(this.value);
    }

    @Override
    public boolean bool(InputInfo ii) {
        return this.value != 0L;
    }

    @Override
    public long itr() {
        return this.value;
    }

    @Override
    public float flt() {
        return this.value;
    }

    @Override
    public double dbl() {
        return this.value;
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) {
        return pos > 0L ? this.value == pos : this.bool(ii);
    }

    @Override
    public BigDecimal dec(InputInfo ii) {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public Itr abs() {
        return this.value < 0L ? Itr.get(-this.value) : this;
    }

    @Override
    public Itr ceiling() {
        return this;
    }

    @Override
    public Itr floor() {
        return this;
    }

    @Override
    public Itr round(int prec, FnRound.RoundMode mode) {
        if (this.value == 0L || prec >= 0) {
            return this;
        }
        long v = Dec.round(BigDecimal.valueOf(this.value), prec, mode).longValue();
        return v == this.value ? this : Itr.get(v);
    }

    public int toInt() {
        int i = (int)this.value;
        return this.value == (long)i ? i : Integer.MIN_VALUE;
    }

    @Override
    public int compare(Item item, Collation coll, boolean transitive, InputInfo ii) throws QueryException {
        int n;
        if (item instanceof Itr) {
            Itr itr = (Itr)item;
            n = Long.compare(this.value, itr.value);
        } else {
            n = this.compare(item, transitive, ii);
        }
        return n;
    }

    @Override
    public Object toJava() {
        return switch ((AtomType)this.type) {
            case AtomType.BYTE -> (byte)this.value;
            case AtomType.SHORT, AtomType.UNSIGNED_BYTE -> (short)this.value;
            case AtomType.UNSIGNED_SHORT -> Character.valueOf((char)this.value);
            case AtomType.INT -> (int)this.value;
            default -> this.value;
        };
    }

    @Override
    public int hashCode() {
        long v = this.value;
        int i = (int)v;
        return v == (long)i ? i : super.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Itr)) return false;
        Itr itr = (Itr)obj;
        if (this.type != itr.type) return false;
        if (this.value != itr.value) return false;
        return true;
    }

    public static long parse(byte[] value, InputInfo info) throws QueryException {
        long l = Token.toLong(value);
        if (l != Long.MIN_VALUE || Token.eq(Token.trim(value), Token.MIN_LONG)) {
            return l;
        }
        throw AtomType.INTEGER.castError(value, info);
    }

    static {
        int nl = 128;
        INTSS = new Itr[128];
        for (int n = 0; n < 128; ++n) {
            Itr.INTSS[n] = new Itr(n);
        }
        MAX = Itr.get(Long.MAX_VALUE);
        ZERO = INTSS[0];
        ONE = INTSS[1];
    }
}

