/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.TrieLeaf;
import org.basex.query.value.map.TrieNode;
import org.basex.query.value.map.TrieUpdate;
import org.basex.util.Array;
import org.basex.util.TokenBuilder;

final class TrieList
extends TrieNode {
    final int hash;
    final Item[] keys;
    final Value[] values;

    TrieList(int hash, Item[] keys, Value[] values) {
        super(keys.length);
        this.keys = keys;
        this.values = values;
        this.hash = hash;
    }

    TrieList(int hash, Item key1, Value value1, Item key2, Value value2) {
        this(hash, new Item[]{key1, key2}, new Value[]{value1, value2});
    }

    @Override
    TrieNode put(int hs, int lv, TrieUpdate update) throws QueryException {
        if (hs != this.hash) {
            return this.branch(hs, lv, this.hash, this.size, update);
        }
        int i = this.keys.length;
        while (i-- > 0) {
            Item key = this.keys[i];
            if (!key.atomicEqual(update.key)) continue;
            if (this.values[i] == update.value) {
                return this;
            }
            Value[] vs = (Value[])this.values.clone();
            vs[i] = update.value;
            return new TrieList(hs, this.keys, vs);
        }
        update.add();
        return new TrieList(this.hash, Array.add(this.keys, update.key), Array.add(this.values, update.value));
    }

    @Override
    TrieNode remove(int hs, int lv, TrieUpdate update) throws QueryException {
        if (hs == this.hash) {
            int i = this.size;
            while (i-- > 0) {
                if (!this.keys[i].atomicEqual(update.key)) continue;
                update.remove(this.keys[i]);
                if (this.size == 2) {
                    int o = i ^ 1;
                    return new TrieLeaf(hs, this.keys[o], this.values[o]);
                }
                int s = this.size - 1;
                Item[] ks = new Item[s];
                Array.copy(this.keys, i, ks);
                Array.copy(this.keys, i + 1, s - i, ks, i);
                Value[] vs = new Value[s];
                Array.copy(this.values, i, vs);
                Array.copy(this.values, i + 1, s - i, vs, i);
                return new TrieList(hs, ks, vs);
            }
        }
        return this;
    }

    @Override
    Value get(int hs, Item ky, int lv) throws QueryException {
        if (hs == this.hash) {
            int k = this.keys.length;
            while (k-- != 0) {
                if (!ky.atomicEqual(this.keys[k])) continue;
                return this.values[k];
            }
        }
        return null;
    }

    @Override
    void add(TokenBuilder tb, String indent) {
        tb.add(indent).add("`-- Collision (").add(Integer.toHexString(this.hash)).add("):\n");
        int kl = this.keys.length;
        for (int k = 0; k < kl; ++k) {
            tb.add(indent).add("      ").add(this.keys[k]).add(" => ").add(this.values[k]).add(10);
        }
    }
}

