/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Locale;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.BaseXSerializer;
import org.basex.io.serial.OutputSerializer;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.XMLSerializer;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.StaticContext;
import org.basex.query.value.Value;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.Token;
import org.basex.util.options.Options;

public class AdaptiveSerializer
extends OutputSerializer {
    private final OutputStream os;
    private XMLSerializer xml;
    private final PrintOutput.Fallback fallback = this::printHex;

    protected AdaptiveSerializer(OutputStream os, SerializerOptions sopts) throws IOException {
        this(os, sopts, true);
    }

    protected AdaptiveSerializer(OutputStream os, SerializerOptions sopts, boolean omit) throws IOException {
        super(os, sopts);
        this.os = os;
        if (omit) {
            sopts.set(SerializerOptions.OMIT_XML_DECLARATION, Options.YesNo.YES);
        }
        this.indent = sopts.yes(SerializerOptions.INDENT);
        if (this.itemsep == null) {
            this.itemsep = Token.token("\n");
        }
    }

    @Override
    public Serializer sc(StaticContext sctx) {
        if (this.xml != null) {
            this.xml.sc(sctx);
        }
        return super.sc(sctx);
    }

    @Override
    public final void serialize(Item item) throws IOException {
        this.separate();
        super.serialize(item);
    }

    @Override
    protected final void node(ANode node) throws IOException {
        Type type = node.type;
        XMLSerializer ser = this.xml();
        if (type == NodeType.ATTRIBUTE) {
            ser.attribute(node.name(), node.string(), true);
        } else if (type == NodeType.NAMESPACE_NODE) {
            ser.namespace(node.name(), node.string(), true);
        } else {
            ser.node(node);
        }
        ser.out.flush();
        ser.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void atomic(Item item) throws IOException {
        block12: {
            Type type = item.type;
            boolean basex = this instanceof BaseXSerializer;
            try {
                if (type == AtomType.DOUBLE) {
                    double d = item.dbl(null);
                    if (basex) {
                        this.printChars(Dbl.string(d));
                        break block12;
                    }
                    if (!Double.isFinite(d)) {
                        this.printChars(item.string(null));
                        break block12;
                    }
                    DecimalFormat decimalFormat = Token.AD;
                    synchronized (decimalFormat) {
                        this.printChars(Token.token(Token.AD.format(d).toLowerCase(Locale.ENGLISH)));
                        break block12;
                    }
                }
                if (type == AtomType.QNAME) {
                    this.printChar(35);
                    this.printChars(basex ? item.string(null) : ((QNm)item).unique());
                } else {
                    byte[] value;
                    boolean simple = type == AtomType.BOOLEAN || type.instanceOf(AtomType.DECIMAL);
                    byte[] byArray = value = simple ? Token.token(item) : AdaptiveSerializer.value(item.string(null), '\"', false);
                    if (basex || simple || type.instanceOf(AtomType.STRING) || type.oneOf(AtomType.UNTYPED_ATOMIC, AtomType.ANY_URI)) {
                        this.printChars(value);
                    } else {
                        this.printChars(Token.token(type.instanceOf(AtomType.DURATION) ? AtomType.DURATION : type));
                        this.printChar(40);
                        this.printChars(value);
                        this.printChar(41);
                    }
                }
            }
            catch (QueryException ex) {
                throw new QueryIOException(ex);
            }
        }
    }

    @Override
    protected final void function(FItem item) throws IOException {
        if (item instanceof XQArray) {
            XQArray array = (XQArray)item;
            this.array(array);
        } else if (item instanceof XQMap) {
            XQMap map = (XQMap)item;
            this.map(map);
        } else {
            QNm fn = item.funcName();
            if (fn == null) {
                this.printChars(Token.token("(anonymous-function)"));
            } else {
                this.printChars(fn.prefixId());
            }
            this.printChar(35);
            this.printChars(Token.token(item.arity()));
        }
    }

    @Override
    protected void printChar(int cp) throws IOException {
        this.out.print(cp, this.fallback);
    }

    protected void array(XQArray array) throws IOException {
        this.printChar(91);
        int c = 0;
        for (Value value : array.iterable()) {
            long vs;
            if (c++ > 0) {
                this.printChar(44);
            }
            if (this.indent) {
                this.printChar(32);
            }
            if ((vs = value.size()) != 1L) {
                this.printChar(40);
            }
            int i = 0;
            int cc = 0;
            while ((long)i < vs) {
                if (cc > 0) {
                    this.printChar(44);
                    if (this.indent) {
                        this.printChar(32);
                    }
                }
                this.more = false;
                this.serialize(value.itemAt(i));
                ++i;
                ++cc;
            }
            if (vs == 1L) continue;
            this.printChar(41);
        }
        if (c > 0 && this.indent) {
            this.printChar(32);
        }
        this.printChar(93);
    }

    protected void map(XQMap map) throws IOException {
        this.printChar(123);
        int c = 0;
        ++this.level;
        try {
            for (Item key : map.keys()) {
                Value value;
                boolean par;
                if (c++ > 0) {
                    this.printChar(44);
                }
                this.indent();
                this.more = false;
                this.serialize(key);
                this.printChar(58);
                if (this.indent) {
                    this.printChar(32);
                }
                boolean bl = par = (value = map.get(key)).size() != 1L;
                if (par) {
                    this.printChar(40);
                }
                int cc = 0;
                for (Item item : value) {
                    if (cc++ > 0) {
                        this.printChar(44);
                        if (this.indent) {
                            this.printChar(32);
                        }
                    }
                    this.more = false;
                    this.serialize(item);
                }
                if (!par) continue;
                this.printChar(41);
            }
        }
        catch (QueryException ex) {
            throw new QueryIOException(ex);
        }
        --this.level;
        if (c > 0) {
            this.indent();
        }
        this.printChar(125);
    }

    private XMLSerializer xml() throws IOException {
        if (this.xml == null) {
            this.xml = new XMLSerializer(this.os, this.sopts);
            this.xml.sc(this.sc);
        }
        return this.xml;
    }
}

