/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import java.util.ArrayList;
import org.basex.query.StaticContext;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.RecordType;
import org.basex.query.value.type.Types;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.hash.IntObjectMap;
import org.basex.util.hash.TokenObjectMap;
import org.basex.util.hash.WeakTokenSet;

public final class SharedData {
    private final TokenObjectMap<QNm> qnames = new TokenObjectMap();
    private final WeakTokenSet tokens = new WeakTokenSet();
    private final IntObjectMap<ArrayList<RecordType>> recordTypes = new IntObjectMap();

    public SharedData() {
        this.record(Types.RECORD);
    }

    public QNm parseQName(byte[] token, boolean elem, StaticContext sc) {
        byte[] name = Token.trim(token);
        if (XMLToken.isQName(name)) {
            byte[] prefix = Token.prefix(name);
            byte[] uri = prefix.length != 0 || elem ? sc.ns.uri(prefix) : null;
            return this.qName(name, uri);
        }
        byte[][] parsed = QNm.parseExpanded(name, false);
        return parsed != null ? this.qName(parsed[0], parsed[1]) : null;
    }

    public QNm qName(byte[] name) {
        return this.qName(name, null);
    }

    public QNm qName(byte[] name, byte[] uri) {
        return this.qnames.computeIfAbsent(uri != null ? Token.concat(name, Token.cpToken(32), uri) : name, () -> new QNm(name, uri));
    }

    public byte[] token(byte[] token) {
        return token.length == 0 ? Token.EMPTY : this.tokens.put(token);
    }

    public RecordType record(RecordType rt) {
        ArrayList types = this.recordTypes.computeIfAbsent(rt.fields().size(), ArrayList::new);
        for (RecordType type : types) {
            if (!type.equals(rt)) continue;
            return type;
        }
        types.add(rt);
        return rt;
    }
}

