/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.transform;

import de.bottlecaps.markup.Blitz;
import de.bottlecaps.markup.blitz.grammar.Alt;
import de.bottlecaps.markup.blitz.grammar.Alts;
import de.bottlecaps.markup.blitz.grammar.Charset;
import de.bottlecaps.markup.blitz.grammar.Control;
import de.bottlecaps.markup.blitz.grammar.Grammar;
import de.bottlecaps.markup.blitz.grammar.Insertion;
import de.bottlecaps.markup.blitz.grammar.Literal;
import de.bottlecaps.markup.blitz.grammar.Mark;
import de.bottlecaps.markup.blitz.grammar.Node;
import de.bottlecaps.markup.blitz.grammar.Nonterminal;
import de.bottlecaps.markup.blitz.grammar.Occurrence;
import de.bottlecaps.markup.blitz.grammar.Rule;
import de.bottlecaps.markup.blitz.grammar.Term;
import de.bottlecaps.markup.blitz.transform.ClassifyCharacters;
import de.bottlecaps.markup.blitz.transform.GenerateAdditionalNames;
import de.bottlecaps.markup.blitz.transform.PostProcess;
import de.bottlecaps.markup.blitz.transform.Visitor;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;

public class BNF
extends Visitor {
    private Stack<Alts> alts = new Stack();
    private Grammar copy;
    private Map<String, Rule> justAdded = new LinkedHashMap<String, Rule>();
    private Queue<Rule> charsets = new LinkedList<Rule>();
    private Set<String> coveredRules = new HashSet<String>();
    private Grammar grammar;
    private boolean isolateCharsets;

    private BNF(Grammar grammar, boolean isolateCharsets) {
        this.grammar = grammar;
        this.isolateCharsets = isolateCharsets;
    }

    public static Grammar process(Grammar g) {
        return BNF.process(g, Collections.emptySet());
    }

    public static Grammar process(Grammar g, Set<Blitz.Option> options) {
        return BNF.process(g, false, options);
    }

    public static Grammar process(Grammar g, boolean isolateCharsets, Set<Blitz.Option> options) {
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        boolean timing = options.contains((Object)Blitz.Option.TIMING);
        if (timing) {
            t0 = System.currentTimeMillis();
        }
        ClassifyCharacters cc = new ClassifyCharacters(new Grammar(g));
        Grammar grammar = cc.combine(g, options);
        if (timing) {
            t1 = System.currentTimeMillis();
        }
        new GenerateAdditionalNames(grammar).visit(grammar);
        if (timing) {
            t2 = System.currentTimeMillis();
        }
        BNF bnf = new BNF(grammar, isolateCharsets);
        bnf.visit(grammar);
        bnf.copy.setAdditionalNames(grammar.getAdditionalNames());
        PostProcess.process(bnf.copy);
        if (timing) {
            t3 = System.currentTimeMillis();
            System.err.println("                                charset combination time: " + (t1 - t0) + " msec");
            System.err.println("                                    name generation time: " + (t2 - t1) + " msec");
            System.err.println("                                                BNF time: " + (t3 - t2) + " msec");
        }
        return bnf.copy;
    }

    @Override
    public void visit(Grammar g) {
        this.copy = new Grammar(g);
        super.visit(g);
        if (this.isolateCharsets) {
            Rule rule;
            while ((rule = this.charsets.poll()) != null) {
                this.copy.addRule(rule);
            }
        }
    }

    @Override
    public void visit(Rule r) {
        if (this.copy.getRules().isEmpty()) {
            Alt alt = new Alt();
            Mark mark = r.getMark() == Mark.NONE ? Mark.NODE : r.getMark();
            alt.addNonterminal(mark, r.getAlias(), r.getName());
            Alts alts = new Alts();
            alts.addAlt(alt);
            Rule rule = new Rule(Mark.DELETE, null, this.grammar.getAdditionalNames().get(Term.START)[0], alts);
            this.copy.addRule(rule);
        }
        if (!this.copy.getRules().containsKey(r.getName())) {
            super.visit(r);
            Alts a = this.alts.pop();
            if (this.justAdded.containsKey(r.getName())) {
                this.copy.addRule(this.justAdded.remove(r.getName()));
            } else {
                this.copy.addRule(new Rule(Mark.NONE, null, r.getName(), a));
                this.coveredRules.add(r.getName());
            }
            for (Rule rule : this.justAdded.values()) {
                this.copy.addRule(rule);
            }
            this.justAdded.clear();
        }
    }

    @Override
    public void visit(Alts a) {
        this.alts.push(new Alts());
        super.visit(a);
        String[] names = this.grammar.getAdditionalNames().get(a);
        if (names == null) {
            if (this.alts.size() != 1) {
                Alts nested = this.alts.pop();
                this.alts.peek().last().addAlts(nested);
            }
        } else if (this.alts.size() != 1) {
            String name = names[0];
            Alts pop = this.alts.pop();
            Nonterminal nonterminal = new Nonterminal(Mark.DELETE, null, name);
            this.alts.peek().last().getTerms().add(nonterminal);
            if (!this.coveredRules.contains(name)) {
                Rule additionalRule = new Rule(Mark.NONE, null, name, pop);
                this.coveredRules.add(additionalRule.getName());
                this.justAdded.put(additionalRule.getName(), additionalRule);
            }
        }
    }

    @Override
    public void visit(Alt a) {
        this.alts.peek().addAlt(new Alt());
        super.visit(a);
    }

    @Override
    public void visit(Nonterminal n) {
        this.alts.peek().last().getTerms().add(new Nonterminal(n.getEffectiveMark(), n.getEffectiveAlias(), n.getName()));
    }

    @Override
    public void visit(Literal l) {
        throw new IllegalStateException();
    }

    @Override
    public void visit(Control c) {
        super.visit(c);
        Term separator = c.getSeparator() == null ? null : this.alts.peek().last().removeLast();
        Term term = this.alts.peek().last().removeLast();
        String[] names = this.grammar.getAdditionalNames().get(c);
        String name = names[0];
        this.alts.peek().last().getTerms().add(new Nonterminal(Mark.DELETE, null, name));
        switch (c.getOccurrence()) {
            case ONE_OR_MORE: {
                if (this.coveredRules.contains(name)) break;
                Alts alts = new Alts();
                Alt alt1 = new Alt();
                alt1.getTerms().add((Term)term.copy());
                Alt alt2 = new Alt();
                alt2.addNonterminal(Mark.DELETE, null, name);
                if (separator != null) {
                    alt2.getTerms().add((Term)separator.copy());
                }
                alt2.getTerms().add((Term)term.copy());
                alts.addAlt(alt1);
                alts.addAlt(alt2);
                Rule additionalRule = new Rule(Mark.NONE, null, name, alts);
                this.coveredRules.add(name);
                this.justAdded.put(name, additionalRule);
                break;
            }
            case ZERO_OR_MORE: {
                Rule additionalRule;
                Alts alts;
                if (separator == null) {
                    if (this.coveredRules.contains(name)) break;
                    Alts alts2 = new Alts();
                    Alt alt1 = new Alt();
                    Alt alt2 = new Alt();
                    alt2.addNonterminal(Mark.DELETE, null, name);
                    alt2.getTerms().add((Term)term.copy());
                    alts2.addAlt(alt1);
                    alts2.addAlt(alt2);
                    Rule additionalRule2 = new Rule(Mark.NONE, null, name, alts2);
                    this.coveredRules.add(name);
                    this.justAdded.put(name, additionalRule2);
                    break;
                }
                String listName = names[1];
                if (!this.coveredRules.contains(listName)) {
                    alts = new Alts();
                    Alt alt1 = new Alt();
                    alt1.getTerms().add((Term)term.copy());
                    Alt alt2 = new Alt();
                    alt2.addNonterminal(Mark.DELETE, null, listName);
                    alt2.getTerms().add((Term)separator.copy());
                    alt2.getTerms().add((Term)term.copy());
                    alts.addAlt(alt1);
                    alts.addAlt(alt2);
                    additionalRule = new Rule(Mark.NONE, null, listName, alts);
                    this.coveredRules.add(listName);
                    this.justAdded.put(listName, additionalRule);
                }
                if (this.coveredRules.contains(name)) break;
                alts = new Alts();
                Alt alt2 = new Alt();
                alt2.addNonterminal(Mark.DELETE, null, listName);
                alts.addAlt(new Alt());
                alts.addAlt(alt2);
                additionalRule = new Rule(Mark.NONE, null, name, alts);
                this.coveredRules.add(name);
                this.justAdded.put(name, additionalRule);
                break;
            }
            case ZERO_OR_ONE: {
                if (this.coveredRules.contains(name)) break;
                Alts alts = new Alts();
                alts.addAlt(new Alt());
                alts.addAlt(new Alt());
                alts.last().getTerms().add(term);
                Rule additionalRule = new Rule(Mark.NONE, null, name, alts);
                this.coveredRules.add(name);
                this.justAdded.put(name, additionalRule);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void visit(Charset c) {
        if (!this.isolateCharsets || this.grammar.getAdditionalNames().get(c) == null) {
            this.alts.peek().last().getTerms().add(c.copy());
        } else {
            String name = this.grammar.getAdditionalNames().get(c)[0];
            Nonterminal nonterminal = new Nonterminal(Mark.DELETE, null, name);
            this.alts.peek().last().getTerms().add(nonterminal);
            if (!this.coveredRules.contains(name)) {
                Alts alts = new Alts();
                Alt alt = new Alt();
                alt.addCharset(c);
                alts.addAlt(alt);
                Rule additionalRule = new Rule(Mark.NONE, null, name, alts);
                this.coveredRules.add(additionalRule.getName());
                this.charsets.offer(additionalRule);
            }
        }
    }

    @Override
    public void visit(Insertion i) {
        if (i.getNext() == null && !this.isRepeated(i)) {
            this.alts.peek().last().getTerms().add((Term)i.copy());
        } else {
            String name = this.grammar.getAdditionalNames().get(i)[0];
            Nonterminal nonterminal = new Nonterminal(Mark.DELETE, null, name);
            this.alts.peek().last().getTerms().add(nonterminal);
            if (!this.coveredRules.contains(name)) {
                Alts alts = new Alts();
                Alt alt = new Alt();
                alt.getTerms().add(i);
                alts.addAlt(alt);
                Rule additionalRule = new Rule(Mark.NONE, null, name, alts);
                this.coveredRules.add(additionalRule.getName());
                this.justAdded.put(additionalRule.getName(), additionalRule);
            }
        }
    }

    private boolean isRepeated(Node node) {
        while (!(node.getParent() instanceof Rule)) {
            if (!((node = node.getParent()) instanceof Control) || ((Control)node).getOccurrence() == Occurrence.ZERO_OR_ONE) continue;
            return true;
        }
        return false;
    }
}

