case RISCVVector::BI__builtin_rvv_vundefined:
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return llvm::PoisonValue::get(ResultType);
      break;
case RISCVVector::BI__builtin_rvv_vget_v:
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVGetBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                 PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vset_v:
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVSetBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                 PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vcreate_v:
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVCreateBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                    PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vlenb:
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

      return emitRVVVlenbBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                 PolicyAttrs, IsMasked, SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlmul_ext_v:
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return Builder.CreateInsertVector(ResultType,
                                          llvm::PoisonValue::get(ResultType),
                                          Ops[0], ConstantInt::get(Int64Ty, 0));
      break;
case RISCVVector::BI__builtin_rvv_vlmul_trunc_v:
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;
 {
        return Builder.CreateExtractVector(ResultType, Ops[0],
                                           ConstantInt::get(Int64Ty, 0));
      } break;
case RISCVVector::BI__builtin_rvv_vreinterpret_v:
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVReinterpretBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return llvm::PoisonValue::get(ResultType);
      break;
case RISCVVector::BI__builtin_rvv_vaadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vaadd_vx_tu:
  ID = Intrinsic::riscv_vaadd;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vaadd_vv:
case RISCVVector::BI__builtin_rvv_vaadd_vx:
  ID = Intrinsic::riscv_vaadd;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vaadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vaadd_vx_tum:
  ID = Intrinsic::riscv_vaadd_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vaadd_vv_m:
case RISCVVector::BI__builtin_rvv_vaadd_vx_m:
  ID = Intrinsic::riscv_vaadd_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vaadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vaadd_vx_tumu:
  ID = Intrinsic::riscv_vaadd_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vaadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vaadd_vx_mu:
  ID = Intrinsic::riscv_vaadd_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vaaddu_vv_tu:
case RISCVVector::BI__builtin_rvv_vaaddu_vx_tu:
  ID = Intrinsic::riscv_vaaddu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vaaddu_vv:
case RISCVVector::BI__builtin_rvv_vaaddu_vx:
  ID = Intrinsic::riscv_vaaddu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vaaddu_vv_tum:
case RISCVVector::BI__builtin_rvv_vaaddu_vx_tum:
  ID = Intrinsic::riscv_vaaddu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vaaddu_vv_m:
case RISCVVector::BI__builtin_rvv_vaaddu_vx_m:
  ID = Intrinsic::riscv_vaaddu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vaaddu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vaaddu_vx_tumu:
  ID = Intrinsic::riscv_vaaddu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vaaddu_vv_mu:
case RISCVVector::BI__builtin_rvv_vaaddu_vx_mu:
  ID = Intrinsic::riscv_vaaddu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vadc_vvm_tu:
case RISCVVector::BI__builtin_rvv_vadc_vxm_tu:
  ID = Intrinsic::riscv_vadc;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vadc_vvm:
case RISCVVector::BI__builtin_rvv_vadc_vxm:
  ID = Intrinsic::riscv_vadc;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vadd_vx_tu:
  ID = Intrinsic::riscv_vadd;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vadd_vv:
case RISCVVector::BI__builtin_rvv_vadd_vx:
  ID = Intrinsic::riscv_vadd;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vadd_vx_tum:
  ID = Intrinsic::riscv_vadd_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vadd_vv_m:
case RISCVVector::BI__builtin_rvv_vadd_vx_m:
  ID = Intrinsic::riscv_vadd_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vadd_vx_tumu:
  ID = Intrinsic::riscv_vadd_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vadd_vx_mu:
  ID = Intrinsic::riscv_vadd_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesdf_vs_tu:
  ID = Intrinsic::riscv_vaesdf_vs;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesdf_vs:
  ID = Intrinsic::riscv_vaesdf_vs;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesdf_vv_tu:
  ID = Intrinsic::riscv_vaesdf_vv;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesdf_vv:
  ID = Intrinsic::riscv_vaesdf_vv;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesdm_vs_tu:
  ID = Intrinsic::riscv_vaesdm_vs;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesdm_vs:
  ID = Intrinsic::riscv_vaesdm_vs;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesdm_vv_tu:
  ID = Intrinsic::riscv_vaesdm_vv;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesdm_vv:
  ID = Intrinsic::riscv_vaesdm_vv;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesef_vs_tu:
  ID = Intrinsic::riscv_vaesef_vs;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesef_vs:
  ID = Intrinsic::riscv_vaesef_vs;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesef_vv_tu:
  ID = Intrinsic::riscv_vaesef_vv;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesef_vv:
  ID = Intrinsic::riscv_vaesef_vv;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesem_vs_tu:
  ID = Intrinsic::riscv_vaesem_vs;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesem_vs:
  ID = Intrinsic::riscv_vaesem_vs;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesem_vv_tu:
  ID = Intrinsic::riscv_vaesem_vv;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesem_vv:
  ID = Intrinsic::riscv_vaesem_vv;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaeskf1_vi_tu:
  ID = Intrinsic::riscv_vaeskf1;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaeskf1_vi:
  ID = Intrinsic::riscv_vaeskf1;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaeskf2_vi_tu:
  ID = Intrinsic::riscv_vaeskf2;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaeskf2_vi:
  ID = Intrinsic::riscv_vaeskf2;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesz_vs_tu:
  ID = Intrinsic::riscv_vaesz_vs;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vaesz_vs:
  ID = Intrinsic::riscv_vaesz_vs;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vand_vv_tu:
case RISCVVector::BI__builtin_rvv_vand_vx_tu:
  ID = Intrinsic::riscv_vand;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vand_vv:
case RISCVVector::BI__builtin_rvv_vand_vx:
  ID = Intrinsic::riscv_vand;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vand_vv_tum:
case RISCVVector::BI__builtin_rvv_vand_vx_tum:
  ID = Intrinsic::riscv_vand_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vand_vv_m:
case RISCVVector::BI__builtin_rvv_vand_vx_m:
  ID = Intrinsic::riscv_vand_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vand_vv_tumu:
case RISCVVector::BI__builtin_rvv_vand_vx_tumu:
  ID = Intrinsic::riscv_vand_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vand_vv_mu:
case RISCVVector::BI__builtin_rvv_vand_vx_mu:
  ID = Intrinsic::riscv_vand_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vandn_vv_tu:
case RISCVVector::BI__builtin_rvv_vandn_vx_tu:
  ID = Intrinsic::riscv_vandn;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vandn_vv:
case RISCVVector::BI__builtin_rvv_vandn_vx:
  ID = Intrinsic::riscv_vandn;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vandn_vv_tum:
case RISCVVector::BI__builtin_rvv_vandn_vx_tum:
  ID = Intrinsic::riscv_vandn_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vandn_vv_m:
case RISCVVector::BI__builtin_rvv_vandn_vx_m:
  ID = Intrinsic::riscv_vandn_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vandn_vv_tumu:
case RISCVVector::BI__builtin_rvv_vandn_vx_tumu:
  ID = Intrinsic::riscv_vandn_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vandn_vv_mu:
case RISCVVector::BI__builtin_rvv_vandn_vx_mu:
  ID = Intrinsic::riscv_vandn_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vasub_vv_tu:
case RISCVVector::BI__builtin_rvv_vasub_vx_tu:
  ID = Intrinsic::riscv_vasub;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vasub_vv:
case RISCVVector::BI__builtin_rvv_vasub_vx:
  ID = Intrinsic::riscv_vasub;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vasub_vv_tum:
case RISCVVector::BI__builtin_rvv_vasub_vx_tum:
  ID = Intrinsic::riscv_vasub_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vasub_vv_m:
case RISCVVector::BI__builtin_rvv_vasub_vx_m:
  ID = Intrinsic::riscv_vasub_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vasub_vv_tumu:
case RISCVVector::BI__builtin_rvv_vasub_vx_tumu:
  ID = Intrinsic::riscv_vasub_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vasub_vv_mu:
case RISCVVector::BI__builtin_rvv_vasub_vx_mu:
  ID = Intrinsic::riscv_vasub_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vasubu_vv_tu:
case RISCVVector::BI__builtin_rvv_vasubu_vx_tu:
  ID = Intrinsic::riscv_vasubu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vasubu_vv:
case RISCVVector::BI__builtin_rvv_vasubu_vx:
  ID = Intrinsic::riscv_vasubu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vasubu_vv_tum:
case RISCVVector::BI__builtin_rvv_vasubu_vx_tum:
  ID = Intrinsic::riscv_vasubu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vasubu_vv_m:
case RISCVVector::BI__builtin_rvv_vasubu_vx_m:
  ID = Intrinsic::riscv_vasubu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vasubu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vasubu_vx_tumu:
  ID = Intrinsic::riscv_vasubu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vasubu_vv_mu:
case RISCVVector::BI__builtin_rvv_vasubu_vx_mu:
  ID = Intrinsic::riscv_vasubu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vbrev_v_tu:
  ID = Intrinsic::riscv_vbrev;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev_v:
  ID = Intrinsic::riscv_vbrev;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev8_v_tu:
  ID = Intrinsic::riscv_vbrev8;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev8_v:
  ID = Intrinsic::riscv_vbrev8;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev8_v_tum:
  ID = Intrinsic::riscv_vbrev8_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev8_v_m:
  ID = Intrinsic::riscv_vbrev8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev8_v_tumu:
  ID = Intrinsic::riscv_vbrev8_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev8_v_mu:
  ID = Intrinsic::riscv_vbrev8_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev_v_tum:
  ID = Intrinsic::riscv_vbrev_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev_v_m:
  ID = Intrinsic::riscv_vbrev_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev_v_tumu:
  ID = Intrinsic::riscv_vbrev_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vbrev_v_mu:
  ID = Intrinsic::riscv_vbrev_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmul_vv_tu:
case RISCVVector::BI__builtin_rvv_vclmul_vx_tu:
  ID = Intrinsic::riscv_vclmul;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmul_vv:
case RISCVVector::BI__builtin_rvv_vclmul_vx:
  ID = Intrinsic::riscv_vclmul;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmul_vv_tum:
case RISCVVector::BI__builtin_rvv_vclmul_vx_tum:
  ID = Intrinsic::riscv_vclmul_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmul_vv_m:
case RISCVVector::BI__builtin_rvv_vclmul_vx_m:
  ID = Intrinsic::riscv_vclmul_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmul_vv_tumu:
case RISCVVector::BI__builtin_rvv_vclmul_vx_tumu:
  ID = Intrinsic::riscv_vclmul_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmul_vv_mu:
case RISCVVector::BI__builtin_rvv_vclmul_vx_mu:
  ID = Intrinsic::riscv_vclmul_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmulh_vv_tu:
case RISCVVector::BI__builtin_rvv_vclmulh_vx_tu:
  ID = Intrinsic::riscv_vclmulh;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmulh_vv:
case RISCVVector::BI__builtin_rvv_vclmulh_vx:
  ID = Intrinsic::riscv_vclmulh;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmulh_vv_tum:
case RISCVVector::BI__builtin_rvv_vclmulh_vx_tum:
  ID = Intrinsic::riscv_vclmulh_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmulh_vv_m:
case RISCVVector::BI__builtin_rvv_vclmulh_vx_m:
  ID = Intrinsic::riscv_vclmulh_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmulh_vv_tumu:
case RISCVVector::BI__builtin_rvv_vclmulh_vx_tumu:
  ID = Intrinsic::riscv_vclmulh_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclmulh_vv_mu:
case RISCVVector::BI__builtin_rvv_vclmulh_vx_mu:
  ID = Intrinsic::riscv_vclmulh_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclz_v_tu:
  ID = Intrinsic::riscv_vclz;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclz_v:
  ID = Intrinsic::riscv_vclz;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclz_v_tum:
  ID = Intrinsic::riscv_vclz_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclz_v_m:
  ID = Intrinsic::riscv_vclz_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclz_v_tumu:
  ID = Intrinsic::riscv_vclz_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vclz_v_mu:
  ID = Intrinsic::riscv_vclz_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vcompress_vm_tu:
  ID = Intrinsic::riscv_vcompress;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

      // insert poison passthru
      if (PolicyAttrs & RVV_VTA)
        Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      IntrinsicTypes = {ResultType, Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vcompress_vm:
  ID = Intrinsic::riscv_vcompress;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

      // insert poison passthru
      if (PolicyAttrs & RVV_VTA)
        Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      IntrinsicTypes = {ResultType, Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vcpop_m:
  ID = Intrinsic::riscv_vcpop;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vcpop_m_m:
  ID = Intrinsic::riscv_vcpop_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[0]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vcpop_v_tu:
  ID = Intrinsic::riscv_vcpopv;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vcpop_v:
  ID = Intrinsic::riscv_vcpopv;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vcpop_v_tum:
  ID = Intrinsic::riscv_vcpopv_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vcpop_v_m:
  ID = Intrinsic::riscv_vcpopv_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vcpop_v_tumu:
  ID = Intrinsic::riscv_vcpopv_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vcpop_v_mu:
  ID = Intrinsic::riscv_vcpopv_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vctz_v_tu:
  ID = Intrinsic::riscv_vctz;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vctz_v:
  ID = Intrinsic::riscv_vctz;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vctz_v_tum:
  ID = Intrinsic::riscv_vctz_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vctz_v_m:
  ID = Intrinsic::riscv_vctz_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vctz_v_tumu:
  ID = Intrinsic::riscv_vctz_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vctz_v_mu:
  ID = Intrinsic::riscv_vctz_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdiv_vv_tu:
case RISCVVector::BI__builtin_rvv_vdiv_vx_tu:
  ID = Intrinsic::riscv_vdiv;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdiv_vv:
case RISCVVector::BI__builtin_rvv_vdiv_vx:
  ID = Intrinsic::riscv_vdiv;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdiv_vv_tum:
case RISCVVector::BI__builtin_rvv_vdiv_vx_tum:
  ID = Intrinsic::riscv_vdiv_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdiv_vv_m:
case RISCVVector::BI__builtin_rvv_vdiv_vx_m:
  ID = Intrinsic::riscv_vdiv_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdiv_vv_tumu:
case RISCVVector::BI__builtin_rvv_vdiv_vx_tumu:
  ID = Intrinsic::riscv_vdiv_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdiv_vv_mu:
case RISCVVector::BI__builtin_rvv_vdiv_vx_mu:
  ID = Intrinsic::riscv_vdiv_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdivu_vv_tu:
case RISCVVector::BI__builtin_rvv_vdivu_vx_tu:
  ID = Intrinsic::riscv_vdivu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdivu_vv:
case RISCVVector::BI__builtin_rvv_vdivu_vx:
  ID = Intrinsic::riscv_vdivu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdivu_vv_tum:
case RISCVVector::BI__builtin_rvv_vdivu_vx_tum:
  ID = Intrinsic::riscv_vdivu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdivu_vv_m:
case RISCVVector::BI__builtin_rvv_vdivu_vx_m:
  ID = Intrinsic::riscv_vdivu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdivu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vdivu_vx_tumu:
  ID = Intrinsic::riscv_vdivu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vdivu_vv_mu:
case RISCVVector::BI__builtin_rvv_vdivu_vx_mu:
  ID = Intrinsic::riscv_vdivu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfadd_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfadd_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vfadd_vf_tu:
  ID = Intrinsic::riscv_vfadd;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfadd_vv_rm:
case RISCVVector::BI__builtin_rvv_vfadd_vf_rm:
case RISCVVector::BI__builtin_rvv_vfadd_vv:
case RISCVVector::BI__builtin_rvv_vfadd_vf:
  ID = Intrinsic::riscv_vfadd;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfadd_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfadd_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vfadd_vf_tum:
  ID = Intrinsic::riscv_vfadd_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfadd_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfadd_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfadd_vv_m:
case RISCVVector::BI__builtin_rvv_vfadd_vf_m:
  ID = Intrinsic::riscv_vfadd_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfadd_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfadd_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfadd_vf_tumu:
  ID = Intrinsic::riscv_vfadd_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfadd_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfadd_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vfadd_vf_mu:
  ID = Intrinsic::riscv_vfadd_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfclass_v_tu:
  ID = Intrinsic::riscv_vfclass;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfclass_v:
  ID = Intrinsic::riscv_vfclass;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfclass_v_tum:
  ID = Intrinsic::riscv_vfclass_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfclass_v_m:
  ID = Intrinsic::riscv_vfclass_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfclass_v_tumu:
  ID = Intrinsic::riscv_vfclass_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfclass_v_mu:
  ID = Intrinsic::riscv_vfclass_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_tu:
  ID = Intrinsic::riscv_vfcvt_f_x_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_rm:
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v:
  ID = Intrinsic::riscv_vfcvt_f_x_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_tum:
  ID = Intrinsic::riscv_vfcvt_f_x_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_m:
  ID = Intrinsic::riscv_vfcvt_f_x_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_tumu:
  ID = Intrinsic::riscv_vfcvt_f_x_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfcvt_f_x_v_mu:
  ID = Intrinsic::riscv_vfcvt_f_x_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_tu:
  ID = Intrinsic::riscv_vfcvt_f_xu_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_rm:
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v:
  ID = Intrinsic::riscv_vfcvt_f_xu_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_tum:
  ID = Intrinsic::riscv_vfcvt_f_xu_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_m:
  ID = Intrinsic::riscv_vfcvt_f_xu_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_tumu:
  ID = Intrinsic::riscv_vfcvt_f_xu_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfcvt_f_xu_v_mu:
  ID = Intrinsic::riscv_vfcvt_f_xu_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_x_f_v_tu:
  ID = Intrinsic::riscv_vfcvt_rtz_x_f_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_x_f_v:
  ID = Intrinsic::riscv_vfcvt_rtz_x_f_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_x_f_v_tum:
  ID = Intrinsic::riscv_vfcvt_rtz_x_f_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_x_f_v_m:
  ID = Intrinsic::riscv_vfcvt_rtz_x_f_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_x_f_v_tumu:
  ID = Intrinsic::riscv_vfcvt_rtz_x_f_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_x_f_v_mu:
  ID = Intrinsic::riscv_vfcvt_rtz_x_f_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_xu_f_v_tu:
  ID = Intrinsic::riscv_vfcvt_rtz_xu_f_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_xu_f_v:
  ID = Intrinsic::riscv_vfcvt_rtz_xu_f_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_xu_f_v_tum:
  ID = Intrinsic::riscv_vfcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_xu_f_v_m:
  ID = Intrinsic::riscv_vfcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_xu_f_v_tumu:
  ID = Intrinsic::riscv_vfcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_rtz_xu_f_v_mu:
  ID = Intrinsic::riscv_vfcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_tu:
  ID = Intrinsic::riscv_vfcvt_x_f_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_rm:
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v:
  ID = Intrinsic::riscv_vfcvt_x_f_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_tum:
  ID = Intrinsic::riscv_vfcvt_x_f_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_m:
  ID = Intrinsic::riscv_vfcvt_x_f_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_tumu:
  ID = Intrinsic::riscv_vfcvt_x_f_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfcvt_x_f_v_mu:
  ID = Intrinsic::riscv_vfcvt_x_f_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_tu:
  ID = Intrinsic::riscv_vfcvt_xu_f_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_rm:
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v:
  ID = Intrinsic::riscv_vfcvt_xu_f_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_tum:
  ID = Intrinsic::riscv_vfcvt_xu_f_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_m:
  ID = Intrinsic::riscv_vfcvt_xu_f_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_tumu:
  ID = Intrinsic::riscv_vfcvt_xu_f_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfcvt_xu_f_v_mu:
  ID = Intrinsic::riscv_vfcvt_xu_f_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfdiv_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfdiv_vv_tu:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_tu:
  ID = Intrinsic::riscv_vfdiv;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfdiv_vv_rm:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_rm:
case RISCVVector::BI__builtin_rvv_vfdiv_vv:
case RISCVVector::BI__builtin_rvv_vfdiv_vf:
  ID = Intrinsic::riscv_vfdiv;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfdiv_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfdiv_vv_tum:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_tum:
  ID = Intrinsic::riscv_vfdiv_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfdiv_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfdiv_vv_m:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_m:
  ID = Intrinsic::riscv_vfdiv_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfdiv_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfdiv_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_tumu:
  ID = Intrinsic::riscv_vfdiv_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfdiv_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfdiv_vv_mu:
case RISCVVector::BI__builtin_rvv_vfdiv_vf_mu:
  ID = Intrinsic::riscv_vfdiv_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfirst_m:
  ID = Intrinsic::riscv_vfirst;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfirst_m_m:
  ID = Intrinsic::riscv_vfirst_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[0]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmacc_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmacc_vv_tu:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_tu:
  ID = Intrinsic::riscv_vfmacc;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmacc_vv_rm:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_rm:
case RISCVVector::BI__builtin_rvv_vfmacc_vv:
case RISCVVector::BI__builtin_rvv_vfmacc_vf:
  ID = Intrinsic::riscv_vfmacc;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmacc_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmacc_vv_tum:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_tum:
  ID = Intrinsic::riscv_vfmacc_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmacc_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfmacc_vv_m:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_m:
  ID = Intrinsic::riscv_vfmacc_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmacc_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmacc_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_tumu:
  ID = Intrinsic::riscv_vfmacc_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmacc_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmacc_vv_mu:
case RISCVVector::BI__builtin_rvv_vfmacc_vf_mu:
  ID = Intrinsic::riscv_vfmacc_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmadd_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_tu:
  ID = Intrinsic::riscv_vfmadd;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmadd_vv_rm:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_rm:
case RISCVVector::BI__builtin_rvv_vfmadd_vv:
case RISCVVector::BI__builtin_rvv_vfmadd_vf:
  ID = Intrinsic::riscv_vfmadd;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmadd_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_tum:
  ID = Intrinsic::riscv_vfmadd_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmadd_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfmadd_vv_m:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_m:
  ID = Intrinsic::riscv_vfmadd_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmadd_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_tumu:
  ID = Intrinsic::riscv_vfmadd_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmadd_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vfmadd_vf_mu:
  ID = Intrinsic::riscv_vfmadd_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmax_vv_tu:
case RISCVVector::BI__builtin_rvv_vfmax_vf_tu:
  ID = Intrinsic::riscv_vfmax;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmax_vv:
case RISCVVector::BI__builtin_rvv_vfmax_vf:
  ID = Intrinsic::riscv_vfmax;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmax_vv_tum:
case RISCVVector::BI__builtin_rvv_vfmax_vf_tum:
  ID = Intrinsic::riscv_vfmax_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmax_vv_m:
case RISCVVector::BI__builtin_rvv_vfmax_vf_m:
  ID = Intrinsic::riscv_vfmax_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmax_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfmax_vf_tumu:
  ID = Intrinsic::riscv_vfmax_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmax_vv_mu:
case RISCVVector::BI__builtin_rvv_vfmax_vf_mu:
  ID = Intrinsic::riscv_vfmax_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmerge_vfm_tu:
  ID = Intrinsic::riscv_vfmerge;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

      // insert poison passthru
      if (PolicyAttrs & RVV_VTA)
        Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vfmerge_vfm:
  ID = Intrinsic::riscv_vfmerge;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

      // insert poison passthru
      if (PolicyAttrs & RVV_VTA)
        Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vfmin_vv_tu:
case RISCVVector::BI__builtin_rvv_vfmin_vf_tu:
  ID = Intrinsic::riscv_vfmin;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmin_vv:
case RISCVVector::BI__builtin_rvv_vfmin_vf:
  ID = Intrinsic::riscv_vfmin;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmin_vv_tum:
case RISCVVector::BI__builtin_rvv_vfmin_vf_tum:
  ID = Intrinsic::riscv_vfmin_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmin_vv_m:
case RISCVVector::BI__builtin_rvv_vfmin_vf_m:
  ID = Intrinsic::riscv_vfmin_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmin_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfmin_vf_tumu:
  ID = Intrinsic::riscv_vfmin_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmin_vv_mu:
case RISCVVector::BI__builtin_rvv_vfmin_vf_mu:
  ID = Intrinsic::riscv_vfmin_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmsac_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmsac_vv_tu:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_tu:
  ID = Intrinsic::riscv_vfmsac;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsac_vv_rm:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_rm:
case RISCVVector::BI__builtin_rvv_vfmsac_vv:
case RISCVVector::BI__builtin_rvv_vfmsac_vf:
  ID = Intrinsic::riscv_vfmsac;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsac_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmsac_vv_tum:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_tum:
  ID = Intrinsic::riscv_vfmsac_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsac_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfmsac_vv_m:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_m:
  ID = Intrinsic::riscv_vfmsac_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsac_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmsac_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_tumu:
  ID = Intrinsic::riscv_vfmsac_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsac_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmsac_vv_mu:
case RISCVVector::BI__builtin_rvv_vfmsac_vf_mu:
  ID = Intrinsic::riscv_vfmsac_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsub_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmsub_vv_tu:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_tu:
  ID = Intrinsic::riscv_vfmsub;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsub_vv_rm:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_rm:
case RISCVVector::BI__builtin_rvv_vfmsub_vv:
case RISCVVector::BI__builtin_rvv_vfmsub_vf:
  ID = Intrinsic::riscv_vfmsub;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsub_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmsub_vv_tum:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_tum:
  ID = Intrinsic::riscv_vfmsub_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsub_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfmsub_vv_m:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_m:
  ID = Intrinsic::riscv_vfmsub_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsub_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmsub_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_tumu:
  ID = Intrinsic::riscv_vfmsub_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmsub_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmsub_vv_mu:
case RISCVVector::BI__builtin_rvv_vfmsub_vf_mu:
  ID = Intrinsic::riscv_vfmsub_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmul_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmul_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfmul_vv_tu:
case RISCVVector::BI__builtin_rvv_vfmul_vf_tu:
  ID = Intrinsic::riscv_vfmul;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmul_vv_rm:
case RISCVVector::BI__builtin_rvv_vfmul_vf_rm:
case RISCVVector::BI__builtin_rvv_vfmul_vv:
case RISCVVector::BI__builtin_rvv_vfmul_vf:
  ID = Intrinsic::riscv_vfmul;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmul_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmul_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfmul_vv_tum:
case RISCVVector::BI__builtin_rvv_vfmul_vf_tum:
  ID = Intrinsic::riscv_vfmul_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmul_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfmul_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfmul_vv_m:
case RISCVVector::BI__builtin_rvv_vfmul_vf_m:
  ID = Intrinsic::riscv_vfmul_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmul_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmul_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfmul_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfmul_vf_tumu:
  ID = Intrinsic::riscv_vfmul_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmul_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmul_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfmul_vv_mu:
case RISCVVector::BI__builtin_rvv_vfmul_vf_mu:
  ID = Intrinsic::riscv_vfmul_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfmv_f_s:
  ID = Intrinsic::riscv_vfmv_f_s;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmv_s_f_tu:
case RISCVVector::BI__builtin_rvv_vfmv_s_x_tu:
  ID = Intrinsic::riscv_vfmv_s_f;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmv_s_f:
case RISCVVector::BI__builtin_rvv_vfmv_s_x:
  ID = Intrinsic::riscv_vfmv_s_f;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmv_v_f_tu:
  ID = Intrinsic::riscv_vfmv_v_f;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfmv_v_f:
  ID = Intrinsic::riscv_vfmv_v_f;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_rm_tu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_tu:
  ID = Intrinsic::riscv_vfncvt_f_f_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_rm:
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w:
  ID = Intrinsic::riscv_vfncvt_f_f_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_rm_tum:
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_tum:
  ID = Intrinsic::riscv_vfncvt_f_f_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_rm_m:
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_m:
  ID = Intrinsic::riscv_vfncvt_f_f_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_tumu:
  ID = Intrinsic::riscv_vfncvt_f_f_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_rm_mu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_f_w_mu:
  ID = Intrinsic::riscv_vfncvt_f_f_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_rm_tu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_tu:
  ID = Intrinsic::riscv_vfncvt_f_x_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_rm:
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w:
  ID = Intrinsic::riscv_vfncvt_f_x_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_rm_tum:
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_tum:
  ID = Intrinsic::riscv_vfncvt_f_x_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_rm_m:
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_m:
  ID = Intrinsic::riscv_vfncvt_f_x_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_tumu:
  ID = Intrinsic::riscv_vfncvt_f_x_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_rm_mu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_x_w_mu:
  ID = Intrinsic::riscv_vfncvt_f_x_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_rm_tu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_tu:
  ID = Intrinsic::riscv_vfncvt_f_xu_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_rm:
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w:
  ID = Intrinsic::riscv_vfncvt_f_xu_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_rm_tum:
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_tum:
  ID = Intrinsic::riscv_vfncvt_f_xu_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_rm_m:
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_m:
  ID = Intrinsic::riscv_vfncvt_f_xu_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_tumu:
  ID = Intrinsic::riscv_vfncvt_f_xu_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_rm_mu:
case RISCVVector::BI__builtin_rvv_vfncvt_f_xu_w_mu:
  ID = Intrinsic::riscv_vfncvt_f_xu_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_rod_f_f_w_tu:
  ID = Intrinsic::riscv_vfncvt_rod_f_f_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rod_f_f_w:
  ID = Intrinsic::riscv_vfncvt_rod_f_f_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rod_f_f_w_tum:
  ID = Intrinsic::riscv_vfncvt_rod_f_f_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rod_f_f_w_m:
  ID = Intrinsic::riscv_vfncvt_rod_f_f_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rod_f_f_w_tumu:
  ID = Intrinsic::riscv_vfncvt_rod_f_f_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rod_f_f_w_mu:
  ID = Intrinsic::riscv_vfncvt_rod_f_f_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_x_f_w_tu:
  ID = Intrinsic::riscv_vfncvt_rtz_x_f_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_x_f_w:
  ID = Intrinsic::riscv_vfncvt_rtz_x_f_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_x_f_w_tum:
  ID = Intrinsic::riscv_vfncvt_rtz_x_f_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_x_f_w_m:
  ID = Intrinsic::riscv_vfncvt_rtz_x_f_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_x_f_w_tumu:
  ID = Intrinsic::riscv_vfncvt_rtz_x_f_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_x_f_w_mu:
  ID = Intrinsic::riscv_vfncvt_rtz_x_f_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_xu_f_w_tu:
  ID = Intrinsic::riscv_vfncvt_rtz_xu_f_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_xu_f_w:
  ID = Intrinsic::riscv_vfncvt_rtz_xu_f_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_xu_f_w_tum:
  ID = Intrinsic::riscv_vfncvt_rtz_xu_f_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_xu_f_w_m:
  ID = Intrinsic::riscv_vfncvt_rtz_xu_f_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_xu_f_w_tumu:
  ID = Intrinsic::riscv_vfncvt_rtz_xu_f_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_rtz_xu_f_w_mu:
  ID = Intrinsic::riscv_vfncvt_rtz_xu_f_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_rm_tu:
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_tu:
  ID = Intrinsic::riscv_vfncvt_x_f_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_rm:
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w:
  ID = Intrinsic::riscv_vfncvt_x_f_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_rm_tum:
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_tum:
  ID = Intrinsic::riscv_vfncvt_x_f_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_rm_m:
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_m:
  ID = Intrinsic::riscv_vfncvt_x_f_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_tumu:
  ID = Intrinsic::riscv_vfncvt_x_f_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_rm_mu:
case RISCVVector::BI__builtin_rvv_vfncvt_x_f_w_mu:
  ID = Intrinsic::riscv_vfncvt_x_f_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_rm_tu:
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_tu:
  ID = Intrinsic::riscv_vfncvt_xu_f_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_rm:
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w:
  ID = Intrinsic::riscv_vfncvt_xu_f_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_rm_tum:
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_tum:
  ID = Intrinsic::riscv_vfncvt_xu_f_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_rm_m:
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_m:
  ID = Intrinsic::riscv_vfncvt_xu_f_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_tumu:
  ID = Intrinsic::riscv_vfncvt_xu_f_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_rm_mu:
case RISCVVector::BI__builtin_rvv_vfncvt_xu_f_w_mu:
  ID = Intrinsic::riscv_vfncvt_xu_f_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_rm_tu:
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_tu:
  ID = Intrinsic::riscv_vfncvtbf16_f_f_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_rm:
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w:
  ID = Intrinsic::riscv_vfncvtbf16_f_f_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_rm_tum:
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_tum:
  ID = Intrinsic::riscv_vfncvtbf16_f_f_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_rm_m:
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_m:
  ID = Intrinsic::riscv_vfncvtbf16_f_f_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_tumu:
  ID = Intrinsic::riscv_vfncvtbf16_f_f_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_rm_mu:
case RISCVVector::BI__builtin_rvv_vfncvtbf16_f_f_w_mu:
  ID = Intrinsic::riscv_vfncvtbf16_f_f_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_tu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_tu:
  ID = Intrinsic::riscv_vfnmacc;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_rm:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_rm:
case RISCVVector::BI__builtin_rvv_vfnmacc_vv:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf:
  ID = Intrinsic::riscv_vfnmacc;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_tum:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_tum:
  ID = Intrinsic::riscv_vfnmacc_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_m:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_m:
  ID = Intrinsic::riscv_vfnmacc_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_tumu:
  ID = Intrinsic::riscv_vfnmacc_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vv_mu:
case RISCVVector::BI__builtin_rvv_vfnmacc_vf_mu:
  ID = Intrinsic::riscv_vfnmacc_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_tu:
  ID = Intrinsic::riscv_vfnmadd;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_rm:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_rm:
case RISCVVector::BI__builtin_rvv_vfnmadd_vv:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf:
  ID = Intrinsic::riscv_vfnmadd;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_tum:
  ID = Intrinsic::riscv_vfnmadd_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_m:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_m:
  ID = Intrinsic::riscv_vfnmadd_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_tumu:
  ID = Intrinsic::riscv_vfnmadd_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vfnmadd_vf_mu:
  ID = Intrinsic::riscv_vfnmadd_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_tu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_tu:
  ID = Intrinsic::riscv_vfnmsac;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_rm:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_rm:
case RISCVVector::BI__builtin_rvv_vfnmsac_vv:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf:
  ID = Intrinsic::riscv_vfnmsac;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_tum:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_tum:
  ID = Intrinsic::riscv_vfnmsac_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_m:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_m:
  ID = Intrinsic::riscv_vfnmsac_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_tumu:
  ID = Intrinsic::riscv_vfnmsac_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vv_mu:
case RISCVVector::BI__builtin_rvv_vfnmsac_vf_mu:
  ID = Intrinsic::riscv_vfnmsac_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_tu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_tu:
  ID = Intrinsic::riscv_vfnmsub;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_rm:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_rm:
case RISCVVector::BI__builtin_rvv_vfnmsub_vv:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf:
  ID = Intrinsic::riscv_vfnmsub;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_tum:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_tum:
  ID = Intrinsic::riscv_vfnmsub_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_m:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_m:
  ID = Intrinsic::riscv_vfnmsub_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_tumu:
  ID = Intrinsic::riscv_vfnmsub_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vv_mu:
case RISCVVector::BI__builtin_rvv_vfnmsub_vf_mu:
  ID = Intrinsic::riscv_vfnmsub_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFMABuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                             PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_tu:
  ID = Intrinsic::riscv_vfrdiv;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_rm:
case RISCVVector::BI__builtin_rvv_vfrdiv_vf:
  ID = Intrinsic::riscv_vfrdiv;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_tum:
  ID = Intrinsic::riscv_vfrdiv_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_m:
  ID = Intrinsic::riscv_vfrdiv_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_tumu:
  ID = Intrinsic::riscv_vfrdiv_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfrdiv_vf_mu:
  ID = Intrinsic::riscv_vfrdiv_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfrec7_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfrec7_v_tu:
  ID = Intrinsic::riscv_vfrec7;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfrec7_v_rm:
case RISCVVector::BI__builtin_rvv_vfrec7_v:
  ID = Intrinsic::riscv_vfrec7;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfrec7_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfrec7_v_tum:
  ID = Intrinsic::riscv_vfrec7_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfrec7_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfrec7_v_m:
  ID = Intrinsic::riscv_vfrec7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfrec7_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfrec7_v_tumu:
  ID = Intrinsic::riscv_vfrec7_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfrec7_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfrec7_v_mu:
  ID = Intrinsic::riscv_vfrec7_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfredmax_vs_tu:
  ID = Intrinsic::riscv_vfredmax;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredmax_vs:
  ID = Intrinsic::riscv_vfredmax;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredmax_vs_tum:
  ID = Intrinsic::riscv_vfredmax_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredmax_vs_m:
  ID = Intrinsic::riscv_vfredmax_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredmin_vs_tu:
  ID = Intrinsic::riscv_vfredmin;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredmin_vs:
  ID = Intrinsic::riscv_vfredmin;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredmin_vs_tum:
  ID = Intrinsic::riscv_vfredmin_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredmin_vs_m:
  ID = Intrinsic::riscv_vfredmin_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfredosum_vs_rm_tu:
case RISCVVector::BI__builtin_rvv_vfredosum_vs_tu:
  ID = Intrinsic::riscv_vfredosum;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingReductionBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfredosum_vs_rm:
case RISCVVector::BI__builtin_rvv_vfredosum_vs:
  ID = Intrinsic::riscv_vfredosum;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingReductionBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfredosum_vs_rm_tum:
case RISCVVector::BI__builtin_rvv_vfredosum_vs_tum:
  ID = Intrinsic::riscv_vfredosum_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingReductionBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfredosum_vs_rm_m:
case RISCVVector::BI__builtin_rvv_vfredosum_vs_m:
  ID = Intrinsic::riscv_vfredosum_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingReductionBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfredusum_vs_rm_tu:
case RISCVVector::BI__builtin_rvv_vfredusum_vs_tu:
  ID = Intrinsic::riscv_vfredusum;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingReductionBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfredusum_vs_rm:
case RISCVVector::BI__builtin_rvv_vfredusum_vs:
  ID = Intrinsic::riscv_vfredusum;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingReductionBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfredusum_vs_rm_tum:
case RISCVVector::BI__builtin_rvv_vfredusum_vs_tum:
  ID = Intrinsic::riscv_vfredusum_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingReductionBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfredusum_vs_rm_m:
case RISCVVector::BI__builtin_rvv_vfredusum_vs_m:
  ID = Intrinsic::riscv_vfredusum_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingReductionBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfrsqrt7_v_tu:
  ID = Intrinsic::riscv_vfrsqrt7;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfrsqrt7_v:
  ID = Intrinsic::riscv_vfrsqrt7;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfrsqrt7_v_tum:
  ID = Intrinsic::riscv_vfrsqrt7_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfrsqrt7_v_m:
  ID = Intrinsic::riscv_vfrsqrt7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfrsqrt7_v_tumu:
  ID = Intrinsic::riscv_vfrsqrt7_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfrsqrt7_v_mu:
  ID = Intrinsic::riscv_vfrsqrt7_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfrsub_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfrsub_vf_tu:
  ID = Intrinsic::riscv_vfrsub;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfrsub_vf_rm:
case RISCVVector::BI__builtin_rvv_vfrsub_vf:
  ID = Intrinsic::riscv_vfrsub;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfrsub_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfrsub_vf_tum:
  ID = Intrinsic::riscv_vfrsub_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfrsub_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfrsub_vf_m:
  ID = Intrinsic::riscv_vfrsub_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfrsub_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfrsub_vf_tumu:
  ID = Intrinsic::riscv_vfrsub_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfrsub_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfrsub_vf_mu:
  ID = Intrinsic::riscv_vfrsub_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfsgnj_vv_tu:
case RISCVVector::BI__builtin_rvv_vfsgnj_vf_tu:
  ID = Intrinsic::riscv_vfsgnj;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfsgnj_vv:
case RISCVVector::BI__builtin_rvv_vfsgnj_vf:
  ID = Intrinsic::riscv_vfsgnj;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfsgnj_vv_tum:
case RISCVVector::BI__builtin_rvv_vfsgnj_vf_tum:
  ID = Intrinsic::riscv_vfsgnj_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfsgnj_vv_m:
case RISCVVector::BI__builtin_rvv_vfsgnj_vf_m:
  ID = Intrinsic::riscv_vfsgnj_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfsgnj_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfsgnj_vf_tumu:
  ID = Intrinsic::riscv_vfsgnj_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfsgnj_vv_mu:
case RISCVVector::BI__builtin_rvv_vfsgnj_vf_mu:
  ID = Intrinsic::riscv_vfsgnj_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfneg_v_tu:
  ID = Intrinsic::riscv_vfsgnjn;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVPseudoVFUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                           Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjn_vv_tu:
case RISCVVector::BI__builtin_rvv_vfsgnjn_vf_tu:
  ID = Intrinsic::riscv_vfsgnjn;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vfsgnjn;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVPseudoVFUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                           Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vfneg_v:
  ID = Intrinsic::riscv_vfsgnjn;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVPseudoVFUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                           Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjn_vv:
case RISCVVector::BI__builtin_rvv_vfsgnjn_vf:
  ID = Intrinsic::riscv_vfsgnjn;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vfsgnjn;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVPseudoVFUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                           Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vfneg_v_tum:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVFUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                           Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjn_vv_tum:
case RISCVVector::BI__builtin_rvv_vfsgnjn_vf_tum:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVFUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                           Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vfneg_v_m:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVFUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                           Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjn_vv_m:
case RISCVVector::BI__builtin_rvv_vfsgnjn_vf_m:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVFUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                           Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vfneg_v_tumu:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVFUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                           Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjn_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfsgnjn_vf_tumu:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVFUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                           Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vfneg_v_mu:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVFUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                           Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjn_vv_mu:
case RISCVVector::BI__builtin_rvv_vfsgnjn_vf_mu:
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vfsgnjn_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVFUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                           Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjx_vv_tu:
case RISCVVector::BI__builtin_rvv_vfsgnjx_vf_tu:
  ID = Intrinsic::riscv_vfsgnjx;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfabs_v_tu:
  ID = Intrinsic::riscv_vfsgnjx;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVPseudoVFUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                           Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjx_vv:
case RISCVVector::BI__builtin_rvv_vfsgnjx_vf:
  ID = Intrinsic::riscv_vfsgnjx;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfabs_v:
  ID = Intrinsic::riscv_vfsgnjx;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVPseudoVFUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                           Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjx_vv_tum:
case RISCVVector::BI__builtin_rvv_vfsgnjx_vf_tum:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfabs_v_tum:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVFUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                           Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjx_vv_m:
case RISCVVector::BI__builtin_rvv_vfsgnjx_vf_m:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfabs_v_m:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVFUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                           Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjx_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfsgnjx_vf_tumu:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfabs_v_tumu:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVFUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                           Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vfsgnjx_vv_mu:
case RISCVVector::BI__builtin_rvv_vfsgnjx_vf_mu:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfabs_v_mu:
  ID = Intrinsic::riscv_vfsgnjx_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVFUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                           Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vfslide1down_vf_tu:
  ID = Intrinsic::riscv_vfslide1down;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1down_vf:
  ID = Intrinsic::riscv_vfslide1down;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1down_vf_tum:
  ID = Intrinsic::riscv_vfslide1down_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1down_vf_m:
  ID = Intrinsic::riscv_vfslide1down_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1down_vf_tumu:
  ID = Intrinsic::riscv_vfslide1down_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1down_vf_mu:
  ID = Intrinsic::riscv_vfslide1down_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1up_vf_tu:
  ID = Intrinsic::riscv_vfslide1up;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1up_vf:
  ID = Intrinsic::riscv_vfslide1up;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1up_vf_tum:
  ID = Intrinsic::riscv_vfslide1up_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1up_vf_m:
  ID = Intrinsic::riscv_vfslide1up_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1up_vf_tumu:
  ID = Intrinsic::riscv_vfslide1up_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfslide1up_vf_mu:
  ID = Intrinsic::riscv_vfslide1up_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfsqrt_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfsqrt_v_tu:
  ID = Intrinsic::riscv_vfsqrt;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfsqrt_v_rm:
case RISCVVector::BI__builtin_rvv_vfsqrt_v:
  ID = Intrinsic::riscv_vfsqrt;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfsqrt_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfsqrt_v_tum:
  ID = Intrinsic::riscv_vfsqrt_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfsqrt_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfsqrt_v_m:
  ID = Intrinsic::riscv_vfsqrt_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfsqrt_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfsqrt_v_tumu:
  ID = Intrinsic::riscv_vfsqrt_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfsqrt_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfsqrt_v_mu:
  ID = Intrinsic::riscv_vfsqrt_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfsub_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfsub_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfsub_vv_tu:
case RISCVVector::BI__builtin_rvv_vfsub_vf_tu:
  ID = Intrinsic::riscv_vfsub;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfsub_vv_rm:
case RISCVVector::BI__builtin_rvv_vfsub_vf_rm:
case RISCVVector::BI__builtin_rvv_vfsub_vv:
case RISCVVector::BI__builtin_rvv_vfsub_vf:
  ID = Intrinsic::riscv_vfsub;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfsub_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfsub_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfsub_vv_tum:
case RISCVVector::BI__builtin_rvv_vfsub_vf_tum:
  ID = Intrinsic::riscv_vfsub_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfsub_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfsub_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfsub_vv_m:
case RISCVVector::BI__builtin_rvv_vfsub_vf_m:
  ID = Intrinsic::riscv_vfsub_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfsub_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfsub_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfsub_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfsub_vf_tumu:
  ID = Intrinsic::riscv_vfsub_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfsub_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfsub_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfsub_vv_mu:
case RISCVVector::BI__builtin_rvv_vfsub_vf_mu:
  ID = Intrinsic::riscv_vfsub_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_tu:
  ID = Intrinsic::riscv_vfwadd;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVWideningFloatingPointBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwadd_vv:
case RISCVVector::BI__builtin_rvv_vfwadd_vf:
  ID = Intrinsic::riscv_vfwadd;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVWideningFloatingPointBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_tum:
  ID = Intrinsic::riscv_vfwadd_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFloatingPointBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwadd_vv_m:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_m:
  ID = Intrinsic::riscv_vfwadd_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFloatingPointBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_tumu:
  ID = Intrinsic::riscv_vfwadd_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFloatingPointBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwadd_vf_mu:
  ID = Intrinsic::riscv_vfwadd_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFloatingPointBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_wv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwadd_wv_tu:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_tu:
  ID = Intrinsic::riscv_vfwadd_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_wv_rm:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_rm:
case RISCVVector::BI__builtin_rvv_vfwadd_wv:
case RISCVVector::BI__builtin_rvv_vfwadd_wf:
  ID = Intrinsic::riscv_vfwadd_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_wv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwadd_wv_tum:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_tum:
  ID = Intrinsic::riscv_vfwadd_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_wv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwadd_wv_m:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_m:
  ID = Intrinsic::riscv_vfwadd_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_wv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwadd_wv_tumu:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_tumu:
  ID = Intrinsic::riscv_vfwadd_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwadd_wv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwadd_wv_mu:
case RISCVVector::BI__builtin_rvv_vfwadd_wf_mu:
  ID = Intrinsic::riscv_vfwadd_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_f_v_tu:
  ID = Intrinsic::riscv_vfwcvt_f_f_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_f_v:
  ID = Intrinsic::riscv_vfwcvt_f_f_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_f_v_tum:
  ID = Intrinsic::riscv_vfwcvt_f_f_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_f_v_m:
  ID = Intrinsic::riscv_vfwcvt_f_f_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_f_v_tumu:
  ID = Intrinsic::riscv_vfwcvt_f_f_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_f_v_mu:
  ID = Intrinsic::riscv_vfwcvt_f_f_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_x_v_tu:
  ID = Intrinsic::riscv_vfwcvt_f_x_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_x_v:
  ID = Intrinsic::riscv_vfwcvt_f_x_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_x_v_tum:
  ID = Intrinsic::riscv_vfwcvt_f_x_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_x_v_m:
  ID = Intrinsic::riscv_vfwcvt_f_x_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_x_v_tumu:
  ID = Intrinsic::riscv_vfwcvt_f_x_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_x_v_mu:
  ID = Intrinsic::riscv_vfwcvt_f_x_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_xu_v_tu:
  ID = Intrinsic::riscv_vfwcvt_f_xu_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_xu_v:
  ID = Intrinsic::riscv_vfwcvt_f_xu_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_xu_v_tum:
  ID = Intrinsic::riscv_vfwcvt_f_xu_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_xu_v_m:
  ID = Intrinsic::riscv_vfwcvt_f_xu_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_xu_v_tumu:
  ID = Intrinsic::riscv_vfwcvt_f_xu_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_f_xu_v_mu:
  ID = Intrinsic::riscv_vfwcvt_f_xu_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_x_f_v_tu:
  ID = Intrinsic::riscv_vfwcvt_rtz_x_f_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_x_f_v:
  ID = Intrinsic::riscv_vfwcvt_rtz_x_f_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_x_f_v_tum:
  ID = Intrinsic::riscv_vfwcvt_rtz_x_f_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_x_f_v_m:
  ID = Intrinsic::riscv_vfwcvt_rtz_x_f_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_x_f_v_tumu:
  ID = Intrinsic::riscv_vfwcvt_rtz_x_f_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_x_f_v_mu:
  ID = Intrinsic::riscv_vfwcvt_rtz_x_f_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_xu_f_v_tu:
  ID = Intrinsic::riscv_vfwcvt_rtz_xu_f_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_xu_f_v:
  ID = Intrinsic::riscv_vfwcvt_rtz_xu_f_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_xu_f_v_tum:
  ID = Intrinsic::riscv_vfwcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_xu_f_v_m:
  ID = Intrinsic::riscv_vfwcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_xu_f_v_tumu:
  ID = Intrinsic::riscv_vfwcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_rtz_xu_f_v_mu:
  ID = Intrinsic::riscv_vfwcvt_rtz_xu_f_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_tu:
  ID = Intrinsic::riscv_vfwcvt_x_f_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_rm:
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v:
  ID = Intrinsic::riscv_vfwcvt_x_f_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_tum:
  ID = Intrinsic::riscv_vfwcvt_x_f_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_m:
  ID = Intrinsic::riscv_vfwcvt_x_f_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_tumu:
  ID = Intrinsic::riscv_vfwcvt_x_f_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwcvt_x_f_v_mu:
  ID = Intrinsic::riscv_vfwcvt_x_f_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_tu:
  ID = Intrinsic::riscv_vfwcvt_xu_f_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_rm:
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v:
  ID = Intrinsic::riscv_vfwcvt_xu_f_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_tum:
  ID = Intrinsic::riscv_vfwcvt_xu_f_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_rm_m:
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_m:
  ID = Intrinsic::riscv_vfwcvt_xu_f_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_tumu:
  ID = Intrinsic::riscv_vfwcvt_xu_f_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwcvt_xu_f_v_mu:
  ID = Intrinsic::riscv_vfwcvt_xu_f_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingConvBuiltin(this, E, ReturnValue, ResultType, ID,
                                      Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwcvtbf16_f_f_v_tu:
  ID = Intrinsic::riscv_vfwcvtbf16_f_f_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvtbf16_f_f_v:
  ID = Intrinsic::riscv_vfwcvtbf16_f_f_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvtbf16_f_f_v_tum:
  ID = Intrinsic::riscv_vfwcvtbf16_f_f_v_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvtbf16_f_f_v_m:
  ID = Intrinsic::riscv_vfwcvtbf16_f_f_v_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvtbf16_f_f_v_tumu:
  ID = Intrinsic::riscv_vfwcvtbf16_f_f_v_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwcvtbf16_f_f_v_mu:
  ID = Intrinsic::riscv_vfwcvtbf16_f_f_v_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_tu:
  ID = Intrinsic::riscv_vfwmacc;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwmacc_vv:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf:
  ID = Intrinsic::riscv_vfwmacc;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_tum:
  ID = Intrinsic::riscv_vfwmacc_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_m:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_m:
  ID = Intrinsic::riscv_vfwmacc_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_tumu:
  ID = Intrinsic::riscv_vfwmacc_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwmacc_vf_mu:
  ID = Intrinsic::riscv_vfwmacc_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_tu:
  ID = Intrinsic::riscv_vfwmaccbf16;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf:
  ID = Intrinsic::riscv_vfwmaccbf16;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_tum:
  ID = Intrinsic::riscv_vfwmaccbf16_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_m:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_m:
  ID = Intrinsic::riscv_vfwmaccbf16_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_tumu:
  ID = Intrinsic::riscv_vfwmaccbf16_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwmaccbf16_vf_mu:
  ID = Intrinsic::riscv_vfwmaccbf16_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_tu:
  ID = Intrinsic::riscv_vfwmsac;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwmsac_vv:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf:
  ID = Intrinsic::riscv_vfwmsac;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_tum:
  ID = Intrinsic::riscv_vfwmsac_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_m:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_m:
  ID = Intrinsic::riscv_vfwmsac_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_tumu:
  ID = Intrinsic::riscv_vfwmsac_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwmsac_vf_mu:
  ID = Intrinsic::riscv_vfwmsac_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmul_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwmul_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_tu:
  ID = Intrinsic::riscv_vfwmul;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVWideningFloatingPointBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmul_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwmul_vv:
case RISCVVector::BI__builtin_rvv_vfwmul_vf:
  ID = Intrinsic::riscv_vfwmul;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVWideningFloatingPointBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmul_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwmul_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_tum:
  ID = Intrinsic::riscv_vfwmul_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFloatingPointBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmul_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwmul_vv_m:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_m:
  ID = Intrinsic::riscv_vfwmul_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFloatingPointBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmul_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwmul_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_tumu:
  ID = Intrinsic::riscv_vfwmul_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFloatingPointBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwmul_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwmul_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwmul_vf_mu:
  ID = Intrinsic::riscv_vfwmul_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFloatingPointBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_tu:
  ID = Intrinsic::riscv_vfwnmacc;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf:
  ID = Intrinsic::riscv_vfwnmacc;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_tum:
  ID = Intrinsic::riscv_vfwnmacc_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_m:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_m:
  ID = Intrinsic::riscv_vfwnmacc_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_tumu:
  ID = Intrinsic::riscv_vfwnmacc_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwnmacc_vf_mu:
  ID = Intrinsic::riscv_vfwnmacc_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_tu:
  ID = Intrinsic::riscv_vfwnmsac;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf:
  ID = Intrinsic::riscv_vfwnmsac;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_tum:
  ID = Intrinsic::riscv_vfwnmsac_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_m:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_m:
  ID = Intrinsic::riscv_vfwnmsac_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_tumu:
  ID = Intrinsic::riscv_vfwnmsac_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwnmsac_vf_mu:
  ID = Intrinsic::riscv_vfwnmsac_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFMABuiltin(this, E, ReturnValue, ResultType, ID,
                                     Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredosum_vs_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwredosum_vs_tu:
  ID = Intrinsic::riscv_vfwredosum;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingReductionBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredosum_vs_rm:
case RISCVVector::BI__builtin_rvv_vfwredosum_vs:
  ID = Intrinsic::riscv_vfwredosum;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingReductionBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredosum_vs_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwredosum_vs_tum:
  ID = Intrinsic::riscv_vfwredosum_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingReductionBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredosum_vs_rm_m:
case RISCVVector::BI__builtin_rvv_vfwredosum_vs_m:
  ID = Intrinsic::riscv_vfwredosum_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingReductionBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredusum_vs_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwredusum_vs_tu:
  ID = Intrinsic::riscv_vfwredusum;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingReductionBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredusum_vs_rm:
case RISCVVector::BI__builtin_rvv_vfwredusum_vs:
  ID = Intrinsic::riscv_vfwredusum;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingReductionBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredusum_vs_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwredusum_vs_tum:
  ID = Intrinsic::riscv_vfwredusum_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingReductionBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwredusum_vs_rm_m:
case RISCVVector::BI__builtin_rvv_vfwredusum_vs_m:
  ID = Intrinsic::riscv_vfwredusum_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingReductionBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_vv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwsub_vv_tu:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_tu:
  ID = Intrinsic::riscv_vfwsub;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVWideningFloatingPointBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_vv_rm:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_rm:
case RISCVVector::BI__builtin_rvv_vfwsub_vv:
case RISCVVector::BI__builtin_rvv_vfwsub_vf:
  ID = Intrinsic::riscv_vfwsub;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVWideningFloatingPointBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_vv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwsub_vv_tum:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_tum:
  ID = Intrinsic::riscv_vfwsub_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFloatingPointBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_vv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwsub_vv_m:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_m:
  ID = Intrinsic::riscv_vfwsub_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFloatingPointBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_vv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwsub_vv_tumu:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_tumu:
  ID = Intrinsic::riscv_vfwsub_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFloatingPointBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_vv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwsub_vv_mu:
case RISCVVector::BI__builtin_rvv_vfwsub_vf_mu:
  ID = Intrinsic::riscv_vfwsub_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVWideningFloatingPointBuiltin(
        this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
        SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_wv_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_rm_tu:
case RISCVVector::BI__builtin_rvv_vfwsub_wv_tu:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_tu:
  ID = Intrinsic::riscv_vfwsub_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_wv_rm:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_rm:
case RISCVVector::BI__builtin_rvv_vfwsub_wv:
case RISCVVector::BI__builtin_rvv_vfwsub_wf:
  ID = Intrinsic::riscv_vfwsub_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_wv_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_rm_tum:
case RISCVVector::BI__builtin_rvv_vfwsub_wv_tum:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_tum:
  ID = Intrinsic::riscv_vfwsub_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_wv_rm_m:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_rm_m:
case RISCVVector::BI__builtin_rvv_vfwsub_wv_m:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_m:
  ID = Intrinsic::riscv_vfwsub_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_wv_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_rm_tumu:
case RISCVVector::BI__builtin_rvv_vfwsub_wv_tumu:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_tumu:
  ID = Intrinsic::riscv_vfwsub_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vfwsub_wv_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_rm_mu:
case RISCVVector::BI__builtin_rvv_vfwsub_wv_mu:
case RISCVVector::BI__builtin_rvv_vfwsub_wf_mu:
  ID = Intrinsic::riscv_vfwsub_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVFloatingPointBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vghsh_vv_tu:
  ID = Intrinsic::riscv_vghsh;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vghsh_vv:
  ID = Intrinsic::riscv_vghsh;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vgmul_vv_tu:
  ID = Intrinsic::riscv_vgmul_vv;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vgmul_vv:
  ID = Intrinsic::riscv_vgmul_vv;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vid_v_tu:
  ID = Intrinsic::riscv_vid;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vid_v:
  ID = Intrinsic::riscv_vid;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vid_v_tum:
  ID = Intrinsic::riscv_vid_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vid_v_m:
  ID = Intrinsic::riscv_vid_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vid_v_tumu:
  ID = Intrinsic::riscv_vid_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vid_v_mu:
  ID = Intrinsic::riscv_vid_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_viota_m_tu:
  ID = Intrinsic::riscv_viota;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_viota_m:
  ID = Intrinsic::riscv_viota;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_viota_m_tum:
  ID = Intrinsic::riscv_viota_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_viota_m_m:
  ID = Intrinsic::riscv_viota_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_viota_m_tumu:
  ID = Intrinsic::riscv_viota_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_viota_m_mu:
  ID = Intrinsic::riscv_viota_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vle8_v_tu:
case RISCVVector::BI__builtin_rvv_vle16_v_tu:
case RISCVVector::BI__builtin_rvv_vle32_v_tu:
case RISCVVector::BI__builtin_rvv_vle64_v_tu:
  ID = Intrinsic::riscv_vle;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vle8_v:
case RISCVVector::BI__builtin_rvv_vle16_v:
case RISCVVector::BI__builtin_rvv_vle32_v:
case RISCVVector::BI__builtin_rvv_vle64_v:
  ID = Intrinsic::riscv_vle;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vle8_v_tum:
case RISCVVector::BI__builtin_rvv_vle16_v_tum:
case RISCVVector::BI__builtin_rvv_vle32_v_tum:
case RISCVVector::BI__builtin_rvv_vle64_v_tum:
  ID = Intrinsic::riscv_vle_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vle8_v_m:
case RISCVVector::BI__builtin_rvv_vle16_v_m:
case RISCVVector::BI__builtin_rvv_vle32_v_m:
case RISCVVector::BI__builtin_rvv_vle64_v_m:
  ID = Intrinsic::riscv_vle_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vle8_v_tumu:
case RISCVVector::BI__builtin_rvv_vle16_v_tumu:
case RISCVVector::BI__builtin_rvv_vle32_v_tumu:
case RISCVVector::BI__builtin_rvv_vle64_v_tumu:
  ID = Intrinsic::riscv_vle_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vle8_v_mu:
case RISCVVector::BI__builtin_rvv_vle16_v_mu:
case RISCVVector::BI__builtin_rvv_vle32_v_mu:
case RISCVVector::BI__builtin_rvv_vle64_v_mu:
  ID = Intrinsic::riscv_vle_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vle8ff_v_tu:
case RISCVVector::BI__builtin_rvv_vle16ff_v_tu:
case RISCVVector::BI__builtin_rvv_vle32ff_v_tu:
case RISCVVector::BI__builtin_rvv_vle64ff_v_tu:
  ID = Intrinsic::riscv_vleff;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVVLEFFBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vle8ff_v:
case RISCVVector::BI__builtin_rvv_vle16ff_v:
case RISCVVector::BI__builtin_rvv_vle32ff_v:
case RISCVVector::BI__builtin_rvv_vle64ff_v:
  ID = Intrinsic::riscv_vleff;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVVLEFFBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vle8ff_v_tum:
case RISCVVector::BI__builtin_rvv_vle16ff_v_tum:
case RISCVVector::BI__builtin_rvv_vle32ff_v_tum:
case RISCVVector::BI__builtin_rvv_vle64ff_v_tum:
  ID = Intrinsic::riscv_vleff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVVLEFFBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vle8ff_v_m:
case RISCVVector::BI__builtin_rvv_vle16ff_v_m:
case RISCVVector::BI__builtin_rvv_vle32ff_v_m:
case RISCVVector::BI__builtin_rvv_vle64ff_v_m:
  ID = Intrinsic::riscv_vleff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVVLEFFBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vle8ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vle16ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vle32ff_v_tumu:
case RISCVVector::BI__builtin_rvv_vle64ff_v_tumu:
  ID = Intrinsic::riscv_vleff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVVLEFFBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vle8ff_v_mu:
case RISCVVector::BI__builtin_rvv_vle16ff_v_mu:
case RISCVVector::BI__builtin_rvv_vle32ff_v_mu:
case RISCVVector::BI__builtin_rvv_vle64ff_v_mu:
  ID = Intrinsic::riscv_vleff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVVLEFFBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vlm_v:
  ID = Intrinsic::riscv_vlm;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[0]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vloxei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxei64_v_tu:
  ID = Intrinsic::riscv_vloxei;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vloxei8_v:
case RISCVVector::BI__builtin_rvv_vloxei16_v:
case RISCVVector::BI__builtin_rvv_vloxei32_v:
case RISCVVector::BI__builtin_rvv_vloxei64_v:
  ID = Intrinsic::riscv_vloxei;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vloxei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxei64_v_tum:
  ID = Intrinsic::riscv_vloxei_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vloxei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxei64_v_m:
  ID = Intrinsic::riscv_vloxei_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vloxei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxei64_v_tumu:
  ID = Intrinsic::riscv_vloxei_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vloxei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxei64_v_mu:
  ID = Intrinsic::riscv_vloxei_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vloxseg2ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei64_v_tu:
  ID = Intrinsic::riscv_vloxseg2;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg2ei8_v:
case RISCVVector::BI__builtin_rvv_vloxseg2ei16_v:
case RISCVVector::BI__builtin_rvv_vloxseg2ei32_v:
case RISCVVector::BI__builtin_rvv_vloxseg2ei64_v:
  ID = Intrinsic::riscv_vloxseg2;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg2ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg2ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg2ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg2ei64_v_tum:
  ID = Intrinsic::riscv_vloxseg2_mask;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg2ei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg2ei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg2ei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg2ei64_v_m:
  ID = Intrinsic::riscv_vloxseg2_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg2ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei64_v_tumu:
  ID = Intrinsic::riscv_vloxseg2_mask;
  PolicyAttrs = 0;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg2ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg2ei64_v_mu:
  ID = Intrinsic::riscv_vloxseg2_mask;
  PolicyAttrs = 1;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg3ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei64_v_tu:
  ID = Intrinsic::riscv_vloxseg3;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg3ei8_v:
case RISCVVector::BI__builtin_rvv_vloxseg3ei16_v:
case RISCVVector::BI__builtin_rvv_vloxseg3ei32_v:
case RISCVVector::BI__builtin_rvv_vloxseg3ei64_v:
  ID = Intrinsic::riscv_vloxseg3;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg3ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg3ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg3ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg3ei64_v_tum:
  ID = Intrinsic::riscv_vloxseg3_mask;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg3ei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg3ei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg3ei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg3ei64_v_m:
  ID = Intrinsic::riscv_vloxseg3_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg3ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei64_v_tumu:
  ID = Intrinsic::riscv_vloxseg3_mask;
  PolicyAttrs = 0;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg3ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg3ei64_v_mu:
  ID = Intrinsic::riscv_vloxseg3_mask;
  PolicyAttrs = 1;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg4ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei64_v_tu:
  ID = Intrinsic::riscv_vloxseg4;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg4ei8_v:
case RISCVVector::BI__builtin_rvv_vloxseg4ei16_v:
case RISCVVector::BI__builtin_rvv_vloxseg4ei32_v:
case RISCVVector::BI__builtin_rvv_vloxseg4ei64_v:
  ID = Intrinsic::riscv_vloxseg4;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg4ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg4ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg4ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg4ei64_v_tum:
  ID = Intrinsic::riscv_vloxseg4_mask;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg4ei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg4ei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg4ei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg4ei64_v_m:
  ID = Intrinsic::riscv_vloxseg4_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg4ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei64_v_tumu:
  ID = Intrinsic::riscv_vloxseg4_mask;
  PolicyAttrs = 0;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg4ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg4ei64_v_mu:
  ID = Intrinsic::riscv_vloxseg4_mask;
  PolicyAttrs = 1;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg5ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei64_v_tu:
  ID = Intrinsic::riscv_vloxseg5;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg5ei8_v:
case RISCVVector::BI__builtin_rvv_vloxseg5ei16_v:
case RISCVVector::BI__builtin_rvv_vloxseg5ei32_v:
case RISCVVector::BI__builtin_rvv_vloxseg5ei64_v:
  ID = Intrinsic::riscv_vloxseg5;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg5ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg5ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg5ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg5ei64_v_tum:
  ID = Intrinsic::riscv_vloxseg5_mask;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg5ei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg5ei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg5ei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg5ei64_v_m:
  ID = Intrinsic::riscv_vloxseg5_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg5ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei64_v_tumu:
  ID = Intrinsic::riscv_vloxseg5_mask;
  PolicyAttrs = 0;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg5ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg5ei64_v_mu:
  ID = Intrinsic::riscv_vloxseg5_mask;
  PolicyAttrs = 1;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg6ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei64_v_tu:
  ID = Intrinsic::riscv_vloxseg6;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg6ei8_v:
case RISCVVector::BI__builtin_rvv_vloxseg6ei16_v:
case RISCVVector::BI__builtin_rvv_vloxseg6ei32_v:
case RISCVVector::BI__builtin_rvv_vloxseg6ei64_v:
  ID = Intrinsic::riscv_vloxseg6;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg6ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg6ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg6ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg6ei64_v_tum:
  ID = Intrinsic::riscv_vloxseg6_mask;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg6ei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg6ei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg6ei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg6ei64_v_m:
  ID = Intrinsic::riscv_vloxseg6_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg6ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei64_v_tumu:
  ID = Intrinsic::riscv_vloxseg6_mask;
  PolicyAttrs = 0;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg6ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg6ei64_v_mu:
  ID = Intrinsic::riscv_vloxseg6_mask;
  PolicyAttrs = 1;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg7ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei64_v_tu:
  ID = Intrinsic::riscv_vloxseg7;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg7ei8_v:
case RISCVVector::BI__builtin_rvv_vloxseg7ei16_v:
case RISCVVector::BI__builtin_rvv_vloxseg7ei32_v:
case RISCVVector::BI__builtin_rvv_vloxseg7ei64_v:
  ID = Intrinsic::riscv_vloxseg7;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg7ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg7ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg7ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg7ei64_v_tum:
  ID = Intrinsic::riscv_vloxseg7_mask;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg7ei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg7ei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg7ei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg7ei64_v_m:
  ID = Intrinsic::riscv_vloxseg7_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg7ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei64_v_tumu:
  ID = Intrinsic::riscv_vloxseg7_mask;
  PolicyAttrs = 0;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg7ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg7ei64_v_mu:
  ID = Intrinsic::riscv_vloxseg7_mask;
  PolicyAttrs = 1;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg8ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei64_v_tu:
  ID = Intrinsic::riscv_vloxseg8;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg8ei8_v:
case RISCVVector::BI__builtin_rvv_vloxseg8ei16_v:
case RISCVVector::BI__builtin_rvv_vloxseg8ei32_v:
case RISCVVector::BI__builtin_rvv_vloxseg8ei64_v:
  ID = Intrinsic::riscv_vloxseg8;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg8ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg8ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg8ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vloxseg8ei64_v_tum:
  ID = Intrinsic::riscv_vloxseg8_mask;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg8ei8_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg8ei16_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg8ei32_v_m:
case RISCVVector::BI__builtin_rvv_vloxseg8ei64_v_m:
  ID = Intrinsic::riscv_vloxseg8_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg8ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei64_v_tumu:
  ID = Intrinsic::riscv_vloxseg8_mask;
  PolicyAttrs = 0;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vloxseg8ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vloxseg8ei64_v_mu:
  ID = Intrinsic::riscv_vloxseg8_mask;
  PolicyAttrs = 1;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlse8_v_tu:
case RISCVVector::BI__builtin_rvv_vlse16_v_tu:
case RISCVVector::BI__builtin_rvv_vlse32_v_tu:
case RISCVVector::BI__builtin_rvv_vlse64_v_tu:
  ID = Intrinsic::riscv_vlse;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vlse8_v:
case RISCVVector::BI__builtin_rvv_vlse16_v:
case RISCVVector::BI__builtin_rvv_vlse32_v:
case RISCVVector::BI__builtin_rvv_vlse64_v:
  ID = Intrinsic::riscv_vlse;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vlse8_v_tum:
case RISCVVector::BI__builtin_rvv_vlse16_v_tum:
case RISCVVector::BI__builtin_rvv_vlse32_v_tum:
case RISCVVector::BI__builtin_rvv_vlse64_v_tum:
  ID = Intrinsic::riscv_vlse_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vlse8_v_m:
case RISCVVector::BI__builtin_rvv_vlse16_v_m:
case RISCVVector::BI__builtin_rvv_vlse32_v_m:
case RISCVVector::BI__builtin_rvv_vlse64_v_m:
  ID = Intrinsic::riscv_vlse_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vlse8_v_tumu:
case RISCVVector::BI__builtin_rvv_vlse16_v_tumu:
case RISCVVector::BI__builtin_rvv_vlse32_v_tumu:
case RISCVVector::BI__builtin_rvv_vlse64_v_tumu:
  ID = Intrinsic::riscv_vlse_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vlse8_v_mu:
case RISCVVector::BI__builtin_rvv_vlse16_v_mu:
case RISCVVector::BI__builtin_rvv_vlse32_v_mu:
case RISCVVector::BI__builtin_rvv_vlse64_v_mu:
  ID = Intrinsic::riscv_vlse_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vlseg2e8_v_tu:
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e16_v_tu:
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e32_v_tu:
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e64_v_tu:
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e8_v:
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e16_v:
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e32_v:
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e64_v:
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e8_v_tum:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e16_v_tum:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e32_v_tum:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e64_v_tum:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e8_v_m:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e16_v_m:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e32_v_m:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e64_v_m:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e8_v_tumu:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e16_v_tumu:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e32_v_tumu:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e64_v_tumu:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e8_v_mu:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e16_v_mu:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e32_v_mu:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e64_v_mu:
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg2e8ff_v_tu:
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e16ff_v_tu:
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e32ff_v_tu:
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e64ff_v_tu:
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8ff_v:
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e16ff_v:
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e32ff_v:
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e64ff_v:
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8ff_v_tum:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e16ff_v_tum:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e32ff_v_tum:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e64ff_v_tum:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8ff_v_m:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e16ff_v_m:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e32ff_v_m:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e64ff_v_m:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8ff_v_tumu:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e16ff_v_tumu:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e32ff_v_tumu:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e64ff_v_tumu:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e8ff_v_mu:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e16ff_v_mu:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e32ff_v_mu:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg2e64ff_v_mu:
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg2ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8_v_tu:
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e16_v_tu:
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e32_v_tu:
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e64_v_tu:
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e8_v:
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e16_v:
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e32_v:
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e64_v:
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e8_v_tum:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e16_v_tum:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e32_v_tum:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e64_v_tum:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e8_v_m:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e16_v_m:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e32_v_m:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e64_v_m:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e8_v_tumu:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e16_v_tumu:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e32_v_tumu:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e64_v_tumu:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e8_v_mu:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e16_v_mu:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e32_v_mu:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e64_v_mu:
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg3e8ff_v_tu:
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e16ff_v_tu:
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e32ff_v_tu:
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e64ff_v_tu:
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8ff_v:
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e16ff_v:
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e32ff_v:
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e64ff_v:
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8ff_v_tum:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e16ff_v_tum:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e32ff_v_tum:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e64ff_v_tum:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8ff_v_m:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e16ff_v_m:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e32ff_v_m:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e64ff_v_m:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8ff_v_tumu:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e16ff_v_tumu:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e32ff_v_tumu:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e64ff_v_tumu:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e8ff_v_mu:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e16ff_v_mu:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e32ff_v_mu:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg3e64ff_v_mu:
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg3ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e8_v_tu:
  ID = Intrinsic::riscv_vlseg4;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e16_v_tu:
  ID = Intrinsic::riscv_vlseg4;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e32_v_tu:
  ID = Intrinsic::riscv_vlseg4;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e64_v_tu:
  ID = Intrinsic::riscv_vlseg4;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e8_v:
  ID = Intrinsic::riscv_vlseg4;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e16_v:
  ID = Intrinsic::riscv_vlseg4;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e32_v:
  ID = Intrinsic::riscv_vlseg4;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e64_v:
  ID = Intrinsic::riscv_vlseg4;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e8_v_tum:
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e16_v_tum:
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e32_v_tum:
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e64_v_tum:
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e8_v_m:
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e16_v_m:
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e32_v_m:
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e64_v_m:
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e8_v_tumu:
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e16_v_tumu:
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e32_v_tumu:
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e64_v_tumu:
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e8_v_mu:
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e16_v_mu:
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e32_v_mu:
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e64_v_mu:
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg4_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg4e8ff_v_tu:
  ID = Intrinsic::riscv_vlseg4ff;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e16ff_v_tu:
  ID = Intrinsic::riscv_vlseg4ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e32ff_v_tu:
  ID = Intrinsic::riscv_vlseg4ff;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e64ff_v_tu:
  ID = Intrinsic::riscv_vlseg4ff;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e8ff_v:
  ID = Intrinsic::riscv_vlseg4ff;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e16ff_v:
  ID = Intrinsic::riscv_vlseg4ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e32ff_v:
  ID = Intrinsic::riscv_vlseg4ff;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e64ff_v:
  ID = Intrinsic::riscv_vlseg4ff;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e8ff_v_tum:
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e16ff_v_tum:
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e32ff_v_tum:
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e64ff_v_tum:
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e8ff_v_m:
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e16ff_v_m:
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e32ff_v_m:
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e64ff_v_m:
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e8ff_v_tumu:
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e16ff_v_tumu:
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e32ff_v_tumu:
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e64ff_v_tumu:
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e8ff_v_mu:
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e16ff_v_mu:
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e32ff_v_mu:
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg4e64ff_v_mu:
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg4ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e8_v_tu:
  ID = Intrinsic::riscv_vlseg5;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e16_v_tu:
  ID = Intrinsic::riscv_vlseg5;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e32_v_tu:
  ID = Intrinsic::riscv_vlseg5;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e64_v_tu:
  ID = Intrinsic::riscv_vlseg5;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e8_v:
  ID = Intrinsic::riscv_vlseg5;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e16_v:
  ID = Intrinsic::riscv_vlseg5;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e32_v:
  ID = Intrinsic::riscv_vlseg5;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e64_v:
  ID = Intrinsic::riscv_vlseg5;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e8_v_tum:
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e16_v_tum:
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e32_v_tum:
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e64_v_tum:
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e8_v_m:
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e16_v_m:
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e32_v_m:
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e64_v_m:
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e8_v_tumu:
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e16_v_tumu:
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e32_v_tumu:
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e64_v_tumu:
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e8_v_mu:
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e16_v_mu:
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e32_v_mu:
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e64_v_mu:
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg5_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg5e8ff_v_tu:
  ID = Intrinsic::riscv_vlseg5ff;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e16ff_v_tu:
  ID = Intrinsic::riscv_vlseg5ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e32ff_v_tu:
  ID = Intrinsic::riscv_vlseg5ff;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e64ff_v_tu:
  ID = Intrinsic::riscv_vlseg5ff;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e8ff_v:
  ID = Intrinsic::riscv_vlseg5ff;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e16ff_v:
  ID = Intrinsic::riscv_vlseg5ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e32ff_v:
  ID = Intrinsic::riscv_vlseg5ff;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e64ff_v:
  ID = Intrinsic::riscv_vlseg5ff;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e8ff_v_tum:
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e16ff_v_tum:
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e32ff_v_tum:
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e64ff_v_tum:
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e8ff_v_m:
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e16ff_v_m:
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e32ff_v_m:
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e64ff_v_m:
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e8ff_v_tumu:
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e16ff_v_tumu:
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e32ff_v_tumu:
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e64ff_v_tumu:
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e8ff_v_mu:
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e16ff_v_mu:
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e32ff_v_mu:
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg5e64ff_v_mu:
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg5ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e8_v_tu:
  ID = Intrinsic::riscv_vlseg6;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e16_v_tu:
  ID = Intrinsic::riscv_vlseg6;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e32_v_tu:
  ID = Intrinsic::riscv_vlseg6;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e64_v_tu:
  ID = Intrinsic::riscv_vlseg6;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e8_v:
  ID = Intrinsic::riscv_vlseg6;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e16_v:
  ID = Intrinsic::riscv_vlseg6;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e32_v:
  ID = Intrinsic::riscv_vlseg6;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e64_v:
  ID = Intrinsic::riscv_vlseg6;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e8_v_tum:
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e16_v_tum:
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e32_v_tum:
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e64_v_tum:
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e8_v_m:
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e16_v_m:
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e32_v_m:
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e64_v_m:
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e8_v_tumu:
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e16_v_tumu:
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e32_v_tumu:
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e64_v_tumu:
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e8_v_mu:
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e16_v_mu:
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e32_v_mu:
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e64_v_mu:
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg6_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg6e8ff_v_tu:
  ID = Intrinsic::riscv_vlseg6ff;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e16ff_v_tu:
  ID = Intrinsic::riscv_vlseg6ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e32ff_v_tu:
  ID = Intrinsic::riscv_vlseg6ff;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e64ff_v_tu:
  ID = Intrinsic::riscv_vlseg6ff;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e8ff_v:
  ID = Intrinsic::riscv_vlseg6ff;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e16ff_v:
  ID = Intrinsic::riscv_vlseg6ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e32ff_v:
  ID = Intrinsic::riscv_vlseg6ff;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e64ff_v:
  ID = Intrinsic::riscv_vlseg6ff;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e8ff_v_tum:
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e16ff_v_tum:
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e32ff_v_tum:
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e64ff_v_tum:
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e8ff_v_m:
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e16ff_v_m:
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e32ff_v_m:
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e64ff_v_m:
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e8ff_v_tumu:
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e16ff_v_tumu:
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e32ff_v_tumu:
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e64ff_v_tumu:
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e8ff_v_mu:
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e16ff_v_mu:
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e32ff_v_mu:
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg6e64ff_v_mu:
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg6ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e8_v_tu:
  ID = Intrinsic::riscv_vlseg7;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e16_v_tu:
  ID = Intrinsic::riscv_vlseg7;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e32_v_tu:
  ID = Intrinsic::riscv_vlseg7;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e64_v_tu:
  ID = Intrinsic::riscv_vlseg7;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e8_v:
  ID = Intrinsic::riscv_vlseg7;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e16_v:
  ID = Intrinsic::riscv_vlseg7;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e32_v:
  ID = Intrinsic::riscv_vlseg7;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e64_v:
  ID = Intrinsic::riscv_vlseg7;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e8_v_tum:
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e16_v_tum:
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e32_v_tum:
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e64_v_tum:
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e8_v_m:
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e16_v_m:
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e32_v_m:
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e64_v_m:
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e8_v_tumu:
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e16_v_tumu:
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e32_v_tumu:
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e64_v_tumu:
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e8_v_mu:
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e16_v_mu:
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e32_v_mu:
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e64_v_mu:
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg7_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg7e8ff_v_tu:
  ID = Intrinsic::riscv_vlseg7ff;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e16ff_v_tu:
  ID = Intrinsic::riscv_vlseg7ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e32ff_v_tu:
  ID = Intrinsic::riscv_vlseg7ff;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e64ff_v_tu:
  ID = Intrinsic::riscv_vlseg7ff;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e8ff_v:
  ID = Intrinsic::riscv_vlseg7ff;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e16ff_v:
  ID = Intrinsic::riscv_vlseg7ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e32ff_v:
  ID = Intrinsic::riscv_vlseg7ff;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e64ff_v:
  ID = Intrinsic::riscv_vlseg7ff;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e8ff_v_tum:
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e16ff_v_tum:
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e32ff_v_tum:
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e64ff_v_tum:
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e8ff_v_m:
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e16ff_v_m:
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e32ff_v_m:
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e64ff_v_m:
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e8ff_v_tumu:
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e16ff_v_tumu:
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e32ff_v_tumu:
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e64ff_v_tumu:
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e8ff_v_mu:
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e16ff_v_mu:
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e32ff_v_mu:
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg7e64ff_v_mu:
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg7ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e8_v_tu:
  ID = Intrinsic::riscv_vlseg8;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e16_v_tu:
  ID = Intrinsic::riscv_vlseg8;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e32_v_tu:
  ID = Intrinsic::riscv_vlseg8;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e64_v_tu:
  ID = Intrinsic::riscv_vlseg8;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e8_v:
  ID = Intrinsic::riscv_vlseg8;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e16_v:
  ID = Intrinsic::riscv_vlseg8;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e32_v:
  ID = Intrinsic::riscv_vlseg8;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e64_v:
  ID = Intrinsic::riscv_vlseg8;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e8_v_tum:
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e16_v_tum:
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e32_v_tum:
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e64_v_tum:
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e8_v_m:
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e16_v_m:
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e32_v_m:
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e64_v_m:
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e8_v_tumu:
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e16_v_tumu:
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e32_v_tumu:
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e64_v_tumu:
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e8_v_mu:
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e16_v_mu:
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e32_v_mu:
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e64_v_mu:
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
  ID = Intrinsic::riscv_vlseg8_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

              return emitRVVUnitStridedSegLoadTupleBuiltin(
                  this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                  IsMasked, SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vlseg8e8ff_v_tu:
  ID = Intrinsic::riscv_vlseg8ff;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e16ff_v_tu:
  ID = Intrinsic::riscv_vlseg8ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e32ff_v_tu:
  ID = Intrinsic::riscv_vlseg8ff;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e64ff_v_tu:
  ID = Intrinsic::riscv_vlseg8ff;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e8ff_v:
  ID = Intrinsic::riscv_vlseg8ff;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e16ff_v:
  ID = Intrinsic::riscv_vlseg8ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e32ff_v:
  ID = Intrinsic::riscv_vlseg8ff;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e64ff_v:
  ID = Intrinsic::riscv_vlseg8ff;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e8ff_v_tum:
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e16ff_v_tum:
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e32ff_v_tum:
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e64ff_v_tum:
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e8ff_v_m:
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e16ff_v_m:
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e32ff_v_m:
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e64ff_v_m:
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e8ff_v_tumu:
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e16ff_v_tumu:
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e32ff_v_tumu:
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e64ff_v_tumu:
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e8ff_v_mu:
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e16ff_v_mu:
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e32ff_v_mu:
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlseg8e64ff_v_mu:
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlseg8ff_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVUnitStridedSegLoadFFTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e8_v_tu:
  ID = Intrinsic::riscv_vlsseg2;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e16_v_tu:
  ID = Intrinsic::riscv_vlsseg2;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e32_v_tu:
  ID = Intrinsic::riscv_vlsseg2;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e64_v_tu:
  ID = Intrinsic::riscv_vlsseg2;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e8_v:
  ID = Intrinsic::riscv_vlsseg2;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e16_v:
  ID = Intrinsic::riscv_vlsseg2;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e32_v:
  ID = Intrinsic::riscv_vlsseg2;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e64_v:
  ID = Intrinsic::riscv_vlsseg2;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e8_v_tum:
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e16_v_tum:
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e32_v_tum:
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e64_v_tum:
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e8_v_m:
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e16_v_m:
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e32_v_m:
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e64_v_m:
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e8_v_tumu:
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e16_v_tumu:
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e32_v_tumu:
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e64_v_tumu:
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e8_v_mu:
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e16_v_mu:
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e32_v_mu:
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg2e64_v_mu:
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg2_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e8_v_tu:
  ID = Intrinsic::riscv_vlsseg3;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e16_v_tu:
  ID = Intrinsic::riscv_vlsseg3;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e32_v_tu:
  ID = Intrinsic::riscv_vlsseg3;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e64_v_tu:
  ID = Intrinsic::riscv_vlsseg3;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e8_v:
  ID = Intrinsic::riscv_vlsseg3;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e16_v:
  ID = Intrinsic::riscv_vlsseg3;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e32_v:
  ID = Intrinsic::riscv_vlsseg3;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e64_v:
  ID = Intrinsic::riscv_vlsseg3;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e8_v_tum:
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e16_v_tum:
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e32_v_tum:
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e64_v_tum:
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e8_v_m:
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e16_v_m:
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e32_v_m:
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e64_v_m:
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e8_v_tumu:
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e16_v_tumu:
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e32_v_tumu:
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e64_v_tumu:
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e8_v_mu:
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e16_v_mu:
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e32_v_mu:
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg3e64_v_mu:
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg3_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e8_v_tu:
  ID = Intrinsic::riscv_vlsseg4;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e16_v_tu:
  ID = Intrinsic::riscv_vlsseg4;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e32_v_tu:
  ID = Intrinsic::riscv_vlsseg4;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e64_v_tu:
  ID = Intrinsic::riscv_vlsseg4;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e8_v:
  ID = Intrinsic::riscv_vlsseg4;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e16_v:
  ID = Intrinsic::riscv_vlsseg4;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e32_v:
  ID = Intrinsic::riscv_vlsseg4;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e64_v:
  ID = Intrinsic::riscv_vlsseg4;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e8_v_tum:
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e16_v_tum:
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e32_v_tum:
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e64_v_tum:
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e8_v_m:
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e16_v_m:
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e32_v_m:
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e64_v_m:
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e8_v_tumu:
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e16_v_tumu:
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e32_v_tumu:
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e64_v_tumu:
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e8_v_mu:
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e16_v_mu:
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e32_v_mu:
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg4e64_v_mu:
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg4_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e8_v_tu:
  ID = Intrinsic::riscv_vlsseg5;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e16_v_tu:
  ID = Intrinsic::riscv_vlsseg5;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e32_v_tu:
  ID = Intrinsic::riscv_vlsseg5;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e64_v_tu:
  ID = Intrinsic::riscv_vlsseg5;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e8_v:
  ID = Intrinsic::riscv_vlsseg5;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e16_v:
  ID = Intrinsic::riscv_vlsseg5;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e32_v:
  ID = Intrinsic::riscv_vlsseg5;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e64_v:
  ID = Intrinsic::riscv_vlsseg5;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e8_v_tum:
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e16_v_tum:
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e32_v_tum:
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e64_v_tum:
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e8_v_m:
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e16_v_m:
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e32_v_m:
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e64_v_m:
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e8_v_tumu:
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e16_v_tumu:
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e32_v_tumu:
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e64_v_tumu:
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e8_v_mu:
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e16_v_mu:
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e32_v_mu:
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg5e64_v_mu:
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg5_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e8_v_tu:
  ID = Intrinsic::riscv_vlsseg6;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e16_v_tu:
  ID = Intrinsic::riscv_vlsseg6;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e32_v_tu:
  ID = Intrinsic::riscv_vlsseg6;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e64_v_tu:
  ID = Intrinsic::riscv_vlsseg6;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e8_v:
  ID = Intrinsic::riscv_vlsseg6;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e16_v:
  ID = Intrinsic::riscv_vlsseg6;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e32_v:
  ID = Intrinsic::riscv_vlsseg6;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e64_v:
  ID = Intrinsic::riscv_vlsseg6;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e8_v_tum:
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e16_v_tum:
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e32_v_tum:
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e64_v_tum:
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e8_v_m:
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e16_v_m:
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e32_v_m:
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e64_v_m:
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e8_v_tumu:
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e16_v_tumu:
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e32_v_tumu:
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e64_v_tumu:
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e8_v_mu:
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e16_v_mu:
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e32_v_mu:
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg6e64_v_mu:
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg6_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e8_v_tu:
  ID = Intrinsic::riscv_vlsseg7;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e16_v_tu:
  ID = Intrinsic::riscv_vlsseg7;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e32_v_tu:
  ID = Intrinsic::riscv_vlsseg7;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e64_v_tu:
  ID = Intrinsic::riscv_vlsseg7;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e8_v:
  ID = Intrinsic::riscv_vlsseg7;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e16_v:
  ID = Intrinsic::riscv_vlsseg7;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e32_v:
  ID = Intrinsic::riscv_vlsseg7;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e64_v:
  ID = Intrinsic::riscv_vlsseg7;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e8_v_tum:
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e16_v_tum:
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e32_v_tum:
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e64_v_tum:
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e8_v_m:
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e16_v_m:
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e32_v_m:
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e64_v_m:
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e8_v_tumu:
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e16_v_tumu:
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e32_v_tumu:
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e64_v_tumu:
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e8_v_mu:
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e16_v_mu:
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e32_v_mu:
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg7e64_v_mu:
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg7_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e8_v_tu:
  ID = Intrinsic::riscv_vlsseg8;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e16_v_tu:
  ID = Intrinsic::riscv_vlsseg8;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e32_v_tu:
  ID = Intrinsic::riscv_vlsseg8;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e64_v_tu:
  ID = Intrinsic::riscv_vlsseg8;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e8_v:
  ID = Intrinsic::riscv_vlsseg8;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e16_v:
  ID = Intrinsic::riscv_vlsseg8;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e32_v:
  ID = Intrinsic::riscv_vlsseg8;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e64_v:
  ID = Intrinsic::riscv_vlsseg8;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e8_v_tum:
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 2;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e16_v_tum:
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e32_v_tum:
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e64_v_tum:
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 2;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 2;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 2;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e8_v_m:
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e16_v_m:
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e32_v_m:
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e64_v_m:
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e8_v_tumu:
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 0;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e16_v_tumu:
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e32_v_tumu:
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e64_v_tumu:
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 0;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 0;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 0;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e8_v_mu:
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 1;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e16_v_mu:
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e32_v_mu:
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vlsseg8e64_v_mu:
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 1;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 1;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
  ID = Intrinsic::riscv_vlsseg8_mask;
  PolicyAttrs = 1;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxei8_v_tu:
case RISCVVector::BI__builtin_rvv_vluxei64_v_tu:
case RISCVVector::BI__builtin_rvv_vluxei16_v_tu:
case RISCVVector::BI__builtin_rvv_vluxei32_v_tu:
  ID = Intrinsic::riscv_vluxei;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vluxei8_v:
case RISCVVector::BI__builtin_rvv_vluxei64_v:
case RISCVVector::BI__builtin_rvv_vluxei16_v:
case RISCVVector::BI__builtin_rvv_vluxei32_v:
  ID = Intrinsic::riscv_vluxei;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vluxei8_v_tum:
case RISCVVector::BI__builtin_rvv_vluxei64_v_tum:
case RISCVVector::BI__builtin_rvv_vluxei16_v_tum:
case RISCVVector::BI__builtin_rvv_vluxei32_v_tum:
  ID = Intrinsic::riscv_vluxei_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vluxei8_v_m:
case RISCVVector::BI__builtin_rvv_vluxei64_v_m:
case RISCVVector::BI__builtin_rvv_vluxei16_v_m:
case RISCVVector::BI__builtin_rvv_vluxei32_v_m:
  ID = Intrinsic::riscv_vluxei_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vluxei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxei64_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxei32_v_tumu:
  ID = Intrinsic::riscv_vluxei_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vluxei8_v_mu:
case RISCVVector::BI__builtin_rvv_vluxei64_v_mu:
case RISCVVector::BI__builtin_rvv_vluxei16_v_mu:
case RISCVVector::BI__builtin_rvv_vluxei32_v_mu:
  ID = Intrinsic::riscv_vluxei_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vluxseg2ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg2ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg2ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg2ei64_v_tu:
  ID = Intrinsic::riscv_vluxseg2;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg2ei8_v:
case RISCVVector::BI__builtin_rvv_vluxseg2ei16_v:
case RISCVVector::BI__builtin_rvv_vluxseg2ei32_v:
case RISCVVector::BI__builtin_rvv_vluxseg2ei64_v:
  ID = Intrinsic::riscv_vluxseg2;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg2ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg2ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg2ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg2ei64_v_tum:
  ID = Intrinsic::riscv_vluxseg2_mask;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg2ei8_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg2ei16_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg2ei32_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg2ei64_v_m:
  ID = Intrinsic::riscv_vluxseg2_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg2ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg2ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg2ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg2ei64_v_tumu:
  ID = Intrinsic::riscv_vluxseg2_mask;
  PolicyAttrs = 0;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg2ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg2ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg2ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg2ei64_v_mu:
  ID = Intrinsic::riscv_vluxseg2_mask;
  PolicyAttrs = 1;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg3ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg3ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg3ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg3ei64_v_tu:
  ID = Intrinsic::riscv_vluxseg3;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg3ei8_v:
case RISCVVector::BI__builtin_rvv_vluxseg3ei16_v:
case RISCVVector::BI__builtin_rvv_vluxseg3ei32_v:
case RISCVVector::BI__builtin_rvv_vluxseg3ei64_v:
  ID = Intrinsic::riscv_vluxseg3;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg3ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg3ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg3ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg3ei64_v_tum:
  ID = Intrinsic::riscv_vluxseg3_mask;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg3ei8_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg3ei16_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg3ei32_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg3ei64_v_m:
  ID = Intrinsic::riscv_vluxseg3_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg3ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg3ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg3ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg3ei64_v_tumu:
  ID = Intrinsic::riscv_vluxseg3_mask;
  PolicyAttrs = 0;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg3ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg3ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg3ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg3ei64_v_mu:
  ID = Intrinsic::riscv_vluxseg3_mask;
  PolicyAttrs = 1;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg4ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg4ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg4ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg4ei64_v_tu:
  ID = Intrinsic::riscv_vluxseg4;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg4ei8_v:
case RISCVVector::BI__builtin_rvv_vluxseg4ei16_v:
case RISCVVector::BI__builtin_rvv_vluxseg4ei32_v:
case RISCVVector::BI__builtin_rvv_vluxseg4ei64_v:
  ID = Intrinsic::riscv_vluxseg4;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg4ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg4ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg4ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg4ei64_v_tum:
  ID = Intrinsic::riscv_vluxseg4_mask;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg4ei8_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg4ei16_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg4ei32_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg4ei64_v_m:
  ID = Intrinsic::riscv_vluxseg4_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg4ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg4ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg4ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg4ei64_v_tumu:
  ID = Intrinsic::riscv_vluxseg4_mask;
  PolicyAttrs = 0;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg4ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg4ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg4ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg4ei64_v_mu:
  ID = Intrinsic::riscv_vluxseg4_mask;
  PolicyAttrs = 1;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg5ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg5ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg5ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg5ei64_v_tu:
  ID = Intrinsic::riscv_vluxseg5;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg5ei8_v:
case RISCVVector::BI__builtin_rvv_vluxseg5ei16_v:
case RISCVVector::BI__builtin_rvv_vluxseg5ei32_v:
case RISCVVector::BI__builtin_rvv_vluxseg5ei64_v:
  ID = Intrinsic::riscv_vluxseg5;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg5ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg5ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg5ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg5ei64_v_tum:
  ID = Intrinsic::riscv_vluxseg5_mask;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg5ei8_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg5ei16_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg5ei32_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg5ei64_v_m:
  ID = Intrinsic::riscv_vluxseg5_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg5ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg5ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg5ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg5ei64_v_tumu:
  ID = Intrinsic::riscv_vluxseg5_mask;
  PolicyAttrs = 0;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg5ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg5ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg5ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg5ei64_v_mu:
  ID = Intrinsic::riscv_vluxseg5_mask;
  PolicyAttrs = 1;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg6ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg6ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg6ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg6ei64_v_tu:
  ID = Intrinsic::riscv_vluxseg6;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg6ei8_v:
case RISCVVector::BI__builtin_rvv_vluxseg6ei16_v:
case RISCVVector::BI__builtin_rvv_vluxseg6ei32_v:
case RISCVVector::BI__builtin_rvv_vluxseg6ei64_v:
  ID = Intrinsic::riscv_vluxseg6;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg6ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg6ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg6ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg6ei64_v_tum:
  ID = Intrinsic::riscv_vluxseg6_mask;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg6ei8_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg6ei16_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg6ei32_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg6ei64_v_m:
  ID = Intrinsic::riscv_vluxseg6_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg6ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg6ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg6ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg6ei64_v_tumu:
  ID = Intrinsic::riscv_vluxseg6_mask;
  PolicyAttrs = 0;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg6ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg6ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg6ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg6ei64_v_mu:
  ID = Intrinsic::riscv_vluxseg6_mask;
  PolicyAttrs = 1;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg7ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg7ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg7ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg7ei64_v_tu:
  ID = Intrinsic::riscv_vluxseg7;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg7ei8_v:
case RISCVVector::BI__builtin_rvv_vluxseg7ei16_v:
case RISCVVector::BI__builtin_rvv_vluxseg7ei32_v:
case RISCVVector::BI__builtin_rvv_vluxseg7ei64_v:
  ID = Intrinsic::riscv_vluxseg7;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg7ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg7ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg7ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg7ei64_v_tum:
  ID = Intrinsic::riscv_vluxseg7_mask;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg7ei8_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg7ei16_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg7ei32_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg7ei64_v_m:
  ID = Intrinsic::riscv_vluxseg7_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg7ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg7ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg7ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg7ei64_v_tumu:
  ID = Intrinsic::riscv_vluxseg7_mask;
  PolicyAttrs = 0;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg7ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg7ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg7ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg7ei64_v_mu:
  ID = Intrinsic::riscv_vluxseg7_mask;
  PolicyAttrs = 1;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg8ei8_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg8ei16_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg8ei32_v_tu:
case RISCVVector::BI__builtin_rvv_vluxseg8ei64_v_tu:
  ID = Intrinsic::riscv_vluxseg8;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg8ei8_v:
case RISCVVector::BI__builtin_rvv_vluxseg8ei16_v:
case RISCVVector::BI__builtin_rvv_vluxseg8ei32_v:
case RISCVVector::BI__builtin_rvv_vluxseg8ei64_v:
  ID = Intrinsic::riscv_vluxseg8;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg8ei8_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg8ei16_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg8ei32_v_tum:
case RISCVVector::BI__builtin_rvv_vluxseg8ei64_v_tum:
  ID = Intrinsic::riscv_vluxseg8_mask;
  PolicyAttrs = 2;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg8ei8_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg8ei16_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg8ei32_v_m:
case RISCVVector::BI__builtin_rvv_vluxseg8ei64_v_m:
  ID = Intrinsic::riscv_vluxseg8_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg8ei8_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg8ei16_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg8ei32_v_tumu:
case RISCVVector::BI__builtin_rvv_vluxseg8ei64_v_tumu:
  ID = Intrinsic::riscv_vluxseg8_mask;
  PolicyAttrs = 0;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vluxseg8ei8_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg8ei16_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg8ei32_v_mu:
case RISCVVector::BI__builtin_rvv_vluxseg8ei64_v_mu:
  ID = Intrinsic::riscv_vluxseg8_mask;
  PolicyAttrs = 1;
  {
    auto PointeeType = E->getArg(2)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegLoadTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vmacc_vv_tu:
case RISCVVector::BI__builtin_rvv_vmacc_vx_tu:
  ID = Intrinsic::riscv_vmacc;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmacc_vv:
case RISCVVector::BI__builtin_rvv_vmacc_vx:
  ID = Intrinsic::riscv_vmacc;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmacc_vv_tum:
case RISCVVector::BI__builtin_rvv_vmacc_vx_tum:
  ID = Intrinsic::riscv_vmacc_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmacc_vv_m:
case RISCVVector::BI__builtin_rvv_vmacc_vx_m:
  ID = Intrinsic::riscv_vmacc_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmacc_vv_tumu:
case RISCVVector::BI__builtin_rvv_vmacc_vx_tumu:
  ID = Intrinsic::riscv_vmacc_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmacc_vv_mu:
case RISCVVector::BI__builtin_rvv_vmacc_vx_mu:
  ID = Intrinsic::riscv_vmacc_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmadc_vv:
case RISCVVector::BI__builtin_rvv_vmadc_vx:
  ID = Intrinsic::riscv_vmadc;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmadc_vvm:
case RISCVVector::BI__builtin_rvv_vmadc_vxm:
  ID = Intrinsic::riscv_vmadc_carry_in;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vmadd_vx_tu:
  ID = Intrinsic::riscv_vmadd;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmadd_vv:
case RISCVVector::BI__builtin_rvv_vmadd_vx:
  ID = Intrinsic::riscv_vmadd;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vmadd_vx_tum:
  ID = Intrinsic::riscv_vmadd_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmadd_vv_m:
case RISCVVector::BI__builtin_rvv_vmadd_vx_m:
  ID = Intrinsic::riscv_vmadd_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vmadd_vx_tumu:
  ID = Intrinsic::riscv_vmadd_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vmadd_vx_mu:
  ID = Intrinsic::riscv_vmadd_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmmv_m:
  ID = Intrinsic::riscv_vmand;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVPseudoMaskBuiltin(this, E, ReturnValue, ResultType, ID,
                                        Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vmand_mm:
  ID = Intrinsic::riscv_vmand;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmandn_mm:
  ID = Intrinsic::riscv_vmandn;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmax_vv_tu:
case RISCVVector::BI__builtin_rvv_vmax_vx_tu:
  ID = Intrinsic::riscv_vmax;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmax_vv:
case RISCVVector::BI__builtin_rvv_vmax_vx:
  ID = Intrinsic::riscv_vmax;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmax_vv_tum:
case RISCVVector::BI__builtin_rvv_vmax_vx_tum:
  ID = Intrinsic::riscv_vmax_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmax_vv_m:
case RISCVVector::BI__builtin_rvv_vmax_vx_m:
  ID = Intrinsic::riscv_vmax_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmax_vv_tumu:
case RISCVVector::BI__builtin_rvv_vmax_vx_tumu:
  ID = Intrinsic::riscv_vmax_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmax_vv_mu:
case RISCVVector::BI__builtin_rvv_vmax_vx_mu:
  ID = Intrinsic::riscv_vmax_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmaxu_vv_tu:
case RISCVVector::BI__builtin_rvv_vmaxu_vx_tu:
  ID = Intrinsic::riscv_vmaxu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmaxu_vv:
case RISCVVector::BI__builtin_rvv_vmaxu_vx:
  ID = Intrinsic::riscv_vmaxu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmaxu_vv_tum:
case RISCVVector::BI__builtin_rvv_vmaxu_vx_tum:
  ID = Intrinsic::riscv_vmaxu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmaxu_vv_m:
case RISCVVector::BI__builtin_rvv_vmaxu_vx_m:
  ID = Intrinsic::riscv_vmaxu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmaxu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vmaxu_vx_tumu:
  ID = Intrinsic::riscv_vmaxu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmaxu_vv_mu:
case RISCVVector::BI__builtin_rvv_vmaxu_vx_mu:
  ID = Intrinsic::riscv_vmaxu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmclr_m:
  ID = Intrinsic::riscv_vmclr;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmerge_vvm_tu:
case RISCVVector::BI__builtin_rvv_vmerge_vxm_tu:
  ID = Intrinsic::riscv_vmerge;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

      // insert poison passthru
      if (PolicyAttrs & RVV_VTA)
        Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vmerge_vvm:
case RISCVVector::BI__builtin_rvv_vmerge_vxm:
  ID = Intrinsic::riscv_vmerge;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

      // insert poison passthru
      if (PolicyAttrs & RVV_VTA)
        Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vmfeq_vv:
case RISCVVector::BI__builtin_rvv_vmfeq_vf:
  ID = Intrinsic::riscv_vmfeq;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfeq_vv_m:
case RISCVVector::BI__builtin_rvv_vmfeq_vf_m:
  ID = Intrinsic::riscv_vmfeq_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfeq_vv_mu:
case RISCVVector::BI__builtin_rvv_vmfeq_vf_mu:
  ID = Intrinsic::riscv_vmfeq_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfge_vv:
case RISCVVector::BI__builtin_rvv_vmfge_vf:
  ID = Intrinsic::riscv_vmfge;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfge_vv_m:
case RISCVVector::BI__builtin_rvv_vmfge_vf_m:
  ID = Intrinsic::riscv_vmfge_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfge_vv_mu:
case RISCVVector::BI__builtin_rvv_vmfge_vf_mu:
  ID = Intrinsic::riscv_vmfge_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfgt_vv:
case RISCVVector::BI__builtin_rvv_vmfgt_vf:
  ID = Intrinsic::riscv_vmfgt;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfgt_vv_m:
case RISCVVector::BI__builtin_rvv_vmfgt_vf_m:
  ID = Intrinsic::riscv_vmfgt_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfgt_vv_mu:
case RISCVVector::BI__builtin_rvv_vmfgt_vf_mu:
  ID = Intrinsic::riscv_vmfgt_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfle_vv:
case RISCVVector::BI__builtin_rvv_vmfle_vf:
  ID = Intrinsic::riscv_vmfle;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfle_vv_m:
case RISCVVector::BI__builtin_rvv_vmfle_vf_m:
  ID = Intrinsic::riscv_vmfle_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfle_vv_mu:
case RISCVVector::BI__builtin_rvv_vmfle_vf_mu:
  ID = Intrinsic::riscv_vmfle_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmflt_vv:
case RISCVVector::BI__builtin_rvv_vmflt_vf:
  ID = Intrinsic::riscv_vmflt;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmflt_vv_m:
case RISCVVector::BI__builtin_rvv_vmflt_vf_m:
  ID = Intrinsic::riscv_vmflt_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmflt_vv_mu:
case RISCVVector::BI__builtin_rvv_vmflt_vf_mu:
  ID = Intrinsic::riscv_vmflt_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfne_vv:
case RISCVVector::BI__builtin_rvv_vmfne_vf:
  ID = Intrinsic::riscv_vmfne;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfne_vv_m:
case RISCVVector::BI__builtin_rvv_vmfne_vf_m:
  ID = Intrinsic::riscv_vmfne_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmfne_vv_mu:
case RISCVVector::BI__builtin_rvv_vmfne_vf_mu:
  ID = Intrinsic::riscv_vmfne_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmin_vv_tu:
case RISCVVector::BI__builtin_rvv_vmin_vx_tu:
  ID = Intrinsic::riscv_vmin;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmin_vv:
case RISCVVector::BI__builtin_rvv_vmin_vx:
  ID = Intrinsic::riscv_vmin;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmin_vv_tum:
case RISCVVector::BI__builtin_rvv_vmin_vx_tum:
  ID = Intrinsic::riscv_vmin_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmin_vv_m:
case RISCVVector::BI__builtin_rvv_vmin_vx_m:
  ID = Intrinsic::riscv_vmin_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmin_vv_tumu:
case RISCVVector::BI__builtin_rvv_vmin_vx_tumu:
  ID = Intrinsic::riscv_vmin_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmin_vv_mu:
case RISCVVector::BI__builtin_rvv_vmin_vx_mu:
  ID = Intrinsic::riscv_vmin_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vminu_vv_tu:
case RISCVVector::BI__builtin_rvv_vminu_vx_tu:
  ID = Intrinsic::riscv_vminu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vminu_vv:
case RISCVVector::BI__builtin_rvv_vminu_vx:
  ID = Intrinsic::riscv_vminu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vminu_vv_tum:
case RISCVVector::BI__builtin_rvv_vminu_vx_tum:
  ID = Intrinsic::riscv_vminu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vminu_vv_m:
case RISCVVector::BI__builtin_rvv_vminu_vx_m:
  ID = Intrinsic::riscv_vminu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vminu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vminu_vx_tumu:
  ID = Intrinsic::riscv_vminu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vminu_vv_mu:
case RISCVVector::BI__builtin_rvv_vminu_vx_mu:
  ID = Intrinsic::riscv_vminu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmnot_m:
  ID = Intrinsic::riscv_vmnand;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVPseudoMaskBuiltin(this, E, ReturnValue, ResultType, ID,
                                        Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vmnand_mm:
  ID = Intrinsic::riscv_vmnand;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmnor_mm:
  ID = Intrinsic::riscv_vmnor;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmor_mm:
  ID = Intrinsic::riscv_vmor;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmorn_mm:
  ID = Intrinsic::riscv_vmorn;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsbc_vv:
case RISCVVector::BI__builtin_rvv_vmsbc_vx:
  ID = Intrinsic::riscv_vmsbc;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsbc_vvm:
case RISCVVector::BI__builtin_rvv_vmsbc_vxm:
  ID = Intrinsic::riscv_vmsbc_borrow_in;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsbf_m:
  ID = Intrinsic::riscv_vmsbf;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsbf_m_m:
  ID = Intrinsic::riscv_vmsbf_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsbf_m_mu:
  ID = Intrinsic::riscv_vmsbf_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmseq_vv:
case RISCVVector::BI__builtin_rvv_vmseq_vx:
  ID = Intrinsic::riscv_vmseq;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmseq_vv_m:
case RISCVVector::BI__builtin_rvv_vmseq_vx_m:
  ID = Intrinsic::riscv_vmseq_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmseq_vv_mu:
case RISCVVector::BI__builtin_rvv_vmseq_vx_mu:
  ID = Intrinsic::riscv_vmseq_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmset_m:
  ID = Intrinsic::riscv_vmset;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsge_vv:
case RISCVVector::BI__builtin_rvv_vmsge_vx:
  ID = Intrinsic::riscv_vmsge;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsge_vv_m:
case RISCVVector::BI__builtin_rvv_vmsge_vx_m:
  ID = Intrinsic::riscv_vmsge_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsge_vv_mu:
case RISCVVector::BI__builtin_rvv_vmsge_vx_mu:
  ID = Intrinsic::riscv_vmsge_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsgeu_vv:
case RISCVVector::BI__builtin_rvv_vmsgeu_vx:
  ID = Intrinsic::riscv_vmsgeu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsgeu_vv_m:
case RISCVVector::BI__builtin_rvv_vmsgeu_vx_m:
  ID = Intrinsic::riscv_vmsgeu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsgeu_vv_mu:
case RISCVVector::BI__builtin_rvv_vmsgeu_vx_mu:
  ID = Intrinsic::riscv_vmsgeu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsgt_vv:
case RISCVVector::BI__builtin_rvv_vmsgt_vx:
  ID = Intrinsic::riscv_vmsgt;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsgt_vv_m:
case RISCVVector::BI__builtin_rvv_vmsgt_vx_m:
  ID = Intrinsic::riscv_vmsgt_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsgt_vv_mu:
case RISCVVector::BI__builtin_rvv_vmsgt_vx_mu:
  ID = Intrinsic::riscv_vmsgt_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsgtu_vv:
case RISCVVector::BI__builtin_rvv_vmsgtu_vx:
  ID = Intrinsic::riscv_vmsgtu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsgtu_vv_m:
case RISCVVector::BI__builtin_rvv_vmsgtu_vx_m:
  ID = Intrinsic::riscv_vmsgtu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsgtu_vv_mu:
case RISCVVector::BI__builtin_rvv_vmsgtu_vx_mu:
  ID = Intrinsic::riscv_vmsgtu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsif_m:
  ID = Intrinsic::riscv_vmsif;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsif_m_m:
  ID = Intrinsic::riscv_vmsif_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsif_m_mu:
  ID = Intrinsic::riscv_vmsif_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsle_vv:
case RISCVVector::BI__builtin_rvv_vmsle_vx:
  ID = Intrinsic::riscv_vmsle;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsle_vv_m:
case RISCVVector::BI__builtin_rvv_vmsle_vx_m:
  ID = Intrinsic::riscv_vmsle_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsle_vv_mu:
case RISCVVector::BI__builtin_rvv_vmsle_vx_mu:
  ID = Intrinsic::riscv_vmsle_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsleu_vv:
case RISCVVector::BI__builtin_rvv_vmsleu_vx:
  ID = Intrinsic::riscv_vmsleu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsleu_vv_m:
case RISCVVector::BI__builtin_rvv_vmsleu_vx_m:
  ID = Intrinsic::riscv_vmsleu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsleu_vv_mu:
case RISCVVector::BI__builtin_rvv_vmsleu_vx_mu:
  ID = Intrinsic::riscv_vmsleu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmslt_vv:
case RISCVVector::BI__builtin_rvv_vmslt_vx:
  ID = Intrinsic::riscv_vmslt;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmslt_vv_m:
case RISCVVector::BI__builtin_rvv_vmslt_vx_m:
  ID = Intrinsic::riscv_vmslt_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmslt_vv_mu:
case RISCVVector::BI__builtin_rvv_vmslt_vx_mu:
  ID = Intrinsic::riscv_vmslt_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsltu_vv:
case RISCVVector::BI__builtin_rvv_vmsltu_vx:
  ID = Intrinsic::riscv_vmsltu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsltu_vv_m:
case RISCVVector::BI__builtin_rvv_vmsltu_vx_m:
  ID = Intrinsic::riscv_vmsltu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsltu_vv_mu:
case RISCVVector::BI__builtin_rvv_vmsltu_vx_mu:
  ID = Intrinsic::riscv_vmsltu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsne_vv:
case RISCVVector::BI__builtin_rvv_vmsne_vx:
  ID = Intrinsic::riscv_vmsne;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType(), Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsne_vv_m:
case RISCVVector::BI__builtin_rvv_vmsne_vx_m:
  ID = Intrinsic::riscv_vmsne_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsne_vv_mu:
case RISCVVector::BI__builtin_rvv_vmsne_vx_mu:
  ID = Intrinsic::riscv_vmsne_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsof_m:
  ID = Intrinsic::riscv_vmsof;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsof_m_m:
  ID = Intrinsic::riscv_vmsof_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmsof_m_mu:
  ID = Intrinsic::riscv_vmsof_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmul_vv_tu:
case RISCVVector::BI__builtin_rvv_vmul_vx_tu:
  ID = Intrinsic::riscv_vmul;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmul_vv:
case RISCVVector::BI__builtin_rvv_vmul_vx:
  ID = Intrinsic::riscv_vmul;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmul_vv_tum:
case RISCVVector::BI__builtin_rvv_vmul_vx_tum:
  ID = Intrinsic::riscv_vmul_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmul_vv_m:
case RISCVVector::BI__builtin_rvv_vmul_vx_m:
  ID = Intrinsic::riscv_vmul_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmul_vv_tumu:
case RISCVVector::BI__builtin_rvv_vmul_vx_tumu:
  ID = Intrinsic::riscv_vmul_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmul_vv_mu:
case RISCVVector::BI__builtin_rvv_vmul_vx_mu:
  ID = Intrinsic::riscv_vmul_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulh_vv_tu:
case RISCVVector::BI__builtin_rvv_vmulh_vx_tu:
  ID = Intrinsic::riscv_vmulh;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulh_vv:
case RISCVVector::BI__builtin_rvv_vmulh_vx:
  ID = Intrinsic::riscv_vmulh;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulh_vv_tum:
case RISCVVector::BI__builtin_rvv_vmulh_vx_tum:
  ID = Intrinsic::riscv_vmulh_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulh_vv_m:
case RISCVVector::BI__builtin_rvv_vmulh_vx_m:
  ID = Intrinsic::riscv_vmulh_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulh_vv_tumu:
case RISCVVector::BI__builtin_rvv_vmulh_vx_tumu:
  ID = Intrinsic::riscv_vmulh_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulh_vv_mu:
case RISCVVector::BI__builtin_rvv_vmulh_vx_mu:
  ID = Intrinsic::riscv_vmulh_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhsu_vv_tu:
case RISCVVector::BI__builtin_rvv_vmulhsu_vx_tu:
  ID = Intrinsic::riscv_vmulhsu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhsu_vv:
case RISCVVector::BI__builtin_rvv_vmulhsu_vx:
  ID = Intrinsic::riscv_vmulhsu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhsu_vv_tum:
case RISCVVector::BI__builtin_rvv_vmulhsu_vx_tum:
  ID = Intrinsic::riscv_vmulhsu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhsu_vv_m:
case RISCVVector::BI__builtin_rvv_vmulhsu_vx_m:
  ID = Intrinsic::riscv_vmulhsu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhsu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vmulhsu_vx_tumu:
  ID = Intrinsic::riscv_vmulhsu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhsu_vv_mu:
case RISCVVector::BI__builtin_rvv_vmulhsu_vx_mu:
  ID = Intrinsic::riscv_vmulhsu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhu_vv_tu:
case RISCVVector::BI__builtin_rvv_vmulhu_vx_tu:
  ID = Intrinsic::riscv_vmulhu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhu_vv:
case RISCVVector::BI__builtin_rvv_vmulhu_vx:
  ID = Intrinsic::riscv_vmulhu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhu_vv_tum:
case RISCVVector::BI__builtin_rvv_vmulhu_vx_tum:
  ID = Intrinsic::riscv_vmulhu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhu_vv_m:
case RISCVVector::BI__builtin_rvv_vmulhu_vx_m:
  ID = Intrinsic::riscv_vmulhu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vmulhu_vx_tumu:
  ID = Intrinsic::riscv_vmulhu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmulhu_vv_mu:
case RISCVVector::BI__builtin_rvv_vmulhu_vx_mu:
  ID = Intrinsic::riscv_vmulhu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmv_s_x_tu:
  ID = Intrinsic::riscv_vmv_s_x;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmv_s_x:
  ID = Intrinsic::riscv_vmv_s_x;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmv_v_v_tu:
  ID = Intrinsic::riscv_vmv_v_v;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmv_v_v:
  ID = Intrinsic::riscv_vmv_v_v;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmv_v_x_tu:
  ID = Intrinsic::riscv_vmv_v_x;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmv_v_x:
  ID = Intrinsic::riscv_vmv_v_x;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmv_x_s:
  ID = Intrinsic::riscv_vmv_x_s;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {Ops[0]->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmxnor_mm:
  ID = Intrinsic::riscv_vmxnor;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vmxor_mm:
  ID = Intrinsic::riscv_vmxor;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnclip_wv_tu:
case RISCVVector::BI__builtin_rvv_vnclip_wx_tu:
  ID = Intrinsic::riscv_vnclip;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVNarrowingClipBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vnclip_wv:
case RISCVVector::BI__builtin_rvv_vnclip_wx:
  ID = Intrinsic::riscv_vnclip;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVNarrowingClipBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vnclip_wv_tum:
case RISCVVector::BI__builtin_rvv_vnclip_wx_tum:
  ID = Intrinsic::riscv_vnclip_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVNarrowingClipBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vnclip_wv_m:
case RISCVVector::BI__builtin_rvv_vnclip_wx_m:
  ID = Intrinsic::riscv_vnclip_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVNarrowingClipBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vnclip_wv_tumu:
case RISCVVector::BI__builtin_rvv_vnclip_wx_tumu:
  ID = Intrinsic::riscv_vnclip_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVNarrowingClipBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vnclip_wv_mu:
case RISCVVector::BI__builtin_rvv_vnclip_wx_mu:
  ID = Intrinsic::riscv_vnclip_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVNarrowingClipBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vnclipu_wv_tu:
case RISCVVector::BI__builtin_rvv_vnclipu_wx_tu:
  ID = Intrinsic::riscv_vnclipu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVNarrowingClipBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vnclipu_wv:
case RISCVVector::BI__builtin_rvv_vnclipu_wx:
  ID = Intrinsic::riscv_vnclipu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVNarrowingClipBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vnclipu_wv_tum:
case RISCVVector::BI__builtin_rvv_vnclipu_wx_tum:
  ID = Intrinsic::riscv_vnclipu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVNarrowingClipBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vnclipu_wv_m:
case RISCVVector::BI__builtin_rvv_vnclipu_wx_m:
  ID = Intrinsic::riscv_vnclipu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVNarrowingClipBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vnclipu_wv_tumu:
case RISCVVector::BI__builtin_rvv_vnclipu_wx_tumu:
  ID = Intrinsic::riscv_vnclipu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVNarrowingClipBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vnclipu_wv_mu:
case RISCVVector::BI__builtin_rvv_vnclipu_wx_mu:
  ID = Intrinsic::riscv_vnclipu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVNarrowingClipBuiltin(this, E, ReturnValue, ResultType, ID,
                                       Ops, PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vnmsac_vv_tu:
case RISCVVector::BI__builtin_rvv_vnmsac_vx_tu:
  ID = Intrinsic::riscv_vnmsac;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsac_vv:
case RISCVVector::BI__builtin_rvv_vnmsac_vx:
  ID = Intrinsic::riscv_vnmsac;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsac_vv_tum:
case RISCVVector::BI__builtin_rvv_vnmsac_vx_tum:
  ID = Intrinsic::riscv_vnmsac_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsac_vv_m:
case RISCVVector::BI__builtin_rvv_vnmsac_vx_m:
  ID = Intrinsic::riscv_vnmsac_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsac_vv_tumu:
case RISCVVector::BI__builtin_rvv_vnmsac_vx_tumu:
  ID = Intrinsic::riscv_vnmsac_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsac_vv_mu:
case RISCVVector::BI__builtin_rvv_vnmsac_vx_mu:
  ID = Intrinsic::riscv_vnmsac_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsub_vv_tu:
case RISCVVector::BI__builtin_rvv_vnmsub_vx_tu:
  ID = Intrinsic::riscv_vnmsub;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsub_vv:
case RISCVVector::BI__builtin_rvv_vnmsub_vx:
  ID = Intrinsic::riscv_vnmsub;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsub_vv_tum:
case RISCVVector::BI__builtin_rvv_vnmsub_vx_tum:
  ID = Intrinsic::riscv_vnmsub_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsub_vv_m:
case RISCVVector::BI__builtin_rvv_vnmsub_vx_m:
  ID = Intrinsic::riscv_vnmsub_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsub_vv_tumu:
case RISCVVector::BI__builtin_rvv_vnmsub_vx_tumu:
  ID = Intrinsic::riscv_vnmsub_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnmsub_vv_mu:
case RISCVVector::BI__builtin_rvv_vnmsub_vx_mu:
  ID = Intrinsic::riscv_vnmsub_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnsra_wv_tu:
case RISCVVector::BI__builtin_rvv_vnsra_wx_tu:
  ID = Intrinsic::riscv_vnsra;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnsra_wv:
case RISCVVector::BI__builtin_rvv_vnsra_wx:
  ID = Intrinsic::riscv_vnsra;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnsra_wv_tum:
case RISCVVector::BI__builtin_rvv_vnsra_wx_tum:
  ID = Intrinsic::riscv_vnsra_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnsra_wv_m:
case RISCVVector::BI__builtin_rvv_vnsra_wx_m:
  ID = Intrinsic::riscv_vnsra_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnsra_wv_tumu:
case RISCVVector::BI__builtin_rvv_vnsra_wx_tumu:
  ID = Intrinsic::riscv_vnsra_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnsra_wv_mu:
case RISCVVector::BI__builtin_rvv_vnsra_wx_mu:
  ID = Intrinsic::riscv_vnsra_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vncvt_x_x_w_tu:
  ID = Intrinsic::riscv_vnsrl;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVPseudoVNCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vnsrl_wv_tu:
case RISCVVector::BI__builtin_rvv_vnsrl_wx_tu:
  ID = Intrinsic::riscv_vnsrl;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vnsrl;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVPseudoVNCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vncvt_x_x_w:
  ID = Intrinsic::riscv_vnsrl;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVPseudoVNCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vnsrl_wv:
case RISCVVector::BI__builtin_rvv_vnsrl_wx:
  ID = Intrinsic::riscv_vnsrl;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vnsrl;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVPseudoVNCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vncvt_x_x_w_tum:
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVNCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vnsrl_wv_tum:
case RISCVVector::BI__builtin_rvv_vnsrl_wx_tum:
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVNCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vncvt_x_x_w_m:
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVNCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vnsrl_wv_m:
case RISCVVector::BI__builtin_rvv_vnsrl_wx_m:
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVNCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vncvt_x_x_w_tumu:
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVNCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vnsrl_wv_tumu:
case RISCVVector::BI__builtin_rvv_vnsrl_wx_tumu:
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVNCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vncvt_x_x_w_mu:
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVNCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vnsrl_wv_mu:
case RISCVVector::BI__builtin_rvv_vnsrl_wx_mu:
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
  ID = Intrinsic::riscv_vnsrl_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVNCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vor_vv_tu:
case RISCVVector::BI__builtin_rvv_vor_vx_tu:
  ID = Intrinsic::riscv_vor;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vor_vv:
case RISCVVector::BI__builtin_rvv_vor_vx:
  ID = Intrinsic::riscv_vor;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vor_vv_tum:
case RISCVVector::BI__builtin_rvv_vor_vx_tum:
  ID = Intrinsic::riscv_vor_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vor_vv_m:
case RISCVVector::BI__builtin_rvv_vor_vx_m:
  ID = Intrinsic::riscv_vor_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vor_vv_tumu:
case RISCVVector::BI__builtin_rvv_vor_vx_tumu:
  ID = Intrinsic::riscv_vor_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vor_vv_mu:
case RISCVVector::BI__builtin_rvv_vor_vx_mu:
  ID = Intrinsic::riscv_vor_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdot_vv_tu:
case RISCVVector::BI__builtin_rvv_vqdot_vx_tu:
  ID = Intrinsic::riscv_vqdot;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdot_vv:
case RISCVVector::BI__builtin_rvv_vqdot_vx:
  ID = Intrinsic::riscv_vqdot;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdot_vv_tum:
case RISCVVector::BI__builtin_rvv_vqdot_vx_tum:
  ID = Intrinsic::riscv_vqdot_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdot_vv_m:
case RISCVVector::BI__builtin_rvv_vqdot_vx_m:
  ID = Intrinsic::riscv_vqdot_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdot_vv_tumu:
case RISCVVector::BI__builtin_rvv_vqdot_vx_tumu:
  ID = Intrinsic::riscv_vqdot_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdot_vv_mu:
case RISCVVector::BI__builtin_rvv_vqdot_vx_mu:
  ID = Intrinsic::riscv_vqdot_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdotsu_vv_tu:
case RISCVVector::BI__builtin_rvv_vqdotsu_vx_tu:
  ID = Intrinsic::riscv_vqdotsu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdotsu_vv:
case RISCVVector::BI__builtin_rvv_vqdotsu_vx:
  ID = Intrinsic::riscv_vqdotsu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdotsu_vv_tum:
case RISCVVector::BI__builtin_rvv_vqdotsu_vx_tum:
  ID = Intrinsic::riscv_vqdotsu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdotsu_vv_m:
case RISCVVector::BI__builtin_rvv_vqdotsu_vx_m:
  ID = Intrinsic::riscv_vqdotsu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdotsu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vqdotsu_vx_tumu:
  ID = Intrinsic::riscv_vqdotsu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdotsu_vv_mu:
case RISCVVector::BI__builtin_rvv_vqdotsu_vx_mu:
  ID = Intrinsic::riscv_vqdotsu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdotu_vv_tu:
case RISCVVector::BI__builtin_rvv_vqdotu_vx_tu:
  ID = Intrinsic::riscv_vqdotu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdotu_vv:
case RISCVVector::BI__builtin_rvv_vqdotu_vx:
  ID = Intrinsic::riscv_vqdotu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdotu_vv_tum:
case RISCVVector::BI__builtin_rvv_vqdotu_vx_tum:
  ID = Intrinsic::riscv_vqdotu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdotu_vv_m:
case RISCVVector::BI__builtin_rvv_vqdotu_vx_m:
  ID = Intrinsic::riscv_vqdotu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdotu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vqdotu_vx_tumu:
  ID = Intrinsic::riscv_vqdotu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdotu_vv_mu:
case RISCVVector::BI__builtin_rvv_vqdotu_vx_mu:
  ID = Intrinsic::riscv_vqdotu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdotus_vx_tu:
  ID = Intrinsic::riscv_vqdotus;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdotus_vx:
  ID = Intrinsic::riscv_vqdotus;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdotus_vx_tum:
  ID = Intrinsic::riscv_vqdotus_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdotus_vx_m:
  ID = Intrinsic::riscv_vqdotus_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdotus_vx_tumu:
  ID = Intrinsic::riscv_vqdotus_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vqdotus_vx_mu:
  ID = Intrinsic::riscv_vqdotus_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredand_vs_tu:
  ID = Intrinsic::riscv_vredand;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredand_vs:
  ID = Intrinsic::riscv_vredand;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredand_vs_tum:
  ID = Intrinsic::riscv_vredand_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredand_vs_m:
  ID = Intrinsic::riscv_vredand_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmax_vs_tu:
  ID = Intrinsic::riscv_vredmax;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmax_vs:
  ID = Intrinsic::riscv_vredmax;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmax_vs_tum:
  ID = Intrinsic::riscv_vredmax_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmax_vs_m:
  ID = Intrinsic::riscv_vredmax_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmaxu_vs_tu:
  ID = Intrinsic::riscv_vredmaxu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmaxu_vs:
  ID = Intrinsic::riscv_vredmaxu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmaxu_vs_tum:
  ID = Intrinsic::riscv_vredmaxu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmaxu_vs_m:
  ID = Intrinsic::riscv_vredmaxu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmin_vs_tu:
  ID = Intrinsic::riscv_vredmin;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmin_vs:
  ID = Intrinsic::riscv_vredmin;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmin_vs_tum:
  ID = Intrinsic::riscv_vredmin_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredmin_vs_m:
  ID = Intrinsic::riscv_vredmin_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredminu_vs_tu:
  ID = Intrinsic::riscv_vredminu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredminu_vs:
  ID = Intrinsic::riscv_vredminu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredminu_vs_tum:
  ID = Intrinsic::riscv_vredminu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredminu_vs_m:
  ID = Intrinsic::riscv_vredminu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredor_vs_tu:
  ID = Intrinsic::riscv_vredor;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredor_vs:
  ID = Intrinsic::riscv_vredor;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredor_vs_tum:
  ID = Intrinsic::riscv_vredor_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredor_vs_m:
  ID = Intrinsic::riscv_vredor_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredsum_vs_tu:
  ID = Intrinsic::riscv_vredsum;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredsum_vs:
  ID = Intrinsic::riscv_vredsum;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredsum_vs_tum:
  ID = Intrinsic::riscv_vredsum_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredsum_vs_m:
  ID = Intrinsic::riscv_vredsum_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredxor_vs_tu:
  ID = Intrinsic::riscv_vredxor;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredxor_vs:
  ID = Intrinsic::riscv_vredxor;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredxor_vs_tum:
  ID = Intrinsic::riscv_vredxor_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vredxor_vs_m:
  ID = Intrinsic::riscv_vredxor_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrem_vv_tu:
case RISCVVector::BI__builtin_rvv_vrem_vx_tu:
  ID = Intrinsic::riscv_vrem;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrem_vv:
case RISCVVector::BI__builtin_rvv_vrem_vx:
  ID = Intrinsic::riscv_vrem;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrem_vv_tum:
case RISCVVector::BI__builtin_rvv_vrem_vx_tum:
  ID = Intrinsic::riscv_vrem_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrem_vv_m:
case RISCVVector::BI__builtin_rvv_vrem_vx_m:
  ID = Intrinsic::riscv_vrem_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrem_vv_tumu:
case RISCVVector::BI__builtin_rvv_vrem_vx_tumu:
  ID = Intrinsic::riscv_vrem_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrem_vv_mu:
case RISCVVector::BI__builtin_rvv_vrem_vx_mu:
  ID = Intrinsic::riscv_vrem_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vremu_vv_tu:
case RISCVVector::BI__builtin_rvv_vremu_vx_tu:
  ID = Intrinsic::riscv_vremu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vremu_vv:
case RISCVVector::BI__builtin_rvv_vremu_vx:
  ID = Intrinsic::riscv_vremu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vremu_vv_tum:
case RISCVVector::BI__builtin_rvv_vremu_vx_tum:
  ID = Intrinsic::riscv_vremu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vremu_vv_m:
case RISCVVector::BI__builtin_rvv_vremu_vx_m:
  ID = Intrinsic::riscv_vremu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vremu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vremu_vx_tumu:
  ID = Intrinsic::riscv_vremu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vremu_vv_mu:
case RISCVVector::BI__builtin_rvv_vremu_vx_mu:
  ID = Intrinsic::riscv_vremu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrev8_v_tu:
  ID = Intrinsic::riscv_vrev8;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrev8_v:
  ID = Intrinsic::riscv_vrev8;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrev8_v_tum:
  ID = Intrinsic::riscv_vrev8_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrev8_v_m:
  ID = Intrinsic::riscv_vrev8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrev8_v_tumu:
  ID = Intrinsic::riscv_vrev8_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrev8_v_mu:
  ID = Intrinsic::riscv_vrev8_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vv_tu:
  ID = Intrinsic::riscv_vrgather_vv;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vv:
  ID = Intrinsic::riscv_vrgather_vv;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vv_tum:
  ID = Intrinsic::riscv_vrgather_vv_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vv_m:
  ID = Intrinsic::riscv_vrgather_vv_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vv_tumu:
  ID = Intrinsic::riscv_vrgather_vv_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vv_mu:
  ID = Intrinsic::riscv_vrgather_vv_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vx_tu:
  ID = Intrinsic::riscv_vrgather_vx;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vx:
  ID = Intrinsic::riscv_vrgather_vx;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vx_tum:
  ID = Intrinsic::riscv_vrgather_vx_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vx_m:
  ID = Intrinsic::riscv_vrgather_vx_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vx_tumu:
  ID = Intrinsic::riscv_vrgather_vx_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgather_vx_mu:
  ID = Intrinsic::riscv_vrgather_vx_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgatherei16_vv_tu:
  ID = Intrinsic::riscv_vrgatherei16_vv;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgatherei16_vv:
  ID = Intrinsic::riscv_vrgatherei16_vv;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgatherei16_vv_tum:
  ID = Intrinsic::riscv_vrgatherei16_vv_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgatherei16_vv_m:
  ID = Intrinsic::riscv_vrgatherei16_vv_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgatherei16_vv_tumu:
  ID = Intrinsic::riscv_vrgatherei16_vv_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrgatherei16_vv_mu:
  ID = Intrinsic::riscv_vrgatherei16_vv_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrol_vv_tu:
case RISCVVector::BI__builtin_rvv_vrol_vx_tu:
  ID = Intrinsic::riscv_vrol;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrol_vv:
case RISCVVector::BI__builtin_rvv_vrol_vx:
  ID = Intrinsic::riscv_vrol;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrol_vv_tum:
case RISCVVector::BI__builtin_rvv_vrol_vx_tum:
  ID = Intrinsic::riscv_vrol_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrol_vv_m:
case RISCVVector::BI__builtin_rvv_vrol_vx_m:
  ID = Intrinsic::riscv_vrol_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrol_vv_tumu:
case RISCVVector::BI__builtin_rvv_vrol_vx_tumu:
  ID = Intrinsic::riscv_vrol_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vrol_vv_mu:
case RISCVVector::BI__builtin_rvv_vrol_vx_mu:
  ID = Intrinsic::riscv_vrol_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vror_vv_tu:
case RISCVVector::BI__builtin_rvv_vror_vx_tu:
  ID = Intrinsic::riscv_vror;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vror_vv:
case RISCVVector::BI__builtin_rvv_vror_vx:
  ID = Intrinsic::riscv_vror;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vror_vv_tum:
case RISCVVector::BI__builtin_rvv_vror_vx_tum:
  ID = Intrinsic::riscv_vror_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vror_vv_m:
case RISCVVector::BI__builtin_rvv_vror_vx_m:
  ID = Intrinsic::riscv_vror_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vror_vv_tumu:
case RISCVVector::BI__builtin_rvv_vror_vx_tumu:
  ID = Intrinsic::riscv_vror_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vror_vv_mu:
case RISCVVector::BI__builtin_rvv_vror_vx_mu:
  ID = Intrinsic::riscv_vror_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vneg_v_tu:
  ID = Intrinsic::riscv_vrsub;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVPseudoUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vrsub_vx_tu:
  ID = Intrinsic::riscv_vrsub;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vneg_v:
  ID = Intrinsic::riscv_vrsub;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVPseudoUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vrsub_vx:
  ID = Intrinsic::riscv_vrsub;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vneg_v_tum:
  ID = Intrinsic::riscv_vrsub_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vrsub_vx_tum:
  ID = Intrinsic::riscv_vrsub_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vneg_v_m:
  ID = Intrinsic::riscv_vrsub_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vrsub_vx_m:
  ID = Intrinsic::riscv_vrsub_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vneg_v_tumu:
  ID = Intrinsic::riscv_vrsub_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vrsub_vx_tumu:
  ID = Intrinsic::riscv_vrsub_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vneg_v_mu:
  ID = Intrinsic::riscv_vrsub_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoUnaryBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vrsub_vx_mu:
  ID = Intrinsic::riscv_vrsub_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vsadd_vx_tu:
  ID = Intrinsic::riscv_vsadd;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsadd_vv:
case RISCVVector::BI__builtin_rvv_vsadd_vx:
  ID = Intrinsic::riscv_vsadd;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vsadd_vx_tum:
  ID = Intrinsic::riscv_vsadd_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsadd_vv_m:
case RISCVVector::BI__builtin_rvv_vsadd_vx_m:
  ID = Intrinsic::riscv_vsadd_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vsadd_vx_tumu:
  ID = Intrinsic::riscv_vsadd_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vsadd_vx_mu:
  ID = Intrinsic::riscv_vsadd_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsaddu_vv_tu:
case RISCVVector::BI__builtin_rvv_vsaddu_vx_tu:
  ID = Intrinsic::riscv_vsaddu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsaddu_vv:
case RISCVVector::BI__builtin_rvv_vsaddu_vx:
  ID = Intrinsic::riscv_vsaddu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsaddu_vv_tum:
case RISCVVector::BI__builtin_rvv_vsaddu_vx_tum:
  ID = Intrinsic::riscv_vsaddu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsaddu_vv_m:
case RISCVVector::BI__builtin_rvv_vsaddu_vx_m:
  ID = Intrinsic::riscv_vsaddu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsaddu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vsaddu_vx_tumu:
  ID = Intrinsic::riscv_vsaddu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsaddu_vv_mu:
case RISCVVector::BI__builtin_rvv_vsaddu_vx_mu:
  ID = Intrinsic::riscv_vsaddu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsbc_vvm_tu:
case RISCVVector::BI__builtin_rvv_vsbc_vxm_tu:
  ID = Intrinsic::riscv_vsbc;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsbc_vvm:
case RISCVVector::BI__builtin_rvv_vsbc_vxm:
  ID = Intrinsic::riscv_vsbc;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vse8_v:
case RISCVVector::BI__builtin_rvv_vse16_v:
case RISCVVector::BI__builtin_rvv_vse32_v:
case RISCVVector::BI__builtin_rvv_vse64_v:
  ID = Intrinsic::riscv_vse;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

      return emitRVVVSEMaskBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vse8_v_m:
case RISCVVector::BI__builtin_rvv_vse16_v_m:
case RISCVVector::BI__builtin_rvv_vse32_v_m:
case RISCVVector::BI__builtin_rvv_vse64_v_m:
  ID = Intrinsic::riscv_vse_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

      return emitRVVVSEMaskBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vsetvli:
  ID = Intrinsic::riscv_vsetvli;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

      return emitRVVVsetvliBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vsetvlimax:
  ID = Intrinsic::riscv_vsetvlimax;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

      return emitRVVVsetvliBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vsext_vf2_tu:
case RISCVVector::BI__builtin_rvv_vsext_vf4_tu:
case RISCVVector::BI__builtin_rvv_vsext_vf8_tu:
  ID = Intrinsic::riscv_vsext;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsext_vf2:
case RISCVVector::BI__builtin_rvv_vsext_vf4:
case RISCVVector::BI__builtin_rvv_vsext_vf8:
  ID = Intrinsic::riscv_vsext;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsext_vf2_tum:
case RISCVVector::BI__builtin_rvv_vsext_vf4_tum:
case RISCVVector::BI__builtin_rvv_vsext_vf8_tum:
  ID = Intrinsic::riscv_vsext_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsext_vf2_m:
case RISCVVector::BI__builtin_rvv_vsext_vf4_m:
case RISCVVector::BI__builtin_rvv_vsext_vf8_m:
  ID = Intrinsic::riscv_vsext_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsext_vf2_tumu:
case RISCVVector::BI__builtin_rvv_vsext_vf4_tumu:
case RISCVVector::BI__builtin_rvv_vsext_vf8_tumu:
  ID = Intrinsic::riscv_vsext_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsext_vf2_mu:
case RISCVVector::BI__builtin_rvv_vsext_vf4_mu:
case RISCVVector::BI__builtin_rvv_vsext_vf8_mu:
  ID = Intrinsic::riscv_vsext_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsha2ch_vv_tu:
  ID = Intrinsic::riscv_vsha2ch;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsha2ch_vv:
  ID = Intrinsic::riscv_vsha2ch;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsha2cl_vv_tu:
  ID = Intrinsic::riscv_vsha2cl;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsha2cl_vv:
  ID = Intrinsic::riscv_vsha2cl;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsha2ms_vv_tu:
  ID = Intrinsic::riscv_vsha2ms;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsha2ms_vv:
  ID = Intrinsic::riscv_vsha2ms;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1down_vx_tu:
  ID = Intrinsic::riscv_vslide1down;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1down_vx:
  ID = Intrinsic::riscv_vslide1down;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1down_vx_tum:
  ID = Intrinsic::riscv_vslide1down_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1down_vx_m:
  ID = Intrinsic::riscv_vslide1down_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1down_vx_tumu:
  ID = Intrinsic::riscv_vslide1down_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1down_vx_mu:
  ID = Intrinsic::riscv_vslide1down_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1up_vx_tu:
  ID = Intrinsic::riscv_vslide1up;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1up_vx:
  ID = Intrinsic::riscv_vslide1up;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1up_vx_tum:
  ID = Intrinsic::riscv_vslide1up_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1up_vx_m:
  ID = Intrinsic::riscv_vslide1up_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1up_vx_tumu:
  ID = Intrinsic::riscv_vslide1up_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslide1up_vx_mu:
  ID = Intrinsic::riscv_vslide1up_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslidedown_vx_tu:
  ID = Intrinsic::riscv_vslidedown;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

      if (IsMasked) {
        std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
        if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
          Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      } else {
        if (PolicyAttrs & RVV_VTA)
          Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      }

      Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      IntrinsicTypes = {ResultType, Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vslidedown_vx:
  ID = Intrinsic::riscv_vslidedown;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

      if (IsMasked) {
        std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
        if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
          Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      } else {
        if (PolicyAttrs & RVV_VTA)
          Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      }

      Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      IntrinsicTypes = {ResultType, Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vslidedown_vx_tum:
  ID = Intrinsic::riscv_vslidedown_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

      if (IsMasked) {
        std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
        if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
          Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      } else {
        if (PolicyAttrs & RVV_VTA)
          Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      }

      Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      IntrinsicTypes = {ResultType, Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vslidedown_vx_m:
  ID = Intrinsic::riscv_vslidedown_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

      if (IsMasked) {
        std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
        if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
          Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      } else {
        if (PolicyAttrs & RVV_VTA)
          Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      }

      Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      IntrinsicTypes = {ResultType, Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vslidedown_vx_tumu:
  ID = Intrinsic::riscv_vslidedown_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

      if (IsMasked) {
        std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
        if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
          Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      } else {
        if (PolicyAttrs & RVV_VTA)
          Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      }

      Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      IntrinsicTypes = {ResultType, Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vslidedown_vx_mu:
  ID = Intrinsic::riscv_vslidedown_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

      if (IsMasked) {
        std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
        if ((PolicyAttrs & RVV_VTA) && (PolicyAttrs & RVV_VMA))
          Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      } else {
        if (PolicyAttrs & RVV_VTA)
          Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
      }

      Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
      IntrinsicTypes = {ResultType, Ops.back()->getType()};
    break;
case RISCVVector::BI__builtin_rvv_vslideup_vx_tu:
  ID = Intrinsic::riscv_vslideup;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslideup_vx:
  ID = Intrinsic::riscv_vslideup;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslideup_vx_tum:
  ID = Intrinsic::riscv_vslideup_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslideup_vx_m:
  ID = Intrinsic::riscv_vslideup_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslideup_vx_tumu:
  ID = Intrinsic::riscv_vslideup_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vslideup_vx_mu:
  ID = Intrinsic::riscv_vslideup_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsll_vv_tu:
case RISCVVector::BI__builtin_rvv_vsll_vx_tu:
  ID = Intrinsic::riscv_vsll;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsll_vv:
case RISCVVector::BI__builtin_rvv_vsll_vx:
  ID = Intrinsic::riscv_vsll;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsll_vv_tum:
case RISCVVector::BI__builtin_rvv_vsll_vx_tum:
  ID = Intrinsic::riscv_vsll_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsll_vv_m:
case RISCVVector::BI__builtin_rvv_vsll_vx_m:
  ID = Intrinsic::riscv_vsll_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsll_vv_tumu:
case RISCVVector::BI__builtin_rvv_vsll_vx_tumu:
  ID = Intrinsic::riscv_vsll_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsll_vv_mu:
case RISCVVector::BI__builtin_rvv_vsll_vx_mu:
  ID = Intrinsic::riscv_vsll_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsm_v:
  ID = Intrinsic::riscv_vsm;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

      return emitRVVVSEMaskBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
    break;
case RISCVVector::BI__builtin_rvv_vsm3c_vi_tu:
  ID = Intrinsic::riscv_vsm3c;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsm3c_vi:
  ID = Intrinsic::riscv_vsm3c;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsm3me_vv_tu:
  ID = Intrinsic::riscv_vsm3me;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsm3me_vv:
  ID = Intrinsic::riscv_vsm3me;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsm4k_vi_tu:
  ID = Intrinsic::riscv_vsm4k;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsm4k_vi:
  ID = Intrinsic::riscv_vsm4k;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsm4r_vs_tu:
  ID = Intrinsic::riscv_vsm4r_vs;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsm4r_vs:
  ID = Intrinsic::riscv_vsm4r_vs;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsm4r_vv_tu:
  ID = Intrinsic::riscv_vsm4r_vv;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsm4r_vv:
  ID = Intrinsic::riscv_vsm4r_vv;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsmul_vv_tu:
case RISCVVector::BI__builtin_rvv_vsmul_vx_tu:
  ID = Intrinsic::riscv_vsmul;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vsmul_vv:
case RISCVVector::BI__builtin_rvv_vsmul_vx:
  ID = Intrinsic::riscv_vsmul;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vsmul_vv_tum:
case RISCVVector::BI__builtin_rvv_vsmul_vx_tum:
  ID = Intrinsic::riscv_vsmul_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vsmul_vv_m:
case RISCVVector::BI__builtin_rvv_vsmul_vx_m:
  ID = Intrinsic::riscv_vsmul_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vsmul_vv_tumu:
case RISCVVector::BI__builtin_rvv_vsmul_vx_tumu:
  ID = Intrinsic::riscv_vsmul_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vsmul_vv_mu:
case RISCVVector::BI__builtin_rvv_vsmul_vx_mu:
  ID = Intrinsic::riscv_vsmul_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vsoxei8_v:
case RISCVVector::BI__builtin_rvv_vsoxei16_v:
case RISCVVector::BI__builtin_rvv_vsoxei32_v:
case RISCVVector::BI__builtin_rvv_vsoxei64_v:
  ID = Intrinsic::riscv_vsoxei;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVIndexedStoreBuiltin(this, E, ReturnValue, ResultType, ID,
                                          Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vsoxei8_v_m:
case RISCVVector::BI__builtin_rvv_vsoxei16_v_m:
case RISCVVector::BI__builtin_rvv_vsoxei32_v_m:
case RISCVVector::BI__builtin_rvv_vsoxei64_v_m:
  ID = Intrinsic::riscv_vsoxei_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVIndexedStoreBuiltin(this, E, ReturnValue, ResultType, ID,
                                          Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vsoxseg2ei8_v:
case RISCVVector::BI__builtin_rvv_vsoxseg2ei16_v:
case RISCVVector::BI__builtin_rvv_vsoxseg2ei32_v:
case RISCVVector::BI__builtin_rvv_vsoxseg2ei64_v:
  ID = Intrinsic::riscv_vsoxseg2;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsoxseg2ei8_v_m:
case RISCVVector::BI__builtin_rvv_vsoxseg2ei16_v_m:
case RISCVVector::BI__builtin_rvv_vsoxseg2ei32_v_m:
case RISCVVector::BI__builtin_rvv_vsoxseg2ei64_v_m:
  ID = Intrinsic::riscv_vsoxseg2_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsoxseg3ei8_v:
case RISCVVector::BI__builtin_rvv_vsoxseg3ei16_v:
case RISCVVector::BI__builtin_rvv_vsoxseg3ei32_v:
case RISCVVector::BI__builtin_rvv_vsoxseg3ei64_v:
  ID = Intrinsic::riscv_vsoxseg3;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsoxseg3ei8_v_m:
case RISCVVector::BI__builtin_rvv_vsoxseg3ei16_v_m:
case RISCVVector::BI__builtin_rvv_vsoxseg3ei32_v_m:
case RISCVVector::BI__builtin_rvv_vsoxseg3ei64_v_m:
  ID = Intrinsic::riscv_vsoxseg3_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsoxseg4ei8_v:
case RISCVVector::BI__builtin_rvv_vsoxseg4ei16_v:
case RISCVVector::BI__builtin_rvv_vsoxseg4ei32_v:
case RISCVVector::BI__builtin_rvv_vsoxseg4ei64_v:
  ID = Intrinsic::riscv_vsoxseg4;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsoxseg4ei8_v_m:
case RISCVVector::BI__builtin_rvv_vsoxseg4ei16_v_m:
case RISCVVector::BI__builtin_rvv_vsoxseg4ei32_v_m:
case RISCVVector::BI__builtin_rvv_vsoxseg4ei64_v_m:
  ID = Intrinsic::riscv_vsoxseg4_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsoxseg5ei8_v:
case RISCVVector::BI__builtin_rvv_vsoxseg5ei16_v:
case RISCVVector::BI__builtin_rvv_vsoxseg5ei32_v:
case RISCVVector::BI__builtin_rvv_vsoxseg5ei64_v:
  ID = Intrinsic::riscv_vsoxseg5;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsoxseg5ei8_v_m:
case RISCVVector::BI__builtin_rvv_vsoxseg5ei16_v_m:
case RISCVVector::BI__builtin_rvv_vsoxseg5ei32_v_m:
case RISCVVector::BI__builtin_rvv_vsoxseg5ei64_v_m:
  ID = Intrinsic::riscv_vsoxseg5_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsoxseg6ei8_v:
case RISCVVector::BI__builtin_rvv_vsoxseg6ei16_v:
case RISCVVector::BI__builtin_rvv_vsoxseg6ei32_v:
case RISCVVector::BI__builtin_rvv_vsoxseg6ei64_v:
  ID = Intrinsic::riscv_vsoxseg6;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsoxseg6ei8_v_m:
case RISCVVector::BI__builtin_rvv_vsoxseg6ei16_v_m:
case RISCVVector::BI__builtin_rvv_vsoxseg6ei32_v_m:
case RISCVVector::BI__builtin_rvv_vsoxseg6ei64_v_m:
  ID = Intrinsic::riscv_vsoxseg6_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsoxseg7ei8_v:
case RISCVVector::BI__builtin_rvv_vsoxseg7ei16_v:
case RISCVVector::BI__builtin_rvv_vsoxseg7ei32_v:
case RISCVVector::BI__builtin_rvv_vsoxseg7ei64_v:
  ID = Intrinsic::riscv_vsoxseg7;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsoxseg7ei8_v_m:
case RISCVVector::BI__builtin_rvv_vsoxseg7ei16_v_m:
case RISCVVector::BI__builtin_rvv_vsoxseg7ei32_v_m:
case RISCVVector::BI__builtin_rvv_vsoxseg7ei64_v_m:
  ID = Intrinsic::riscv_vsoxseg7_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsoxseg8ei8_v:
case RISCVVector::BI__builtin_rvv_vsoxseg8ei16_v:
case RISCVVector::BI__builtin_rvv_vsoxseg8ei32_v:
case RISCVVector::BI__builtin_rvv_vsoxseg8ei64_v:
  ID = Intrinsic::riscv_vsoxseg8;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsoxseg8ei8_v_m:
case RISCVVector::BI__builtin_rvv_vsoxseg8ei16_v_m:
case RISCVVector::BI__builtin_rvv_vsoxseg8ei32_v_m:
case RISCVVector::BI__builtin_rvv_vsoxseg8ei64_v_m:
  ID = Intrinsic::riscv_vsoxseg8_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsra_vv_tu:
case RISCVVector::BI__builtin_rvv_vsra_vx_tu:
  ID = Intrinsic::riscv_vsra;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsra_vv:
case RISCVVector::BI__builtin_rvv_vsra_vx:
  ID = Intrinsic::riscv_vsra;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsra_vv_tum:
case RISCVVector::BI__builtin_rvv_vsra_vx_tum:
  ID = Intrinsic::riscv_vsra_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsra_vv_m:
case RISCVVector::BI__builtin_rvv_vsra_vx_m:
  ID = Intrinsic::riscv_vsra_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsra_vv_tumu:
case RISCVVector::BI__builtin_rvv_vsra_vx_tumu:
  ID = Intrinsic::riscv_vsra_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsra_vv_mu:
case RISCVVector::BI__builtin_rvv_vsra_vx_mu:
  ID = Intrinsic::riscv_vsra_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsrl_vv_tu:
case RISCVVector::BI__builtin_rvv_vsrl_vx_tu:
  ID = Intrinsic::riscv_vsrl;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsrl_vv:
case RISCVVector::BI__builtin_rvv_vsrl_vx:
  ID = Intrinsic::riscv_vsrl;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsrl_vv_tum:
case RISCVVector::BI__builtin_rvv_vsrl_vx_tum:
  ID = Intrinsic::riscv_vsrl_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsrl_vv_m:
case RISCVVector::BI__builtin_rvv_vsrl_vx_m:
  ID = Intrinsic::riscv_vsrl_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsrl_vv_tumu:
case RISCVVector::BI__builtin_rvv_vsrl_vx_tumu:
  ID = Intrinsic::riscv_vsrl_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsrl_vv_mu:
case RISCVVector::BI__builtin_rvv_vsrl_vx_mu:
  ID = Intrinsic::riscv_vsrl_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsse8_v:
case RISCVVector::BI__builtin_rvv_vsse16_v:
case RISCVVector::BI__builtin_rvv_vsse32_v:
case RISCVVector::BI__builtin_rvv_vsse64_v:
  ID = Intrinsic::riscv_vsse;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVVSSEBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                  PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vsse8_v_m:
case RISCVVector::BI__builtin_rvv_vsse16_v_m:
case RISCVVector::BI__builtin_rvv_vsse32_v_m:
case RISCVVector::BI__builtin_rvv_vsse64_v_m:
  ID = Intrinsic::riscv_vsse_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVVSSEBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                  PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vsseg2e8_v:
  ID = Intrinsic::riscv_vsseg2;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg2e16_v:
  ID = Intrinsic::riscv_vsseg2;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg2e32_v:
  ID = Intrinsic::riscv_vsseg2;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg2e64_v:
  ID = Intrinsic::riscv_vsseg2;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg2;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg2;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg2;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg2;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg2e8_v_m:
  ID = Intrinsic::riscv_vsseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg2e16_v_m:
  ID = Intrinsic::riscv_vsseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg2e32_v_m:
  ID = Intrinsic::riscv_vsseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg2e64_v_m:
  ID = Intrinsic::riscv_vsseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg3e8_v:
  ID = Intrinsic::riscv_vsseg3;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg3e16_v:
  ID = Intrinsic::riscv_vsseg3;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg3e32_v:
  ID = Intrinsic::riscv_vsseg3;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg3e64_v:
  ID = Intrinsic::riscv_vsseg3;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg3;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg3;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg3;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg3;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg3e8_v_m:
  ID = Intrinsic::riscv_vsseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg3e16_v_m:
  ID = Intrinsic::riscv_vsseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg3e32_v_m:
  ID = Intrinsic::riscv_vsseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg3e64_v_m:
  ID = Intrinsic::riscv_vsseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg4e8_v:
  ID = Intrinsic::riscv_vsseg4;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg4e16_v:
  ID = Intrinsic::riscv_vsseg4;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg4e32_v:
  ID = Intrinsic::riscv_vsseg4;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg4e64_v:
  ID = Intrinsic::riscv_vsseg4;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg4;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg4;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg4;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg4;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg4e8_v_m:
  ID = Intrinsic::riscv_vsseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg4e16_v_m:
  ID = Intrinsic::riscv_vsseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg4e32_v_m:
  ID = Intrinsic::riscv_vsseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg4e64_v_m:
  ID = Intrinsic::riscv_vsseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg5e8_v:
  ID = Intrinsic::riscv_vsseg5;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg5e16_v:
  ID = Intrinsic::riscv_vsseg5;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg5e32_v:
  ID = Intrinsic::riscv_vsseg5;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg5e64_v:
  ID = Intrinsic::riscv_vsseg5;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg5;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg5;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg5;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg5;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg5e8_v_m:
  ID = Intrinsic::riscv_vsseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg5e16_v_m:
  ID = Intrinsic::riscv_vsseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg5e32_v_m:
  ID = Intrinsic::riscv_vsseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg5e64_v_m:
  ID = Intrinsic::riscv_vsseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg6e8_v:
  ID = Intrinsic::riscv_vsseg6;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg6e16_v:
  ID = Intrinsic::riscv_vsseg6;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg6e32_v:
  ID = Intrinsic::riscv_vsseg6;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg6e64_v:
  ID = Intrinsic::riscv_vsseg6;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg6;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg6;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg6;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg6;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg6e8_v_m:
  ID = Intrinsic::riscv_vsseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg6e16_v_m:
  ID = Intrinsic::riscv_vsseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg6e32_v_m:
  ID = Intrinsic::riscv_vsseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg6e64_v_m:
  ID = Intrinsic::riscv_vsseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg7e8_v:
  ID = Intrinsic::riscv_vsseg7;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg7e16_v:
  ID = Intrinsic::riscv_vsseg7;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg7e32_v:
  ID = Intrinsic::riscv_vsseg7;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg7e64_v:
  ID = Intrinsic::riscv_vsseg7;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg7;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg7;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg7;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg7;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg7e8_v_m:
  ID = Intrinsic::riscv_vsseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg7e16_v_m:
  ID = Intrinsic::riscv_vsseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg7e32_v_m:
  ID = Intrinsic::riscv_vsseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg7e64_v_m:
  ID = Intrinsic::riscv_vsseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg8e8_v:
  ID = Intrinsic::riscv_vsseg8;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg8e16_v:
  ID = Intrinsic::riscv_vsseg8;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg8e32_v:
  ID = Intrinsic::riscv_vsseg8;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg8e64_v:
  ID = Intrinsic::riscv_vsseg8;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg8;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg8;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg8;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg8;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg8e8_v_m:
  ID = Intrinsic::riscv_vsseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg8e16_v_m:
  ID = Intrinsic::riscv_vsseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg8e32_v_m:
  ID = Intrinsic::riscv_vsseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vsseg8e64_v_m:
  ID = Intrinsic::riscv_vsseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
  ID = Intrinsic::riscv_vsseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

            return emitRVVUnitStridedSegStoreTupleBuiltin(
                this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs,
                IsMasked, SegInstSEW);
          break;
case RISCVVector::BI__builtin_rvv_vssra_vv_tu:
case RISCVVector::BI__builtin_rvv_vssra_vx_tu:
  ID = Intrinsic::riscv_vssra;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vssra_vv:
case RISCVVector::BI__builtin_rvv_vssra_vx:
  ID = Intrinsic::riscv_vssra;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vssra_vv_tum:
case RISCVVector::BI__builtin_rvv_vssra_vx_tum:
  ID = Intrinsic::riscv_vssra_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vssra_vv_m:
case RISCVVector::BI__builtin_rvv_vssra_vx_m:
  ID = Intrinsic::riscv_vssra_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vssra_vv_tumu:
case RISCVVector::BI__builtin_rvv_vssra_vx_tumu:
  ID = Intrinsic::riscv_vssra_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vssra_vv_mu:
case RISCVVector::BI__builtin_rvv_vssra_vx_mu:
  ID = Intrinsic::riscv_vssra_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vssrl_vv_tu:
case RISCVVector::BI__builtin_rvv_vssrl_vx_tu:
  ID = Intrinsic::riscv_vssrl;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vssrl_vv:
case RISCVVector::BI__builtin_rvv_vssrl_vx:
  ID = Intrinsic::riscv_vssrl;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vssrl_vv_tum:
case RISCVVector::BI__builtin_rvv_vssrl_vx_tum:
  ID = Intrinsic::riscv_vssrl_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vssrl_vv_m:
case RISCVVector::BI__builtin_rvv_vssrl_vx_m:
  ID = Intrinsic::riscv_vssrl_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vssrl_vv_tumu:
case RISCVVector::BI__builtin_rvv_vssrl_vx_tumu:
  ID = Intrinsic::riscv_vssrl_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vssrl_vv_mu:
case RISCVVector::BI__builtin_rvv_vssrl_vx_mu:
  ID = Intrinsic::riscv_vssrl_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

  {
    return emitRVVAveragingBuiltin(this, E, ReturnValue, ResultType, ID, Ops,
                                   PolicyAttrs, IsMasked, SegInstSEW);
  }
break;
case RISCVVector::BI__builtin_rvv_vssseg2e8_v:
  ID = Intrinsic::riscv_vssseg2;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg2e16_v:
  ID = Intrinsic::riscv_vssseg2;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg2e32_v:
  ID = Intrinsic::riscv_vssseg2;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg2e64_v:
  ID = Intrinsic::riscv_vssseg2;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg2;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg2;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg2;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg2;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg2e8_v_m:
  ID = Intrinsic::riscv_vssseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg2e16_v_m:
  ID = Intrinsic::riscv_vssseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg2e32_v_m:
  ID = Intrinsic::riscv_vssseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg2e64_v_m:
  ID = Intrinsic::riscv_vssseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg2_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg3e8_v:
  ID = Intrinsic::riscv_vssseg3;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg3e16_v:
  ID = Intrinsic::riscv_vssseg3;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg3e32_v:
  ID = Intrinsic::riscv_vssseg3;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg3e64_v:
  ID = Intrinsic::riscv_vssseg3;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg3;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg3;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg3;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg3;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg3e8_v_m:
  ID = Intrinsic::riscv_vssseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg3e16_v_m:
  ID = Intrinsic::riscv_vssseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg3e32_v_m:
  ID = Intrinsic::riscv_vssseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg3e64_v_m:
  ID = Intrinsic::riscv_vssseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg3_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg4e8_v:
  ID = Intrinsic::riscv_vssseg4;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg4e16_v:
  ID = Intrinsic::riscv_vssseg4;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg4e32_v:
  ID = Intrinsic::riscv_vssseg4;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg4e64_v:
  ID = Intrinsic::riscv_vssseg4;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg4;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg4;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg4;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg4;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg4e8_v_m:
  ID = Intrinsic::riscv_vssseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg4e16_v_m:
  ID = Intrinsic::riscv_vssseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg4e32_v_m:
  ID = Intrinsic::riscv_vssseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg4e64_v_m:
  ID = Intrinsic::riscv_vssseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg4_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg5e8_v:
  ID = Intrinsic::riscv_vssseg5;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg5e16_v:
  ID = Intrinsic::riscv_vssseg5;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg5e32_v:
  ID = Intrinsic::riscv_vssseg5;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg5e64_v:
  ID = Intrinsic::riscv_vssseg5;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg5;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg5;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg5;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg5;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg5e8_v_m:
  ID = Intrinsic::riscv_vssseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg5e16_v_m:
  ID = Intrinsic::riscv_vssseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg5e32_v_m:
  ID = Intrinsic::riscv_vssseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg5e64_v_m:
  ID = Intrinsic::riscv_vssseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg5_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg6e8_v:
  ID = Intrinsic::riscv_vssseg6;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg6e16_v:
  ID = Intrinsic::riscv_vssseg6;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg6e32_v:
  ID = Intrinsic::riscv_vssseg6;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg6e64_v:
  ID = Intrinsic::riscv_vssseg6;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg6;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg6;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg6;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg6;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg6e8_v_m:
  ID = Intrinsic::riscv_vssseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg6e16_v_m:
  ID = Intrinsic::riscv_vssseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg6e32_v_m:
  ID = Intrinsic::riscv_vssseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg6e64_v_m:
  ID = Intrinsic::riscv_vssseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg6_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg7e8_v:
  ID = Intrinsic::riscv_vssseg7;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg7e16_v:
  ID = Intrinsic::riscv_vssseg7;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg7e32_v:
  ID = Intrinsic::riscv_vssseg7;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg7e64_v:
  ID = Intrinsic::riscv_vssseg7;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg7;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg7;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg7;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg7;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg7e8_v_m:
  ID = Intrinsic::riscv_vssseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg7e16_v_m:
  ID = Intrinsic::riscv_vssseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg7e32_v_m:
  ID = Intrinsic::riscv_vssseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg7e64_v_m:
  ID = Intrinsic::riscv_vssseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg7_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg8e8_v:
  ID = Intrinsic::riscv_vssseg8;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg8e16_v:
  ID = Intrinsic::riscv_vssseg8;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg8e32_v:
  ID = Intrinsic::riscv_vssseg8;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg8e64_v:
  ID = Intrinsic::riscv_vssseg8;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg8;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg8;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg8;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg8;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = false;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg8e8_v_m:
  ID = Intrinsic::riscv_vssseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 3;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg8e16_v_m:
  ID = Intrinsic::riscv_vssseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg8e32_v_m:
  ID = Intrinsic::riscv_vssseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssseg8e64_v_m:
  ID = Intrinsic::riscv_vssseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 5;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 6;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
  ID = Intrinsic::riscv_vssseg8_mask;
  PolicyAttrs = 3;
  SegInstSEW = 4;
IsMasked = true;

      return emitRVVStridedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vssub_vv_tu:
case RISCVVector::BI__builtin_rvv_vssub_vx_tu:
  ID = Intrinsic::riscv_vssub;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vssub_vv:
case RISCVVector::BI__builtin_rvv_vssub_vx:
  ID = Intrinsic::riscv_vssub;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vssub_vv_tum:
case RISCVVector::BI__builtin_rvv_vssub_vx_tum:
  ID = Intrinsic::riscv_vssub_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vssub_vv_m:
case RISCVVector::BI__builtin_rvv_vssub_vx_m:
  ID = Intrinsic::riscv_vssub_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vssub_vv_tumu:
case RISCVVector::BI__builtin_rvv_vssub_vx_tumu:
  ID = Intrinsic::riscv_vssub_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vssub_vv_mu:
case RISCVVector::BI__builtin_rvv_vssub_vx_mu:
  ID = Intrinsic::riscv_vssub_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vssubu_vv_tu:
case RISCVVector::BI__builtin_rvv_vssubu_vx_tu:
  ID = Intrinsic::riscv_vssubu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vssubu_vv:
case RISCVVector::BI__builtin_rvv_vssubu_vx:
  ID = Intrinsic::riscv_vssubu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vssubu_vv_tum:
case RISCVVector::BI__builtin_rvv_vssubu_vx_tum:
  ID = Intrinsic::riscv_vssubu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vssubu_vv_m:
case RISCVVector::BI__builtin_rvv_vssubu_vx_m:
  ID = Intrinsic::riscv_vssubu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vssubu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vssubu_vx_tumu:
  ID = Intrinsic::riscv_vssubu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vssubu_vv_mu:
case RISCVVector::BI__builtin_rvv_vssubu_vx_mu:
  ID = Intrinsic::riscv_vssubu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsub_vv_tu:
case RISCVVector::BI__builtin_rvv_vsub_vx_tu:
  ID = Intrinsic::riscv_vsub;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsub_vv:
case RISCVVector::BI__builtin_rvv_vsub_vx:
  ID = Intrinsic::riscv_vsub;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsub_vv_tum:
case RISCVVector::BI__builtin_rvv_vsub_vx_tum:
  ID = Intrinsic::riscv_vsub_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsub_vv_m:
case RISCVVector::BI__builtin_rvv_vsub_vx_m:
  ID = Intrinsic::riscv_vsub_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsub_vv_tumu:
case RISCVVector::BI__builtin_rvv_vsub_vx_tumu:
  ID = Intrinsic::riscv_vsub_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsub_vv_mu:
case RISCVVector::BI__builtin_rvv_vsub_vx_mu:
  ID = Intrinsic::riscv_vsub_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vsuxei8_v:
case RISCVVector::BI__builtin_rvv_vsuxei64_v:
case RISCVVector::BI__builtin_rvv_vsuxei16_v:
case RISCVVector::BI__builtin_rvv_vsuxei32_v:
  ID = Intrinsic::riscv_vsuxei;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVIndexedStoreBuiltin(this, E, ReturnValue, ResultType, ID,
                                          Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vsuxei8_v_m:
case RISCVVector::BI__builtin_rvv_vsuxei64_v_m:
case RISCVVector::BI__builtin_rvv_vsuxei16_v_m:
case RISCVVector::BI__builtin_rvv_vsuxei32_v_m:
  ID = Intrinsic::riscv_vsuxei_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVIndexedStoreBuiltin(this, E, ReturnValue, ResultType, ID,
                                          Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vsuxseg2ei8_v:
case RISCVVector::BI__builtin_rvv_vsuxseg2ei16_v:
case RISCVVector::BI__builtin_rvv_vsuxseg2ei32_v:
case RISCVVector::BI__builtin_rvv_vsuxseg2ei64_v:
  ID = Intrinsic::riscv_vsuxseg2;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsuxseg2ei8_v_m:
case RISCVVector::BI__builtin_rvv_vsuxseg2ei16_v_m:
case RISCVVector::BI__builtin_rvv_vsuxseg2ei32_v_m:
case RISCVVector::BI__builtin_rvv_vsuxseg2ei64_v_m:
  ID = Intrinsic::riscv_vsuxseg2_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsuxseg3ei8_v:
case RISCVVector::BI__builtin_rvv_vsuxseg3ei16_v:
case RISCVVector::BI__builtin_rvv_vsuxseg3ei32_v:
case RISCVVector::BI__builtin_rvv_vsuxseg3ei64_v:
  ID = Intrinsic::riscv_vsuxseg3;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsuxseg3ei8_v_m:
case RISCVVector::BI__builtin_rvv_vsuxseg3ei16_v_m:
case RISCVVector::BI__builtin_rvv_vsuxseg3ei32_v_m:
case RISCVVector::BI__builtin_rvv_vsuxseg3ei64_v_m:
  ID = Intrinsic::riscv_vsuxseg3_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsuxseg4ei8_v:
case RISCVVector::BI__builtin_rvv_vsuxseg4ei16_v:
case RISCVVector::BI__builtin_rvv_vsuxseg4ei32_v:
case RISCVVector::BI__builtin_rvv_vsuxseg4ei64_v:
  ID = Intrinsic::riscv_vsuxseg4;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsuxseg4ei8_v_m:
case RISCVVector::BI__builtin_rvv_vsuxseg4ei16_v_m:
case RISCVVector::BI__builtin_rvv_vsuxseg4ei32_v_m:
case RISCVVector::BI__builtin_rvv_vsuxseg4ei64_v_m:
  ID = Intrinsic::riscv_vsuxseg4_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsuxseg5ei8_v:
case RISCVVector::BI__builtin_rvv_vsuxseg5ei16_v:
case RISCVVector::BI__builtin_rvv_vsuxseg5ei32_v:
case RISCVVector::BI__builtin_rvv_vsuxseg5ei64_v:
  ID = Intrinsic::riscv_vsuxseg5;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsuxseg5ei8_v_m:
case RISCVVector::BI__builtin_rvv_vsuxseg5ei16_v_m:
case RISCVVector::BI__builtin_rvv_vsuxseg5ei32_v_m:
case RISCVVector::BI__builtin_rvv_vsuxseg5ei64_v_m:
  ID = Intrinsic::riscv_vsuxseg5_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsuxseg6ei8_v:
case RISCVVector::BI__builtin_rvv_vsuxseg6ei16_v:
case RISCVVector::BI__builtin_rvv_vsuxseg6ei32_v:
case RISCVVector::BI__builtin_rvv_vsuxseg6ei64_v:
  ID = Intrinsic::riscv_vsuxseg6;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsuxseg6ei8_v_m:
case RISCVVector::BI__builtin_rvv_vsuxseg6ei16_v_m:
case RISCVVector::BI__builtin_rvv_vsuxseg6ei32_v_m:
case RISCVVector::BI__builtin_rvv_vsuxseg6ei64_v_m:
  ID = Intrinsic::riscv_vsuxseg6_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsuxseg7ei8_v:
case RISCVVector::BI__builtin_rvv_vsuxseg7ei16_v:
case RISCVVector::BI__builtin_rvv_vsuxseg7ei32_v:
case RISCVVector::BI__builtin_rvv_vsuxseg7ei64_v:
  ID = Intrinsic::riscv_vsuxseg7;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsuxseg7ei8_v_m:
case RISCVVector::BI__builtin_rvv_vsuxseg7ei16_v_m:
case RISCVVector::BI__builtin_rvv_vsuxseg7ei32_v_m:
case RISCVVector::BI__builtin_rvv_vsuxseg7ei64_v_m:
  ID = Intrinsic::riscv_vsuxseg7_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsuxseg8ei8_v:
case RISCVVector::BI__builtin_rvv_vsuxseg8ei16_v:
case RISCVVector::BI__builtin_rvv_vsuxseg8ei32_v:
case RISCVVector::BI__builtin_rvv_vsuxseg8ei64_v:
  ID = Intrinsic::riscv_vsuxseg8;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(0)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = false;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vsuxseg8ei8_v_m:
case RISCVVector::BI__builtin_rvv_vsuxseg8ei16_v_m:
case RISCVVector::BI__builtin_rvv_vsuxseg8ei32_v_m:
case RISCVVector::BI__builtin_rvv_vsuxseg8ei64_v_m:
  ID = Intrinsic::riscv_vsuxseg8_mask;
  PolicyAttrs = 3;
  {
    auto PointeeType = E->getArg(1)->getType()->getPointeeType();
    SegInstSEW = llvm::Log2_64(getContext().getTypeSize(PointeeType));
  }
IsMasked = true;

      return emitRVVIndexedSegStoreTupleBuiltin(
          this, E, ReturnValue, ResultType, ID, Ops, PolicyAttrs, IsMasked,
          SegInstSEW);
            break;
case RISCVVector::BI__builtin_rvv_vwadd_vv_tu:
case RISCVVector::BI__builtin_rvv_vwadd_vx_tu:
  ID = Intrinsic::riscv_vwadd;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwcvt_x_x_v_tu:
  ID = Intrinsic::riscv_vwadd;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVPseudoVWCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vwadd_vv:
case RISCVVector::BI__builtin_rvv_vwadd_vx:
  ID = Intrinsic::riscv_vwadd;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwcvt_x_x_v:
  ID = Intrinsic::riscv_vwadd;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVPseudoVWCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vwadd_vv_tum:
case RISCVVector::BI__builtin_rvv_vwadd_vx_tum:
  ID = Intrinsic::riscv_vwadd_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwcvt_x_x_v_tum:
  ID = Intrinsic::riscv_vwadd_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVWCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vwadd_vv_m:
case RISCVVector::BI__builtin_rvv_vwadd_vx_m:
  ID = Intrinsic::riscv_vwadd_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwcvt_x_x_v_m:
  ID = Intrinsic::riscv_vwadd_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVWCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vwadd_vv_tumu:
case RISCVVector::BI__builtin_rvv_vwadd_vx_tumu:
  ID = Intrinsic::riscv_vwadd_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwcvt_x_x_v_tumu:
  ID = Intrinsic::riscv_vwadd_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVWCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vwadd_vv_mu:
case RISCVVector::BI__builtin_rvv_vwadd_vx_mu:
  ID = Intrinsic::riscv_vwadd_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwcvt_x_x_v_mu:
  ID = Intrinsic::riscv_vwadd_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVWCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vwadd_wv_tu:
case RISCVVector::BI__builtin_rvv_vwadd_wx_tu:
  ID = Intrinsic::riscv_vwadd_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwadd_wv:
case RISCVVector::BI__builtin_rvv_vwadd_wx:
  ID = Intrinsic::riscv_vwadd_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwadd_wv_tum:
case RISCVVector::BI__builtin_rvv_vwadd_wx_tum:
  ID = Intrinsic::riscv_vwadd_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwadd_wv_m:
case RISCVVector::BI__builtin_rvv_vwadd_wx_m:
  ID = Intrinsic::riscv_vwadd_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwadd_wv_tumu:
case RISCVVector::BI__builtin_rvv_vwadd_wx_tumu:
  ID = Intrinsic::riscv_vwadd_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwadd_wv_mu:
case RISCVVector::BI__builtin_rvv_vwadd_wx_mu:
  ID = Intrinsic::riscv_vwadd_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwaddu_vv_tu:
  ID = Intrinsic::riscv_vwaddu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwcvtu_x_x_v_tu:
  ID = Intrinsic::riscv_vwaddu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVPseudoVWCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vwaddu_vx_tu:
  ID = Intrinsic::riscv_vwaddu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwaddu_vv:
  ID = Intrinsic::riscv_vwaddu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwcvtu_x_x_v:
  ID = Intrinsic::riscv_vwaddu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVPseudoVWCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vwaddu_vx:
  ID = Intrinsic::riscv_vwaddu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwaddu_vv_tum:
  ID = Intrinsic::riscv_vwaddu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwcvtu_x_x_v_tum:
  ID = Intrinsic::riscv_vwaddu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVWCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vwaddu_vx_tum:
  ID = Intrinsic::riscv_vwaddu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwaddu_vv_m:
  ID = Intrinsic::riscv_vwaddu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwcvtu_x_x_v_m:
  ID = Intrinsic::riscv_vwaddu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVWCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vwaddu_vx_m:
  ID = Intrinsic::riscv_vwaddu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwaddu_vv_tumu:
  ID = Intrinsic::riscv_vwaddu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwcvtu_x_x_v_tumu:
  ID = Intrinsic::riscv_vwaddu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVWCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vwaddu_vx_tumu:
  ID = Intrinsic::riscv_vwaddu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwaddu_vv_mu:
  ID = Intrinsic::riscv_vwaddu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwcvtu_x_x_v_mu:
  ID = Intrinsic::riscv_vwaddu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVWCVTBuiltin(this, E, ReturnValue, ResultType, ID,
                                         Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vwaddu_vx_mu:
  ID = Intrinsic::riscv_vwaddu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwaddu_wv_tu:
case RISCVVector::BI__builtin_rvv_vwaddu_wx_tu:
  ID = Intrinsic::riscv_vwaddu_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwaddu_wv:
case RISCVVector::BI__builtin_rvv_vwaddu_wx:
  ID = Intrinsic::riscv_vwaddu_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwaddu_wv_tum:
case RISCVVector::BI__builtin_rvv_vwaddu_wx_tum:
  ID = Intrinsic::riscv_vwaddu_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwaddu_wv_m:
case RISCVVector::BI__builtin_rvv_vwaddu_wx_m:
  ID = Intrinsic::riscv_vwaddu_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwaddu_wv_tumu:
case RISCVVector::BI__builtin_rvv_vwaddu_wx_tumu:
  ID = Intrinsic::riscv_vwaddu_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwaddu_wv_mu:
case RISCVVector::BI__builtin_rvv_vwaddu_wx_mu:
  ID = Intrinsic::riscv_vwaddu_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmacc_vv_tu:
case RISCVVector::BI__builtin_rvv_vwmacc_vx_tu:
  ID = Intrinsic::riscv_vwmacc;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmacc_vv:
case RISCVVector::BI__builtin_rvv_vwmacc_vx:
  ID = Intrinsic::riscv_vwmacc;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmacc_vv_tum:
case RISCVVector::BI__builtin_rvv_vwmacc_vx_tum:
  ID = Intrinsic::riscv_vwmacc_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmacc_vv_m:
case RISCVVector::BI__builtin_rvv_vwmacc_vx_m:
  ID = Intrinsic::riscv_vwmacc_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmacc_vv_tumu:
case RISCVVector::BI__builtin_rvv_vwmacc_vx_tumu:
  ID = Intrinsic::riscv_vwmacc_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmacc_vv_mu:
case RISCVVector::BI__builtin_rvv_vwmacc_vx_mu:
  ID = Intrinsic::riscv_vwmacc_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmaccsu_vv_tu:
case RISCVVector::BI__builtin_rvv_vwmaccsu_vx_tu:
  ID = Intrinsic::riscv_vwmaccsu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmaccsu_vv:
case RISCVVector::BI__builtin_rvv_vwmaccsu_vx:
  ID = Intrinsic::riscv_vwmaccsu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmaccsu_vv_tum:
case RISCVVector::BI__builtin_rvv_vwmaccsu_vx_tum:
  ID = Intrinsic::riscv_vwmaccsu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmaccsu_vv_m:
case RISCVVector::BI__builtin_rvv_vwmaccsu_vx_m:
  ID = Intrinsic::riscv_vwmaccsu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmaccsu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vwmaccsu_vx_tumu:
  ID = Intrinsic::riscv_vwmaccsu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmaccsu_vv_mu:
case RISCVVector::BI__builtin_rvv_vwmaccsu_vx_mu:
  ID = Intrinsic::riscv_vwmaccsu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmaccu_vv_tu:
case RISCVVector::BI__builtin_rvv_vwmaccu_vx_tu:
  ID = Intrinsic::riscv_vwmaccu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmaccu_vv:
case RISCVVector::BI__builtin_rvv_vwmaccu_vx:
  ID = Intrinsic::riscv_vwmaccu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmaccu_vv_tum:
case RISCVVector::BI__builtin_rvv_vwmaccu_vx_tum:
  ID = Intrinsic::riscv_vwmaccu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmaccu_vv_m:
case RISCVVector::BI__builtin_rvv_vwmaccu_vx_m:
  ID = Intrinsic::riscv_vwmaccu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmaccu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vwmaccu_vx_tumu:
  ID = Intrinsic::riscv_vwmaccu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmaccu_vv_mu:
case RISCVVector::BI__builtin_rvv_vwmaccu_vx_mu:
  ID = Intrinsic::riscv_vwmaccu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmaccus_vx_tu:
  ID = Intrinsic::riscv_vwmaccus;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmaccus_vx:
  ID = Intrinsic::riscv_vwmaccus;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmaccus_vx_tum:
  ID = Intrinsic::riscv_vwmaccus_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmaccus_vx_m:
  ID = Intrinsic::riscv_vwmaccus_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmaccus_vx_tumu:
  ID = Intrinsic::riscv_vwmaccus_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmaccus_vx_mu:
  ID = Intrinsic::riscv_vwmaccus_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmul_vv_tu:
case RISCVVector::BI__builtin_rvv_vwmul_vx_tu:
  ID = Intrinsic::riscv_vwmul;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmul_vv:
case RISCVVector::BI__builtin_rvv_vwmul_vx:
  ID = Intrinsic::riscv_vwmul;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmul_vv_tum:
case RISCVVector::BI__builtin_rvv_vwmul_vx_tum:
  ID = Intrinsic::riscv_vwmul_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmul_vv_m:
case RISCVVector::BI__builtin_rvv_vwmul_vx_m:
  ID = Intrinsic::riscv_vwmul_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmul_vv_tumu:
case RISCVVector::BI__builtin_rvv_vwmul_vx_tumu:
  ID = Intrinsic::riscv_vwmul_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmul_vv_mu:
case RISCVVector::BI__builtin_rvv_vwmul_vx_mu:
  ID = Intrinsic::riscv_vwmul_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmulsu_vv_tu:
case RISCVVector::BI__builtin_rvv_vwmulsu_vx_tu:
  ID = Intrinsic::riscv_vwmulsu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmulsu_vv:
case RISCVVector::BI__builtin_rvv_vwmulsu_vx:
  ID = Intrinsic::riscv_vwmulsu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmulsu_vv_tum:
case RISCVVector::BI__builtin_rvv_vwmulsu_vx_tum:
  ID = Intrinsic::riscv_vwmulsu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmulsu_vv_m:
case RISCVVector::BI__builtin_rvv_vwmulsu_vx_m:
  ID = Intrinsic::riscv_vwmulsu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmulsu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vwmulsu_vx_tumu:
  ID = Intrinsic::riscv_vwmulsu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmulsu_vv_mu:
case RISCVVector::BI__builtin_rvv_vwmulsu_vx_mu:
  ID = Intrinsic::riscv_vwmulsu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmulu_vv_tu:
case RISCVVector::BI__builtin_rvv_vwmulu_vx_tu:
  ID = Intrinsic::riscv_vwmulu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmulu_vv:
case RISCVVector::BI__builtin_rvv_vwmulu_vx:
  ID = Intrinsic::riscv_vwmulu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmulu_vv_tum:
case RISCVVector::BI__builtin_rvv_vwmulu_vx_tum:
  ID = Intrinsic::riscv_vwmulu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmulu_vv_m:
case RISCVVector::BI__builtin_rvv_vwmulu_vx_m:
  ID = Intrinsic::riscv_vwmulu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmulu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vwmulu_vx_tumu:
  ID = Intrinsic::riscv_vwmulu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwmulu_vv_mu:
case RISCVVector::BI__builtin_rvv_vwmulu_vx_mu:
  ID = Intrinsic::riscv_vwmulu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwredsum_vs_tu:
  ID = Intrinsic::riscv_vwredsum;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwredsum_vs:
  ID = Intrinsic::riscv_vwredsum;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwredsum_vs_tum:
  ID = Intrinsic::riscv_vwredsum_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwredsum_vs_m:
  ID = Intrinsic::riscv_vwredsum_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwredsumu_vs_tu:
  ID = Intrinsic::riscv_vwredsumu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwredsumu_vs:
  ID = Intrinsic::riscv_vwredsumu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwredsumu_vs_tum:
  ID = Intrinsic::riscv_vwredsumu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwredsumu_vs_m:
  ID = Intrinsic::riscv_vwredsumu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsll_vv_tu:
case RISCVVector::BI__builtin_rvv_vwsll_vx_tu:
  ID = Intrinsic::riscv_vwsll;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsll_vv:
case RISCVVector::BI__builtin_rvv_vwsll_vx:
  ID = Intrinsic::riscv_vwsll;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsll_vv_tum:
case RISCVVector::BI__builtin_rvv_vwsll_vx_tum:
  ID = Intrinsic::riscv_vwsll_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsll_vv_m:
case RISCVVector::BI__builtin_rvv_vwsll_vx_m:
  ID = Intrinsic::riscv_vwsll_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsll_vv_tumu:
case RISCVVector::BI__builtin_rvv_vwsll_vx_tumu:
  ID = Intrinsic::riscv_vwsll_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsll_vv_mu:
case RISCVVector::BI__builtin_rvv_vwsll_vx_mu:
  ID = Intrinsic::riscv_vwsll_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsub_vv_tu:
case RISCVVector::BI__builtin_rvv_vwsub_vx_tu:
  ID = Intrinsic::riscv_vwsub;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsub_vv:
case RISCVVector::BI__builtin_rvv_vwsub_vx:
  ID = Intrinsic::riscv_vwsub;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsub_vv_tum:
case RISCVVector::BI__builtin_rvv_vwsub_vx_tum:
  ID = Intrinsic::riscv_vwsub_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsub_vv_m:
case RISCVVector::BI__builtin_rvv_vwsub_vx_m:
  ID = Intrinsic::riscv_vwsub_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsub_vv_tumu:
case RISCVVector::BI__builtin_rvv_vwsub_vx_tumu:
  ID = Intrinsic::riscv_vwsub_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsub_vv_mu:
case RISCVVector::BI__builtin_rvv_vwsub_vx_mu:
  ID = Intrinsic::riscv_vwsub_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsub_wv_tu:
case RISCVVector::BI__builtin_rvv_vwsub_wx_tu:
  ID = Intrinsic::riscv_vwsub_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsub_wv:
case RISCVVector::BI__builtin_rvv_vwsub_wx:
  ID = Intrinsic::riscv_vwsub_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsub_wv_tum:
case RISCVVector::BI__builtin_rvv_vwsub_wx_tum:
  ID = Intrinsic::riscv_vwsub_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsub_wv_m:
case RISCVVector::BI__builtin_rvv_vwsub_wx_m:
  ID = Intrinsic::riscv_vwsub_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsub_wv_tumu:
case RISCVVector::BI__builtin_rvv_vwsub_wx_tumu:
  ID = Intrinsic::riscv_vwsub_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsub_wv_mu:
case RISCVVector::BI__builtin_rvv_vwsub_wx_mu:
  ID = Intrinsic::riscv_vwsub_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsubu_vv_tu:
case RISCVVector::BI__builtin_rvv_vwsubu_vx_tu:
  ID = Intrinsic::riscv_vwsubu;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsubu_vv:
case RISCVVector::BI__builtin_rvv_vwsubu_vx:
  ID = Intrinsic::riscv_vwsubu;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsubu_vv_tum:
case RISCVVector::BI__builtin_rvv_vwsubu_vx_tum:
  ID = Intrinsic::riscv_vwsubu_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsubu_vv_m:
case RISCVVector::BI__builtin_rvv_vwsubu_vx_m:
  ID = Intrinsic::riscv_vwsubu_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsubu_vv_tumu:
case RISCVVector::BI__builtin_rvv_vwsubu_vx_tumu:
  ID = Intrinsic::riscv_vwsubu_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsubu_vv_mu:
case RISCVVector::BI__builtin_rvv_vwsubu_vx_mu:
  ID = Intrinsic::riscv_vwsubu_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsubu_wv_tu:
case RISCVVector::BI__builtin_rvv_vwsubu_wx_tu:
  ID = Intrinsic::riscv_vwsubu_w;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsubu_wv:
case RISCVVector::BI__builtin_rvv_vwsubu_wx:
  ID = Intrinsic::riscv_vwsubu_w;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsubu_wv_tum:
case RISCVVector::BI__builtin_rvv_vwsubu_wx_tum:
  ID = Intrinsic::riscv_vwsubu_w_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsubu_wv_m:
case RISCVVector::BI__builtin_rvv_vwsubu_wx_m:
  ID = Intrinsic::riscv_vwsubu_w_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsubu_wv_tumu:
case RISCVVector::BI__builtin_rvv_vwsubu_wx_tumu:
  ID = Intrinsic::riscv_vwsubu_w_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vwsubu_wv_mu:
case RISCVVector::BI__builtin_rvv_vwsubu_wx_mu:
  ID = Intrinsic::riscv_vwsubu_w_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnot_v_tu:
  ID = Intrinsic::riscv_vxor;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVPseudoVNotBuiltin(this, E, ReturnValue, ResultType, ID,
                                        Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vxor_vv_tu:
case RISCVVector::BI__builtin_rvv_vxor_vx_tu:
  ID = Intrinsic::riscv_vxor;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnot_v:
  ID = Intrinsic::riscv_vxor;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = false;

        return emitRVVPseudoVNotBuiltin(this, E, ReturnValue, ResultType, ID,
                                        Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vxor_vv:
case RISCVVector::BI__builtin_rvv_vxor_vx:
  ID = Intrinsic::riscv_vxor;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnot_v_tum:
  ID = Intrinsic::riscv_vxor_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVNotBuiltin(this, E, ReturnValue, ResultType, ID,
                                        Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vxor_vv_tum:
case RISCVVector::BI__builtin_rvv_vxor_vx_tum:
  ID = Intrinsic::riscv_vxor_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnot_v_m:
  ID = Intrinsic::riscv_vxor_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVNotBuiltin(this, E, ReturnValue, ResultType, ID,
                                        Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vxor_vv_m:
case RISCVVector::BI__builtin_rvv_vxor_vx_m:
  ID = Intrinsic::riscv_vxor_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnot_v_tumu:
  ID = Intrinsic::riscv_vxor_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVNotBuiltin(this, E, ReturnValue, ResultType, ID,
                                        Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vxor_vv_tumu:
case RISCVVector::BI__builtin_rvv_vxor_vx_tumu:
  ID = Intrinsic::riscv_vxor_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vnot_v_mu:
  ID = Intrinsic::riscv_vxor_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
IsMasked = true;

        return emitRVVPseudoVNotBuiltin(this, E, ReturnValue, ResultType, ID,
                                        Ops, PolicyAttrs, IsMasked, SegInstSEW);
      break;
case RISCVVector::BI__builtin_rvv_vxor_vv_mu:
case RISCVVector::BI__builtin_rvv_vxor_vx_mu:
  ID = Intrinsic::riscv_vxor_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[2]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vzext_vf2_tu:
case RISCVVector::BI__builtin_rvv_vzext_vf4_tu:
case RISCVVector::BI__builtin_rvv_vzext_vf8_tu:
  ID = Intrinsic::riscv_vzext;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vzext_vf2:
case RISCVVector::BI__builtin_rvv_vzext_vf4:
case RISCVVector::BI__builtin_rvv_vzext_vf8:
  ID = Intrinsic::riscv_vzext;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vzext_vf2_tum:
case RISCVVector::BI__builtin_rvv_vzext_vf4_tum:
case RISCVVector::BI__builtin_rvv_vzext_vf8_tum:
  ID = Intrinsic::riscv_vzext_mask;
  PolicyAttrs = 2;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vzext_vf2_m:
case RISCVVector::BI__builtin_rvv_vzext_vf4_m:
case RISCVVector::BI__builtin_rvv_vzext_vf8_m:
  ID = Intrinsic::riscv_vzext_mask;
  PolicyAttrs = 3;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  Ops.insert(Ops.begin(), llvm::PoisonValue::get(ResultType));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vzext_vf2_tumu:
case RISCVVector::BI__builtin_rvv_vzext_vf4_tumu:
case RISCVVector::BI__builtin_rvv_vzext_vf8_tumu:
  ID = Intrinsic::riscv_vzext_mask;
  PolicyAttrs = 0;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;
case RISCVVector::BI__builtin_rvv_vzext_vf2_mu:
case RISCVVector::BI__builtin_rvv_vzext_vf4_mu:
case RISCVVector::BI__builtin_rvv_vzext_vf8_mu:
  ID = Intrinsic::riscv_vzext_mask;
  PolicyAttrs = 1;
  SegInstSEW = 0;
  std::rotate(Ops.begin(), Ops.begin() + 1, Ops.end() - 1);
  Ops.push_back(ConstantInt::get(Ops.back()->getType(), PolicyAttrs));
  IntrinsicTypes = {ResultType, Ops[1]->getType(), Ops.back()->getType()};
  break;

