/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.qm.QMTransactionState;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.runtime.DBeaverNotifications;
import org.jkiss.dbeaver.runtime.TasksJob;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.controls.txn.TransactionLogDialog;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class DataSourceRollbackHandler
extends AbstractDataSourceHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DBCExecutionContext context = DataSourceRollbackHandler.getActiveExecutionContext((ExecutionEvent)event, (boolean)true);
        if (context != null && context.isConnected()) {
            DataSourceRollbackHandler.execute(context);
        }
        return null;
    }

    public static void execute(DBCExecutionContext context) {
        TasksJob.runTask((String)"Rollback transaction", monitor -> {
            DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context);
            if (txnManager != null) {
                QMTransactionState txnInfo = QMUtils.getTransactionState((DBCExecutionContext)context);
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (DBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Rollback transaction");){
                        txnManager.rollback(session, null);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (DBCException e) {
                    throw new InvocationTargetException(e);
                }
                if (context.getDataSource().getContainer().getPreferenceStore().getBoolean("transaction.show.notifications")) {
                    DBeaverNotifications.showNotification((DBPDataSource)context.getDataSource(), (String)"rollback", (String)("Transaction has been rolled back\n\nQuery count: " + txnInfo.getUpdateCount() + "\nDuration: " + RuntimeUtils.formatExecutionTime((long)(System.currentTimeMillis() - txnInfo.getTransactionStartTime())) + "\n"), (DBPMessageType)DBPMessageType.ERROR, () -> TransactionLogDialog.showDialog(null, context, true));
                }
            }
        });
    }
}

