/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri;

import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.VariablePointer;

public class InfoSetUtil {
    private static final Double ZERO = 0.0;
    private static final Double ONE = 1.0;
    private static final Double NOT_A_NUMBER = Double.NaN;

    public static String stringValue(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number) {
            long l;
            double d = ((Number)object).doubleValue();
            return d == (double)(l = ((Number)object).longValue()) ? String.valueOf(l) : String.valueOf(d);
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? "true" : "false";
        }
        if (object == null) {
            return "";
        }
        if (object instanceof NodePointer) {
            return InfoSetUtil.stringValue(((NodePointer)object).getValue());
        }
        if (object instanceof EvalContext) {
            EvalContext ctx = (EvalContext)object;
            Pointer ptr = ctx.getSingleNodePointer();
            return ptr == null ? "" : InfoSetUtil.stringValue(ptr);
        }
        return String.valueOf(object);
    }

    public static Number number(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? ONE : ZERO;
        }
        if (object instanceof String) {
            try {
                return Double.valueOf((String)object);
            }
            catch (NumberFormatException ex) {
                return NOT_A_NUMBER;
            }
        }
        if (object instanceof EvalContext) {
            EvalContext ctx = (EvalContext)object;
            Pointer ptr = ctx.getSingleNodePointer();
            return ptr == null ? (Number)NOT_A_NUMBER : (Number)InfoSetUtil.number(ptr);
        }
        if (object instanceof NodePointer) {
            return InfoSetUtil.number(((NodePointer)object).getValue());
        }
        return InfoSetUtil.number(InfoSetUtil.stringValue(object));
    }

    public static double doubleValue(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 0.0 : 1.0;
        }
        if (object instanceof String) {
            if (object.equals("")) {
                return 0.0;
            }
            try {
                return Double.parseDouble((String)object);
            }
            catch (NumberFormatException ex) {
                return Double.NaN;
            }
        }
        if (object instanceof NodePointer) {
            return InfoSetUtil.doubleValue(((NodePointer)object).getValue());
        }
        if (object instanceof EvalContext) {
            EvalContext ctx = (EvalContext)object;
            Pointer ptr = ctx.getSingleNodePointer();
            return ptr == null ? Double.NaN : InfoSetUtil.doubleValue(ptr);
        }
        return InfoSetUtil.doubleValue(InfoSetUtil.stringValue(object));
    }

    public static boolean booleanValue(Object object) {
        if (object instanceof Number) {
            double value = ((Number)object).doubleValue();
            boolean negZero = false;
            return value != 0.0 && value != 0.0 && !Double.isNaN(value);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof EvalContext) {
            EvalContext ctx = (EvalContext)object;
            Pointer ptr = ctx.getSingleNodePointer();
            return ptr != null && InfoSetUtil.booleanValue(ptr);
        }
        if (object instanceof String) {
            return ((String)object).length() != 0;
        }
        if (object instanceof NodePointer) {
            NodePointer pointer = (NodePointer)object;
            if (pointer instanceof VariablePointer) {
                return InfoSetUtil.booleanValue(pointer.getNode());
            }
            pointer = pointer.getValuePointer();
            return pointer.isActual();
        }
        return object != null;
    }
}

