/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.database;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNRoot;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferProducer;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.pages.DataTransferPageNodeSettings;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class DatabaseProducerPageInputObjects
extends DataTransferPageNodeSettings {
    private Table mappingTable;
    private DBNDatabaseNode lastSelection;

    public DatabaseProducerPageInputObjects() {
        super(DTUIMessages.database_producer_page_input_objects_name);
        this.setTitle(DTUIMessages.database_producer_page_input_objects_title);
        this.setDescription(DTUIMessages.database_producer_page_input_objects_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        ((DataTransferWizard)this.getWizard()).getSettings();
        Composite tablesGroup = UIUtils.createComposite((Composite)composite, (int)1);
        tablesGroup.setLayoutData((Object)new GridData(1808));
        UIUtils.createControlLabel((Composite)tablesGroup, (String)DTMessages.data_transfer_wizard_mappings_name);
        this.mappingTable = new Table(tablesGroup, 67588);
        this.mappingTable.setLayoutData((Object)new GridData(1808));
        this.mappingTable.setHeaderVisible(true);
        this.mappingTable.setLinesVisible(true);
        UIUtils.createTableColumn((Table)this.mappingTable, (int)16384, (String)DTUIMessages.data_transfer_wizard_final_column_source);
        UIUtils.createTableColumn((Table)this.mappingTable, (int)16384, (String)DTUIMessages.data_transfer_wizard_final_column_target);
        this.mappingTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DatabaseProducerPageInputObjects.this.mappingTable.getSelectionIndex() < 0) {
                    return;
                }
                TableItem item = DatabaseProducerPageInputObjects.this.mappingTable.getItem(DatabaseProducerPageInputObjects.this.mappingTable.getSelectionIndex());
                DataTransferPipe pipe = (DataTransferPipe)item.getData();
                if (DatabaseProducerPageInputObjects.this.chooseEntity(pipe)) {
                    DatabaseProducerPageInputObjects.this.updateItemData(item, pipe);
                    DatabaseProducerPageInputObjects.this.updatePageCompletion();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.mappingTable, (boolean)true));
        Composite controlGroup = UIUtils.createComposite((Composite)composite, (int)1);
        Button autoAssignButton = new Button(controlGroup, 8);
        autoAssignButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.ASTERISK));
        autoAssignButton.setText(DTMessages.data_transfer_db_consumer_auto_assign);
        autoAssignButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseProducerPageInputObjects.this.autoAssignMappings();
            }
        });
        this.setControl((Control)composite);
    }

    private void autoAssignMappings() {
        DBSObjectContainer objectContainer = this.chooseEntityContainer();
        if (objectContainer == null) {
            this.setMessage(DTUIMessages.database_producer_page_input_objects_error_message_auto_assign_failed, 2);
            return;
        }
        ArrayList<DBSObject> containerObjects = new ArrayList<DBSObject>();
        try {
            ((DataTransferWizard)this.getWizard()).getContainer().run(true, true, mon -> {
                try {
                    Collection children = objectContainer.getChildren((DBRProgressMonitor)new DefaultProgressMonitor(mon));
                    if (children != null) {
                        containerObjects.addAll(children);
                    }
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(DTUIMessages.database_producer_page_input_objects_title_assign_error, DTUIMessages.database_producer_page_input_objects_message_error_reading_container_objects, (Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
        if (CommonUtils.isEmpty(containerObjects)) {
            this.setMessage(DTUIMessages.database_producer_page_input_objects_error_message_auto_assign_failed, 2);
        } else {
            this.autoAssignMappings(containerObjects);
        }
    }

    private void autoAssignMappings(List<DBSObject> containerObjects) {
        boolean chooseConsumer = ((DataTransferWizard)this.getWizard()).getSettings().isConsumerOptional();
        boolean success = false;
        TableItem[] tableItemArray = this.mappingTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            DataTransferPipe pipe = (DataTransferPipe)item.getData();
            if (chooseConsumer && (pipe.getConsumer() == null || pipe.getConsumer().getDatabaseObject() == null) || !chooseConsumer && (pipe.getProducer() == null || pipe.getProducer().getDatabaseObject() == null)) {
                DBSObject object;
                DBSObject objectToMap;
                DBSObject dBSObject = objectToMap = chooseConsumer ? pipe.getProducer().getDatabaseObject() : pipe.getConsumer().getDatabaseObject();
                if (objectToMap != null && (object = (DBSObject)DBUtils.findObject(containerObjects, (String)objectToMap.getName())) != null) {
                    success = true;
                    if (chooseConsumer) {
                        if (object instanceof DBSDataManipulator) {
                            pipe.setConsumer((IDataTransferConsumer)new DatabaseTransferConsumer((DBSDataManipulator)object));
                            this.updateConsumerContainer(pipe);
                        }
                    } else if (object instanceof DBSDataContainer) {
                        pipe.setProducer((IDataTransferProducer)new DatabaseTransferProducer((DBSDataContainer)object));
                    }
                    this.updateItemData(item, pipe);
                }
            }
            ++n2;
        }
        if (!success) {
            this.setMessage(DTUIMessages.database_producer_page_input_objects_error_message_auto_assign_failed, 2);
        }
        this.updatePageCompletion();
    }

    private void updateItemData(TableItem item, DataTransferPipe pipe) {
        this.setErrorMessage(null);
        DataTransferSettings settings = ((DataTransferWizard)this.getWizard()).getSettings();
        if (pipe.getProducer() == null || pipe.getProducer().getDatabaseObject() == null) {
            item.setImage(0, null);
            item.setText(0, DTUIMessages.database_producer_page_input_objects_item_text_none);
        } else {
            item.setImage(0, DBeaverIcons.getImage((DBPImage)settings.getProducer().getIcon()));
            item.setText(0, DBUtils.getObjectFullName((DBPNamedObject)pipe.getProducer().getDatabaseObject(), (DBPEvaluationContext)DBPEvaluationContext.DML));
        }
        if (pipe.getConsumer() == null || pipe.getConsumer().getObjectName() == null) {
            item.setImage(1, null);
            item.setText(1, DTUIMessages.database_producer_page_input_objects_item_text_none);
        } else {
            this.updateConsumerContainer(pipe);
            item.setImage(1, DBeaverIcons.getImage((DBPImage)settings.getConsumer().getIcon()));
            item.setText(1, pipe.getConsumer().getObjectName());
        }
    }

    public void activatePage() {
        DataTransferSettings settings = ((DataTransferWizard)this.getWizard()).getSettings();
        this.mappingTable.removeAll();
        for (DataTransferPipe pipe : settings.getDataPipes()) {
            TableItem item = new TableItem(this.mappingTable, 0);
            item.setData((Object)pipe);
            this.updateItemData(item, pipe);
        }
        this.updatePageCompletion();
    }

    protected boolean determinePageCompletion() {
        for (DataTransferPipe pipe : ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes()) {
            if (pipe.getConsumer() != null && pipe.getProducer() != null && pipe.getProducer().getDatabaseObject() != null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private DBSObjectContainer chooseEntityContainer() {
        DataTransferSettings settings = ((DataTransferWizard)this.getWizard()).getSettings();
        DBNModel navigatorModel = DBWorkbench.getPlatform().getNavigatorModel();
        DBNRoot rootNode = DBWorkbench.getPlatform().getWorkspace().getProjects().size() == 1 ? navigatorModel.getRoot().getProjectNode(DBWorkbench.getPlatform().getWorkspace().getActiveProject()) : navigatorModel.getRoot();
        settings.isConsumerOptional();
        DBNNode node = DBWorkbench.getPlatformUI().selectObject((Object)UIUtils.getActiveWorkbenchShell(), DTUIMessages.database_producer_page_input_objects_node_select_table, (DBNNode)rootNode, (DBNNode)this.lastSelection, new Class[]{DBSInstance.class, DBSObjectContainer.class}, new Class[]{DBSObjectContainer.class}, null);
        if (!(node instanceof DBNDatabaseNode)) {
            return null;
        }
        this.lastSelection = (DBNDatabaseNode)node;
        DBSObject object = this.lastSelection.getObject();
        if (!(object instanceof DBSObjectContainer)) {
            object = (DBSObject)DBUtils.getAdapter(DBSObjectContainer.class, (Object)((DBSWrapper)node).getObject());
        }
        return (DBSObjectContainer)object;
    }

    protected boolean chooseEntity(DataTransferPipe pipe) {
        DataTransferSettings settings = ((DataTransferWizard)this.getWizard()).getSettings();
        DBNModel navigatorModel = DBWorkbench.getPlatform().getNavigatorModel();
        DBNRoot rootNode = DBWorkbench.getPlatform().getWorkspace().getProjects().size() == 1 ? navigatorModel.getRoot().getProjectNode(DBWorkbench.getPlatform().getWorkspace().getActiveProject()) : navigatorModel.getRoot();
        boolean chooseConsumer = settings.isConsumerOptional();
        DBNNode node = DBWorkbench.getPlatformUI().selectObject((Object)UIUtils.getActiveWorkbenchShell(), chooseConsumer ? NLS.bind((String)DTUIMessages.database_producer_page_input_objects_node_select_target, (Object)pipe.getProducer().getDatabaseObject().getName()) : NLS.bind((String)DTUIMessages.database_producer_page_input_objects_node_select_source, (Object)pipe.getConsumer().getObjectName()), (DBNNode)rootNode, (DBNNode)this.lastSelection, new Class[]{DBSInstance.class, DBSObjectContainer.class, DBSDataContainer.class}, new Class[]{chooseConsumer ? DBSDataManipulator.class : DBSDataContainer.class}, null);
        if (node instanceof DBNDatabaseNode) {
            this.lastSelection = (DBNDatabaseNode)node;
            DBSObject object = ((DBNDatabaseNode)node).getObject();
            if (chooseConsumer) {
                if (object instanceof DBSDataManipulator) {
                    pipe.setConsumer((IDataTransferConsumer)new DatabaseTransferConsumer((DBSDataManipulator)object));
                    this.updateConsumerContainer(pipe);
                }
            } else if (object instanceof DBSDataContainer) {
                pipe.setProducer((IDataTransferProducer)new DatabaseTransferProducer((DBSDataContainer)object));
            }
            return true;
        }
        return false;
    }

    private void updateConsumerContainer(DataTransferPipe pipe) {
        IDataTransferSettings consumerSettings = ((DataTransferWizard)this.getWizard()).getSettings().getNodeSettings(((DataTransferWizard)this.getWizard()).getSettings().getConsumer());
        if (consumerSettings instanceof DatabaseConsumerSettings) {
            DBSDataManipulator databaseObject;
            DBSObject container;
            DBSObject dBSObject;
            DatabaseConsumerSettings databaseConsumerSettings = (DatabaseConsumerSettings)consumerSettings;
            if (pipe.getConsumer() != null && (dBSObject = pipe.getConsumer().getDatabaseObject()) instanceof DBSDataManipulator && (container = (databaseObject = (DBSDataManipulator)dBSObject).getParentObject()) instanceof DBSObjectContainer) {
                databaseConsumerSettings.setContainer((DBSObjectContainer)container);
            }
        }
    }

    public boolean isPageApplicable() {
        return this.isProducerOfType(DatabaseTransferProducer.class);
    }
}

