/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.tokens.predicates;

import java.util.Iterator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.AlternativeTokenPredicateNode;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.CaptureTokenPredicateNode;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.GroupTokenPredicatesNode;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.OptionalTokenPredicateNode;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.SQLTokenEntry;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.SequenceTokenPredicateNode;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicateNode;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicateNodeVisitor;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.UnaryTokenPredicateNode;

class TokenPredicateFormatter
implements TokenPredicateNodeVisitor<StringBuilder, StringBuilder> {
    private static final TokenPredicateFormatter INSTANCE = new TokenPredicateFormatter();

    @NotNull
    public static String format(@Nullable TokenPredicateNode node) {
        return node == null ? "<NULL>" : node.apply(INSTANCE, new StringBuilder()).toString();
    }

    private TokenPredicateFormatter() {
    }

    @NotNull
    private StringBuilder visit(@NotNull TokenPredicateNode parent, @NotNull TokenPredicateNode node, @NotNull StringBuilder sb) {
        boolean needsWrapping;
        boolean bl = needsWrapping = parent instanceof GroupTokenPredicatesNode && node instanceof GroupTokenPredicatesNode && parent.getClass() != node.getClass() || parent instanceof UnaryTokenPredicateNode && node instanceof GroupTokenPredicatesNode;
        if (needsWrapping) {
            sb.append("(");
        }
        node.apply(this, sb);
        if (needsWrapping) {
            sb.append(")");
        }
        return sb;
    }

    @NotNull
    private StringBuilder visitUnary(@NotNull UnaryTokenPredicateNode unary, @NotNull StringBuilder sb) {
        return this.visit(unary, unary.child, sb);
    }

    @NotNull
    private StringBuilder visitGroup(@NotNull GroupTokenPredicatesNode group, @NotNull StringBuilder sb, @NotNull String separator) {
        Iterator<TokenPredicateNode> it = group.childs.iterator();
        if (it.hasNext()) {
            this.visit(group, it.next(), sb);
            while (it.hasNext()) {
                sb.append(separator);
                this.visit(group, it.next(), sb);
            }
        }
        return sb;
    }

    @Override
    @NotNull
    public StringBuilder visitSequence(@NotNull SequenceTokenPredicateNode sequence, @NotNull StringBuilder sb) {
        return this.visitGroup(sequence, sb, " ");
    }

    @Override
    @NotNull
    public StringBuilder visitAlternative(@NotNull AlternativeTokenPredicateNode alternative, @NotNull StringBuilder sb) {
        return this.visitGroup(alternative, sb, "|");
    }

    @Override
    @NotNull
    public StringBuilder visitOptional(@NotNull OptionalTokenPredicateNode optional, @NotNull StringBuilder sb) {
        return this.visitUnary(optional, sb).append("?");
    }

    @Override
    @NotNull
    public StringBuilder visitTokenEntry(@NotNull SQLTokenEntry token, @NotNull StringBuilder sb) {
        return token.format(sb);
    }

    @Override
    @NotNull
    public StringBuilder visitCapture(@NotNull CaptureTokenPredicateNode captureToken, @NotNull StringBuilder sb) {
        return captureToken.format(sb);
    }
}

