/*
 * Decompiled with CFR 0.152.
 */
package org.cts;

import java.util.ArrayList;
import java.util.List;
import org.cts.Identifiable;

public class Identifier
implements Identifiable {
    private static int localId = 0;
    private String authorityName;
    private String authorityKey;
    private String name;
    private String shortName;
    private String remarks;
    private List<Identifiable> aliases;

    public static int getNewId() {
        return localId++;
    }

    public Identifier(String authorityName, String authorityKey, String name, String shortName, String remarks, List<Identifiable> aliases) {
        this.authorityName = authorityName;
        this.authorityKey = authorityKey;
        this.name = name;
        this.shortName = shortName;
        this.remarks = remarks;
        this.aliases = aliases;
    }

    public Identifier(Class clazz) {
        this("LOCAL_" + clazz.getSimpleName(), "" + Identifier.getNewId(), "UNKNOWN", null, null, null);
    }

    public Identifier(Class clazz, String name) {
        this("LOCAL_" + clazz.getSimpleName(), "" + Identifier.getNewId(), name, null, null, null);
    }

    public Identifier(Class clazz, String name, String shortName) {
        this("LOCAL_" + clazz.getSimpleName(), "" + Identifier.getNewId(), name, shortName, null, null);
    }

    public Identifier(Class clazz, String name, String shortName, List<Identifiable> aliases) {
        this("LOCAL_" + clazz.getSimpleName(), "" + Identifier.getNewId(), name, shortName, null, aliases);
    }

    public Identifier(String authorityName, String authorityKey, String name) {
        this(authorityName, authorityKey, name, null, null, null);
    }

    public Identifier(String authorityName, String authorityKey, String name, String shortName) {
        this(authorityName, authorityKey, name, shortName, null, null);
    }

    @Override
    public String getAuthorityName() {
        return this.authorityName;
    }

    @Override
    public String getAuthorityKey() {
        return this.authorityKey;
    }

    @Override
    public String getCode() {
        return this.authorityName + ":" + this.authorityKey;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.shortName == null ? this.name : this.shortName;
    }

    @Override
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Override
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    public void addRemark(String new_remark) {
        this.remarks = this.remarks + "\n" + new_remark;
    }

    @Override
    public List<Identifiable> getAliases() {
        return this.aliases == null ? new ArrayList() : this.aliases;
    }

    @Override
    public boolean addAlias(Identifiable alias) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<Identifiable>();
        }
        return this.aliases.add(alias);
    }

    public String toWKT() {
        String w = "AUTHORITY[\"" + this.getAuthorityName() + "\",\"" + this.getAuthorityKey() + "\"]";
        return w;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Identifier) {
            boolean areEquals;
            Identifier other = (Identifier)object;
            if (this.getAuthorityName() != null && other.getAuthorityName() != null && this.getAuthorityName().toUpperCase().equals(other.getAuthorityName().toUpperCase()) && this.getAuthorityKey() != null && other.getAuthorityKey() != null && this.getAuthorityKey().equals(other.getAuthorityKey())) {
                return true;
            }
            for (Identifiable id2 : other.getAliases()) {
                areEquals = this.getAuthorityName() != null && id2.getAuthorityName() != null && this.getAuthorityName().toUpperCase().equals(id2.getAuthorityName().toUpperCase()) && this.getAuthorityKey() != null && id2.getAuthorityKey() != null && this.getAuthorityKey().equals(id2.getAuthorityKey());
                if (!areEquals) continue;
                return true;
            }
            for (Identifiable id1 : this.getAliases()) {
                boolean bl = areEquals = id1.getAuthorityName() != null && other.getAuthorityName() != null && id1.getAuthorityName().toUpperCase().equals(other.getAuthorityName().toUpperCase()) && id1.getAuthorityKey() != null && other.getAuthorityKey() != null && id1.getAuthorityKey().equals(other.getAuthorityKey());
                if (areEquals) {
                    return true;
                }
                for (Identifiable id2 : other.getAliases()) {
                    areEquals = id1.getAuthorityName() != null && id2.getAuthorityName() != null && id1.getAuthorityName().toUpperCase().equals(id2.getAuthorityName().toUpperCase()) && id1.getAuthorityKey() != null && id2.getAuthorityKey() != null && id1.getAuthorityKey().equals(id2.getAuthorityKey());
                    if (!areEquals) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + (this.authorityName.toUpperCase() != null ? this.authorityName.toUpperCase().hashCode() : 0);
        hash = 11 * hash + (this.authorityKey != null ? this.authorityKey.hashCode() : 0);
        hash = 11 * hash + (this.aliases != null ? this.aliases.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "[" + this.authorityName + ":" + this.authorityKey + "] " + this.name;
    }
}

