/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2SchemaObject;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2AliasType;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAlias;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class DB2Alias
extends DB2SchemaObject
implements DBSAlias {
    private DB2AliasType type;
    private DBSObject targetObject;

    public DB2Alias(DBRProgressMonitor monitor, DB2Schema schema, ResultSet dbResult) throws DBException {
        super(schema, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"NAME"), true);
        this.type = (DB2AliasType)CommonUtils.valueOf(DB2AliasType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE"));
        String baseSchemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"BASE_SCHEMA");
        String baseObjectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"BASE_NAME");
        DB2Schema targetSchema = this.getDataSource().getSchema(monitor, baseSchemaName);
        switch (this.type) {
            case TABLE: {
                this.targetObject = targetSchema.getTable(monitor, baseObjectName);
                break;
            }
            case MODULE: {
                this.targetObject = targetSchema.getModule(monitor, baseObjectName);
                break;
            }
            case SEQUENCE: {
                this.targetObject = targetSchema.getSequence(monitor, baseObjectName);
            }
        }
    }

    @Override
    @Property(viewable=true, editable=false, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Override
    @Property(viewable=true, editable=false, order=2)
    public DB2Schema getSchema() {
        return super.getSchema();
    }

    @Property(viewable=true, editable=false, order=3)
    public DB2AliasType getType() {
        return this.type;
    }

    @Property(viewable=true, editable=false, order=4)
    public DBSObject getTargetObject() {
        return this.targetObject;
    }

    public DBSObject getTargetObject(DBRProgressMonitor monitor) throws DBException {
        return this.getTargetObject();
    }
}

