/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditor;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditorDescriptor;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditorsRegistry;
import org.jkiss.dbeaver.ui.editors.entity.properties.ObjectPropertiesEditor;
import org.jkiss.dbeaver.ui.editors.text.BaseTextEditor;

public class ObjectPropertySwitchToSourceHandler
extends AbstractHandler {
    @Nullable
    public Object execute(@NotNull ExecutionEvent event) throws ExecutionException {
        EntityEditor editor;
        String sourceEditorId;
        IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editorPart instanceof EntityEditor && (sourceEditorId = ObjectPropertySwitchToSourceHandler.findSourceTextEditorId(editor = (EntityEditor)editorPart)) != null) {
            editor.switchFolder(sourceEditorId);
        }
        return null;
    }

    @Nullable
    public static String findSourceTextEditorId(@NotNull EntityEditor editor) {
        IEditorPart iEditorPart = editor.getPageEditor("default.object.editor");
        if (iEditorPart instanceof ObjectPropertiesEditor) {
            ObjectPropertiesEditor part = (ObjectPropertiesEditor)iEditorPart;
            List<EntityEditorDescriptor> descrs = EntityEditorsRegistry.getInstance().getEntityEditors((DBPObject)editor.getDatabaseObject(), part, null);
            for (EntityEditorDescriptor descr : descrs) {
                if (!descr.getEditorType().matchesType(BaseTextEditor.class)) continue;
                return descr.getId();
            }
        }
        return null;
    }
}

