/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.app;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.utils.CommonUtils;

public class ApplicationDescriptor
extends AbstractDescriptor {
    private final String id;
    private final String productFamily;
    private final String licenseProductId;
    private final String name;
    private final String description;
    private final String parentId;
    private final String[] umbrellaProductIds;
    private final boolean serverApplication;
    private final boolean hidden;
    private ApplicationDescriptor parent;
    private boolean finalApplication = true;
    private final AbstractDescriptor.ObjectType implClass;
    private DBPApplication implementation;

    ApplicationDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.productFamily = CommonUtils.toString((Object)config.getAttribute("family"), (String)"DB");
        this.licenseProductId = CommonUtils.toString((Object)config.getAttribute("licenseProductId"), (String)this.id);
        this.name = config.getAttribute("name");
        this.description = config.getAttribute("description");
        this.parentId = config.getAttribute("parent");
        String umbrella = config.getAttribute("umbrella");
        this.umbrellaProductIds = !CommonUtils.isEmptyTrimmed((String)umbrella) ? umbrella.split(",") : new String[0];
        this.serverApplication = CommonUtils.toBoolean((Object)config.getAttribute("server"));
        this.hidden = CommonUtils.toBoolean((Object)config.getAttribute("hidden"));
        this.implClass = new AbstractDescriptor.ObjectType(this, config, "class");
    }

    public String getId() {
        return this.id;
    }

    public String getLicenseProductId() {
        return this.licenseProductId;
    }

    public String getProductFamily() {
        return this.productFamily;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ApplicationDescriptor getParent() {
        return this.parent;
    }

    void setParent(ApplicationDescriptor parent) {
        this.parent = parent;
        this.parent.finalApplication = false;
    }

    public String[] getUmbrellaProductIds() {
        return this.umbrellaProductIds;
    }

    public boolean isServerApplication() {
        return this.serverApplication;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public DBPApplication getInstance() throws Exception {
        if (this.implementation == null) {
            this.implementation = this.getImplClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return this.implementation;
    }

    @NotNull
    private Class<? extends DBPApplication> getImplClass() {
        return this.implClass.getImplClass(DBPApplication.class);
    }

    boolean isFinalApplication() {
        return this.finalApplication;
    }

    String getParentId() {
        return this.parentId;
    }
}

