/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.handler;

import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.handler.ResultSetHandlerMain;
import org.jkiss.dbeaver.ui.data.editors.ContentPanelEditor;
import org.jkiss.dbeaver.ui.data.registry.StreamValueManagerDescriptor;
import org.jkiss.dbeaver.ui.data.registry.ValueManagerRegistry;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class ResultSetHandlerSwitchContentViewer
extends AbstractHandler
implements IElementUpdater {
    public static final String COMMAND_ID = "org.jkiss.dbeaver.core.resultset.grid.switchContentViewer";
    public static final String PARAM_STREAM_MANAGER_ID = "managerId";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String managerId = event.getParameter(PARAM_STREAM_MANAGER_ID);
        StreamValueManagerDescriptor manager = ValueManagerRegistry.getInstance().getStreamManager(managerId);
        ContentPanelEditor editor = ResultSetHandlerSwitchContentViewer.getEditor(HandlerUtil.getActivePart((ExecutionEvent)event));
        if (manager != null && editor != null) {
            editor.setCurrentStreamManager(manager);
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        String managerId = (String)parameters.get(PARAM_STREAM_MANAGER_ID);
        StreamValueManagerDescriptor manager = ValueManagerRegistry.getInstance().getStreamManager(managerId);
        ContentPanelEditor editor = ResultSetHandlerSwitchContentViewer.getEditor((IWorkbenchPart)element.getServiceLocator().getService(IWorkbenchPart.class));
        if (manager != null) {
            element.setText(manager.getLabel());
            element.setTooltip(manager.getDescription());
            element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)manager.getIcon()));
            element.setChecked(editor != null && editor.getCurrentStreamManager() == manager);
        }
    }

    @Nullable
    private static ContentPanelEditor getEditor(@NotNull IWorkbenchPart workbenchPart) {
        ResultSetViewer rsv = (ResultSetViewer)ResultSetHandlerMain.getActiveResultSet(workbenchPart);
        if (rsv != null && rsv.isPanelVisible("value-view")) {
            return (ContentPanelEditor)GeneralUtils.adapt((Object)rsv.getVisiblePanel(), ContentPanelEditor.class);
        }
        return null;
    }

    public static class StreamManagerIdParameterValues
    implements IParameterValues {
        public Map<String, String> getParameterValues() {
            return ValueManagerRegistry.getInstance().getAllStreamManagers().stream().collect(Collectors.toMap(StreamValueManagerDescriptor::getLabel, StreamValueManagerDescriptor::getId));
        }
    }
}

