/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.ProjectPreferences;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.BitMask;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public class File
extends Resource
implements IFile {
    protected File(IPath path, Workspace container) {
        super(path, container);
    }

    @Override
    public void appendContents(InputStream content, int updateFlags, IProgressMonitor monitor) throws CoreException {
        String message = NLS.bind((String)Messages.resources_settingContents, (Object)this.getFullPath());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)message, (int)100);
        try {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try {
                    try {
                        Assert.isNotNull((Object)content, (String)"Content cannot be null.");
                        if (this.workspace.shouldValidate) {
                            this.workspace.validateSave(this);
                        }
                        ISchedulingRule rule = this.workspace.getRuleFactory().modifyRule(this);
                        SubMonitor newChild = subMonitor.newChild(1);
                        try {
                            try {
                                this.workspace.prepareOperation(rule, (IProgressMonitor)newChild);
                                ResourceInfo info = this.getResourceInfo(false, false);
                                this.checkAccessible(this.getFlags(info));
                                this.workspace.beginOperation(true);
                                IFileInfo fileInfo = this.getStore().fetchInfo();
                                this.internalSetContents(content, fileInfo, updateFlags, true, (IProgressMonitor)subMonitor.newChild(99));
                            }
                            catch (OperationCanceledException e) {
                                this.workspace.getWorkManager().operationCanceled();
                                throw e;
                            }
                        }
                        finally {
                            this.workspace.endOperation(rule, true);
                        }
                    }
                    finally {
                        if (content != null) {
                            content.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                subMonitor.done();
            }
        }
        finally {
            subMonitor.done();
        }
    }

    @Override
    public void appendContents(InputStream content, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.appendContents(content, updateFlags |= keepHistory ? 2 : 0, monitor);
    }

    public IFolder changeToFolder() throws CoreException {
        this.getPropertyManager().deleteProperties(this, 0);
        IFolder result = this.workspace.getRoot().getFolder(this.path);
        if (this.isLinked()) {
            IPath location = this.getRawLocation();
            this.delete(0, null);
            result.createLink(location, 16, null);
        } else {
            this.workspace.deleteResource(this);
            this.workspace.createResource((IResource)result, false);
        }
        return result;
    }

    @Override
    public void create(InputStream content, int updateFlags, IProgressMonitor monitor) throws CoreException {
        String message = NLS.bind((String)Messages.resources_creating, (Object)this.getFullPath());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)message, (int)100);
        try {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try {
                    try {
                        this.checkValidPath(this.path, 1, true);
                        ISchedulingRule rule = this.workspace.getRuleFactory().createRule(this);
                        try {
                            try {
                                boolean local;
                                this.workspace.prepareOperation(rule, (IProgressMonitor)subMonitor.newChild(1));
                                this.checkCreatable();
                                this.workspace.beginOperation(true);
                                IFileStore store = this.getStore();
                                IFileInfo localInfo = this.create(updateFlags, (IProgressMonitor)subMonitor.newChild(40), store);
                                boolean bl = local = content != null;
                                if (local) {
                                    try {
                                        this.internalSetContents(content, localInfo, updateFlags, false, (IProgressMonitor)subMonitor.newChild(59));
                                    }
                                    catch (CoreException | OperationCanceledException e) {
                                        this.workspace.deleteResource(this);
                                        store.delete(0, null);
                                        throw e;
                                    }
                                }
                                this.setLocal(local);
                            }
                            catch (OperationCanceledException e) {
                                this.workspace.getWorkManager().operationCanceled();
                                throw e;
                            }
                        }
                        finally {
                            this.workspace.endOperation(rule, true);
                        }
                    }
                    finally {
                        if (content != null) {
                            content.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                subMonitor.done();
            }
        }
        finally {
            subMonitor.done();
        }
    }

    @Override
    public void create(InputStream content, boolean force, IProgressMonitor monitor) throws CoreException {
        this.create(content, force ? 1 : 0, monitor);
    }

    @Override
    public void create(byte[] content, int updateFlags, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.resources_creating, (Object)this.getFullPath()), (int)100);
        try {
            this.checkValidPath(this.path, 1, true);
            ISchedulingRule rule = this.workspace.getRuleFactory().createRule(this);
            try {
                try {
                    boolean local;
                    this.workspace.prepareOperation(rule, (IProgressMonitor)subMonitor.newChild(1));
                    this.checkCreatable();
                    this.workspace.beginOperation(true);
                    IFileStore store = this.getStore();
                    IFileInfo localInfo = this.create(updateFlags, (IProgressMonitor)subMonitor.newChild(40), store);
                    boolean bl = local = content != null;
                    if (local) {
                        try {
                            this.internalSetContents(content, localInfo, updateFlags, false, (IProgressMonitor)subMonitor.newChild(59));
                        }
                        catch (CoreException | OperationCanceledException e) {
                            this.workspace.deleteResource(this);
                            store.delete(0, null);
                            throw e;
                        }
                    }
                    this.setLocal(local);
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            finally {
                this.workspace.endOperation(rule, true);
            }
        }
        finally {
            subMonitor.done();
        }
    }

    void checkCreatable() throws CoreException {
        this.checkDoesNotExist();
        Container parent = (Container)this.getParent();
        ResourceInfo info = parent.getResourceInfo(false, false);
        parent.checkAccessible(this.getFlags(info));
        this.checkValidGroupContainer(parent, false, false);
    }

    IFileInfo create(int updateFlags, IProgressMonitor subMonitor, IFileStore store) throws CoreException, ResourceException {
        IFileInfo localInfo;
        if (BitMask.isSet(updateFlags, 1)) {
            localInfo = new FileInfo(this.getName());
        } else {
            localInfo = store.fetchInfo();
            if (localInfo.exists()) {
                String name;
                if (!Workspace.caseSensitive && (name = this.getLocalManager().getLocalName(store)) != null && !localInfo.getName().equals(name)) {
                    String message = NLS.bind((String)Messages.resources_existsLocalDifferentCase, (Object)IPath.fromOSString((String)store.toString()).removeLastSegments(1).append(name).toOSString());
                    throw new ResourceException(275, this.getFullPath(), message, null);
                }
                String message = NLS.bind((String)Messages.resources_fileExists, (Object)store.toString());
                throw new ResourceException(272, this.getFullPath(), message, null);
            }
        }
        subMonitor.done();
        this.workspace.createResource((IResource)this, updateFlags);
        return localInfo;
    }

    private void setLocal(boolean local) throws CoreException {
        this.internalSetLocal(local, 0);
        if (!local) {
            this.getResourceInfo(true, true).clearModificationStamp();
        }
    }

    @Override
    public String getCharset() throws CoreException {
        return this.getCharset(true);
    }

    @Override
    public String getCharset(boolean checkImplicit) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        if (!this.exists(flags, false)) {
            return checkImplicit ? this.workspace.getCharsetManager().getCharsetFor(this.getFullPath().removeLastSegments(1), true) : null;
        }
        this.checkLocal(flags, 0);
        try {
            return this.internalGetCharset(checkImplicit, info);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 368) {
                return checkImplicit ? this.workspace.getCharsetManager().getCharsetFor(this.getFullPath().removeLastSegments(1), true) : null;
            }
            throw e;
        }
    }

    @Override
    public String getCharsetFor(Reader contents) throws CoreException {
        IContentDescription description;
        String charset;
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        if (this.exists(flags, true) && (charset = this.workspace.getCharsetManager().getCharsetFor(this.getFullPath(), false)) != null) {
            return charset;
        }
        try {
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            description = contentTypeManager.getDescriptionFor(contents, this.getName(), new QualifiedName[]{IContentDescription.CHARSET});
        }
        catch (IOException e) {
            String message = NLS.bind((String)Messages.resources_errorContentDescription, (Object)this.getFullPath());
            throw new ResourceException(381, this.getFullPath(), message, e);
        }
        if (description != null && (charset = description.getCharset()) != null) {
            return charset;
        }
        return this.workspace.getCharsetManager().getCharsetFor(this.getFullPath().removeLastSegments(1), true);
    }

    private String internalGetCharset(boolean checkImplicit, ResourceInfo info) throws CoreException {
        String contentCharset;
        String charset = this.workspace.getCharsetManager().getCharsetFor(this.getFullPath(), false);
        if (charset != null || !checkImplicit) {
            return charset;
        }
        IContentDescription description = this.workspace.getContentDescriptionManager().getDescriptionFor(this, info, true);
        if (description != null && (contentCharset = description.getCharset()) != null) {
            return contentCharset;
        }
        return this.workspace.getCharsetManager().getCharsetFor(this.getFullPath().removeLastSegments(1), true);
    }

    @Override
    public IContentDescription getContentDescription() throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, 0);
        boolean isSynchronized = this.isSynchronized(0);
        if (!isSynchronized && !this.getLocalManager().isLightweightAutoRefreshEnabled()) {
            String message = NLS.bind((String)Messages.localstore_resourceIsOutOfSync, (Object)this.getFullPath());
            throw new ResourceException(274, this.getFullPath(), message, null);
        }
        return this.workspace.getContentDescriptionManager().getDescriptionFor(this, info, isSynchronized);
    }

    @Override
    public InputStream getContents() throws CoreException {
        return this.getContents(this.getLocalManager().isLightweightAutoRefreshEnabled());
    }

    @Override
    public InputStream getContents(boolean force) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, 0);
        return this.getLocalManager().read(this, force, null);
    }

    @Override
    public byte[] readAllBytes() throws CoreException {
        boolean force = true;
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, 0);
        return this.getLocalManager().readAllBytes(this, force, null);
    }

    @Override
    @Deprecated
    public int getEncoding() throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, 0);
        return this.getLocalManager().getEncoding(this);
    }

    @Override
    public IFileState[] getHistory(IProgressMonitor monitor) {
        return this.getLocalManager().getHistoryStore().getStates(this.getFullPath(), monitor);
    }

    @Override
    public int getType() {
        return 1;
    }

    protected void internalSetContents(InputStream content, IFileInfo fileInfo, int updateFlags, boolean append, IProgressMonitor monitor) throws CoreException {
        if (content == null) {
            content = new ByteArrayInputStream(new byte[0]);
        }
        this.getLocalManager().write((IFile)this, content, fileInfo, updateFlags, append, monitor);
        this.updateMetadataFiles();
        this.workspace.getAliasManager().updateAliases(this, this.getStore(), 0, monitor);
    }

    protected void internalSetContents(byte[] content, IFileInfo fileInfo, int updateFlags, boolean append, IProgressMonitor monitor) throws CoreException {
        if (content == null) {
            content = new byte[]{};
        }
        this.getLocalManager().write((IFile)this, content, fileInfo, updateFlags, append, monitor);
        this.updateMetadataFiles();
        this.workspace.getAliasManager().updateAliases(this, this.getStore(), 0, monitor);
    }

    static void internalSetMultipleContents(ConcurrentMap<File, byte[]> filesToCreate, int updateFlags, boolean append, IProgressMonitor monitor, ExecutorService executorService) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)filesToCreate.size());
        ArrayList<Object> futures = new ArrayList<Object>(filesToCreate.size());
        for (Map.Entry e : filesToCreate.entrySet()) {
            Future<CoreException> future = executorService.submit(() -> {
                try {
                    File file = (File)e.getKey();
                    byte[] content = (byte[])e.getValue();
                    File.writeSingle(updateFlags, append, subMonitor.slice(1), file, content);
                }
                catch (CoreException ce) {
                    return ce;
                }
                return null;
            });
            futures.add(future);
        }
        CoreException ex = null;
        for (Future future : futures) {
            CoreException ce;
            try {
                ce = (CoreException)((Object)future.get());
            }
            catch (InterruptedException | ExecutionException e) {
                ce = new CoreException(Status.error((String)"Error during parallel IO", (Throwable)e));
            }
            if (ce == null) continue;
            if (ex == null) {
                ex = ce;
                continue;
            }
            ex.addSuppressed((Throwable)ce);
        }
        if (ex != null) {
            ex.addSuppressed((Throwable)new IllegalStateException("Stacktrace of invoking parallel IO"));
            throw ex;
        }
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        for (File file : filesToCreate.keySet()) {
            file.updateMetadataFiles();
            file.workspace.getAliasManager().updateAliases(file, file.getStore(), 0, (IProgressMonitor)nullProgressMonitor);
            file.setLocal(true);
        }
    }

    private static void writeSingle(int updateFlags, boolean append, IProgressMonitor monitor, File file, byte[] content) throws CoreException, ResourceException {
        IFileStore store = file.getStore();
        NullProgressMonitor npm = new NullProgressMonitor();
        IFileInfo localInfo = file.create(updateFlags, (IProgressMonitor)npm, store);
        file.getLocalManager().write((IFile)file, content, localInfo, updateFlags, append, monitor);
    }

    @Override
    public void refreshLocal(int depth, IProgressMonitor monitor) throws CoreException {
        if (!this.getLocalManager().fastIsSynchronized(this)) {
            super.refreshLocal(0, monitor);
        }
    }

    @Override
    public void setContents(IFileState content, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.setContents(content.getContents(), updateFlags, monitor);
    }

    @Override
    public void setContents(InputStream content, int updateFlags, IProgressMonitor monitor) throws CoreException {
        String message = NLS.bind((String)Messages.resources_settingContents, (Object)this.getFullPath());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)message, (int)100);
        try {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try {
                    try {
                        if (this.workspace.shouldValidate) {
                            this.workspace.validateSave(this);
                        }
                        ISchedulingRule rule = this.workspace.getRuleFactory().modifyRule(this);
                        SubMonitor newChild = subMonitor.newChild(1);
                        try {
                            try {
                                this.workspace.prepareOperation(rule, (IProgressMonitor)newChild);
                                ResourceInfo info = this.getResourceInfo(false, false);
                                this.checkAccessible(this.getFlags(info));
                                this.workspace.beginOperation(true);
                                IFileInfo fileInfo = this.getStore().fetchInfo();
                                if (BitMask.isSet(updateFlags, 1024)) {
                                    info.set(16384);
                                }
                                this.internalSetContents(content, fileInfo, updateFlags, false, (IProgressMonitor)subMonitor.newChild(99));
                            }
                            catch (OperationCanceledException e) {
                                this.workspace.getWorkManager().operationCanceled();
                                throw e;
                            }
                        }
                        finally {
                            this.workspace.endOperation(rule, true);
                        }
                    }
                    finally {
                        if (content != null) {
                            content.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                subMonitor.done();
            }
        }
        finally {
            subMonitor.done();
        }
    }

    @Override
    public void setContents(byte[] content, int updateFlags, IProgressMonitor monitor) throws CoreException {
        String message = NLS.bind((String)Messages.resources_settingContents, (Object)this.getFullPath());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)message, (int)100);
        try {
            if (this.workspace.shouldValidate) {
                this.workspace.validateSave(this);
            }
            ISchedulingRule rule = this.workspace.getRuleFactory().modifyRule(this);
            SubMonitor newChild = subMonitor.newChild(1);
            try {
                try {
                    this.workspace.prepareOperation(rule, (IProgressMonitor)newChild);
                    ResourceInfo info = this.getResourceInfo(false, false);
                    this.checkAccessible(this.getFlags(info));
                    this.workspace.beginOperation(true);
                    IFileInfo fileInfo = this.getStore().fetchInfo();
                    if (BitMask.isSet(updateFlags, 1024)) {
                        info.set(16384);
                    }
                    this.internalSetContents(content, fileInfo, updateFlags, false, (IProgressMonitor)subMonitor.newChild(99));
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            finally {
                this.workspace.endOperation(rule, true);
            }
        }
        finally {
            subMonitor.done();
        }
    }

    @Override
    public long setLocalTimeStamp(long value) throws CoreException {
        ResourceInfo projectInfo;
        long result = super.setLocalTimeStamp(value);
        if (this.path.segmentCount() == 2 && this.path.segment(1).equals(".project") && (projectInfo = ((Project)this.getProject()).getResourceInfo(false, false)) != null) {
            this.getLocalManager().updateLocalSync(projectInfo, result);
        }
        return result;
    }

    public void updateMetadataFiles() throws CoreException {
        int count = this.path.segmentCount();
        String name = this.path.segment(1);
        if (count == 2 && name.equals(".project")) {
            Project project = (Project)this.getProject();
            project.updateDescription();
            ProjectInfo projectInfo = (ProjectInfo)project.getResourceInfo(false, true);
            projectInfo.discardNatures();
            return;
        }
        if (count == 3 && ".settings".equals(name)) {
            ProjectPreferences.updatePreferences(this);
            return;
        }
    }

    @Override
    @Deprecated
    public void setCharset(String newCharset) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(info));
        this.workspace.getCharsetManager().setCharsetFor(this.getFullPath(), newCharset);
    }

    @Override
    public void setCharset(String newCharset, IProgressMonitor monitor) throws CoreException {
        String message = NLS.bind((String)Messages.resources_settingCharset, (Object)this.getFullPath());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)message, (int)100);
        ISchedulingRule rule = this.workspace.getRuleFactory().charsetRule(this);
        SubMonitor newChild = subMonitor.newChild(1);
        try {
            try {
                this.workspace.prepareOperation(rule, (IProgressMonitor)newChild);
                ResourceInfo info = this.getResourceInfo(false, false);
                this.checkAccessible(this.getFlags(info));
                this.workspace.beginOperation(true);
                this.workspace.getCharsetManager().setCharsetFor(this.getFullPath(), newCharset);
                info = this.getResourceInfo(false, true);
                info.incrementCharsetGenerationCount();
                subMonitor.worked(99);
            }
            catch (OperationCanceledException e) {
                this.workspace.getWorkManager().operationCanceled();
                throw e;
            }
        }
        finally {
            subMonitor.done();
            this.workspace.endOperation(rule, true);
        }
    }

    @Override
    public void setContents(InputStream content, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.setContents(content, updateFlags |= keepHistory ? 2 : 0, monitor);
    }

    @Override
    public void setContents(IFileState source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.setContents(source.getContents(), updateFlags |= keepHistory ? 2 : 0, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getLineSeparator(boolean checkParent) throws CoreException {
        block16: {
            if (this.exists()) {
                try {
                    Throwable throwable = null;
                    Object var3_6 = null;
                    try (BufferedInputStream input = new BufferedInputStream(this.getContents(), 128);){
                        int c = ((InputStream)input).read();
                        while (true) {
                            if (c == -1 || c == 13 || c == 10) {
                                if (c != 10) break;
                                return "\n";
                            }
                            c = ((InputStream)input).read();
                        }
                        if (c == 13) {
                            if (((InputStream)input).read() != 10) return "\r";
                            return "\r\n";
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        }
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                        throw throwable;
                    }
                }
                catch (CoreException core) {
                    if (!checkParent) {
                        throw core;
                    }
                }
                catch (IOException io) {
                    if (checkParent) break block16;
                    throw new CoreException(Status.error((String)io.getMessage(), (Throwable)io));
                }
            }
        }
        if (!checkParent) return null;
        String string = this.getProject().getDefaultLineSeparator();
        return string;
    }
}

