/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.nio.CharBuffer;
import java.util.Comparator;
import org.jkiss.code.NotNull;

public class AlphanumericComparator
implements Comparator<CharSequence> {
    private static final AlphanumericComparator INSTANCE = new AlphanumericComparator();

    private AlphanumericComparator() {
    }

    @NotNull
    public static AlphanumericComparator getInstance() {
        return INSTANCE;
    }

    @Override
    public int compare(CharSequence o1, CharSequence o2) {
        return this.compare(o1, o2, false);
    }

    public int compareIgnoreCase(@NotNull CharSequence o1, @NotNull CharSequence o2) {
        return this.compare(o1, o2, true);
    }

    private int compare(@NotNull CharSequence o1, @NotNull CharSequence o2, boolean ignoreCase) {
        CharBuffer b1 = CharBuffer.wrap(o1);
        CharBuffer b2 = CharBuffer.wrap(o2);
        while (b1.hasRemaining() && b2.hasRemaining()) {
            AlphanumericComparator.adjustBufferWindow(b1);
            AlphanumericComparator.adjustBufferWindow(b2);
            int result = AlphanumericComparator.compare(b1, b2, ignoreCase);
            if (result != 0) {
                return result;
            }
            AlphanumericComparator.resetBufferWindow(b1);
            AlphanumericComparator.resetBufferWindow(b2);
        }
        return Integer.compare(b1.remaining(), b2.remaining());
    }

    private static int compare(@NotNull CharBuffer b1, @NotNull CharBuffer b2, boolean ignoreCase) {
        if (AlphanumericComparator.isDigit(b1, b1.position()) && AlphanumericComparator.isDigit(b2, b2.position())) {
            int result = Integer.compare(b1.remaining(), b2.remaining());
            if (result != 0) {
                return result;
            }
            return b1.compareTo(b2);
        }
        return ignoreCase ? AlphanumericComparator.compareLettersIgnoreCase(b1, b2) : b1.compareTo(b2);
    }

    private static int compareLettersIgnoreCase(@NotNull CharBuffer b1, @NotNull CharBuffer b2) {
        int len = Math.min(b1.remaining(), b2.remaining());
        int i = 0;
        while (i < len) {
            char c2;
            char c1 = Character.toUpperCase(b1.get(b1.position() + i));
            int compareResult = Character.compare(c1, c2 = Character.toUpperCase(b2.get(b2.position() + i)));
            if (compareResult != 0) {
                return compareResult;
            }
            ++i;
        }
        return b1.remaining() - b2.remaining();
    }

    private static void resetBufferWindow(@NotNull CharBuffer buffer) {
        buffer.position(buffer.limit());
        buffer.limit(buffer.capacity());
    }

    private static void adjustBufferWindow(@NotNull CharBuffer buffer) {
        int start = buffer.position();
        int end = buffer.position();
        boolean digit = AlphanumericComparator.isDigit(buffer, start);
        while (end < buffer.limit() && digit == AlphanumericComparator.isDigit(buffer, end)) {
            if (!digit || start + 1 >= buffer.limit() || !AlphanumericComparator.isZero(buffer, start) || !AlphanumericComparator.isDigit(buffer, ++end)) continue;
            ++start;
        }
        buffer.position(start).limit(end);
    }

    private static boolean isDigit(@NotNull CharBuffer buffer, int position) {
        char ch = buffer.get(position);
        return ch >= '0' && ch <= '9';
    }

    private static boolean isZero(@NotNull CharBuffer buffer, int position) {
        return buffer.get(position) == '0';
    }
}

