/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.synchronize.IRefreshEvent;
import org.eclipse.team.internal.ui.synchronize.IRefreshSubscriberListener;
import org.eclipse.team.internal.ui.synchronize.IRefreshable;
import org.eclipse.team.internal.ui.synchronize.RefreshParticipantJob;
import org.eclipse.team.internal.ui.synchronize.RefreshUserNotificationPolicy;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionFactory;

public class SubscriberRefreshSchedule {
    private long refreshInterval = 3600L;
    private Date refreshStart;
    private boolean runOnce = false;
    private boolean enabled = false;
    private RefreshParticipantJob job;
    private final IRefreshable refreshable;
    private IRefreshEvent lastRefreshEvent;
    private static final String CTX_REFRESHSCHEDULE_INTERVAL = "org.eclipse.team.ui.CTX_REFRESHSCHEDULE_INTERVAL";
    private static final String CTX_REFRESHSCHEDULE_ENABLED = "org.eclipse.team.ui.CTX_REFRESHSCHEDULE_ENABLED";
    private static final String CTX_REFRESHSCHEDULE_START = "org.eclipse.team.ui.CTX_REFRESHSCHEDULE_START";
    private static final String CTX_REFRESHSCHEDULE_RUNONCE = "org.eclipse.team.ui.CTX_REFRESHSCHEDULE_RUNONCE";
    private final IRefreshSubscriberListener refreshSubscriberListener = new IRefreshSubscriberListener(){

        @Override
        public void refreshStarted(IRefreshEvent event) {
        }

        @Override
        public ActionFactory.IWorkbenchAction refreshDone(IRefreshEvent event) {
            if (this.getRefreshable(event.getParticipant()) == SubscriberRefreshSchedule.this.refreshable) {
                SubscriberRefreshSchedule.this.lastRefreshEvent = event;
                if (SubscriberRefreshSchedule.this.enabled && event.getRefreshType() == 1) {
                    RefreshUserNotificationPolicy policy = new RefreshUserNotificationPolicy(SubscriberRefreshSchedule.this.refreshable.getParticipant());
                    policy.refreshDone(event);
                }
            }
            return null;
        }

        private IRefreshable getRefreshable(ISynchronizeParticipant participant) {
            return (IRefreshable)Adapters.adapt((Object)participant, IRefreshable.class);
        }
    };

    public SubscriberRefreshSchedule(IRefreshable refreshable) {
        this.refreshable = refreshable;
        RefreshParticipantJob.addRefreshListener(this.refreshSubscriberListener);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled, boolean allowedToStart) {
        boolean wasEnabled = this.isEnabled();
        this.enabled = enabled;
        if (enabled && !wasEnabled) {
            if (allowedToStart) {
                this.startJob();
            }
        } else {
            this.stopJob();
        }
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public ISynchronizeParticipant getParticipant() {
        return this.refreshable.getParticipant();
    }

    public void setRefreshInterval(long refreshInterval) {
        if (refreshInterval != this.getRefreshInterval()) {
            this.stopJob();
            this.refreshInterval = refreshInterval;
            this.runOnce = false;
            if (this.isEnabled()) {
                this.startJob();
            }
        }
    }

    public void startJob() {
        if (this.job == null) {
            this.job = this.refreshable.createJob(this.getRefreshIntervalAsString());
            this.job.setUser(false);
        } else if (this.job.getState() != 0) {
            this.stopJob();
        }
        this.job.setRefreshInterval(this.getRefreshInterval());
        this.job.setRestartOnCancel(true);
        this.job.setReschedule(!this.runOnce);
        if (this.refreshStart != null) {
            this.job.schedule(this.getJobDelay());
        } else {
            this.job.schedule();
        }
    }

    private long getJobDelay() {
        Calendar now = Calendar.getInstance();
        Calendar start = Calendar.getInstance();
        start.setTime(this.refreshStart);
        while (now.after(start)) {
            start.add(5, 1);
        }
        return start.getTimeInMillis() - now.getTimeInMillis();
    }

    protected void stopJob() {
        if (this.job != null) {
            this.job.setRestartOnCancel(false);
            this.job.setReschedule(false);
            this.job.cancel();
            this.job = null;
        }
    }

    public void dispose() {
        this.stopJob();
        RefreshParticipantJob.removeRefreshListener(this.refreshSubscriberListener);
    }

    public void saveState(IMemento memento) {
        memento.putString(CTX_REFRESHSCHEDULE_ENABLED, Boolean.toString(this.enabled));
        memento.putInteger(CTX_REFRESHSCHEDULE_INTERVAL, (int)this.refreshInterval);
        if (this.refreshStart != null) {
            memento.putString(CTX_REFRESHSCHEDULE_START, Long.toString(this.refreshStart.getTime()));
        }
        memento.putString(CTX_REFRESHSCHEDULE_RUNONCE, Boolean.toString(this.runOnce));
    }

    public static SubscriberRefreshSchedule init(IMemento memento, IRefreshable refreshable) {
        SubscriberRefreshSchedule schedule = new SubscriberRefreshSchedule(refreshable);
        if (memento != null) {
            String enabled = memento.getString(CTX_REFRESHSCHEDULE_ENABLED);
            int interval = memento.getInteger(CTX_REFRESHSCHEDULE_INTERVAL);
            String startString = memento.getString(CTX_REFRESHSCHEDULE_START);
            String runOnce = memento.getString(CTX_REFRESHSCHEDULE_RUNONCE);
            if (startString != null) {
                long start = Long.parseLong(startString);
                schedule.setRefreshStartTime(new Date(start));
            }
            schedule.setRefreshInterval(interval);
            schedule.setRunOnce("true".equals(runOnce));
            schedule.setEnabled("true".equals(enabled), false);
        }
        return schedule;
    }

    public static String refreshEventAsString(IRefreshEvent event) {
        if (event == null) {
            return TeamUIMessages.SyncViewPreferencePage_lastRefreshRunNever;
        }
        long stopMills = event.getStopTime();
        StringBuilder text = new StringBuilder();
        if (stopMills <= 0L) {
            text.append(TeamUIMessages.SyncViewPreferencePage_lastRefreshRunNever);
        } else {
            Date lastTimeRun = new Date(stopMills);
            text.append(DateFormat.getDateTimeInstance(3, 3).format(lastTimeRun));
        }
        int changeCount = event.getChangeDescription().getChangeCount();
        if (changeCount == 0) {
            text.append(TeamUIMessages.RefreshSchedule_7);
        } else if (changeCount == 1) {
            text.append(NLS.bind((String)TeamUIMessages.RefreshSchedule_changesSingular, (Object)Integer.toString(changeCount)));
        } else {
            text.append(NLS.bind((String)TeamUIMessages.RefreshSchedule_changesPlural, (Object)Integer.toString(changeCount)));
        }
        return text.toString();
    }

    public IRefreshEvent getLastRefreshEvent() {
        return this.lastRefreshEvent;
    }

    private String getRefreshIntervalAsString() {
        long minutes;
        if (this.runOnce) {
            return TeamUIMessages.RefreshSchedule_16;
        }
        boolean hours = false;
        long seconds = this.getRefreshInterval();
        if (seconds <= 60L) {
            seconds = 60L;
        }
        if ((minutes = seconds / 60L) >= 60L) {
            minutes /= 60L;
            hours = true;
        }
        String unit = minutes >= 1L ? (hours ? TeamUIMessages.RefreshSchedule_9 : TeamUIMessages.RefreshSchedule_10) : (hours ? TeamUIMessages.RefreshSchedule_11 : TeamUIMessages.RefreshSchedule_12);
        return NLS.bind((String)TeamUIMessages.RefreshSchedule_13, (Object)Long.toString(minutes), (Object)unit);
    }

    public IRefreshable getRefreshable() {
        return this.refreshable;
    }

    public Date getRefreshStartTime() {
        return this.refreshStart;
    }

    public void setRefreshStartTime(Date refreshStart) {
        if (refreshStart == null || refreshStart != this.getRefreshStartTime()) {
            this.stopJob();
            this.refreshStart = refreshStart;
            if (this.isEnabled()) {
                this.startJob();
            }
        }
    }

    public boolean getRunOnce() {
        return this.runOnce;
    }

    public void setRunOnce(boolean runOnce) {
        if (runOnce != this.getRunOnce()) {
            this.stopJob();
            this.runOnce = runOnce;
            if (this.isEnabled()) {
                this.startJob();
            }
        }
    }
}

