/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataType;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataTypeMember;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataTypeModifier;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;

public class OracleDataTypeAttribute
extends OracleDataTypeMember
implements DBSEntityAttribute,
DBSTypedObjectEx {
    private final OracleDataType attrType;
    private final OracleDataTypeModifier attrTypeMod;
    private final Integer length;
    private final Integer precision;
    private final Integer scale;

    public OracleDataTypeAttribute(DBRProgressMonitor monitor, OracleDataType dataType, ResultSet dbResult) {
        super(dataType, dbResult);
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ATTR_NAME");
        this.number = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"ATTR_NO");
        this.attrType = OracleDataType.resolveDataType(monitor, this.getDataSource(), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ATTR_TYPE_OWNER"), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ATTR_TYPE_NAME"));
        this.attrTypeMod = OracleDataTypeModifier.resolveTypeModifier(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ATTR_TYPE_MOD"));
        this.length = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"LENGTH");
        this.precision = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"PRECISION");
        this.scale = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"SCALE");
    }

    @Property(viewable=true, editable=true, order=3)
    public OracleDataType getDataType() {
        return this.attrType;
    }

    @Property(viewable=true, editable=true, order=4)
    public OracleDataTypeModifier getAttrTypeMod() {
        return this.attrTypeMod;
    }

    @Property(viewable=true, editable=true, order=6)
    @Nullable
    public Integer getPrecision() {
        return this.precision == null ? 0 : this.precision;
    }

    @Property(viewable=true, editable=true, order=5)
    public long getMaxLength() {
        return this.length == null ? 0 : this.length;
    }

    public long getTypeModifiers() {
        return 0L;
    }

    @Property(viewable=true, editable=true, order=7)
    @Nullable
    public Integer getScale() {
        return this.scale == null ? 0 : this.scale;
    }

    public int getTypeID() {
        if (this.attrTypeMod == OracleDataTypeModifier.REF) {
            return 2006;
        }
        return this.attrType.getTypeID();
    }

    @NotNull
    public DBPDataKind getDataKind() {
        if (this.attrTypeMod == OracleDataTypeModifier.REF) {
            return DBPDataKind.REFERENCE;
        }
        return this.attrType.getDataKind();
    }

    @NotNull
    public String getTypeName() {
        return this.attrType.getFullyQualifiedName(DBPEvaluationContext.DDL);
    }

    @NotNull
    public String getFullTypeName() {
        return DBUtils.getFullTypeName((DBSTypedObject)this);
    }

    public boolean isRequired() {
        return false;
    }

    public boolean isAutoGenerated() {
        return false;
    }

    @Property(viewable=true, order=2)
    public int getOrdinalPosition() {
        return this.number - 1;
    }

    public String getDefaultValue() {
        return null;
    }

    public String toString() {
        return this.getParentObject().getFullyQualifiedName(DBPEvaluationContext.UI) + "." + this.getName();
    }
}

