/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.utils.CommonUtils;

public class GlobalProxySelector
extends ProxySelector {
    private static final Log log = Log.getLog(GlobalProxySelector.class);
    private final ProxySelector parent;

    public GlobalProxySelector(ProxySelector parent) {
        this.parent = parent;
    }

    public ProxySelector getParent() {
        return this.parent;
    }

    @Override
    public List<Proxy> select(URI uri) {
        List<Proxy> proxies;
        DBPDataSourceContainer dataSourceContainer = this.getActiveDataSourceContainer(uri);
        if (dataSourceContainer != null && (proxies = this.getProxiesForDataSource(uri, dataSourceContainer)) != null) {
            return proxies;
        }
        return this.parent.select(uri);
    }

    @Nullable
    protected List<Proxy> getProxiesForDataSource(@NotNull URI uri, @NotNull DBPDataSourceContainer dataSourceContainer) {
        if ("socket".equals(uri.getScheme())) {
            ArrayList<Proxy> proxies = null;
            for (DBWHandlerConfiguration networkHandler : dataSourceContainer.getActualConnectionConfiguration().getHandlers()) {
                if (!networkHandler.isEnabled() || networkHandler.getType() != DBWHandlerType.PROXY) continue;
                String proxyHost = networkHandler.getStringProperty("socks-host");
                int proxyPort = networkHandler.getIntProperty("socks-port");
                if (CommonUtils.isEmpty((String)proxyHost) || proxyPort == 0) continue;
                InetSocketAddress proxyAddr = new InetSocketAddress(proxyHost, proxyPort);
                Proxy proxy = new Proxy(Proxy.Type.SOCKS, proxyAddr);
                if (proxies == null) {
                    proxies = new ArrayList<Proxy>();
                }
                proxies.add(proxy);
                log.debug("Use SOCKS proxy [" + String.valueOf(proxyAddr) + "]");
            }
            return proxies;
        }
        return null;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        this.parent.connectFailed(uri, sa, ioe);
    }

    @Nullable
    protected DBPDataSourceContainer getActiveDataSourceContainer(@NotNull URI uri) {
        String scheme = uri.getScheme();
        if (CommonUtils.isEmpty((String)scheme)) {
            return null;
        }
        String host = uri.getHost();
        if (CommonUtils.isEmpty((String)host)) {
            return null;
        }
        int port = uri.getPort();
        String path = uri.getPath();
        return DBExecUtils.findConnectionContext(host, port, path);
    }
}

