/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.fs.lock;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class FileLockInfo {
    @NotNull
    private final String applicationId;
    @NotNull
    private final String operationId;
    @Nullable
    private final String operationName;
    private final long operationStartTime;

    private FileLockInfo(@NotNull String applicationId, @NotNull String operationId, @NotNull String operationName, long operationStartTime) {
        this.applicationId = applicationId;
        this.operationId = operationId;
        this.operationName = operationName;
        this.operationStartTime = operationStartTime;
    }

    static FileLockInfo emptyLock() {
        return new FileLockInfo("", "", "", System.currentTimeMillis());
    }

    public boolean isBlank() {
        return this.operationId.isEmpty();
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public long getOperationStartTime() {
        return this.operationStartTime;
    }

    public static class Builder {
        private String applicationId;
        private final String operationId;
        private String operationName;
        private long operationStartTime;

        public Builder(String operationId) {
            this.operationId = operationId;
        }

        public Builder setApplicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder setOperationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public Builder setOperationStartTime(long operationStartTime) {
            this.operationStartTime = operationStartTime;
            return this;
        }

        public FileLockInfo build() {
            return new FileLockInfo(this.applicationId, this.operationId, this.operationName, this.operationStartTime);
        }
    }
}

