/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.prefs;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.tools.transfer.DTConstants;
import org.jkiss.dbeaver.tools.transfer.internal.DTActivator;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageDataTransfer
extends TargetPrefPage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.datatransfer";
    private Button reconnectToLastDatabaseButton;
    private Text fallbackOutputDirectoryText;
    private Combo nameCaseCombo;
    private Combo replaceCombo;
    private Spinner typeLengthSpinner;

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dsContainer) {
        DBPPreferenceStore store = dsContainer.getPreferenceStore();
        return store.contains("nameCaseMapping") || store.contains("replaceMapping") || store.contains("maxTypeLengthMapping");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @NotNull
    protected String getPropertyPageID() {
        return PAGE_ID;
    }

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite group;
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        DBPPreferenceStore preferences = DTActivator.getDefault().getPreferences();
        if (!this.isDataSourcePreferencePage()) {
            group = UIUtils.createTitledComposite((Composite)composite, (String)DTUIMessages.pref_data_transfer_wizard_title, (int)1, (int)768, (int)0);
            this.reconnectToLastDatabaseButton = UIUtils.createCheckbox((Composite)group, (String)DTUIMessages.pref_data_transfer_wizard_reconnect_to_database, (boolean)preferences.getBoolean("reconnectToLastDatabase"));
        }
        if (!this.isDataSourcePreferencePage()) {
            group = UIUtils.createTitledComposite((Composite)composite, (String)DTUIMessages.pref_data_transfer_options_title, (int)2);
            this.fallbackOutputDirectoryText = DialogUtils.createOutputFolderChooser((Composite)group, (String)DTUIMessages.pref_data_transfer_options_fallback_directory, (String)DTUIMessages.pref_data_transfer_options_fallback_directory_tip, null, null, (boolean)false, null);
            this.fallbackOutputDirectoryText.setMessage(DTConstants.DEFAULT_FALLBACK_OUTPUT_DIRECTORY);
        }
        Composite mappingGroup = UIUtils.createTitledComposite((Composite)composite, (String)DTUIMessages.pref_data_transfer_mapping_group, (int)2);
        this.nameCaseCombo = UIUtils.createLabelCombo((Composite)mappingGroup, (String)DTUIMessages.pref_data_transfer_name_case_label, (int)12);
        this.nameCaseCombo.setLayoutData((Object)new GridData(32));
        this.nameCaseCombo.add(DTMessages.pref_data_transfer_name_case_default);
        this.nameCaseCombo.add(DTMessages.pref_data_transfer_name_case_upper);
        this.nameCaseCombo.add(DTMessages.pref_data_transfer_name_case_lower);
        this.replaceCombo = UIUtils.createLabelCombo((Composite)mappingGroup, (String)DTUIMessages.pref_data_transfer_replacing_combo_label, (int)12);
        this.replaceCombo.setLayoutData((Object)new GridData(32));
        this.replaceCombo.add(DTMessages.pref_data_transfer_replacing_combo_do_not);
        this.replaceCombo.add(DTMessages.pref_data_transfer_replacing_combo_underscores);
        this.replaceCombo.add(DTMessages.pref_data_transfer_replacing_combo_camel_case);
        this.replaceCombo.setToolTipText(DTUIMessages.pref_data_transfer_replacing_combo_tip);
        UIUtils.createControlLabel((Composite)mappingGroup, (String)DTUIMessages.pref_data_transfer_spanner_max_length);
        this.typeLengthSpinner = UIUtils.createSpinner((Composite)mappingGroup, (String)DTUIMessages.pref_data_transfer_spanner_max_length_tip, (int)Short.MAX_VALUE, (int)1, (int)Integer.MAX_VALUE);
        UIUtils.createInfoLabel((Composite)mappingGroup, (String)DTUIMessages.pref_data_transfer_info_label_mapping, (int)32, (int)2);
        return composite;
    }

    protected void loadPreferences(@NotNull DBPPreferenceStore store) {
        DBPPreferenceStore preferences = DTActivator.getDefault().getPreferences();
        if (this.reconnectToLastDatabaseButton != null) {
            this.reconnectToLastDatabaseButton.setSelection(preferences.getBoolean("reconnectToLastDatabase"));
        }
        if (this.fallbackOutputDirectoryText != null) {
            this.fallbackOutputDirectoryText.setText(CommonUtils.notEmpty((String)preferences.getString("fallbackOutputDirectory")));
        }
        if (this.isDataSourcePreferencePage()) {
            preferences = store;
        }
        this.nameCaseCombo.select(preferences.getInt("nameCaseMapping"));
        this.replaceCombo.select(preferences.getInt("replaceMapping"));
        this.typeLengthSpinner.setSelection(preferences.contains("maxTypeLengthMapping") ? preferences.getInt("maxTypeLengthMapping") : Short.MAX_VALUE);
    }

    protected void savePreferences(@NotNull DBPPreferenceStore store) {
        DBPPreferenceStore preferences = DTActivator.getDefault().getPreferences();
        if (this.reconnectToLastDatabaseButton != null) {
            preferences.setValue("reconnectToLastDatabase", this.reconnectToLastDatabaseButton.getSelection());
        }
        if (this.fallbackOutputDirectoryText != null) {
            preferences.setValue("fallbackOutputDirectory", this.fallbackOutputDirectoryText.getText());
        }
        if (this.isDataSourcePreferencePage()) {
            preferences = store;
        }
        preferences.setValue("nameCaseMapping", this.nameCaseCombo.getSelectionIndex());
        preferences.setValue("replaceMapping", this.replaceCombo.getSelectionIndex());
        preferences.setValue("maxTypeLengthMapping", this.typeLengthSpinner.getSelection());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)preferences);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("reconnectToLastDatabase");
        store.setToDefault("fallbackOutputDirectory");
        store.setToDefault("nameCaseMapping");
        store.setToDefault("replaceMapping");
        store.setToDefault("maxTypeLengthMapping");
    }

    protected void performDefaults() {
        DBPPreferenceStore preferences = DTActivator.getDefault().getPreferences();
        if (this.reconnectToLastDatabaseButton != null) {
            this.reconnectToLastDatabaseButton.setSelection(preferences.getDefaultBoolean("reconnectToLastDatabase"));
        }
        if (this.fallbackOutputDirectoryText != null) {
            this.fallbackOutputDirectoryText.setText("");
            this.fallbackOutputDirectoryText.setMessage(preferences.getDefaultString("fallbackOutputDirectory"));
        }
        this.nameCaseCombo.select(preferences.getDefaultInt("nameCaseMapping"));
        this.replaceCombo.select(preferences.getDefaultInt("replaceMapping"));
        this.typeLengthSpinner.setSelection(preferences.getDefaultInt("maxTypeLengthMapping"));
    }
}

