/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.wizards.IWizardCategory;

public class WizardPatternFilter
extends PatternFilter {
    @Override
    public boolean isElementSelectable(Object element) {
        return element instanceof WorkbenchWizardElement;
    }

    @Override
    protected boolean isLeafMatch(Viewer viewer, Object element) {
        if (element instanceof WorkbenchWizardElement) {
            WorkbenchWizardElement desc = (WorkbenchWizardElement)element;
            if (Stream.of(this.getWizardCategories(desc.getCategory()), Stream.of(desc.getLabel(), desc.getDescription()), Stream.of(desc.getKeywordLabels())).flatMap(Function.identity()).anyMatch(this::wordMatches)) {
                return true;
            }
        }
        return false;
    }

    private Stream<String> getWizardCategories(IWizardCategory category) {
        if (category == null) {
            return Stream.empty();
        }
        return Stream.iterate(category, current -> current.getParent() != null, IWizardCategory::getParent).map(IWizardCategory::getLabel);
    }

    @Override
    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] objectArray = super.filter(viewer, parent, elements);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object elem = objectArray[n2];
            if (elem instanceof WizardCollectionElement) {
                WizardCollectionElement wizardCollection = WizardCollectionElement.filter(viewer, this, (WizardCollectionElement)elem);
                if (wizardCollection != null) {
                    result.add(wizardCollection);
                }
            } else {
                result.add(elem);
            }
            ++n2;
        }
        return result.toArray();
    }
}

