/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.config.migration.wizards.pgadmin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.annotations.SerializedName;
import java.io.Reader;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.ui.config.migration.wizards.ImportConnectionInfo;
import org.jkiss.dbeaver.ui.config.migration.wizards.ImportData;
import org.jkiss.dbeaver.ui.config.migration.wizards.ImportDriverInfo;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.StringUtils;

public class PgAdminImportConfigurationService {
    private static final Log log = Log.getLog(PgAdminImportConfigurationService.class);
    private static final String DRIVER_ID_POSTGRESQL = "postgres-jdbc";
    private static final String STORAGE_PLACEHOLDER = "<STORAGE_DIR>";
    public static final PgAdminImportConfigurationService INSTANCE = new PgAdminImportConfigurationService();
    private static final Gson GSON = new GsonBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).create();
    private final ImportDriverInfo postgresqlDriver;

    private PgAdminImportConfigurationService() {
        DataSourceProviderRegistry registry = DataSourceProviderRegistry.getInstance();
        DBPDriver driver = registry.findDriver(DRIVER_ID_POSTGRESQL);
        this.postgresqlDriver = driver != null ? new ImportDriverInfo(driver) : new ImportDriverInfo(DRIVER_ID_POSTGRESQL, "PostgreSQL", "jdbc:postgresql://{host}[:{port}]/{database}", "org.postgresql.Driver");
    }

    public void importJSON(@NotNull ImportData importData, @NotNull Reader reader) {
        PgAdminRoot root = (PgAdminRoot)GSON.fromJson(reader, PgAdminRoot.class);
        if (root == null || root.servers == null || root.servers.isEmpty()) {
            log.debug((Object)"Empty or invalid pgAdmin config JSON or no 'Servers' found");
            return;
        }
        if (importData.getDriverByID(this.postgresqlDriver.getId()) == null) {
            importData.addDriver(this.postgresqlDriver);
        }
        for (Map.Entry<String, PgAdminServer> entry : root.servers.entrySet()) {
            String host;
            PgAdminServer pgAdminServer = entry.getValue();
            if (pgAdminServer == null || CommonUtils.isEmpty((String)(host = StringUtils.firstNonEmpty((String)pgAdminServer.host, (String)pgAdminServer.hostAlt)))) continue;
            String db = pgAdminServer.maintenanceDB;
            String user = pgAdminServer.username;
            String port = String.valueOf(pgAdminServer.port);
            ImportConnectionInfo conn = new ImportConnectionInfo(this.postgresqlDriver, null, pgAdminServer.name, null, host, port, CommonUtils.isEmpty((String)db) ? null : db, CommonUtils.isEmpty((String)user) ? null : user, null);
            if (pgAdminServer.connectionParameters != null && !pgAdminServer.connectionParameters.isEmpty()) {
                this.applyConnectionParameters(conn, pgAdminServer.connectionParameters);
            }
            importData.addConnection(conn);
        }
    }

    @Nullable
    private String expandStorageDir(@Nullable String value) {
        if (CommonUtils.isEmpty((String)value)) {
            return value;
        }
        String home = System.getProperty("user.home");
        return value.replace(STORAGE_PLACEHOLDER, CommonUtils.notEmpty((String)home));
    }

    private void applyConnectionParameters(@NotNull ImportConnectionInfo conn, @NotNull Map<String, Object> params) {
        for (Map.Entry<String, Object> pe : params.entrySet()) {
            String propertyName = pe.getKey();
            Object propertyValue = pe.getValue();
            if (CommonUtils.isEmpty((String)propertyName) || propertyValue == null) continue;
            String formattedName = StringUtils.underscoreToCamelCase((String)propertyName);
            String strVal = this.expandStorageDir(String.valueOf(propertyValue));
            if (!CommonUtils.isNotEmpty((String)strVal)) continue;
            conn.setProperty(formattedName, strVal);
        }
    }

    private static class PgAdminRoot {
        @SerializedName(value="Servers")
        Map<String, PgAdminServer> servers;

        private PgAdminRoot() {
        }
    }

    private static class PgAdminServer {
        @SerializedName(value="Host")
        String host;
        @SerializedName(value="host")
        String hostAlt;
        @SerializedName(value="Name")
        String name;
        @SerializedName(value="Port")
        Integer port;
        @SerializedName(value="Username")
        String username;
        @SerializedName(value="MaintenanceDB")
        String maintenanceDB;
        @SerializedName(value="ConnectionParameters")
        Map<String, Object> connectionParameters;

        private PgAdminServer() {
        }
    }
}

