/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.auth;

import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.auth.SQLServerAuthModelAbstract;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class SQLServerAuthModelNTLM
extends SQLServerAuthModelAbstract {
    public static final String ID = "sqlserver_ntlm";

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull AuthModelDatabaseNativeCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        super.initAuthentication(monitor, dataSource, credentials, configuration, connProperties);
        if (!connProperties.contains("integratedSecurity")) {
            connProperties.put("integratedSecurity", String.valueOf(true));
        }
        connProperties.put("authenticationScheme", "NTLM");
        String userName = configuration.getUserName();
        int divPos = userName.indexOf(64);
        if (divPos != -1) {
            connProperties.put("domain", userName.substring(divPos + 1));
            connProperties.put("user", userName.substring(0, divPos));
        }
        return credentials;
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
        super.endAuthentication(dataSource, configuration, connProperties);
    }
}

