/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.felix.resolver.Blame;
import org.apache.felix.resolver.Candidates;
import org.apache.felix.resolver.ResolutionError;
import org.apache.felix.resolver.ResolverImpl;
import org.apache.felix.resolver.Util;
import org.apache.felix.resolver.reason.ReasonException;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;

final class UseConstraintError
extends ResolutionError {
    private final ResolveContext m_context;
    private final Candidates m_allCandidates;
    private final Resource m_resource;
    private final String m_pkgName;
    private final Blame m_blame1;
    private final Blame m_blame2;

    public UseConstraintError(ResolveContext context, Candidates allCandidates, Resource resource, String pkgName, Blame blame) {
        this(context, allCandidates, resource, pkgName, blame, null);
    }

    public UseConstraintError(ResolveContext context, Candidates allCandidates, Resource resource, String pkgName, Blame blame1, Blame blame2) {
        this.m_context = context;
        this.m_allCandidates = allCandidates;
        this.m_resource = resource;
        this.m_pkgName = pkgName;
        if (blame1 == null) {
            throw new NullPointerException("First blame cannot be null.");
        }
        this.m_blame1 = blame1;
        this.m_blame2 = blame2;
    }

    @Override
    public String getMessage() {
        if (this.m_blame2 == null) {
            return "Uses constraint violation. Unable to resolve resource " + Util.getSymbolicName(this.m_resource) + " [" + this.m_resource + "] because it exports package '" + this.m_pkgName + "' and is also exposed to it from resource " + Util.getSymbolicName(this.m_blame1.m_cap.getResource()) + " [" + this.m_blame1.m_cap.getResource() + "] via the following dependency chain:\n\n" + this.toStringBlame(this.m_blame1);
        }
        return "Uses constraint violation. Unable to resolve resource " + Util.getSymbolicName(this.m_resource) + " [" + this.m_resource + "] because it is exposed to package '" + this.m_pkgName + "' from resources " + Util.getSymbolicName(this.m_blame1.m_cap.getResource()) + " [" + this.m_blame1.m_cap.getResource() + "] and " + Util.getSymbolicName(this.m_blame2.m_cap.getResource()) + " [" + this.m_blame2.m_cap.getResource() + "] via two dependency chains.\n\nChain 1:\n" + this.toStringBlame(this.m_blame1) + "\n\nChain 2:\n" + this.toStringBlame(this.m_blame2);
    }

    @Override
    public Collection<Requirement> getUnresolvedRequirements() {
        if (this.m_blame2 == null) {
            return Collections.singleton(this.m_blame1.m_reqs.get(0));
        }
        return Collections.singleton(this.m_blame2.m_reqs.get(0));
    }

    private String toStringBlame(Blame blame) {
        StringBuilder sb = new StringBuilder();
        if (blame.m_reqs != null && !blame.m_reqs.isEmpty()) {
            int i = 0;
            while (i < blame.m_reqs.size()) {
                Requirement req = blame.m_reqs.get(i);
                sb.append("  ");
                sb.append(Util.getSymbolicName(req.getResource()));
                sb.append(" [");
                sb.append(req.getResource().toString());
                sb.append("]\n");
                if (req.getNamespace().equals("osgi.wiring.package")) {
                    sb.append("    import: ");
                } else {
                    sb.append("    require: ");
                }
                sb.append(req.getDirectives().get("filter"));
                sb.append("\n     |");
                if (req.getNamespace().equals("osgi.wiring.package")) {
                    sb.append("\n    export: ");
                } else {
                    sb.append("\n    provide: ");
                }
                if (i + 1 < blame.m_reqs.size()) {
                    Capability cap = this.getSatisfyingCapability(blame.m_reqs.get(i));
                    if (cap.getNamespace().equals("osgi.wiring.package")) {
                        sb.append("osgi.wiring.package");
                        sb.append("=");
                        sb.append(cap.getAttributes().get("osgi.wiring.package"));
                        Capability usedCap = this.getSatisfyingCapability(blame.m_reqs.get(i + 1));
                        sb.append("; uses:=");
                        sb.append(usedCap.getAttributes().get("osgi.wiring.package"));
                    } else {
                        sb.append(cap);
                    }
                    sb.append("\n");
                } else {
                    Capability export = this.getSatisfyingCapability(blame.m_reqs.get(i));
                    sb.append(export.getNamespace());
                    sb.append(": ");
                    Object namespaceVal = export.getAttributes().get(export.getNamespace());
                    if (namespaceVal != null) {
                        sb.append(namespaceVal.toString());
                    } else {
                        for (Map.Entry<String, Object> attrEntry : export.getAttributes().entrySet()) {
                            sb.append(attrEntry.getKey()).append('=').append(attrEntry.getValue()).append(';');
                        }
                    }
                    if (export.getNamespace().equals("osgi.wiring.package") && !export.getAttributes().get("osgi.wiring.package").equals(blame.m_cap.getAttributes().get("osgi.wiring.package"))) {
                        sb.append("; uses:=");
                        sb.append(blame.m_cap.getAttributes().get("osgi.wiring.package"));
                        sb.append("\n    export: ");
                        sb.append("osgi.wiring.package");
                        sb.append("=");
                        sb.append(blame.m_cap.getAttributes().get("osgi.wiring.package"));
                    }
                    sb.append("\n  ");
                    sb.append(Util.getSymbolicName(blame.m_cap.getResource()));
                    sb.append(" [");
                    sb.append(blame.m_cap.getResource().toString());
                    sb.append("]");
                }
                ++i;
            }
        } else {
            sb.append(blame.m_cap.getResource().toString());
        }
        return sb.toString();
    }

    private Capability getSatisfyingCapability(Requirement req) {
        Capability cap = this.m_allCandidates.getFirstCandidate(req);
        if (cap == null && this.m_context.getWirings().containsKey(req.getResource())) {
            List<Wire> wires = this.m_context.getWirings().get(req.getResource()).getRequiredResourceWires(null);
            req = ResolverImpl.getDeclaredRequirement(req);
            for (Wire w : wires) {
                if (!w.getRequirement().equals(req)) continue;
                cap = w.getCapability();
                break;
            }
        }
        return cap;
    }

    @Override
    public ResolutionException toException() {
        return new ReasonException(ReasonException.Reason.UseConstraint, this.getMessage(), null, this.getUnresolvedRequirements());
    }
}

