/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.dashboard.registry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.jexl3.JexlExpression;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DataSourceVariableResolver;
import org.jkiss.dbeaver.model.dashboard.DBDashboardCalcType;
import org.jkiss.dbeaver.model.dashboard.DBDashboardDataType;
import org.jkiss.dbeaver.model.dashboard.DBDashboardFetchType;
import org.jkiss.dbeaver.model.dashboard.DBDashboardFolder;
import org.jkiss.dbeaver.model.dashboard.DBDashboardInterval;
import org.jkiss.dbeaver.model.dashboard.DBDashboardItem;
import org.jkiss.dbeaver.model.dashboard.DBDashboardQuery;
import org.jkiss.dbeaver.model.dashboard.DBDashboardValueType;
import org.jkiss.dbeaver.model.dashboard.DashboardConstants;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardMapQueryDescriptor;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardProviderDescriptor;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardRegistry;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.runtime.OSDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Element;

public class DashboardItemConfiguration
extends AbstractContextDescriptor
implements DBDashboardItem {
    private static final Log log = Log.getLog(DashboardItemConfiguration.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.dashboard";
    private final DashboardProviderDescriptor provider;
    @Nullable
    private DBDashboardFolder folder;
    @NotNull
    private String id;
    @NotNull
    private String name;
    private String displayName;
    private String description;
    private String group;
    private String measure;
    private boolean showByDefault;
    private String renderer;
    private DashboardMapQueryDescriptor mapQuery;
    private String[] mapKeys;
    private String[] mapLabels;
    private String mapFormula;
    private JexlExpression mapFormulaExpr;
    private String[] tags;
    private final List<DataSourceMapping> dataSourceMappings = new ArrayList<DataSourceMapping>();
    private final List<QueryMapping> queries = new ArrayList<QueryMapping>();
    private DBDashboardDataType dataType;
    private float widthRatio;
    private DBDashboardCalcType calcType;
    private DBDashboardFetchType fetchType;
    private long updatePeriod;
    private int maxItems;
    private long maxAge;
    private boolean isCustom;
    private DBDashboardValueType valueType;
    private DBDashboardInterval interval;
    private String dashboardURL;
    private String dashboardExternalURL;
    private boolean resolveVariables = true;
    private final Set<OSDescriptor> supportedSystems = new HashSet<OSDescriptor>();

    DashboardItemConfiguration(DashboardProviderDescriptor provider, MapQueryProvider mapQueryProvider, IConfigurationElement config) {
        super(config);
        IConfigurationElement ds;
        this.provider = provider;
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("label");
        this.displayName = config.getAttribute("displayName");
        this.description = config.getAttribute("description");
        this.group = config.getAttribute("group");
        this.measure = config.getAttribute("measure");
        this.tags = CommonUtils.split((String)config.getAttribute("tags"), (String)",");
        this.showByDefault = CommonUtils.toBoolean((Object)config.getAttribute("showByDefault"));
        this.dataType = (DBDashboardDataType)CommonUtils.valueOf(DBDashboardDataType.class, (String)config.getAttribute("dataType"), (Enum)DashboardConstants.DEF_DASHBOARD_DATA_TYPE);
        this.renderer = config.getAttribute("defaultView");
        if (CommonUtils.isEmpty((String)this.renderer)) {
            this.renderer = "timeseries";
        }
        this.widthRatio = (float)CommonUtils.toDouble((Object)config.getAttribute("ratio"), (double)1.5);
        this.calcType = (DBDashboardCalcType)CommonUtils.valueOf(DBDashboardCalcType.class, (String)config.getAttribute("calc"), (Enum)DashboardConstants.DEF_DASHBOARD_CALC_TYPE);
        this.valueType = (DBDashboardValueType)CommonUtils.valueOf(DBDashboardValueType.class, (String)config.getAttribute("value"), (Enum)DashboardConstants.DEF_DASHBOARD_VALUE_TYPE);
        this.interval = (DBDashboardInterval)CommonUtils.valueOf(DBDashboardInterval.class, (String)config.getAttribute("interval"), (Enum)DashboardConstants.DEF_DASHBOARD_INTERVAL);
        this.fetchType = (DBDashboardFetchType)CommonUtils.valueOf(DBDashboardFetchType.class, (String)config.getAttribute("fetch"), (Enum)DashboardConstants.DEF_DASHBOARD_FETCH_TYPE);
        this.updatePeriod = CommonUtils.toLong((Object)config.getAttribute("updatePeriod"), (long)1000L);
        this.maxItems = CommonUtils.toInt((Object)config.getAttribute("maxItems"), (int)300);
        this.maxAge = CommonUtils.toLong((Object)config.getAttribute("maxAge"), (long)1800000L);
        String mapQueryId = config.getAttribute("mapQuery");
        if (!CommonUtils.isEmpty((String)mapQueryId)) {
            this.mapQuery = mapQueryProvider.getMapQuery(mapQueryId);
            if (this.mapQuery != null) {
                this.mapKeys = CommonUtils.split((String)config.getAttribute("mapKeys"), (String)",");
                this.mapLabels = CommonUtils.split((String)config.getAttribute("mapLabels"), (String)",");
                this.mapFormula = config.getAttribute("mapFormula");
                if (!CommonUtils.isEmpty((String)this.mapFormula)) {
                    try {
                        this.mapFormulaExpr = AbstractDescriptor.parseExpression((String)this.mapFormula);
                    }
                    catch (DBException e) {
                        log.warn((Object)e);
                    }
                }
            }
        }
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("datasource");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ds = iConfigurationElementArray[n2];
            this.dataSourceMappings.add(new DataSourceMapping(ds));
            ++n2;
        }
        iConfigurationElementArray = config.getChildren("query");
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            ds = iConfigurationElementArray[n2];
            this.queries.add(new QueryMapping(ds));
            ++n2;
        }
        this.isCustom = false;
        this.dashboardURL = config.getAttribute("url");
        this.dashboardExternalURL = config.getAttribute("externalUrl");
        this.resolveVariables = CommonUtils.getBoolean((String)config.getAttribute("resolveVariables"), (boolean)true);
        iConfigurationElementArray = config.getChildren("os");
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            IConfigurationElement os = iConfigurationElementArray[n2];
            this.supportedSystems.add(new OSDescriptor(os.getAttribute("name"), os.getAttribute("arch")));
            ++n2;
        }
    }

    DashboardItemConfiguration(DashboardRegistry registry, Element config) {
        super("org.jkiss.dbeaver.model.dashboard");
        this.id = config.getAttribute("id");
        String providerId = config.getAttribute("provider");
        if (CommonUtils.isEmpty((String)providerId)) {
            providerId = "database";
        }
        this.provider = registry.getDashboardProvider(providerId);
        if (this.provider == null) {
            log.error((Object)("Dashboard provider '" + providerId + "' not found for saved dashboard '" + this.id + "'"));
        }
        this.name = config.getAttribute("label");
        this.displayName = config.getAttribute("displayName");
        this.description = config.getAttribute("description");
        this.group = config.getAttribute("group");
        this.measure = config.getAttribute("measure");
        this.tags = CommonUtils.split((String)config.getAttribute("tags"), (String)",");
        this.showByDefault = CommonUtils.toBoolean((Object)config.getAttribute("showByDefault"));
        this.dataType = (DBDashboardDataType)CommonUtils.valueOf(DBDashboardDataType.class, (String)config.getAttribute("dataType"), (Enum)DashboardConstants.DEF_DASHBOARD_DATA_TYPE);
        this.renderer = config.getAttribute("viewType");
        if (CommonUtils.isEmpty((String)this.renderer)) {
            this.renderer = config.getAttribute("defaultView");
        }
        if (CommonUtils.isEmpty((String)this.renderer)) {
            this.renderer = "timeseries";
        }
        if (this.renderer.equals("browser") && this.dataType == DBDashboardDataType.timeseries) {
            this.dataType = DBDashboardDataType.provided;
        }
        this.widthRatio = (float)CommonUtils.toDouble((Object)config.getAttribute("ratio"), (double)1.5);
        this.calcType = (DBDashboardCalcType)CommonUtils.valueOf(DBDashboardCalcType.class, (String)config.getAttribute("calc"), (Enum)DashboardConstants.DEF_DASHBOARD_CALC_TYPE);
        this.valueType = (DBDashboardValueType)CommonUtils.valueOf(DBDashboardValueType.class, (String)config.getAttribute("value"), (Enum)DashboardConstants.DEF_DASHBOARD_VALUE_TYPE);
        this.interval = (DBDashboardInterval)CommonUtils.valueOf(DBDashboardInterval.class, (String)config.getAttribute("interval"), (Enum)DashboardConstants.DEF_DASHBOARD_INTERVAL);
        this.fetchType = (DBDashboardFetchType)CommonUtils.valueOf(DBDashboardFetchType.class, (String)config.getAttribute("fetch"), (Enum)DashboardConstants.DEF_DASHBOARD_FETCH_TYPE);
        this.updatePeriod = CommonUtils.toLong((Object)config.getAttribute("updatePeriod"), (long)1000L);
        this.maxItems = CommonUtils.toInt((Object)config.getAttribute("maxItems"), (int)300);
        this.maxAge = CommonUtils.toLong((Object)config.getAttribute("maxAge"), (long)1800000L);
        for (Element ds : XMLUtils.getChildElementList((Element)config, (String)"datasource")) {
            this.dataSourceMappings.add(new DataSourceMapping(ds));
        }
        for (Element ds : XMLUtils.getChildElementList((Element)config, (String)"query")) {
            this.queries.add(new QueryMapping(ds));
        }
        this.dashboardURL = config.getAttribute("url");
        this.dashboardExternalURL = config.getAttribute("externalUrl");
        this.resolveVariables = CommonUtils.getBoolean((String)config.getAttribute("resolveVariables"), (boolean)true);
        this.isCustom = true;
    }

    public DashboardItemConfiguration(DashboardItemConfiguration source) {
        super(source.getPluginId());
        this.id = source.id;
        this.provider = source.provider;
        this.name = source.name;
        this.displayName = source.displayName;
        this.description = source.description;
        this.group = source.group;
        this.measure = source.measure;
        this.tags = source.tags;
        this.showByDefault = source.showByDefault;
        this.dataType = source.dataType;
        this.renderer = source.renderer;
        this.widthRatio = source.widthRatio;
        this.calcType = source.calcType;
        this.valueType = source.valueType;
        this.interval = source.interval;
        this.fetchType = source.fetchType;
        this.updatePeriod = source.updatePeriod;
        this.maxItems = source.maxItems;
        this.maxAge = source.maxAge;
        this.dataSourceMappings.addAll(source.dataSourceMappings);
        this.queries.addAll(source.queries);
        this.dashboardURL = source.dashboardURL;
        this.dashboardExternalURL = source.dashboardExternalURL;
        this.resolveVariables = source.resolveVariables;
        this.isCustom = source.isCustom;
    }

    public DashboardItemConfiguration(@NotNull DashboardProviderDescriptor provider, @Nullable DBDashboardFolder folder, @NotNull String id, @NotNull String name, @Nullable String description, @Nullable String group, boolean custom) {
        super("org.jkiss.dbeaver.model.dashboard");
        this.provider = provider;
        this.folder = folder;
        this.id = id;
        this.name = name;
        this.description = description;
        this.group = group;
        this.dataType = DBDashboardDataType.timeseries;
        this.renderer = "timeseries";
        this.widthRatio = 1.5f;
        this.calcType = DashboardConstants.DEF_DASHBOARD_CALC_TYPE;
        this.valueType = DashboardConstants.DEF_DASHBOARD_VALUE_TYPE;
        this.interval = DashboardConstants.DEF_DASHBOARD_INTERVAL;
        this.fetchType = DashboardConstants.DEF_DASHBOARD_FETCH_TYPE;
        this.updatePeriod = 1000L;
        this.maxItems = 300;
        this.maxAge = 1800000L;
        this.isCustom = custom;
    }

    @Nullable
    public DBDashboardFolder getFolder() {
        return this.folder;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(@NotNull String id) {
        this.id = id;
    }

    @Override
    @Nullable
    public String getPath() {
        if (this.folder == null) {
            return null;
        }
        StringBuilder path = new StringBuilder();
        DBDashboardFolder f = this.folder;
        while (f != null) {
            path.insert(0, "/" + f.getId());
            f = f.getParent();
        }
        return path.toString();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getTitle() {
        return CommonUtils.isEmpty((String)this.displayName) ? this.name : this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getMeasure() {
        return this.measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }

    public boolean isShowByDefault() {
        return this.showByDefault;
    }

    public DBDashboardDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DBDashboardDataType dataType) {
        this.dataType = dataType;
    }

    public String getDashboardURL() {
        return this.dashboardURL;
    }

    public void setDashboardURL(String dashboardURL) {
        this.dashboardURL = dashboardURL;
    }

    public String getDashboardExternalURL() {
        return this.dashboardExternalURL;
    }

    public void setDashboardExternalURL(String dashboardExternalURL) {
        this.dashboardExternalURL = dashboardExternalURL;
    }

    public boolean isResolveVariables() {
        return this.resolveVariables;
    }

    public void setResolveVariables(boolean resolveVariables) {
        this.resolveVariables = resolveVariables;
    }

    @Override
    @NotNull
    public String getDashboardRenderer() {
        return this.renderer;
    }

    public void setRenderer(String renderer) {
        this.renderer = renderer;
    }

    public String[] getTags() {
        return this.tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    public float getWidthRatio() {
        return this.widthRatio;
    }

    public void setWidthRatio(float widthRatio) {
        this.widthRatio = widthRatio;
    }

    public DBDashboardCalcType getCalcType() {
        return this.calcType;
    }

    public void setCalcType(DBDashboardCalcType calcType) {
        this.calcType = calcType;
    }

    public DBDashboardValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(DBDashboardValueType valueType) {
        this.valueType = valueType;
    }

    public DBDashboardInterval getInterval() {
        return this.interval;
    }

    public void setInterval(DBDashboardInterval interval) {
        this.interval = interval;
    }

    public DBDashboardFetchType getFetchType() {
        return this.fetchType;
    }

    public void setFetchType(DBDashboardFetchType fetchType) {
        this.fetchType = fetchType;
    }

    public List<QueryMapping> getQueries() {
        return this.queries;
    }

    public void setQueries(String[] queryStrings) {
        this.queries.clear();
        String[] stringArray = queryStrings;
        int n = queryStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String qs = stringArray[n2];
            this.queries.add(new QueryMapping(qs.trim()));
            ++n2;
        }
    }

    public long getUpdatePeriod() {
        return this.updatePeriod;
    }

    public void setUpdatePeriod(long updatePeriod) {
        this.updatePeriod = updatePeriod;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    public DashboardMapQueryDescriptor getMapQuery() {
        return this.mapQuery;
    }

    public String[] getMapKeys() {
        return this.mapKeys;
    }

    public String[] getMapLabels() {
        return this.mapLabels;
    }

    public JexlExpression getMapFormulaExpr() {
        return this.mapFormulaExpr;
    }

    @Override
    public boolean isCustom() {
        return this.isCustom;
    }

    @Override
    @NotNull
    public DashboardProviderDescriptor getDashboardProvider() {
        return this.provider;
    }

    public void setCustom(boolean custom) {
        this.isCustom = custom;
    }

    public List<DBPNamedObject> getDataSourceMappings() {
        return this.getSupportedSources();
    }

    public void setDataSourceMappings(List<DBPNamedObject> targets) {
        this.dataSourceMappings.clear();
        for (DBPNamedObject target : targets) {
            if (target instanceof DBPDataSourceProviderDescriptor) {
                this.dataSourceMappings.add(new DataSourceMapping(((DBPDataSourceProviderDescriptor)target).getId(), null, null));
                continue;
            }
            if (!(target instanceof DBPDriver)) continue;
            DBPDriver driver = (DBPDriver)target;
            this.dataSourceMappings.add(new DataSourceMapping(driver.getProviderId(), driver.getId(), null));
        }
    }

    public boolean matches(String providerId, String driverId, String driverClass) {
        for (DataSourceMapping dsm : this.dataSourceMappings) {
            if (dsm.matches(providerId, driverId, driverClass)) continue;
            return false;
        }
        return true;
    }

    public List<DBPNamedObject> getSupportedSources() {
        DBPPlatform platform = DBWorkbench.getPlatform();
        ArrayList<DBPNamedObject> results = new ArrayList<DBPNamedObject>();
        for (DataSourceMapping dsm : this.dataSourceMappings) {
            DBPDriver driver;
            if (dsm.dataSourceProvider != null) {
                DBPDataSourceProviderDescriptor provider = platform.getDataSourceProviderRegistry().getDataSourceProvider(dsm.dataSourceProvider);
                if (provider == null) continue;
                results.add((DBPNamedObject)provider);
                continue;
            }
            if (dsm.driverId == null || (driver = platform.getDataSourceProviderRegistry().findDriver(dsm.driverId)) == null) continue;
            results.add((DBPNamedObject)driver);
        }
        return results;
    }

    public String evaluateURL(String url, DBPProject project, DBPDataSourceContainer dataSourceContainer) {
        if (this.resolveVariables) {
            Object variableResolver = dataSourceContainer != null ? new DataSourceVariableResolver(dataSourceContainer, dataSourceContainer.getConnectionConfiguration()) : new SystemVariablesResolver();
            return GeneralUtils.replaceVariables((String)url, (IVariableResolver)variableResolver);
        }
        return url;
    }

    public boolean isSupportedByLocalSystem() {
        if (this.supportedSystems.isEmpty()) {
            return true;
        }
        OSDescriptor localSystem = DBWorkbench.getPlatform().getLocalSystem();
        for (OSDescriptor system : this.supportedSystems) {
            if (!system.matches(localSystem)) continue;
            return true;
        }
        return false;
    }

    void serialize(XMLBuilder xml) throws IOException {
        XMLBuilder.Element ignored;
        Object var5_7;
        Throwable throwable;
        xml.addAttribute("id", this.id);
        if (this.provider != null) {
            xml.addAttribute("provider", this.provider.getId());
        }
        xml.addAttribute("label", this.name);
        if (!CommonUtils.isEmpty((String)this.description)) {
            xml.addAttribute("description", this.description);
        }
        if (!CommonUtils.isEmpty((String)this.displayName)) {
            xml.addAttribute("displayName", this.displayName);
        }
        if (!CommonUtils.isEmpty((String)this.group)) {
            xml.addAttribute("group", this.group);
        }
        if (!CommonUtils.isEmpty((String)this.measure)) {
            xml.addAttribute("measure", this.measure);
        }
        if (!ArrayUtils.isEmpty((Object[])this.tags)) {
            xml.addAttribute("tags", String.join((CharSequence)",", this.tags));
        }
        xml.addAttribute("showByDefault", this.showByDefault);
        xml.addAttribute("viewType", this.renderer);
        xml.addAttribute("ratio", this.widthRatio);
        xml.addAttribute("calc", this.calcType.name());
        xml.addAttribute("value", this.valueType.name());
        xml.addAttribute("interval", this.interval.name());
        xml.addAttribute("fetch", this.fetchType.name());
        xml.addAttribute("updatePeriod", this.updatePeriod);
        xml.addAttribute("maxItems", this.maxItems);
        xml.addAttribute("maxAge", this.maxAge);
        if (this.mapQuery != null) {
            xml.addAttribute("mapQuery", this.mapQuery.getId());
        }
        if (!ArrayUtils.isEmpty((Object[])this.mapKeys)) {
            xml.addAttribute("mapKeys", String.join((CharSequence)",", this.mapKeys));
        }
        if (!CommonUtils.isEmpty((String)this.mapFormula)) {
            xml.addAttribute("mapFormula", this.mapFormula);
        }
        if (!CommonUtils.isEmpty((String)this.dashboardURL)) {
            xml.addAttribute("url", this.dashboardURL);
        }
        if (!CommonUtils.isEmpty((String)this.dashboardExternalURL)) {
            xml.addAttribute("externalUrl", this.dashboardExternalURL);
        }
        if (this.resolveVariables) {
            xml.addAttribute("resolveVariables", true);
        }
        for (DataSourceMapping mapping : this.dataSourceMappings) {
            throwable = null;
            var5_7 = null;
            try {
                ignored = xml.startElement("datasource");
                try {
                    mapping.serialize(xml);
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        for (QueryMapping qm : this.queries) {
            throwable = null;
            var5_7 = null;
            try {
                ignored = xml.startElement("query");
                try {
                    qm.serialize(xml);
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        this.isCustom = true;
    }

    public String toString() {
        return this.id;
    }

    private static class DataSourceMapping {
        private final String dataSourceProvider;
        private final String driverId;
        private final String driverClass;

        DataSourceMapping(IConfigurationElement config) {
            this.dataSourceProvider = CommonUtils.nullIfEmpty((String)config.getAttribute("id"));
            this.driverId = CommonUtils.nullIfEmpty((String)config.getAttribute("driver"));
            this.driverClass = CommonUtils.nullIfEmpty((String)config.getAttribute("driverClass"));
        }

        DataSourceMapping(Element config) {
            this.dataSourceProvider = CommonUtils.nullIfEmpty((String)config.getAttribute("id"));
            this.driverId = CommonUtils.nullIfEmpty((String)config.getAttribute("driver"));
            this.driverClass = CommonUtils.nullIfEmpty((String)config.getAttribute("driverClass"));
        }

        public DataSourceMapping(String dataSourceProvider, String driverId, String driverClass) {
            this.dataSourceProvider = dataSourceProvider;
            this.driverId = driverId;
            this.driverClass = driverClass;
        }

        boolean matches(String providerId, String checkDriverId, String checkDriverClass) {
            if (this.dataSourceProvider != null && !this.dataSourceProvider.equals(providerId)) {
                DBPDataSourceProviderDescriptor provider = DBWorkbench.getPlatform().getDataSourceProviderRegistry().getDataSourceProvider(this.dataSourceProvider);
                boolean childHasMatch = false;
                if (provider != null) {
                    List childrenProviders = provider.getChildrenProviders();
                    childHasMatch = childrenProviders.stream().map(DBPDataSourceProviderDescriptor::getId).anyMatch(providerId::equals);
                }
                if (!childHasMatch) {
                    return false;
                }
            }
            if (checkDriverId != null && this.driverId != null && !this.driverId.equals(checkDriverId)) {
                return false;
            }
            return checkDriverClass == null || this.driverClass == null || this.driverClass.equals(checkDriverClass);
        }

        void serialize(XMLBuilder xml) throws IOException {
            if (!CommonUtils.isEmpty((String)this.dataSourceProvider)) {
                xml.addAttribute("id", this.dataSourceProvider);
            }
            if (!CommonUtils.isEmpty((String)this.driverId)) {
                xml.addAttribute("driver", this.driverId);
            }
            if (!CommonUtils.isEmpty((String)this.driverClass)) {
                xml.addAttribute("driverClass", this.driverClass);
            }
        }
    }

    public static interface MapQueryProvider {
        public DashboardMapQueryDescriptor getMapQuery(String var1);
    }

    public static class QueryMapping
    implements DBDashboardQuery {
        private final String queryText;

        QueryMapping(IConfigurationElement config) {
            this.queryText = config.getValue();
        }

        QueryMapping(Element config) {
            this.queryText = XMLUtils.getElementBody((Element)config);
        }

        public QueryMapping(String queryText) {
            this.queryText = queryText;
        }

        @Override
        public String getQueryText() {
            return this.queryText;
        }

        void serialize(XMLBuilder xml) throws IOException {
            xml.addText((CharSequence)this.queryText);
        }
    }
}

