/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.http.signature.apache.httpclient;

import com.joyent.http.signature.apache.httpclient.HttpSignatureAuthScheme;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthOption;
import org.apache.http.auth.AuthProtocolState;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.AuthCache;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.protocol.HttpContext;

public class HttpSignatureAuthenticationStrategy
implements AuthenticationStrategy {
    private static final Log LOG = LogFactory.getLog(HttpSignatureAuthScheme.class);
    private final Map<String, Header> challenges = Collections.singletonMap(null, null);
    private final AuthOption authOption;

    public HttpSignatureAuthenticationStrategy(Lookup<AuthSchemeProvider> authSchemeProviderLookup, Credentials credentials) {
        this(((AuthSchemeProvider)authSchemeProviderLookup.lookup("Signatures")).create(null), credentials);
    }

    public HttpSignatureAuthenticationStrategy(AuthScheme authScheme, Credentials credentials) {
        this.authOption = new AuthOption(authScheme, credentials);
    }

    public boolean isAuthenticationRequested(HttpHost authHost, HttpResponse response, HttpContext context) {
        StatusLine line = response.getStatusLine();
        int code = line.getStatusCode();
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        AuthState authState = clientContext.getTargetAuthState();
        AuthProtocolState authProtocolState = authState.getState();
        if (code == 401) {
            if (authProtocolState.equals((Object)AuthProtocolState.CHALLENGED)) {
                clientContext.getTargetAuthState().setState(AuthProtocolState.FAILURE);
                this.authFailed(authHost, authState.getAuthScheme(), context);
            }
            return true;
        }
        return clientContext.getTargetAuthState() == null;
    }

    public Map<String, Header> getChallenges(HttpHost authhost, HttpResponse response, HttpContext context) throws MalformedChallengeException {
        return this.challenges;
    }

    public Queue<AuthOption> select(Map<String, Header> challengeHeaders, HttpHost authhost, HttpResponse response, HttpContext context) {
        HttpClientContext httpClientContext = HttpClientContext.adapt((HttpContext)context);
        AuthState state = httpClientContext.getTargetAuthState();
        ArrayDeque<AuthOption> queue = new ArrayDeque<AuthOption>();
        if (state == null || !state.getState().equals((Object)AuthProtocolState.CHALLENGED)) {
            queue.add(this.authOption);
        } else {
            System.out.println("does this happen?");
        }
        return queue;
    }

    public void authSucceeded(HttpHost authhost, AuthScheme authScheme, HttpContext context) {
        Objects.requireNonNull(authhost, "Authentication host must be present");
        Objects.requireNonNull(authScheme, "Authentication scheme must be present");
        Objects.requireNonNull(context, "HTTP context must be present");
        LOG.debug((Object)"HTTP Signature authentication succeeded");
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        AuthCache authCache = clientContext.getAuthCache();
        if (authCache == null) {
            authCache = new BasicAuthCache();
            clientContext.setAuthCache(authCache);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Caching '" + authScheme.getSchemeName() + "' auth scheme for " + authhost));
        }
        authCache.put(authhost, authScheme);
    }

    public void authFailed(HttpHost authhost, AuthScheme authScheme, HttpContext context) {
        Objects.requireNonNull(authhost, "Authentication host must be present");
        Objects.requireNonNull(context, "HTTP context must be present");
        LOG.debug((Object)"HTTP Signature authentication failed");
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        AuthCache authCache = clientContext.getAuthCache();
        if (authCache != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Clearing cached auth scheme for " + authhost));
            }
            authCache.remove(authhost);
        }
    }
}

