/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.http.signature.crypto;

import com.joyent.http.signature.crypto.MantaNativeRSACoreEngine;
import com.squareup.jnagmp.Gmp;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.util.BigIntegers;

public class NativeRSABlindedEngine
extends RSABlindedEngine {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private MantaNativeRSACoreEngine core = new MantaNativeRSACoreEngine();
    private RSAKeyParameters key;
    private SecureRandom random;

    public void init(boolean forEncryption, CipherParameters param) {
        this.core.init(forEncryption, param);
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (RSAKeyParameters)rParam.getParameters();
            this.random = rParam.getRandom();
        } else {
            this.key = (RSAKeyParameters)param;
            this.random = new SecureRandom();
        }
    }

    public int getInputBlockSize() {
        return this.core.getInputBlockSize();
    }

    public int getOutputBlockSize() {
        return this.core.getOutputBlockSize();
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) {
        BigInteger result;
        if (this.key == null) {
            throw new IllegalStateException("RSA engine not initialised");
        }
        BigInteger input = this.core.convertInput(in, inOff, inLen);
        if (this.key instanceof RSAPrivateCrtKeyParameters) {
            RSAPrivateCrtKeyParameters k = (RSAPrivateCrtKeyParameters)this.key;
            BigInteger e = k.getPublicExponent();
            if (e != null) {
                BigInteger rInv;
                BigInteger m = k.getModulus();
                BigInteger r = BigIntegers.createRandomInRange((BigInteger)ONE, (BigInteger)m.subtract(ONE), (SecureRandom)this.random);
                BigInteger blindedModPow = Gmp.modPowSecure((BigInteger)r, (BigInteger)e, (BigInteger)m);
                BigInteger blindedInput = blindedModPow.multiply(input).mod(m);
                BigInteger blindedResult = this.core.processBlock(blindedInput);
                result = blindedResult.multiply(rInv = Gmp.modInverse((BigInteger)r, (BigInteger)m)).mod(m);
                if (!input.equals(Gmp.modPowInsecure((BigInteger)result, (BigInteger)e, (BigInteger)m))) {
                    throw new IllegalStateException("RSA engine faulty decryption/signing detected");
                }
            } else {
                result = this.core.processBlock(input);
            }
        } else {
            result = this.core.processBlock(input);
        }
        return this.core.convertOutput(result);
    }
}

