/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.DbxAppInfo;
import com.dropbox.core.DbxAuthFinish;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxPKCEManager;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxSessionStore;
import com.dropbox.core.DbxWebAuth;
import java.util.HashMap;
import java.util.Map;

public class DbxPKCEWebAuth {
    private final DbxRequestConfig requestConfig;
    private final DbxAppInfo appInfo;
    private final DbxWebAuth dbxWebAuth;
    private final DbxPKCEManager dbxPKCEManager;
    private boolean started;
    private boolean consumed;

    public DbxPKCEWebAuth(DbxRequestConfig requestConfig, DbxAppInfo appInfo) {
        if (appInfo.hasSecret()) {
            throw new IllegalStateException("PKCE cdoe flow doesn't require app secret, if you decide to embed it in your app, please use regular DbxWebAuth instead.");
        }
        this.requestConfig = requestConfig;
        this.appInfo = appInfo;
        this.dbxWebAuth = new DbxWebAuth(requestConfig, appInfo);
        this.dbxPKCEManager = new DbxPKCEManager();
        this.started = false;
        this.consumed = false;
    }

    public String authorize(DbxWebAuth.Request request) {
        if (this.consumed) {
            throw new IllegalStateException("This DbxPKCEWebAuth instance has been consumed already. To start a new PKCE OAuth flow, please create a new instance.");
        }
        this.started = true;
        HashMap<String, String> pkceParams = new HashMap<String, String>();
        pkceParams.put("code_challenge", this.dbxPKCEManager.getCodeChallenge());
        pkceParams.put("code_challenge_method", "S256");
        return this.dbxWebAuth.authorizeImpl(request, pkceParams);
    }

    public DbxAuthFinish finishFromCode(String code) throws DbxException {
        return this.finish(code, null, null);
    }

    public DbxAuthFinish finishFromRedirect(String redirectUri, DbxSessionStore sessionStore, Map<String, String[]> params) throws DbxException, DbxWebAuth.BadRequestException, DbxWebAuth.BadStateException, DbxWebAuth.CsrfException, DbxWebAuth.NotApprovedException, DbxWebAuth.ProviderException {
        String strippedState = DbxWebAuth.validateRedirectUri(redirectUri, sessionStore, params);
        String code = DbxWebAuth.getParam(params, "code");
        return this.finish(code, redirectUri, strippedState);
    }

    DbxAuthFinish finish(String code, String redirectUri, String state) throws DbxException {
        if (code == null) {
            throw new NullPointerException("code");
        }
        if (!this.started) {
            throw new IllegalStateException("Must initialize the PKCE flow by calling authorize first.");
        }
        if (this.consumed) {
            throw new IllegalStateException("This DbxPKCEWebAuth instance has been consumed already. To start a new PKCE OAuth flow, please create a new instance.");
        }
        DbxAuthFinish authFinish = this.dbxPKCEManager.makeTokenRequest(this.requestConfig, code, this.appInfo.getKey(), redirectUri, this.appInfo.getHost());
        this.consumed = true;
        return authFinish.withUrlState(state);
    }
}

