/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.rfc8032;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Xof;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.math.ec.rfc7748.X448;
import org.bouncycastle.math.ec.rfc7748.X448Field;
import org.bouncycastle.math.raw.Nat;
import org.bouncycastle.util.Arrays;

public abstract class Ed448 {
    private static final long M26L = 0x3FFFFFFL;
    private static final long M28L = 0xFFFFFFFL;
    private static final long M32L = 0xFFFFFFFFL;
    private static final int POINT_BYTES = 57;
    private static final int SCALAR_INTS = 14;
    private static final int SCALAR_BYTES = 57;
    public static final int PREHASH_SIZE = 64;
    public static final int PUBLIC_KEY_SIZE = 57;
    public static final int SECRET_KEY_SIZE = 57;
    public static final int SIGNATURE_SIZE = 114;
    private static final byte[] DOM4_PREFIX = new byte[]{83, 105, 103, 69, 100, 52, 52, 56};
    private static final int[] P = new int[]{-1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1};
    private static final int[] L = new int[]{-1420278541, 595116690, -1916432555, 560775794, -1361693040, -1001465015, 2093622249, -1, -1, -1, -1, -1, -1, 0x3FFFFFFF};
    private static final int L_0 = 78101261;
    private static final int L_1 = 141809365;
    private static final int L_2 = 175155932;
    private static final int L_3 = 64542499;
    private static final int L_4 = 158326419;
    private static final int L_5 = 191173276;
    private static final int L_6 = 104575268;
    private static final int L_7 = 137584065;
    private static final int L4_0 = 43969588;
    private static final int L4_1 = 30366549;
    private static final int L4_2 = 163752818;
    private static final int L4_3 = 258169998;
    private static final int L4_4 = 96434764;
    private static final int L4_5 = 227822194;
    private static final int L4_6 = 149865618;
    private static final int L4_7 = 550336261;
    private static final int[] B_x = new int[]{118276190, 40534716, 9670182, 135141552, 85017403, 259173222, 68333082, 171784774, 174973732, 15824510, 73756743, 57518561, 94773951, 248652241, 107736333, 82941708};
    private static final int[] B_y = new int[]{36764180, 8885695, 130592152, 20104429, 163904957, 30304195, 121295871, 5901357, 125344798, 171541512, 175338348, 209069246, 3626697, 38307682, 24032956, 110359655};
    private static final int C_d = -39081;
    private static final int WNAF_WIDTH_BASE = 7;
    private static final int PRECOMP_BLOCKS = 5;
    private static final int PRECOMP_TEETH = 5;
    private static final int PRECOMP_SPACING = 18;
    private static final int PRECOMP_POINTS = 16;
    private static final int PRECOMP_MASK = 15;
    private static final Object precompLock = new Object();
    private static PointExt[] precompBaseTable = null;
    private static int[] precompBase = null;

    private static byte[] calculateS(byte[] r, byte[] k, byte[] s) {
        int[] t = new int[28];
        Ed448.decodeScalar(r, 0, t);
        int[] u = new int[14];
        Ed448.decodeScalar(k, 0, u);
        int[] v = new int[14];
        Ed448.decodeScalar(s, 0, v);
        Nat.mulAddTo(14, u, v, t);
        byte[] result = new byte[114];
        for (int i = 0; i < t.length; ++i) {
            Ed448.encode32(t[i], result, i * 4);
        }
        return Ed448.reduceScalar(result);
    }

    private static boolean checkContextVar(byte[] ctx) {
        return ctx != null && ctx.length < 256;
    }

    private static int checkPoint(int[] x, int[] y) {
        int[] t = F.create();
        int[] u = F.create();
        int[] v = F.create();
        F.sqr(x, u);
        F.sqr(y, v);
        F.mul(u, v, t);
        F.add(u, v, u);
        F.mul(t, 39081, t);
        F.subOne(t);
        F.add(t, u, t);
        F.normalize(t);
        return F.isZero(t);
    }

    private static int checkPoint(int[] x, int[] y, int[] z) {
        int[] t = F.create();
        int[] u = F.create();
        int[] v = F.create();
        int[] w = F.create();
        F.sqr(x, u);
        F.sqr(y, v);
        F.sqr(z, w);
        F.mul(u, v, t);
        F.add(u, v, u);
        F.mul(u, w, u);
        F.sqr(w, w);
        F.mul(t, 39081, t);
        F.sub(t, w, t);
        F.add(t, u, t);
        F.normalize(t);
        return F.isZero(t);
    }

    private static boolean checkPointVar(byte[] p) {
        if ((p[56] & 0x7F) != 0) {
            return false;
        }
        int[] t = new int[14];
        Ed448.decode32(p, 0, t, 0, 14);
        return !Nat.gte(14, t, P);
    }

    private static boolean checkScalarVar(byte[] s) {
        if (s[56] != 0) {
            return false;
        }
        int[] n = new int[14];
        Ed448.decodeScalar(s, 0, n);
        return !Nat.gte(14, n, L);
    }

    private static byte[] copy(byte[] buf, int off, int len) {
        byte[] result = new byte[len];
        System.arraycopy(buf, off, result, 0, len);
        return result;
    }

    public static Xof createPrehash() {
        return Ed448.createXof();
    }

    private static Xof createXof() {
        return new SHAKEDigest(256);
    }

    private static int decode16(byte[] bs, int off) {
        int n = bs[off] & 0xFF;
        return n |= (bs[++off] & 0xFF) << 8;
    }

    private static int decode24(byte[] bs, int off) {
        int n = bs[off] & 0xFF;
        n |= (bs[++off] & 0xFF) << 8;
        return n |= (bs[++off] & 0xFF) << 16;
    }

    private static int decode32(byte[] bs, int off) {
        int n = bs[off] & 0xFF;
        n |= (bs[++off] & 0xFF) << 8;
        n |= (bs[++off] & 0xFF) << 16;
        return n |= bs[++off] << 24;
    }

    private static void decode32(byte[] bs, int bsOff, int[] n, int nOff, int nLen) {
        for (int i = 0; i < nLen; ++i) {
            n[nOff + i] = Ed448.decode32(bs, bsOff + i * 4);
        }
    }

    private static boolean decodePointVar(byte[] p, int pOff, boolean negate, PointExt r) {
        byte[] py = Ed448.copy(p, pOff, 57);
        if (!Ed448.checkPointVar(py)) {
            return false;
        }
        int x_0 = (py[56] & 0x80) >>> 7;
        py[56] = (byte)(py[56] & 0x7F);
        F.decode(py, 0, r.y);
        int[] u = F.create();
        int[] v = F.create();
        F.sqr(r.y, u);
        F.mul(u, 39081, v);
        F.negate(u, u);
        F.addOne(u);
        F.addOne(v);
        if (!F.sqrtRatioVar(u, v, r.x)) {
            return false;
        }
        F.normalize(r.x);
        if (x_0 == 1 && F.isZeroVar(r.x)) {
            return false;
        }
        if (negate ^ x_0 != (r.x[0] & 1)) {
            F.negate(r.x, r.x);
        }
        Ed448.pointExtendXY(r);
        return true;
    }

    private static void decodeScalar(byte[] k, int kOff, int[] n) {
        Ed448.decode32(k, kOff, n, 0, 14);
    }

    private static void dom4(Xof d, byte phflag, byte[] ctx) {
        int n = DOM4_PREFIX.length;
        byte[] t = new byte[n + 2 + ctx.length];
        System.arraycopy(DOM4_PREFIX, 0, t, 0, n);
        t[n] = phflag;
        t[n + 1] = (byte)ctx.length;
        System.arraycopy(ctx, 0, t, n + 2, ctx.length);
        d.update(t, 0, t.length);
    }

    private static void encode24(int n, byte[] bs, int off) {
        bs[off] = (byte)n;
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)(n >>> 16);
    }

    private static void encode32(int n, byte[] bs, int off) {
        bs[off] = (byte)n;
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 24);
    }

    private static void encode56(long n, byte[] bs, int off) {
        Ed448.encode32((int)n, bs, off);
        Ed448.encode24((int)(n >>> 32), bs, off + 4);
    }

    private static int encodePoint(PointExt p, byte[] r, int rOff) {
        int[] x = F.create();
        int[] y = F.create();
        F.inv(p.z, y);
        F.mul(p.x, y, x);
        F.mul(p.y, y, y);
        F.normalize(x);
        F.normalize(y);
        int result = Ed448.checkPoint(x, y);
        F.encode(y, r, rOff);
        r[rOff + 57 - 1] = (byte)((x[0] & 1) << 7);
        return result;
    }

    public static void generatePrivateKey(SecureRandom random, byte[] k) {
        random.nextBytes(k);
    }

    public static void generatePublicKey(byte[] sk, int skOff, byte[] pk, int pkOff) {
        Xof d = Ed448.createXof();
        byte[] h = new byte[114];
        d.update(sk, skOff, 57);
        d.doFinal(h, 0, h.length);
        byte[] s = new byte[57];
        Ed448.pruneScalar(h, 0, s);
        Ed448.scalarMultBaseEncoded(s, pk, pkOff);
    }

    private static int getWindow4(int[] x, int n) {
        int w = n >>> 3;
        int b = (n & 7) << 2;
        return x[w] >>> b & 0xF;
    }

    private static byte[] getWnafVar(int[] n, int width) {
        int[] t = new int[28];
        int tPos = t.length;
        int c = 0;
        int i = 14;
        while (--i >= 0) {
            int next = n[i];
            t[--tPos] = next >>> 16 | c << 16;
            t[--tPos] = c = next;
        }
        byte[] ws = new byte[447];
        int pow2 = 1 << width;
        int mask = pow2 - 1;
        int sign = pow2 >>> 1;
        int j = 0;
        int carry = 0;
        int i2 = 0;
        while (i2 < t.length) {
            int word = t[i2];
            while (j < 16) {
                int word16 = word >>> j;
                int bit = word16 & 1;
                if (bit == carry) {
                    ++j;
                    continue;
                }
                int digit = (word16 & mask) + carry;
                carry = digit & sign;
                digit -= carry << 1;
                carry >>>= width - 1;
                ws[(i2 << 4) + j] = (byte)digit;
                j += width;
            }
            ++i2;
            j -= 16;
        }
        return ws;
    }

    private static void implSign(Xof d, byte[] h, byte[] s, byte[] pk, int pkOff, byte[] ctx, byte phflag, byte[] m, int mOff, int mLen, byte[] sig, int sigOff) {
        Ed448.dom4(d, phflag, ctx);
        d.update(h, 57, 57);
        d.update(m, mOff, mLen);
        d.doFinal(h, 0, h.length);
        byte[] r = Ed448.reduceScalar(h);
        byte[] R = new byte[57];
        Ed448.scalarMultBaseEncoded(r, R, 0);
        Ed448.dom4(d, phflag, ctx);
        d.update(R, 0, 57);
        d.update(pk, pkOff, 57);
        d.update(m, mOff, mLen);
        d.doFinal(h, 0, h.length);
        byte[] k = Ed448.reduceScalar(h);
        byte[] S = Ed448.calculateS(r, k, s);
        System.arraycopy(R, 0, sig, sigOff, 57);
        System.arraycopy(S, 0, sig, sigOff + 57, 57);
    }

    private static void implSign(byte[] sk, int skOff, byte[] ctx, byte phflag, byte[] m, int mOff, int mLen, byte[] sig, int sigOff) {
        if (!Ed448.checkContextVar(ctx)) {
            throw new IllegalArgumentException("ctx");
        }
        Xof d = Ed448.createXof();
        byte[] h = new byte[114];
        d.update(sk, skOff, 57);
        d.doFinal(h, 0, h.length);
        byte[] s = new byte[57];
        Ed448.pruneScalar(h, 0, s);
        byte[] pk = new byte[57];
        Ed448.scalarMultBaseEncoded(s, pk, 0);
        Ed448.implSign(d, h, s, pk, 0, ctx, phflag, m, mOff, mLen, sig, sigOff);
    }

    private static void implSign(byte[] sk, int skOff, byte[] pk, int pkOff, byte[] ctx, byte phflag, byte[] m, int mOff, int mLen, byte[] sig, int sigOff) {
        if (!Ed448.checkContextVar(ctx)) {
            throw new IllegalArgumentException("ctx");
        }
        Xof d = Ed448.createXof();
        byte[] h = new byte[114];
        d.update(sk, skOff, 57);
        d.doFinal(h, 0, h.length);
        byte[] s = new byte[57];
        Ed448.pruneScalar(h, 0, s);
        Ed448.implSign(d, h, s, pk, pkOff, ctx, phflag, m, mOff, mLen, sig, sigOff);
    }

    private static boolean implVerify(byte[] sig, int sigOff, byte[] pk, int pkOff, byte[] ctx, byte phflag, byte[] m, int mOff, int mLen) {
        if (!Ed448.checkContextVar(ctx)) {
            throw new IllegalArgumentException("ctx");
        }
        byte[] R = Ed448.copy(sig, sigOff, 57);
        byte[] S = Ed448.copy(sig, sigOff + 57, 57);
        if (!Ed448.checkPointVar(R)) {
            return false;
        }
        if (!Ed448.checkScalarVar(S)) {
            return false;
        }
        PointExt pA = new PointExt();
        if (!Ed448.decodePointVar(pk, pkOff, true, pA)) {
            return false;
        }
        Xof d = Ed448.createXof();
        byte[] h = new byte[114];
        Ed448.dom4(d, phflag, ctx);
        d.update(R, 0, 57);
        d.update(pk, pkOff, 57);
        d.update(m, mOff, mLen);
        d.doFinal(h, 0, h.length);
        byte[] k = Ed448.reduceScalar(h);
        int[] nS = new int[14];
        Ed448.decodeScalar(S, 0, nS);
        int[] nA = new int[14];
        Ed448.decodeScalar(k, 0, nA);
        PointExt pR = new PointExt();
        Ed448.scalarMultStrausVar(nS, nA, pA, pR);
        byte[] check = new byte[57];
        return 0 != Ed448.encodePoint(pR, check, 0) && Arrays.areEqual(check, R);
    }

    private static boolean isNeutralElementVar(int[] x, int[] y, int[] z) {
        return F.isZeroVar(x) && F.areEqualVar(y, z);
    }

    private static void pointAdd(PointExt p, PointExt r) {
        int[] a = F.create();
        int[] b = F.create();
        int[] c = F.create();
        int[] d = F.create();
        int[] e = F.create();
        int[] f = F.create();
        int[] g = F.create();
        int[] h = F.create();
        F.mul(p.z, r.z, a);
        F.sqr(a, b);
        F.mul(p.x, r.x, c);
        F.mul(p.y, r.y, d);
        F.mul(c, d, e);
        F.mul(e, 39081, e);
        F.add(b, e, f);
        F.sub(b, e, g);
        F.add(p.x, p.y, b);
        F.add(r.x, r.y, e);
        F.mul(b, e, h);
        F.add(d, c, b);
        F.sub(d, c, e);
        F.carry(b);
        F.sub(h, b, h);
        F.mul(h, a, h);
        F.mul(e, a, e);
        F.mul(f, h, r.x);
        F.mul(e, g, r.y);
        F.mul(f, g, r.z);
    }

    private static void pointAddVar(boolean negate, PointExt p, PointExt r) {
        int[] ng;
        int[] nf;
        int[] ne;
        int[] nb;
        int[] a = F.create();
        int[] b = F.create();
        int[] c = F.create();
        int[] d = F.create();
        int[] e = F.create();
        int[] f = F.create();
        int[] g = F.create();
        int[] h = F.create();
        if (negate) {
            nb = e;
            ne = b;
            nf = g;
            ng = f;
            F.sub(p.y, p.x, h);
        } else {
            nb = b;
            ne = e;
            nf = f;
            ng = g;
            F.add(p.y, p.x, h);
        }
        F.mul(p.z, r.z, a);
        F.sqr(a, b);
        F.mul(p.x, r.x, c);
        F.mul(p.y, r.y, d);
        F.mul(c, d, e);
        F.mul(e, 39081, e);
        F.add(b, e, nf);
        F.sub(b, e, ng);
        F.add(r.x, r.y, e);
        F.mul(h, e, h);
        F.add(d, c, nb);
        F.sub(d, c, ne);
        F.carry(nb);
        F.sub(h, b, h);
        F.mul(h, a, h);
        F.mul(e, a, e);
        F.mul(f, h, r.x);
        F.mul(e, g, r.y);
        F.mul(f, g, r.z);
    }

    private static void pointAddPrecomp(PointPrecomp p, PointExt r) {
        int[] b = F.create();
        int[] c = F.create();
        int[] d = F.create();
        int[] e = F.create();
        int[] f = F.create();
        int[] g = F.create();
        int[] h = F.create();
        F.sqr(r.z, b);
        F.mul(p.x, r.x, c);
        F.mul(p.y, r.y, d);
        F.mul(c, d, e);
        F.mul(e, 39081, e);
        F.add(b, e, f);
        F.sub(b, e, g);
        F.add(p.x, p.y, b);
        F.add(r.x, r.y, e);
        F.mul(b, e, h);
        F.add(d, c, b);
        F.sub(d, c, e);
        F.carry(b);
        F.sub(h, b, h);
        F.mul(h, r.z, h);
        F.mul(e, r.z, e);
        F.mul(f, h, r.x);
        F.mul(e, g, r.y);
        F.mul(f, g, r.z);
    }

    private static PointExt pointCopy(PointExt p) {
        PointExt r = new PointExt();
        Ed448.pointCopy(p, r);
        return r;
    }

    private static void pointCopy(PointExt p, PointExt r) {
        F.copy(p.x, 0, r.x, 0);
        F.copy(p.y, 0, r.y, 0);
        F.copy(p.z, 0, r.z, 0);
    }

    private static void pointDouble(PointExt r) {
        int[] b = F.create();
        int[] c = F.create();
        int[] d = F.create();
        int[] e = F.create();
        int[] h = F.create();
        int[] j = F.create();
        F.add(r.x, r.y, b);
        F.sqr(b, b);
        F.sqr(r.x, c);
        F.sqr(r.y, d);
        F.add(c, d, e);
        F.carry(e);
        F.sqr(r.z, h);
        F.add(h, h, h);
        F.carry(h);
        F.sub(e, h, j);
        F.sub(b, e, b);
        F.sub(c, d, c);
        F.mul(b, j, r.x);
        F.mul(e, c, r.y);
        F.mul(e, j, r.z);
    }

    private static void pointExtendXY(PointExt p) {
        F.one(p.z);
    }

    private static void pointLookup(int block, int index, PointPrecomp p) {
        int off = block * 16 * 2 * 16;
        for (int i = 0; i < 16; ++i) {
            int cond = (i ^ index) - 1 >> 31;
            F.cmov(cond, precompBase, off, p.x, 0);
            F.cmov(cond, precompBase, off += 16, p.y, 0);
            off += 16;
        }
    }

    private static void pointLookup(int[] x, int n, int[] table, PointExt r) {
        int w = Ed448.getWindow4(x, n);
        int sign = w >>> 3 ^ 1;
        int abs = (w ^ -sign) & 7;
        int off = 0;
        for (int i = 0; i < 8; ++i) {
            int cond = (i ^ abs) - 1 >> 31;
            F.cmov(cond, table, off, r.x, 0);
            F.cmov(cond, table, off += 16, r.y, 0);
            F.cmov(cond, table, off += 16, r.z, 0);
            off += 16;
        }
        F.cnegate(sign, r.x);
    }

    private static int[] pointPrecompute(PointExt p, int count) {
        PointExt q = Ed448.pointCopy(p);
        PointExt d = Ed448.pointCopy(q);
        Ed448.pointDouble(d);
        int[] table = F.createTable(count * 3);
        int off = 0;
        int i = 0;
        while (true) {
            F.copy(q.x, 0, table, off);
            F.copy(q.y, 0, table, off += 16);
            F.copy(q.z, 0, table, off += 16);
            off += 16;
            if (++i == count) break;
            Ed448.pointAdd(d, q);
        }
        return table;
    }

    private static PointExt[] pointPrecomputeVar(PointExt p, int count) {
        PointExt d = Ed448.pointCopy(p);
        Ed448.pointDouble(d);
        PointExt[] table = new PointExt[count];
        table[0] = Ed448.pointCopy(p);
        for (int i = 1; i < count; ++i) {
            table[i] = Ed448.pointCopy(table[i - 1]);
            Ed448.pointAddVar(false, d, table[i]);
        }
        return table;
    }

    private static void pointSetNeutral(PointExt p) {
        F.zero(p.x);
        F.one(p.y);
        F.one(p.z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void precompute() {
        Object object = precompLock;
        synchronized (object) {
            if (precompBase != null) {
                return;
            }
            PointExt p = new PointExt();
            F.copy(B_x, 0, p.x, 0);
            F.copy(B_y, 0, p.y, 0);
            Ed448.pointExtendXY(p);
            precompBaseTable = Ed448.pointPrecomputeVar(p, 32);
            precompBase = F.createTable(160);
            int off = 0;
            for (int b = 0; b < 5; ++b) {
                PointExt[] ds = new PointExt[5];
                PointExt sum = new PointExt();
                Ed448.pointSetNeutral(sum);
                for (int t = 0; t < 5; ++t) {
                    Ed448.pointAddVar(true, p, sum);
                    Ed448.pointDouble(p);
                    ds[t] = Ed448.pointCopy(p);
                    if (b + t == 8) continue;
                    for (int s = 1; s < 18; ++s) {
                        Ed448.pointDouble(p);
                    }
                }
                PointExt[] points = new PointExt[16];
                int k = 0;
                points[k++] = sum;
                for (int t = 0; t < 4; ++t) {
                    int size = 1 << t;
                    int j = 0;
                    while (j < size) {
                        points[k] = Ed448.pointCopy(points[k - size]);
                        Ed448.pointAddVar(false, ds[t], points[k]);
                        ++j;
                        ++k;
                    }
                }
                int[] cs = F.createTable(16);
                int[] u = F.create();
                F.copy(points[0].z, 0, u, 0);
                F.copy(u, 0, cs, 0);
                int i = 0;
                while (++i < 16) {
                    F.mul(u, points[i].z, u);
                    F.copy(u, 0, cs, i * 16);
                }
                F.invVar(u, u);
                --i;
                int[] t = F.create();
                while (i > 0) {
                    int j = i--;
                    F.copy(cs, i * 16, t, 0);
                    F.mul(t, u, t);
                    F.copy(t, 0, cs, j * 16);
                    F.mul(u, points[j].z, u);
                }
                F.copy(u, 0, cs, 0);
                for (int i2 = 0; i2 < 16; ++i2) {
                    PointExt q = points[i2];
                    F.copy(cs, i2 * 16, q.z, 0);
                    F.mul(q.x, q.z, q.x);
                    F.mul(q.y, q.z, q.y);
                    F.copy(q.x, 0, precompBase, off);
                    F.copy(q.y, 0, precompBase, off += 16);
                    off += 16;
                }
            }
        }
    }

    private static void pruneScalar(byte[] n, int nOff, byte[] r) {
        System.arraycopy(n, nOff, r, 0, 56);
        r[0] = (byte)(r[0] & 0xFC);
        r[55] = (byte)(r[55] | 0x80);
        r[56] = 0;
    }

    private static byte[] reduceScalar(byte[] n) {
        long x00 = (long)Ed448.decode32(n, 0) & 0xFFFFFFFFL;
        long x01 = (long)(Ed448.decode24(n, 4) << 4) & 0xFFFFFFFFL;
        long x02 = (long)Ed448.decode32(n, 7) & 0xFFFFFFFFL;
        long x03 = (long)(Ed448.decode24(n, 11) << 4) & 0xFFFFFFFFL;
        long x04 = (long)Ed448.decode32(n, 14) & 0xFFFFFFFFL;
        long x05 = (long)(Ed448.decode24(n, 18) << 4) & 0xFFFFFFFFL;
        long x06 = (long)Ed448.decode32(n, 21) & 0xFFFFFFFFL;
        long x07 = (long)(Ed448.decode24(n, 25) << 4) & 0xFFFFFFFFL;
        long x08 = (long)Ed448.decode32(n, 28) & 0xFFFFFFFFL;
        long x09 = (long)(Ed448.decode24(n, 32) << 4) & 0xFFFFFFFFL;
        long x10 = (long)Ed448.decode32(n, 35) & 0xFFFFFFFFL;
        long x11 = (long)(Ed448.decode24(n, 39) << 4) & 0xFFFFFFFFL;
        long x12 = (long)Ed448.decode32(n, 42) & 0xFFFFFFFFL;
        long x13 = (long)(Ed448.decode24(n, 46) << 4) & 0xFFFFFFFFL;
        long x14 = (long)Ed448.decode32(n, 49) & 0xFFFFFFFFL;
        long x15 = (long)(Ed448.decode24(n, 53) << 4) & 0xFFFFFFFFL;
        long x16 = (long)Ed448.decode32(n, 56) & 0xFFFFFFFFL;
        long x17 = (long)(Ed448.decode24(n, 60) << 4) & 0xFFFFFFFFL;
        long x18 = (long)Ed448.decode32(n, 63) & 0xFFFFFFFFL;
        long x19 = (long)(Ed448.decode24(n, 67) << 4) & 0xFFFFFFFFL;
        long x20 = (long)Ed448.decode32(n, 70) & 0xFFFFFFFFL;
        long x21 = (long)(Ed448.decode24(n, 74) << 4) & 0xFFFFFFFFL;
        long x22 = (long)Ed448.decode32(n, 77) & 0xFFFFFFFFL;
        long x23 = (long)(Ed448.decode24(n, 81) << 4) & 0xFFFFFFFFL;
        long x24 = (long)Ed448.decode32(n, 84) & 0xFFFFFFFFL;
        long x25 = (long)(Ed448.decode24(n, 88) << 4) & 0xFFFFFFFFL;
        long x26 = (long)Ed448.decode32(n, 91) & 0xFFFFFFFFL;
        long x27 = (long)(Ed448.decode24(n, 95) << 4) & 0xFFFFFFFFL;
        long x28 = (long)Ed448.decode32(n, 98) & 0xFFFFFFFFL;
        long x29 = (long)(Ed448.decode24(n, 102) << 4) & 0xFFFFFFFFL;
        long x30 = (long)Ed448.decode32(n, 105) & 0xFFFFFFFFL;
        long x31 = (long)(Ed448.decode24(n, 109) << 4) & 0xFFFFFFFFL;
        long x32 = (long)Ed448.decode16(n, 112) & 0xFFFFFFFFL;
        x16 += x32 * 43969588L;
        x17 += x32 * 30366549L;
        x18 += x32 * 163752818L;
        x19 += x32 * 258169998L;
        x20 += x32 * 96434764L;
        x21 += x32 * 227822194L;
        x22 += x32 * 149865618L;
        x23 += x32 * 550336261L;
        x31 += x30 >>> 28;
        x30 &= 0xFFFFFFFL;
        x15 += x31 * 43969588L;
        x16 += x31 * 30366549L;
        x17 += x31 * 163752818L;
        x18 += x31 * 258169998L;
        x19 += x31 * 96434764L;
        x20 += x31 * 227822194L;
        x21 += x31 * 149865618L;
        x22 += x31 * 550336261L;
        x14 += x30 * 43969588L;
        x15 += x30 * 30366549L;
        x16 += x30 * 163752818L;
        x17 += x30 * 258169998L;
        x18 += x30 * 96434764L;
        x19 += x30 * 227822194L;
        x20 += x30 * 149865618L;
        x21 += x30 * 550336261L;
        x29 += x28 >>> 28;
        x28 &= 0xFFFFFFFL;
        x13 += x29 * 43969588L;
        x14 += x29 * 30366549L;
        x15 += x29 * 163752818L;
        x16 += x29 * 258169998L;
        x17 += x29 * 96434764L;
        x18 += x29 * 227822194L;
        x19 += x29 * 149865618L;
        x20 += x29 * 550336261L;
        x12 += x28 * 43969588L;
        x13 += x28 * 30366549L;
        x14 += x28 * 163752818L;
        x15 += x28 * 258169998L;
        x16 += x28 * 96434764L;
        x17 += x28 * 227822194L;
        x18 += x28 * 149865618L;
        x19 += x28 * 550336261L;
        x27 += x26 >>> 28;
        x26 &= 0xFFFFFFFL;
        x11 += x27 * 43969588L;
        x12 += x27 * 30366549L;
        x13 += x27 * 163752818L;
        x14 += x27 * 258169998L;
        x15 += x27 * 96434764L;
        x16 += x27 * 227822194L;
        x17 += x27 * 149865618L;
        x18 += x27 * 550336261L;
        x10 += x26 * 43969588L;
        x11 += x26 * 30366549L;
        x12 += x26 * 163752818L;
        x13 += x26 * 258169998L;
        x14 += x26 * 96434764L;
        x15 += x26 * 227822194L;
        x16 += x26 * 149865618L;
        x17 += x26 * 550336261L;
        x25 += x24 >>> 28;
        x24 &= 0xFFFFFFFL;
        x09 += x25 * 43969588L;
        x10 += x25 * 30366549L;
        x11 += x25 * 163752818L;
        x12 += x25 * 258169998L;
        x13 += x25 * 96434764L;
        x14 += x25 * 227822194L;
        x15 += x25 * 149865618L;
        x16 += x25 * 550336261L;
        x21 += x20 >>> 28;
        x20 &= 0xFFFFFFFL;
        x22 += x21 >>> 28;
        x21 &= 0xFFFFFFFL;
        x23 += x22 >>> 28;
        x22 &= 0xFFFFFFFL;
        x24 += x23 >>> 28;
        x23 &= 0xFFFFFFFL;
        x08 += x24 * 43969588L;
        x09 += x24 * 30366549L;
        x10 += x24 * 163752818L;
        x11 += x24 * 258169998L;
        x12 += x24 * 96434764L;
        x13 += x24 * 227822194L;
        x14 += x24 * 149865618L;
        x15 += x24 * 550336261L;
        x07 += x23 * 43969588L;
        x08 += x23 * 30366549L;
        x09 += x23 * 163752818L;
        x10 += x23 * 258169998L;
        x11 += x23 * 96434764L;
        x12 += x23 * 227822194L;
        x13 += x23 * 149865618L;
        x14 += x23 * 550336261L;
        x06 += x22 * 43969588L;
        x07 += x22 * 30366549L;
        x08 += x22 * 163752818L;
        x09 += x22 * 258169998L;
        x10 += x22 * 96434764L;
        x11 += x22 * 227822194L;
        x12 += x22 * 149865618L;
        x13 += x22 * 550336261L;
        x18 += x17 >>> 28;
        x17 &= 0xFFFFFFFL;
        x19 += x18 >>> 28;
        x18 &= 0xFFFFFFFL;
        x20 += x19 >>> 28;
        x19 &= 0xFFFFFFFL;
        x21 += x20 >>> 28;
        x20 &= 0xFFFFFFFL;
        x05 += x21 * 43969588L;
        x06 += x21 * 30366549L;
        x07 += x21 * 163752818L;
        x08 += x21 * 258169998L;
        x09 += x21 * 96434764L;
        x10 += x21 * 227822194L;
        x11 += x21 * 149865618L;
        x12 += x21 * 550336261L;
        x04 += x20 * 43969588L;
        x05 += x20 * 30366549L;
        x06 += x20 * 163752818L;
        x07 += x20 * 258169998L;
        x08 += x20 * 96434764L;
        x09 += x20 * 227822194L;
        x10 += x20 * 149865618L;
        x11 += x20 * 550336261L;
        x03 += x19 * 43969588L;
        x04 += x19 * 30366549L;
        x05 += x19 * 163752818L;
        x06 += x19 * 258169998L;
        x07 += x19 * 96434764L;
        x08 += x19 * 227822194L;
        x09 += x19 * 149865618L;
        x10 += x19 * 550336261L;
        x15 += x14 >>> 28;
        x14 &= 0xFFFFFFFL;
        x16 += x15 >>> 28;
        x15 &= 0xFFFFFFFL;
        x17 += x16 >>> 28;
        x16 &= 0xFFFFFFFL;
        x18 += x17 >>> 28;
        x17 &= 0xFFFFFFFL;
        x02 += x18 * 43969588L;
        x03 += x18 * 30366549L;
        x04 += x18 * 163752818L;
        x05 += x18 * 258169998L;
        x06 += x18 * 96434764L;
        x07 += x18 * 227822194L;
        x08 += x18 * 149865618L;
        x09 += x18 * 550336261L;
        x01 += x17 * 43969588L;
        x02 += x17 * 30366549L;
        x03 += x17 * 163752818L;
        x04 += x17 * 258169998L;
        x05 += x17 * 96434764L;
        x06 += x17 * 227822194L;
        x07 += x17 * 149865618L;
        x08 += x17 * 550336261L;
        x16 *= 4L;
        x16 += x15 >>> 26;
        x15 &= 0x3FFFFFFL;
        x00 += ++x16 * 78101261L;
        x01 += x16 * 141809365L;
        x02 += x16 * 175155932L;
        x03 += x16 * 64542499L;
        x04 += x16 * 158326419L;
        x05 += x16 * 191173276L;
        x06 += x16 * 104575268L;
        x07 += x16 * 137584065L;
        x01 += x00 >>> 28;
        x00 &= 0xFFFFFFFL;
        x02 += x01 >>> 28;
        x01 &= 0xFFFFFFFL;
        x03 += x02 >>> 28;
        x02 &= 0xFFFFFFFL;
        x04 += x03 >>> 28;
        x03 &= 0xFFFFFFFL;
        x05 += x04 >>> 28;
        x04 &= 0xFFFFFFFL;
        x06 += x05 >>> 28;
        x05 &= 0xFFFFFFFL;
        x07 += x06 >>> 28;
        x06 &= 0xFFFFFFFL;
        x08 += x07 >>> 28;
        x07 &= 0xFFFFFFFL;
        x09 += x08 >>> 28;
        x08 &= 0xFFFFFFFL;
        x10 += x09 >>> 28;
        x09 &= 0xFFFFFFFL;
        x11 += x10 >>> 28;
        x10 &= 0xFFFFFFFL;
        x12 += x11 >>> 28;
        x11 &= 0xFFFFFFFL;
        x13 += x12 >>> 28;
        x12 &= 0xFFFFFFFL;
        x14 += x13 >>> 28;
        x13 &= 0xFFFFFFFL;
        x15 += x14 >>> 28;
        x14 &= 0xFFFFFFFL;
        x16 = x15 >>> 26;
        x15 &= 0x3FFFFFFL;
        x00 -= --x16 & 0x4A7BB0DL;
        x01 -= x16 & 0x873D6D5L;
        x02 -= x16 & 0xA70AADCL;
        x03 -= x16 & 0x3D8D723L;
        x04 -= x16 & 0x96FDE93L;
        x05 -= x16 & 0xB65129CL;
        x06 -= x16 & 0x63BB124L;
        x07 -= x16 & 0x8335DC1L;
        x01 += x00 >> 28;
        x00 &= 0xFFFFFFFL;
        x02 += x01 >> 28;
        x01 &= 0xFFFFFFFL;
        x03 += x02 >> 28;
        x02 &= 0xFFFFFFFL;
        x04 += x03 >> 28;
        x03 &= 0xFFFFFFFL;
        x05 += x04 >> 28;
        x04 &= 0xFFFFFFFL;
        x06 += x05 >> 28;
        x05 &= 0xFFFFFFFL;
        x07 += x06 >> 28;
        x06 &= 0xFFFFFFFL;
        x08 += x07 >> 28;
        x07 &= 0xFFFFFFFL;
        x09 += x08 >> 28;
        x08 &= 0xFFFFFFFL;
        x10 += x09 >> 28;
        x09 &= 0xFFFFFFFL;
        x11 += x10 >> 28;
        x10 &= 0xFFFFFFFL;
        x12 += x11 >> 28;
        x11 &= 0xFFFFFFFL;
        x13 += x12 >> 28;
        x12 &= 0xFFFFFFFL;
        x14 += x13 >> 28;
        x13 &= 0xFFFFFFFL;
        x15 += x14 >> 28;
        x14 &= 0xFFFFFFFL;
        byte[] r = new byte[57];
        Ed448.encode56(x00 | x01 << 28, r, 0);
        Ed448.encode56(x02 | x03 << 28, r, 7);
        Ed448.encode56(x04 | x05 << 28, r, 14);
        Ed448.encode56(x06 | x07 << 28, r, 21);
        Ed448.encode56(x08 | x09 << 28, r, 28);
        Ed448.encode56(x10 | x11 << 28, r, 35);
        Ed448.encode56(x12 | x13 << 28, r, 42);
        Ed448.encode56(x14 | x15 << 28, r, 49);
        return r;
    }

    private static void scalarMult(byte[] k, PointExt p, PointExt r) {
        int[] n = new int[14];
        Ed448.decodeScalar(k, 0, n);
        Nat.shiftDownBits(14, n, 2, 0);
        Nat.cadd(14, ~n[0] & 1, n, L, n);
        Nat.shiftDownBit(14, n, 1);
        int[] table = Ed448.pointPrecompute(p, 8);
        PointExt q = new PointExt();
        Ed448.pointLookup(n, 111, table, r);
        for (int w = 110; w >= 0; --w) {
            for (int i = 0; i < 4; ++i) {
                Ed448.pointDouble(r);
            }
            Ed448.pointLookup(n, w, table, q);
            Ed448.pointAdd(q, r);
        }
        for (int i = 0; i < 2; ++i) {
            Ed448.pointDouble(r);
        }
    }

    private static void scalarMultBase(byte[] k, PointExt r) {
        Ed448.precompute();
        int[] n = new int[15];
        Ed448.decodeScalar(k, 0, n);
        n[14] = 4 + Nat.cadd(14, ~n[0] & 1, n, L, n);
        Nat.shiftDownBit(n.length, n, 0);
        PointPrecomp p = new PointPrecomp();
        Ed448.pointSetNeutral(r);
        int cOff = 17;
        while (true) {
            int tPos = cOff;
            for (int b = 0; b < 5; ++b) {
                int w = 0;
                for (int t = 0; t < 5; ++t) {
                    int tBit = n[tPos >>> 5] >>> (tPos & 0x1F);
                    w &= ~(1 << t);
                    w ^= tBit << t;
                    tPos += 18;
                }
                int sign = w >>> 4 & 1;
                int abs = (w ^ -sign) & 0xF;
                Ed448.pointLookup(b, abs, p);
                F.cnegate(sign, p.x);
                Ed448.pointAddPrecomp(p, r);
            }
            if (--cOff < 0) break;
            Ed448.pointDouble(r);
        }
    }

    private static void scalarMultBaseEncoded(byte[] k, byte[] r, int rOff) {
        PointExt p = new PointExt();
        Ed448.scalarMultBase(k, p);
        if (0 == Ed448.encodePoint(p, r, rOff)) {
            throw new IllegalStateException();
        }
    }

    public static void scalarMultBaseXY(X448.Friend friend, byte[] k, int kOff, int[] x, int[] y) {
        if (null == friend) {
            throw new NullPointerException("This method is only for use by X448");
        }
        byte[] n = new byte[57];
        Ed448.pruneScalar(k, kOff, n);
        PointExt p = new PointExt();
        Ed448.scalarMultBase(n, p);
        if (0 == Ed448.checkPoint(p.x, p.y, p.z)) {
            throw new IllegalStateException();
        }
        F.copy(p.x, 0, x, 0);
        F.copy(p.y, 0, y, 0);
    }

    private static void scalarMultOrder(PointExt p, PointExt r) {
        int[] n = new int[14];
        Nat.shiftDownBit(14, L, 1, n);
        int[] table = Ed448.pointPrecompute(p, 8);
        PointExt q = new PointExt();
        Ed448.pointLookup(n, 111, table, r);
        for (int w = 110; w >= 0; --w) {
            for (int i = 0; i < 4; ++i) {
                Ed448.pointDouble(r);
            }
            Ed448.pointLookup(n, w, table, q);
            Ed448.pointAdd(q, r);
        }
    }

    private static void scalarMultStrausVar(int[] nb, int[] np, PointExt p, PointExt r) {
        Ed448.precompute();
        int width = 5;
        byte[] ws_b = Ed448.getWnafVar(nb, 7);
        byte[] ws_p = Ed448.getWnafVar(np, 5);
        PointExt[] tp = Ed448.pointPrecomputeVar(p, 8);
        Ed448.pointSetNeutral(r);
        int bit = 446;
        while (true) {
            byte wp;
            byte wb;
            if ((wb = ws_b[bit]) != 0) {
                int sign = wb >> 31;
                int index = (wb ^ sign) >>> 1;
                Ed448.pointAddVar(sign != 0, precompBaseTable[index], r);
            }
            if ((wp = ws_p[bit]) != 0) {
                int sign = wp >> 31;
                int index = (wp ^ sign) >>> 1;
                Ed448.pointAddVar(sign != 0, tp[index], r);
            }
            if (--bit < 0) break;
            Ed448.pointDouble(r);
        }
    }

    public static void sign(byte[] sk, int skOff, byte[] ctx, byte[] m, int mOff, int mLen, byte[] sig, int sigOff) {
        byte phflag = 0;
        Ed448.implSign(sk, skOff, ctx, phflag, m, mOff, mLen, sig, sigOff);
    }

    public static void sign(byte[] sk, int skOff, byte[] pk, int pkOff, byte[] ctx, byte[] m, int mOff, int mLen, byte[] sig, int sigOff) {
        byte phflag = 0;
        Ed448.implSign(sk, skOff, pk, pkOff, ctx, phflag, m, mOff, mLen, sig, sigOff);
    }

    public static void signPrehash(byte[] sk, int skOff, byte[] ctx, byte[] ph, int phOff, byte[] sig, int sigOff) {
        byte phflag = 1;
        Ed448.implSign(sk, skOff, ctx, phflag, ph, phOff, 64, sig, sigOff);
    }

    public static void signPrehash(byte[] sk, int skOff, byte[] pk, int pkOff, byte[] ctx, byte[] ph, int phOff, byte[] sig, int sigOff) {
        byte phflag = 1;
        Ed448.implSign(sk, skOff, pk, pkOff, ctx, phflag, ph, phOff, 64, sig, sigOff);
    }

    public static void signPrehash(byte[] sk, int skOff, byte[] ctx, Xof ph, byte[] sig, int sigOff) {
        byte[] m = new byte[64];
        if (64 != ph.doFinal(m, 0, 64)) {
            throw new IllegalArgumentException("ph");
        }
        byte phflag = 1;
        Ed448.implSign(sk, skOff, ctx, phflag, m, 0, m.length, sig, sigOff);
    }

    public static void signPrehash(byte[] sk, int skOff, byte[] pk, int pkOff, byte[] ctx, Xof ph, byte[] sig, int sigOff) {
        byte[] m = new byte[64];
        if (64 != ph.doFinal(m, 0, 64)) {
            throw new IllegalArgumentException("ph");
        }
        byte phflag = 1;
        Ed448.implSign(sk, skOff, pk, pkOff, ctx, phflag, m, 0, m.length, sig, sigOff);
    }

    public static boolean validatePublicKeyFull(byte[] pk, int pkOff) {
        PointExt p = new PointExt();
        if (!Ed448.decodePointVar(pk, pkOff, false, p)) {
            return false;
        }
        F.normalize(p.x);
        F.normalize(p.y);
        F.normalize(p.z);
        if (Ed448.isNeutralElementVar(p.x, p.y, p.z)) {
            return false;
        }
        PointExt r = new PointExt();
        Ed448.scalarMultOrder(p, r);
        F.normalize(r.x);
        F.normalize(r.y);
        F.normalize(r.z);
        return Ed448.isNeutralElementVar(r.x, r.y, r.z);
    }

    public static boolean validatePublicKeyPartial(byte[] pk, int pkOff) {
        PointExt p = new PointExt();
        return Ed448.decodePointVar(pk, pkOff, false, p);
    }

    public static boolean verify(byte[] sig, int sigOff, byte[] pk, int pkOff, byte[] ctx, byte[] m, int mOff, int mLen) {
        byte phflag = 0;
        return Ed448.implVerify(sig, sigOff, pk, pkOff, ctx, phflag, m, mOff, mLen);
    }

    public static boolean verifyPrehash(byte[] sig, int sigOff, byte[] pk, int pkOff, byte[] ctx, byte[] ph, int phOff) {
        byte phflag = 1;
        return Ed448.implVerify(sig, sigOff, pk, pkOff, ctx, phflag, ph, phOff, 64);
    }

    public static boolean verifyPrehash(byte[] sig, int sigOff, byte[] pk, int pkOff, byte[] ctx, Xof ph) {
        byte[] m = new byte[64];
        if (64 != ph.doFinal(m, 0, 64)) {
            throw new IllegalArgumentException("ph");
        }
        byte phflag = 1;
        return Ed448.implVerify(sig, sigOff, pk, pkOff, ctx, phflag, m, 0, m.length);
    }

    public static final class Algorithm {
        public static final int Ed448 = 0;
        public static final int Ed448ph = 1;
    }

    private static class F
    extends X448Field {
        private F() {
        }
    }

    private static class PointExt {
        int[] x = F.create();
        int[] y = F.create();
        int[] z = F.create();

        private PointExt() {
        }
    }

    private static class PointPrecomp {
        int[] x = F.create();
        int[] y = F.create();

        private PointPrecomp() {
        }
    }
}

