/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.PublicKey;
import net.schmizz.sshj.common.Buffer;

public class SSHFingerprintGenerator {
    public String fingerprint(PublicKey key) throws ChecksumException {
        return this.fingerprint(new ByteArrayInputStream(((Buffer.PlainBuffer)new Buffer.PlainBuffer().putPublicKey(key)).getCompactData()));
    }

    public String fingerprint(InputStream in) throws ChecksumException {
        String undelimited = ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.md5).compute((InputStream)in, (TransferStatus)new TransferStatus()).hash;
        StringBuilder fp = new StringBuilder(undelimited.substring(0, 2));
        for (int i = 2; i <= undelimited.length() - 2; i += 2) {
            fp.append(":").append(undelimited.substring(i, i + 2));
        }
        return fp.toString();
    }
}

