/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.messages;

import java.util.ArrayList;
import org.freedesktop.dbus.FileDescriptor;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.types.UInt32;

public class MethodReturn
extends Message {
    private MethodCall call;

    MethodReturn() {
    }

    public MethodReturn(String dest, long replyserial, String sig, Object ... args) throws DBusException {
        this(null, dest, replyserial, sig, args);
    }

    public MethodReturn(String source, String dest, long replyserial, String sig, Object ... args) throws DBusException {
        super(DBusConnection.getEndianness(), (byte)2, (byte)0);
        this.getHeaders().put((byte)5, replyserial);
        ArrayList<Object[]> hargs = new ArrayList<Object[]>();
        hargs.add(new Object[]{(byte)5, new Object[]{"u", replyserial}});
        if (null != source) {
            this.getHeaders().put((byte)7, source);
            hargs.add(new Object[]{(byte)7, new Object[]{"s", source}});
        }
        if (null != dest) {
            this.getHeaders().put((byte)6, dest);
            hargs.add(new Object[]{(byte)6, new Object[]{"s", dest}});
        }
        if (null != sig) {
            hargs.add(new Object[]{(byte)8, new Object[]{"g", sig}});
            this.getHeaders().put((byte)8, sig);
            this.setArgs(args);
        }
        int totalFileDes = 0;
        for (int x = 0; x < args.length; ++x) {
            if (!(args[x] instanceof FileDescriptor)) continue;
            ++totalFileDes;
        }
        if (totalFileDes > 0) {
            this.getHeaders().put((byte)9, totalFileDes);
            hargs.add(new Object[]{(byte)9, new Object[]{"u", new UInt32(totalFileDes)}});
        }
        byte[] blen = new byte[4];
        this.appendBytes(blen);
        this.append("ua(yv)", this.getSerial(), hargs.toArray());
        this.pad((byte)8);
        long c = this.getByteCounter();
        if (null != sig) {
            this.append(sig, args);
        }
        this.marshallint(this.getByteCounter() - c, blen, 0, 4);
    }

    public MethodReturn(MethodCall mc, String sig, Object ... args) throws DBusException {
        this(null, mc, sig, args);
    }

    public MethodReturn(String source, MethodCall mc, String sig, Object ... args) throws DBusException {
        this(source, mc.getSource(), mc.getSerial(), sig, args);
        this.call = mc;
    }

    public MethodCall getCall() {
        return this.call;
    }

    public void setCall(MethodCall _call) {
        this.call = _call;
    }
}

