/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DefaultSocketExceptionMappingService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import java.io.IOException;
import java.net.SocketException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.client.HttpResponseException;

public class StoregateExceptionMappingService
extends AbstractExceptionMappingService<ApiException> {
    public BackgroundException map(ApiException failure) {
        for (Throwable cause : ExceptionUtils.getThrowableList((Throwable)failure)) {
            if (cause instanceof SocketException) {
                return new DefaultSocketExceptionMappingService().map((SocketException)cause);
            }
            if (cause instanceof HttpResponseException) {
                return new DefaultHttpResponseExceptionMappingService().map((HttpResponseException)cause);
            }
            if (cause instanceof IOException) {
                return new DefaultIOExceptionMappingService().map((IOException)cause);
            }
            if (!(cause instanceof IllegalStateException)) continue;
            return new ConnectionCanceledException(cause);
        }
        return new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(failure.getCode(), failure.getMessage()));
    }
}

