/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.joda.time.DateTime;

@ApiModel(description="A media item (a image in a album).")
public class MediaItem {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="fileId")
    private String fileId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="created")
    private DateTime created = null;
    @JsonProperty(value="modified")
    private DateTime modified = null;
    @JsonProperty(value="transformAngle")
    private Integer transformAngle = null;

    public MediaItem id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The item id.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MediaItem fileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    @ApiModelProperty(value="The file id.")
    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public MediaItem name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The image name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MediaItem description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The image description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public MediaItem created(DateTime created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(value="When the image was created.")
    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime created) {
        this.created = created;
    }

    public MediaItem modified(DateTime modified) {
        this.modified = modified;
        return this;
    }

    @ApiModelProperty(value="When the image last was modified.")
    public DateTime getModified() {
        return this.modified;
    }

    public void setModified(DateTime modified) {
        this.modified = modified;
    }

    public MediaItem transformAngle(Integer transformAngle) {
        this.transformAngle = transformAngle;
        return this;
    }

    @ApiModelProperty(value="The number of degrees that the image should be rotated.")
    public Integer getTransformAngle() {
        return this.transformAngle;
    }

    public void setTransformAngle(Integer transformAngle) {
        this.transformAngle = transformAngle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaItem mediaItem = (MediaItem)o;
        return Objects.equals(this.id, mediaItem.id) && Objects.equals(this.fileId, mediaItem.fileId) && Objects.equals(this.name, mediaItem.name) && Objects.equals(this.description, mediaItem.description) && Objects.equals(this.created, mediaItem.created) && Objects.equals(this.modified, mediaItem.modified) && Objects.equals(this.transformAngle, mediaItem.transformAngle);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.fileId, this.name, this.description, this.created, this.modified, this.transformAngle);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MediaItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    fileId: ").append(this.toIndentedString(this.fileId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    transformAngle: ").append(this.toIndentedString(this.transformAngle)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

