/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.util;

import com.joyent.manta.exception.MantaResourceCloseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuingInputStream
extends InputStream {
    private static final Logger LOG = LoggerFactory.getLogger(ContinuingInputStream.class);
    private static final int EOF = -1;
    private boolean eofSeen = false;
    private boolean closed = false;
    private long bytesRead = 0L;
    private InputStream wrapped;

    public ContinuingInputStream(InputStream initial) {
        this.wrapped = Objects.requireNonNull(initial);
    }

    protected InputStream getWrapped() {
        return this.wrapped;
    }

    public void continueWith(InputStream next) {
        Validate.notNull((Object)next, (String)"InputStream must not be null", (Object[])new Object[0]);
        if (this.eofSeen) {
            throw new IllegalStateException("Already reached end of source stream, refusing to set new source");
        }
        if (this.closed) {
            throw new IllegalStateException("Stream is closed, refusing to set new source");
        }
        if (this.wrapped == next) {
            throw new IllegalArgumentException("Current and next stream are the same");
        }
        if (this.wrapped != null) {
            this.closeAndDiscardWrapped();
        }
        this.wrapped = next;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public int read() throws IOException {
        this.ensureReady();
        if (this.eofSeen) {
            return -1;
        }
        int b = this.wrapped.read();
        if (b != -1) {
            this.bytesRead += (long)b;
        } else {
            this.eofSeen = true;
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.ensureReady();
        if (this.eofSeen) {
            return -1;
        }
        int n = this.wrapped.read(b);
        if (n != -1) {
            this.bytesRead += (long)n;
        } else {
            this.eofSeen = true;
        }
        return n;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureReady();
        if (this.eofSeen) {
            return -1;
        }
        int n = this.wrapped.read(b, off, len);
        if (n != -1) {
            this.bytesRead += (long)n;
        } else {
            this.eofSeen = true;
        }
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureReady();
        long s = this.wrapped.skip(n);
        if (0L < s) {
            this.bytesRead += s;
        }
        return s;
    }

    @Override
    public int available() throws IOException {
        this.ensureReady();
        return this.wrapped.available();
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException("ContinuingInputStream does not support mark/reset");
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException("ContinuingInputStream does not support mark/reset");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            if (this.wrapped != null) {
                this.wrapped.close();
            }
        }
        catch (IOException e) {
            String msg = "Unable to close wrapped InputStream";
            throw new MantaResourceCloseException(msg, e);
        }
    }

    private void ensureReady() {
        if (this.closed) {
            throw new IllegalStateException("Attempted to read from a closed InputStream");
        }
        if (this.wrapped == null) {
            throw new IllegalStateException("Read called before setting a continuation stream");
        }
    }

    private void closeAndDiscardWrapped() {
        try {
            if (this.wrapped != null) {
                this.wrapped.close();
            }
        }
        catch (IOException e) {
            LOG.error("Error closing wrapped InputStream", (Throwable)e);
        }
        this.wrapped = null;
    }
}

