/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.oauth;

import ch.cyberduck.core.AlphanumericRandomStringService;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.OAuthTokens;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.UseragentProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.UserAgentHttpRequestInitializer;
import ch.cyberduck.core.local.BrowserLauncher;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.oauth.OAuth2TokenListener;
import ch.cyberduck.core.oauth.OAuth2TokenListenerRegistry;
import ch.cyberduck.core.oauth.OAuthExceptionMappingService;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.CancelCallback;
import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.RefreshTokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.v2.ApacheHttpTransport;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.log4j.Logger;

public class OAuth2AuthorizationService {
    private static final Logger log = Logger.getLogger(OAuth2AuthorizationService.class);
    public static final String OOB_REDIRECT_URI = "urn:ietf:wg:oauth:2.0:oob";
    public static final String CYBERDUCK_REDIRECT_URI = String.format("%s:oauth", PreferencesFactory.get().getProperty("oauth.handler.scheme"));
    private final JsonFactory json = new GsonFactory();
    private final String tokenServerUrl;
    private final String authorizationServerUrl;
    private final String clientid;
    private final String clientsecret;
    public final BrowserLauncher browser = BrowserLauncherFactory.get();
    private final List<String> scopes;
    private final Map<String, String> additionalParameters = new HashMap<String, String>();
    private Credential.AccessMethod method = BearerToken.authorizationHeaderAccessMethod();
    private String redirectUri = "urn:ietf:wg:oauth:2.0:oob";
    private final HttpTransport transport;

    public OAuth2AuthorizationService(HttpClient client, String tokenServerUrl, String authorizationServerUrl, String clientid, String clientsecret, List<String> scopes) {
        this((HttpTransport)new ApacheHttpTransport(client), tokenServerUrl, authorizationServerUrl, clientid, clientsecret, scopes);
    }

    public OAuth2AuthorizationService(HttpTransport transport, String tokenServerUrl, String authorizationServerUrl, String clientid, String clientsecret, List<String> scopes) {
        this.transport = transport;
        this.tokenServerUrl = tokenServerUrl;
        this.authorizationServerUrl = authorizationServerUrl;
        this.clientid = clientid;
        this.clientsecret = clientsecret;
        this.scopes = scopes;
    }

    public OAuthTokens authorize(Host bookmark, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        final Credentials credentials = bookmark.getCredentials();
        OAuthTokens saved = credentials.getOauth();
        if (saved.validate()) {
            if (saved.isExpired()) {
                log.warn((Object)String.format("Refresh expired access tokens %s", saved));
                try {
                    return this.refresh(saved);
                }
                catch (InteroperabilityException | LoginFailureException e) {
                    log.warn((Object)String.format("Failure refreshing tokens from %s for %s", saved, bookmark));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Returned saved OAuth tokens %s for %s", saved, bookmark));
                }
                return saved;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Start new OAuth flow for %s with missing access token", bookmark));
        }
        if (PreferencesFactory.get().getBoolean("oauth.browser.open.warn")) {
            prompt.warn(bookmark, LocaleFactory.localizedString((String)"Provide additional login credentials", (String)"Credentials"), new StringAppender().append(LocaleFactory.localizedString((String)"Open web browser to authenticate and obtain an authorization code", (String)"Credentials")).append(LocaleFactory.localizedString((String)"Please contact your web hosting service provider for assistance", (String)"Support")).toString(), LocaleFactory.localizedString((String)"Continue", (String)"Credentials"), LocaleFactory.localizedString((String)"Cancel"), "oauth.browser.open.warn");
        }
        AuthorizationCodeFlow flow = new AuthorizationCodeFlow.Builder(this.method, this.transport, this.json, new GenericUrl(this.tokenServerUrl), (HttpExecuteInterceptor)new ClientParametersAuthentication(this.clientid, this.clientsecret), this.clientid, this.authorizationServerUrl).setScopes(this.scopes).setRequestInitializer((HttpRequestInitializer)new UserAgentHttpRequestInitializer((UseragentProvider)new PreferencesUseragentProvider())).build();
        AuthorizationCodeRequestUrl authorizationCodeRequestUrl = flow.newAuthorizationUrl();
        authorizationCodeRequestUrl.setRedirectUri(this.redirectUri);
        String state = new AlphanumericRandomStringService().random();
        authorizationCodeRequestUrl.setState(state);
        for (Map.Entry<String, String> values : this.additionalParameters.entrySet()) {
            authorizationCodeRequestUrl.set(values.getKey(), (Object)values.getValue());
        }
        String url = authorizationCodeRequestUrl.build();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Open browser with URL %s", url));
        }
        if (!this.browser.open(url)) {
            log.warn((Object)String.format("Failed to launch web browser for %s", url));
        }
        final AtomicReference<String> authenticationCode = new AtomicReference<String>();
        if (StringUtils.contains((CharSequence)this.redirectUri, (CharSequence)CYBERDUCK_REDIRECT_URI)) {
            final CountDownLatch signal = new CountDownLatch(1);
            OAuth2TokenListenerRegistry registry = OAuth2TokenListenerRegistry.get();
            registry.register(state, new OAuth2TokenListener(){

                @Override
                public void callback(String code) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Callback with code %s", code));
                    }
                    if (!StringUtils.isBlank((CharSequence)code)) {
                        credentials.setSaved(PreferencesFactory.get().getBoolean("connection.login.keychain"));
                        authenticationCode.set(code);
                    }
                    signal.countDown();
                }
            });
            while (!Uninterruptibles.awaitUninterruptibly((CountDownLatch)signal, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS)) {
                cancel.verify();
            }
        } else {
            Credentials input = prompt.prompt(bookmark, LocaleFactory.localizedString((String)"OAuth2 Authentication", (String)"Credentials"), LocaleFactory.localizedString((String)"Paste the authentication code from your web browser", (String)"Credentials"), new LoginOptions(bookmark.getProtocol()).keychain(true).user(false).oauth(true).passwordPlaceholder(LocaleFactory.localizedString((String)"Authentication Code", (String)"Credentials")));
            credentials.setSaved(input.isSaved());
            authenticationCode.set(input.getPassword());
        }
        try {
            if (StringUtils.isBlank((CharSequence)((CharSequence)authenticationCode.get()))) {
                throw new LoginCanceledException();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Request tokens for authentication code %s", authenticationCode.get()));
            }
            TokenResponse response = ((PermissiveTokenResponse)((Object)flow.newTokenRequest((String)authenticationCode.get()).setRedirectUri(this.redirectUri).setScopes(this.scopes.isEmpty() ? null : this.scopes).executeUnparsed().parseAs(PermissiveTokenResponse.class))).toTokenResponse();
            OAuthTokens tokens = new OAuthTokens(response.getAccessToken(), response.getRefreshToken(), Long.valueOf(null == response.getExpiresInSeconds() ? System.currentTimeMillis() : System.currentTimeMillis() + response.getExpiresInSeconds() * 1000L));
            credentials.setOauth(tokens);
            return tokens;
        }
        catch (TokenResponseException e) {
            throw new OAuthExceptionMappingService().map(e);
        }
        catch (com.google.api.client.http.HttpResponseException e) {
            throw new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(e.getStatusCode(), e.getStatusMessage()));
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public OAuthTokens refresh(OAuthTokens tokens) throws BackgroundException {
        if (StringUtils.isBlank((CharSequence)tokens.getRefreshToken())) {
            log.warn((Object)"Missing refresh token");
            return tokens;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Refresh expired tokens %s", tokens));
        }
        try {
            TokenResponse response = ((PermissiveTokenResponse)((Object)new RefreshTokenRequest(this.transport, this.json, new GenericUrl(this.tokenServerUrl), tokens.getRefreshToken()).setRequestInitializer((HttpRequestInitializer)new UserAgentHttpRequestInitializer((UseragentProvider)new PreferencesUseragentProvider())).setClientAuthentication((HttpExecuteInterceptor)new ClientParametersAuthentication(this.clientid, this.clientsecret)).executeUnparsed().parseAs(PermissiveTokenResponse.class))).toTokenResponse();
            long expiryInMilliseconds = System.currentTimeMillis() + response.getExpiresInSeconds() * 1000L;
            if (StringUtils.isBlank((CharSequence)response.getRefreshToken())) {
                return new OAuthTokens(response.getAccessToken(), tokens.getRefreshToken(), Long.valueOf(expiryInMilliseconds));
            }
            return new OAuthTokens(response.getAccessToken(), response.getRefreshToken(), Long.valueOf(expiryInMilliseconds));
        }
        catch (TokenResponseException e) {
            throw new OAuthExceptionMappingService().map(e);
        }
        catch (com.google.api.client.http.HttpResponseException e) {
            throw new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(e.getStatusCode(), e.getStatusMessage()));
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public OAuth2AuthorizationService withMethod(Credential.AccessMethod method) {
        this.method = method;
        return this;
    }

    public OAuth2AuthorizationService withRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    public OAuth2AuthorizationService withParameter(String key, String value) {
        this.additionalParameters.put(key, value);
        return this;
    }

    public static final class PermissiveTokenResponse
    extends GenericJson {
        private String accessToken;
        private String tokenType;
        private Long expiresInSeconds;
        private String refreshToken;
        private String scope;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public PermissiveTokenResponse set(String fieldName, Object value) {
            if ("access_token".equals(fieldName)) {
                this.accessToken = (String)value;
                return this;
            } else if ("refresh_token".equals(fieldName)) {
                this.refreshToken = (String)value;
                return this;
            } else if ("token_type".equals(fieldName)) {
                this.tokenType = (String)value;
                return this;
            } else if ("scope".equals(fieldName)) {
                this.scope = (String)value;
                return this;
            } else {
                if (!"expires_in".equals(fieldName)) return (PermissiveTokenResponse)super.set(fieldName, value);
                if (value instanceof String) {
                    try {
                        this.expiresInSeconds = Long.parseLong((String)value);
                        return this;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Value of expires_in is not a number: " + value);
                    }
                } else {
                    if (!(value instanceof Number)) throw new IllegalArgumentException("Unknown value type for expires_in: " + value.getClass().getName());
                    this.expiresInSeconds = ((Number)value).longValue();
                }
            }
            return this;
        }

        public TokenResponse toTokenResponse() {
            return new TokenResponse().setTokenType(this.tokenType).setScope(this.scope).setExpiresInSeconds(this.expiresInSeconds).setAccessToken(this.accessToken).setRefreshToken(this.refreshToken);
        }
    }
}

