/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;

public final class Guard {
    private Guard() {
    }

    public static boolean isNotNullAndNotEmpty(Collection<?> collection) {
        return !Guard.isNullOrEmpty(collection);
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotNullAndNotEmpty(Iterable<?> iterable) {
        return !Guard.isNullOrEmpty(iterable);
    }

    public static boolean isNullOrEmpty(Iterable<?> iterable) {
        return iterable == null || !iterable.iterator().hasNext();
    }

    public static boolean isStringNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static void throwOnNullOrEmptyString(String str, String message) {
        if (Guard.isStringNullOrEmpty(str)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean isMultiMapNullOrEmpty(Multimap<?, ?> multimap) {
        return multimap == null || multimap.isEmpty();
    }

    public static boolean isMapNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }
}

