/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.multipart.CompleteMultipartUpload;
import com.spectralogic.ds3client.networking.HttpVerb;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.UUID;

public class CompleteMultiPartUploadRequest
extends AbstractRequest {
    private final String bucketName;
    private final String objectName;
    private final String uploadId;
    private final CompleteMultipartUpload requestPayload;
    private long size = 0L;

    public CompleteMultiPartUploadRequest(String bucketName, String objectName, CompleteMultipartUpload requestPayload, UUID uploadId) {
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.uploadId = uploadId.toString();
        this.requestPayload = requestPayload;
        this.updateQueryParam("upload_id", uploadId);
    }

    public CompleteMultiPartUploadRequest(String bucketName, String objectName, CompleteMultipartUpload requestPayload, String uploadId) {
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.uploadId = uploadId;
        this.requestPayload = requestPayload;
        this.updateQueryParam("upload_id", uploadId);
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.POST;
    }

    @Override
    public String getPath() {
        return "/" + this.bucketName + "/" + this.objectName;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public InputStream getStream() {
        if (this.requestPayload == null) {
            return null;
        }
        String xmlOutput = XmlOutput.toXml(this.requestPayload);
        byte[] stringBytes = xmlOutput.getBytes(Charset.forName("UTF-8"));
        this.size = stringBytes.length;
        return new ByteArrayInputStream(stringBytes);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public CompleteMultipartUpload getRequestPayload() {
        return this.requestPayload;
    }
}

