/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.GetDs3TargetReadPreferenceSpectraS3Response;
import com.spectralogic.ds3client.models.Ds3TargetReadPreference;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class GetDs3TargetReadPreferenceSpectraS3ResponseParser
extends AbstractResponseParser<GetDs3TargetReadPreferenceSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public GetDs3TargetReadPreferenceSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        Ds3TargetReadPreference result = XmlOutput.fromXml(inputStream, Ds3TargetReadPreference.class);
                        GetDs3TargetReadPreferenceSpectraS3Response getDs3TargetReadPreferenceSpectraS3Response = new GetDs3TargetReadPreferenceSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return getDs3TargetReadPreferenceSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

