/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.ModifyStorageDomainSpectraS3Response;
import com.spectralogic.ds3client.models.StorageDomain;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class ModifyStorageDomainSpectraS3ResponseParser
extends AbstractResponseParser<ModifyStorageDomainSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public ModifyStorageDomainSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        StorageDomain result = XmlOutput.fromXml(inputStream, StorageDomain.class);
                        ModifyStorageDomainSpectraS3Response modifyStorageDomainSpectraS3Response = new ModifyStorageDomainSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return modifyStorageDomainSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

