/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers.interfaces;

import com.spectralogic.ds3client.commands.interfaces.Ds3Response;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.models.ChecksumType;
import com.spectralogic.ds3client.networking.WebResponse;
import java.io.IOException;
import java.util.List;

public abstract class AbstractResponseParser<T extends Ds3Response> {
    private WebResponse response;
    private String checksum;
    private ChecksumType.Type checksumType;

    public abstract T parseXmlResponse(WebResponse var1) throws IOException;

    public T response(WebResponse response) throws IOException {
        this.response = response;
        if (response != null) {
            this.checksumType = ResponseParserUtils.determineChecksumType(this.response.getHeaders());
            this.checksum = this.checksumType != null ? ResponseParserUtils.getFirstHeaderValue(this.response.getHeaders(), "content-" + this.checksumType.toString().replace("_", "").toLowerCase()) : null;
        } else {
            this.checksum = null;
            this.checksumType = ChecksumType.Type.NONE;
        }
        return this.parseXmlResponse(response);
    }

    public WebResponse getResponse() {
        return this.response;
    }

    public int getStatusCode() {
        return this.response.getStatusCode();
    }

    protected Integer parseIntHeader(String key) {
        List list = this.getResponse().getHeaders().get(key);
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return Integer.parseInt((String)list.get(0));
            }
        }
        throw new IllegalArgumentException("Response has more than one header value for " + key);
    }

    public String getChecksum() {
        return this.checksum;
    }

    public ChecksumType.Type getChecksumType() {
        return this.checksumType;
    }
}

