/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class GetJobChunksReadyForClientProcessingSpectraS3Request
extends AbstractRequest {
    private final String job;
    private String jobChunk;
    private int preferredNumberOfChunks;

    public GetJobChunksReadyForClientProcessingSpectraS3Request(UUID job) {
        this.job = job.toString();
        this.updateQueryParam("job", job);
    }

    public GetJobChunksReadyForClientProcessingSpectraS3Request(String job) {
        this.job = job;
        this.updateQueryParam("job", job);
    }

    public GetJobChunksReadyForClientProcessingSpectraS3Request withJobChunk(UUID jobChunk) {
        this.jobChunk = jobChunk.toString();
        this.updateQueryParam("job_chunk", jobChunk);
        return this;
    }

    public GetJobChunksReadyForClientProcessingSpectraS3Request withJobChunk(String jobChunk) {
        this.jobChunk = jobChunk;
        this.updateQueryParam("job_chunk", jobChunk);
        return this;
    }

    public GetJobChunksReadyForClientProcessingSpectraS3Request withPreferredNumberOfChunks(int preferredNumberOfChunks) {
        this.preferredNumberOfChunks = preferredNumberOfChunks;
        this.updateQueryParam("preferred_number_of_chunks", preferredNumberOfChunks);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/_rest_/job_chunk";
    }

    public String getJob() {
        return this.job;
    }

    public String getJobChunk() {
        return this.jobChunk;
    }

    public int getPreferredNumberOfChunks() {
        return this.preferredNumberOfChunks;
    }
}

